/*
** Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.
**
** Unlimited use, reproduction, and distribution of this software is
** permitted.  Any copy of this software must include both the above
** copyright notice of Xerox Corporation and this paragraph.  Any
** distribution of this software must comply with all applicable United
** States export control laws.  This software is made available AS IS,
** and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
** INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
** PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
** THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
** CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
** XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
 

#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/stat.h>
#include "cstubber.h"

static boolean		makedir (char *);
extern boolean 		ReadSynonyms(  char *filename );
static void		usage( void );

boolean			generateAnsi = True;
boolean 		GenerateImakefile = FALSE;
boolean 		GenerateServerSkeleton = FALSE;
boolean 		GenerateClasses = FALSE;
extern cardinal 	MethodRecordID;
char 			*NamesFile = NULL;
char 			*OutputDirectory = ".";
char 			*ProgramName = "class-stubber";
boolean			useParserIds = False;

static void generateCode(
    Interface	parse )
{
    FILE 	*file;
    char 	filename[ 1000 ];

    MethodRecordID = 0;
    sprintf( 
	filename, 
	"%s/%s-common.c", 
	OutputDirectory, 
	c_interface_name( parse ));
    if (( file = fopen( filename, "w" )) == NULL ) 
        fatal( "Couldn't open client stubs output file %s.\n", filename );
    printf(
	"common code for interface %s to %s...\n", 
	c_interface_name( parse ), 
	filename );
    setFile( file );
    generateCommonCode( parse, file );
    fclose ( file );
    MethodRecordID = 0;
    sprintf( 
	filename, 
	"%s/%s-surrogate.c", 
	OutputDirectory, 
	c_interface_name( parse ));
    if (( file = fopen( filename, "w" )) == NULL ) 
        fatal( "Couldn't open surrogate stubs output file %s.\n", filename );
    printf(
	"code for surrogate stubs of interface %s to %s...\n", 
	c_interface_name( parse ), 
	filename );
    setFile( file );
    generateClientCode( parse, file );
    fclose ( file );
    sprintf( 
	filename, 
	"%s/%s-true.c", 
	OutputDirectory, 
	c_interface_name( parse ));
    if (( file = fopen( filename, "w" )) == NULL ) 
        fatal( "Couldn't open true stubs output file %s.\n", filename );
    printf(
	"code for true stubs of interface %s to %s...\n", 
	c_interface_name( parse ), 
	filename );
    setFile( file );
    generateServerCode( parse, file );
    fclose( file );
}

static void generateHeaders( 
    Interface	parse )
{
    FILE 	*file;
    char 	filename[ 1000 ];

    sprintf( 
	filename,  
	"%s/%s.h",  
	OutputDirectory,  
	c_interface_name( parse ));
    if (( file = fopen( filename, "w" )) == NULL ) {
        fatal( "Couldn't open output file %s.\n", filename );
    }
    printf(
	"header file interface %s to %s...\n", 
	c_interface_name( parse ), 
	filename );
    setFile( file );
    generateCHeaders( parse, file );
    fclose( file );
}

static void generateStubs (Interface parse)
{
  if ( !makedir( OutputDirectory ))
    fatal("Couldn't create output directory %s.\n", OutputDirectory);
  if (GenerateClasses) {
    generateHeaders (parse);
    generateCode (parse);
  }
}

static boolean makedir (char *dirname)
{
  struct stat 	s;
  
  if (stat(dirname, &s) == 0)
    return (S_ISDIR(s.st_mode) AND (access (dirname, W_OK) == 0));
  else
    {
      char buf[1000];
      sprintf( buf, "mkdir %s", dirname );
      return(( system( buf ) >> 8 ) == 0 );
    }
}

void main( 
    int 	ac,
    char 	**av,
    char 	**envp )
{
    list 		s;
    char 		**interfacename;
    extern Interface 	GetInterface( );
    extern list		ParseFile( );

    if ( ac < 2 ) {
        usage( );
        exit( 1 );
    }
    ProgramName = *av;
    ac--;
    av++;
    while( *av[ 0 ] == '-' ) {
        if ( strcmp( *av, "-dir" ) == 0 )
            OutputDirectory = *++av;
        else if ( strcmp( *av, "-imakefile" ) == 0)
            GenerateImakefile = TRUE;
        else if ( strcmp( *av, "-serverskeleton" ) == 0 )
            GenerateServerSkeleton = TRUE;
        else if ( strcmp( *av, "-renames" ) == 0 )
            NamesFile = *++av;
        else if ( strcmp(*av, "-classes" ) == 0 )
            GenerateClasses = TRUE;
        else if ( strcmp(*av, "-a" ) == 0 )
	    generateAnsi = True;
        else if ( strcmp(*av, "-p" ) == 0 )
	    useParserIds = True;
        else {
            usage( );
            fatal( "%s:  Invalid switch \"%s\".\n", ProgramName, *av );
        }
        ac--;
        av++;
    }
    if (!( GenerateServerSkeleton || GenerateImakefile || GenerateClasses )) {
        GenerateClasses = TRUE;
    }
    if ( NamesFile != NULL ) {
        if ( !ReadSynonyms( NamesFile )) {
    	    fatal( "Couldn't read names file %s.\n", NamesFile );
	}
    }      
    for( interfacename = av; *interfacename != NULL; interfacename++ ) {
        if (( s = ParseFile( *interfacename )) == NULL ) {
	    fatal( "Couldn't find or parse %s.\n", *interfacename );
	}
	list_enumerate( s, (void (*)(refany, refany)) generateStubs, NULL );
    }
    exit( 0 );
}

static void usage( )
{
    fprintf(
	stderr, 
	"Usage:  %s [-dir OUTPUTDIRECTORY] [-imakefile] [-serverskeleton] \
	    [-classes] [-renames NAMESFILE] ISLFILE [ISLFILE ...]\n", 
	ProgramName );
}

