/*
** Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.
**
** Unlimited use, reproduction, and distribution of this software is
** permitted.  Any copy of this software must include both the above
** copyright notice of Xerox Corporation and this paragraph.  Any
** distribution of this software must comply with all applicable United
** States export control laws.  This software is made available AS IS,
** and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
** INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
** PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
** THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
** CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
** XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
 

#include "cstubber.h"

#define IsHexDigit(x)	((((x)>='0')&&((x)<='9'))||(((x)>='a')&&((x)<='f'))||(((x)>='A')&&((x)<='F')))
#define HexValue(x)	(((x)<='9')?((x)-'0'):(((x)<='F')?((x)-'A'):(((x)<='f')?((x)-'a'):0)))

struct double_s {
    Type 	t;
    Context 	c;
};

static void 		sortTypesForDeclaration ();

static void convertStringForm (
    char 	*buf,
    string 	str)
{
    char 	*p;
    char 	*q;

    for (p = str, q = buf;  *p != '\0';) {
        if (*p == '#') {
	    ++p;
	    if (*p == 'n')
	        *q++ = '\\', *q++ = 'n', p++;
	    else if (*p == 'r')
	        *q++ = '\\', *q++ = 'r', p++;
	    else if (IsHexDigit (*p)) {
	        unsigned int c = 0;
	        unsigned int i;

	        while (IsHexDigit (*p) && (i = c * 16 + HexValue (*p)) < 256) {
		    c = i;
		    ++p;
		}
	        sprintf (q, "\\%o", c);
	        q += strlen (q);
	    }
	    else if (*p == '\\' || *p == '"')
	        *q++ = '\\', *q++ = *p++;
	    else
	        *q++ = *p++;
	}
        else if (*p == '\\' || *p == '"')
	    *q++ = '\\', *q++ = *p++;
        else
	    *q++ = *p++;
    }
}

static void declareConstant (
    Constant 	c,
    Context 	context)
{
    enum PrimitiveTypes 	t = type_basic_type (c->type);

    if (c->interface != context->interface)
        return;
    if (( t == cardinal_Type || t == shortcardinal_Type || t == byte_Type)
      		&& (c->value->type == integer_Type)) {
        fprintf (context->file, 
		"static const %s %s = %lu;\n",
	        (t == cardinal_Type) 
			? "unsigned long" 
			: (( t == byte_Type) 
				? "unsigned char" 
				: "unsigned short"),
	       	c_constant_name (c),
	       	c->value->val.i.value);
    }
    else if (( t == integer_Type || t == shortinteger_Type)
      		&& (c->value->type == integer_Type)) {
        fprintf (context->file, 
		"static const %s %s = %s%lu;\n",
	        (t == integer_Type) 
			? "long int" 
			: "short int",
	       	c_constant_name (c),
	       	( c->value->val.i.sign < 0) ? "-" : "",
	       	c->value->val.i.value);
    }
    else if (( t == real_Type || t == shortreal_Type)
      		&& (c->value->type == real_Type)) {
        fprintf (context->file, 
		"static const %s %s = %s%s.%se%ld;\n",
	       	( t == real_Type) ? "double" : "real",
	       	c_constant_name (c),
	       	( c->value->val.r.sign < 0) ? "-" : "",
	       	c->value->val.r.value, 
		( c->value->val.r.fraction == NULL) ? "0" : c->value->val.r.fraction,
		c->value->val.r.exponent);
    }
    else if (t == shortcharacter_Type) {
        if (c->value->type == sequence_Type) {
  	    char 	buf[ 1000 ];

	    convertStringForm (buf, c->value->val.s);
	    fprintf (context->file, 
		"static const char * %s \"%s\"\n",
		c_constant_name (c),
		buf);
	}
        else
  	    fprintf (context->file, 
		"static const char %s = 0x%lx;\n",
		c_constant_name (c),
		c->value->val.i.value);
    }
    else
        error ("Invalid constant, %s, encountered.\n", name_base_name (c->name));
}

static void declareException (Exception e, Context context)
{
  if (e->import)
    return;
  fprintf (context->file, "extern ILU_C_ExceptionCode _%s__Exception_%s;\n",
	   c_interface_name (context->interface), c_simple_name (e->name));
  fprintf (context->file, "#define ex_%s  _%s__Exception_%s\n",
	   c_exception_name (e), c_interface_name (context->interface), c_simple_name (e->name));
}

void listArgumentTypes (
    Argument    arg,
    Context     context)
{
    fprintf (context->file, ", %s", c_parameter_type (arg->type, arg->direction));
}
 

static void mkPrototype (
    Procedure	m,
    Context	c)
{
  fprintf (c->file, "%s %s_%s (%s, ILU_C_ENVIRONMENT *", c_return_type (m->returnType),
	   c_type_name (c->class), c_simple_name (m->name), c_type_name (c->class));
  list_enumerate (m->arguments, (void (*)(refany, refany)) listArgumentTypes, c);
  fprintf (c->file, ");\n");
}

static void generatePrototypes (
    Type	t,
    Context	context)
{
    Class 	c;

    if (t == NULL ||
                type_basic_type (t) != object_Type ||
                (c = class_object (t)) == NULL)
        return;
    if (c->superclasses != NULL)
        list_enumerate (c->superclasses, (void (*)(refany, refany)) generatePrototypes, context);
    list_enumerate (c->methods, (void (*)(refany, refany)) mkPrototype, context);
}

static void declareClassType (
    Type	t,
    Context 	context)
{
    Class 	c;

    if (t == NULL ||
                type_basic_type (t) != object_Type ||
                (c = class_object (t)) == NULL)
        return;
    context->class = t;
    fprintf (context->file,
	"typedef ILU_C_OBJECT %s;\n",
	c_type_name (t));
}

static void declareCClass (
    Type	t,
    Context 	context)
{
    Class 	c;

    if (t == NULL ||
                type_basic_type (t) != object_Type ||
                (c = class_object (t)) == NULL)
        return;
    context->class = t;
    fprintf (context->file, "%s %s__CreateTrue (ilu_string, ilu_Server server, void *user_data);\n",
	     c_type_name (t), c_type_name(t));
    fprintf (context->file, "%s %s__CreateFromSBH (char *sbh, char *mostSpecificTypeID);\n",
	c_type_name (t), c_type_name(t));
    fprintf (context->file, "void %s__SetUserData (%s self, void *userData);\n", c_type_name(t), c_type_name (t));
    fprintf (context->file, "void *%s__GetUserData (%s self);\n", c_type_name (t), c_type_name(t));
    generatePrototypes (t, context);
    fprintf (context->file, 
	"extern struct _ilu_Class_s _%s__ILUClassRecord;\n",
	c_type_name (t));
    fprintf (context->file, "struct _%s__MethodBlock_s {\n", c_type_name (t));
    fprintf (context->file, "  ilu_Class c;\n");
    fprintf (context->file, "  void (*methods[%u])(void);\n};\n", countMethods (c));
    fprintf (context->file, "extern struct _%s__MethodBlock_s _%s__MethodBlock;\n",
	     c_type_name(t), c_type_name(t));
}

static boolean matchPointer (
    refany 	p1,
    refany 	p2)
{
    return (p1 == p2);
}

static void generateBoilerplate (
    FILE 	*file,
    Interface 	parse)
{
    fprintf (file, "/*\n");
    fprintf (file, "** this file was automatically generated for C\n");
    fprintf (file, 
	"** from the interface spec %s.isl.\n",
	interface_name (parse));
    fprintf (file, "*/\n\n");
}

static void generateRecordField (
    Argument 	a,
    Context 	context)
{
    fprintf (context->file, "\t%s %s;\n",
	     (( type_basic_type (a->type) == object_Type)  
	      ? c_return_type (a->type) : c_type_name (a->type)),
	c_simple_name (a->name));
}

static void generateRecordDeclaration (
    Type 	t,
    Context 	context)
{
    TypeDescription type_description ();

    fprintf (context->file, "struct %s {\n", c_type_name (t));
    list_enumerate (
	type_description (t)->structuredDes.record, 
	(void (*)(refany, refany)) generateRecordField, 
	context);
    fprintf (context->file, "};\n");
}

static void generateUnionField (
    Argument 	a,
    Context 	context)
{
    char	*name;

    if (a->name)
	name = (char *) c_simple_name (a->name);
    else
	name = (char *) c_string (type_name (a->type));
    fprintf (context->file, 
	"\t\t%s %s;\n", 
	c_type_name (a->type), 
	name);
}

static void generateUnionTypeDescriminator (
    Argument 		a,
    struct double_s 	*s)
{
    fprintf (s->c->file, 
	",\n\t%s_%s", 
	c_type_name (s->t), 
	type_name (a->type));
}

static void generateUnionDeclaration (
    Type 	t,
    Context 	context)
{
    Type		d = type_description (t)->
				structuredDes.uniond.discriminator_type;
    list 		e = type_description (t)->structuredDes.uniond.types;
    struct double_s 	s;

    if (!d || type_basic_type (d) == shortcardinal_Type) {
     	fprintf (context->file, "enum %s_allowableTypes {\n", c_type_name (t));
     	s.c = context;
     	s.t = t; 
     	fprintf (context->file, 
       		"\t%s_%s", 
       		c_type_name (t), 
       		c_string (type_name ((( Argument) list_car (e))->type)));
     	list_enumerate (list_cdr (e), (void (*)(refany, refany)) generateUnionTypeDescriminator, &s);
     	fprintf (context->file, "};\n");
    }
    fprintf (context->file, "struct _%s_union {\n", c_type_name (t));
    fprintf (context->file, 
	"\t%s\t_d;\n\tunion {\n", 
	c_type_name (d));
    list_enumerate (e, (void (*)(refany, refany)) generateUnionField, context);
    fprintf (context->file, "\t} _u;\n};\n");
}

static void PrintEnumField (
    EnumField 	e,
    Context 	context)
{
    fprintf (context->file, 
	", %s_%s", 
	c_interface_name (context->interface),
	c_string (e->name));
    if (e->id >= 0)
        fprintf (context->file, " = %d", e->id);  
}

static void PrintFirstEnumField (
    EnumField 	e,
    Context 	context)
{
    fprintf (context->file, 
	"%s_%s", 
	c_interface_name (context->interface),
	c_string (e->name));
    if (e->id >= 0)
        fprintf (context->file, " = %d", e->id);  
}

static void generateEnumerationTypedefDeclaration (
    Type 	t,
    Context 	context)
{
    list 	e;
    EnumField 	ef;

    fprintf (context->file, "typedef enum {");
    e = (type_description (t))->structuredDes.enumeration;
    ef = (EnumField) list_car (e);
    context->class = t;
    PrintFirstEnumField (ef, context);
    if (list_size (e) > 1)
        list_enumerate (list_cdr (e), (void (*)(refany, refany)) PrintEnumField, context);
    fprintf (context->file, "} %s;\n", c_type_name (t));
}

static void declareType (
    Type 	t,
    Context 	context)
{
  if (t->builtIn)
    return;

    if (t->importInterfaceName != NULL)
        return;
    switch (type_basic_type (t)) {
    case void_Type:
    case integer_Type:
    case cardinal_Type:
    case shortinteger_Type:
    case shortcardinal_Type:
    case longinteger_Type:
    case longcardinal_Type:
    case character_Type:
    case shortcharacter_Type:
    case real_Type:
    case shortreal_Type:
    case longreal_Type:
    case byte_Type:
    case array_Type:
    case boolean_Type:
    case object_Type:
        return;
    case record_Type:
        generateRecordDeclaration (t, context);
        break;
    case union_Type:
        generateUnionDeclaration (t, context);
        break;
    case sequence_Type:
    case enumeration_Type:
        /* already done in typedef */
        break;
    case optional_Type:
        /* already done */
        break;
    default:
        fatal (
	    "Error:  Can't cope with declaration of type %s yet.\n", 
	    c_type_name (t));
    }
}

static void generateUnionTypedef (
    Type 	t,
    Context 	context)
{

    fprintf (context->file, 
	"typedef struct _%s_union %s;\n",
	c_type_name (t), 
	c_type_name (t));
}

static void OutputDim (
    long 	d,
    Context 	context)
{
    fprintf (context->file, "[%lu]", d);
}

static void generateArrayTypedef (
    Type 	t,
    Context 	context)
{
    TypeDescription d = type_description (t);

    fprintf (context->file, 
	"typedef %s %s", 
	c_type_name (d->structuredDes.array.type),
	c_type_name (t));
    list_enumerate (d->structuredDes.array.dimensions, (void (*)(refany, refany)) OutputDim, context);
    fprintf (context->file, ";\n");
}

static void generateSequenceTypedef (
    Type 	t,
    Context 	context)
{
    TypeDescription d = type_description (t);

    if (type_basic_type (d->structuredDes.sequence.type) == shortcharacter_Type)
        fprintf (context->file, 
		"typedef char * %s;\n", 
		c_type_name (t));
    else if (type_basic_type (d->structuredDes.sequence.type) == character_Type)
        fprintf (context->file, 
		"typedef unsigned short int * %s;\n", 
		c_type_name (t));
    else {
        fprintf (context->file, "typedef struct {\n  unsigned long _maximum;\n");
        fprintf (context->file, "  unsigned long _length;\n  %s *_buffer;\n} %s;\n",
		c_type_name (d->structuredDes.sequence.type), 
		c_type_name (t));
    }
}

static void generateRecordTypedef (
    Type 	t,
    Context 	context)
{
    fprintf (context->file, 
	"typedef struct %s %s;\n", 
	c_type_name (t), 
	c_type_name (t));
}

static void typedefType (
    Type 	t,
    Context 	context)
{
    if (t->builtIn)
        return;
    if (t->importInterfaceName != NULL)
        return;
    switch (type_basic_type (t)) {
    case void_Type:
        break;
    case integer_Type:
        fprintf (context->file, "typedef long int %s;\n", c_type_name (t));
        break;
    case cardinal_Type:
        fprintf (context->file, "typedef unsigned long int %s;\n", c_type_name (t));
        break;
    case shortinteger_Type:
        fprintf (context->file, "typedef short int %s;\n", c_type_name (t));
        break;
    case shortcardinal_Type:
        fprintf (context->file, 
		"typedef unsigned short int %s;\n", 
		c_type_name (t));
        break;
    case longinteger_Type:
        fprintf (context->file, "typedef ilu_longinteger %s;\n", c_type_name (t));
        break;
    case boolean_Type:
        fprintf (context->file, "typedef ilu_boolean %s;\n", c_type_name (t));
        break;
    case longcardinal_Type:
        fprintf (context->file, 
		"typedef ilu_longcardinal %s;\n", 
		c_type_name (t));
        break;
    case real_Type:
        fprintf (context->file, "typedef double %s;\n", c_type_name (t));
        break;
    case shortreal_Type:
        fprintf (context->file, "typedef float %s;\n", c_type_name (t));
        break;
    case longreal_Type:
        fprintf (context->file, "typedef ilu_longreal %s;\n", c_type_name (t));
        break;
    case byte_Type:
        fprintf (context->file, "typedef unsigned char %s;\n", c_type_name (t));
        break;
    case character_Type:
        fprintf (context->file, "typedef unsigned short %s;\n", c_type_name (t));
        break;
    case shortcharacter_Type:
        fprintf (context->file, "typedef unsigned char %s;\n", c_type_name (t));
        break;
    case optional_Type:
	{
	  Type t2 = type_description (t)->structuredDes.optional;
	  enum PrimitiveTypes tp = type_basic_type (t2);
	  fprintf (context->file, "typedef %s %s%s;\n", c_type_name (t2),
		  (tp == optional_Type OR tp == array_Type OR tp == object_Type) ? "" : "* ", c_type_name (t));
	}
        break;
    case array_Type:
        generateArrayTypedef (t, context);
        break;
    case record_Type:
        generateRecordTypedef (t, context);
        break;
    case object_Type:
        break;
    case union_Type:
        generateUnionTypedef (t, context);
        break;
    case sequence_Type:
        generateSequenceTypedef (t, context);
        break;
    case enumeration_Type:
        generateEnumerationTypedefDeclaration (t, context);
        break;
    default:
        fatal (
	    "Error:  Can't cope with typedef of type %s yet.\n",
	    c_type_name (t));
    }
}

static void listException (
    Exception 	e,
    Context 	context)
{
    if (type_basic_type (e->type) == void_Type)
        return;
    else
        fprintf (context->file, 
	    "typedef %s %s;\n",
	    c_type_name (e->type),
	    c_exception_name (e));
}

static void declareStatusStruct (
    Interface 	i,
    Context 	c)
{
    fprintf (c->file, 
	"#define %sReply_Success\t\t ((ILU_C_ExceptionCode) NULL)\n\n", 
	c_interface_name (i));
    list_enumerate (i->exceptions, (void (*)(refany, refany)) listException, c);
}

static void generateSeqProto (
    Type 	t,
    Context 	c)
{
    enum PrimitiveTypes bt;
    int		nr;
    char	*rtn;
    Type	seq;
    char	*st;
    char	*tn;

    if (type_basic_type (t) != sequence_Type)
	return;
    seq = type_description (t)->structuredDes.sequence.type;
    bt = type_basic_type (seq);
    if (type_basic_type (seq) == shortcharacter_Type
                || type_basic_type (seq) == character_Type
                || type_basic_type (seq) == byte_Type) {
 
      /* no declaration, already handled in typedef */
    }
    else {
        tn = c_type_name (t);
        st = c_parameter_type (seq, In);
        rtn = c_type_name (seq);
        nr = (bt == record_Type OR (bt == sequence_Type AND NOT TypeIsString(seq)) OR bt == union_Type);
        fprintf (c->file, "void %s_Every (%s *h, void (*f)(%s%s, void *), void *);\n", tn, tn, st, nr ? "" : "*");
        fprintf (c->file, "void %s_Append (%s *h, %s item);\n", tn, tn, st);
        fprintf (c->file, "void %s_Push (%s *h, %s item);\n", tn, tn, st);
        fprintf (c->file, "void %s_Pop (%s *h, %s item);\n", tn, tn, st);
        fprintf (c->file, "%s *%s_Create (unsigned long sz, %s %sp);\n", tn, tn, st, (nr) ? "" : "*");
        fprintf (c->file, "void %s_Init (%s *s, unsigned long sz, %s %sp);\n", tn, tn, st, (nr) ? "" : "*");
    }
}

static void generateNormalIncludes (
    Context	c)
{
  fprintf (c->file, "#ifndef __ilu_c_h_\n");
  fprintf (c->file, "#include \"ilu-c.h\"\n");
  fprintf (c->file, "#endif\n");
}

static void generateInputPrototype (Type type, enum PrimitiveTypes t, Context context)
{
  fprintf (context->file, "extern %s %s_%s_Input_%s (ilu_Call, %s);\n", c_return_type (type),
	   (t == record_Type OR t == union_Type OR (t == sequence_Type AND NOT TypeIsString (type))) ? "*" : "",
	   c_interface_name (context->interface), c_simple_name (type->name),
	   (t == object_Type) ? c_return_type(type) : c_parameter_type (type, InOut));
}

static void generateFreePrototype (Type type, enum PrimitiveTypes t, Context context)
{
  fprintf (context->file, "extern void %s__Free (%s);\n", c_type_name(type), c_parameter_type (type, In));
}

static void generateOutputPrototype (Type type, enum PrimitiveTypes t, Context context)
{
  fprintf (context->file, "extern void _%s_Output_%s (ilu_Call, %s);\n", c_interface_name (context->interface),
	   c_simple_name (type->name), c_parameter_type (type, In));
}

static void generateSizeOfPrototype (Type type, enum PrimitiveTypes t, Context context)
{
  fprintf (context->file, "extern ilu_cardinal _%s_SizeOf_%s (ilu_Call, %s);\n", c_interface_name (context->interface),
	   c_simple_name (type->name), c_parameter_type (type, In));
}

static void generateTypeIoProto (Type type, Context context)
{
  enum PrimitiveTypes t = type_basic_type (type);

  if (type->importInterfaceName == NULL AND
      (t == union_Type OR
       t == record_Type OR
       (t == sequence_Type AND
	NOT (type_basic_type(type_description(type)->structuredDes.sequence.type) == shortcharacter_Type OR
	     (type_basic_type(type_description(type)->structuredDes.sequence.type) == byte_Type) OR
	     (type_basic_type(type_description(type)->structuredDes.sequence.type) == character_Type))) OR
       (t == array_Type AND
	NOT (list_size(type_description(type)->structuredDes.array.dimensions) == 1 AND
	     (type_basic_type(type_description(type)->structuredDes.array.type) == byte_Type OR
	      type_basic_type(type_description(type)->structuredDes.array.type) == shortcharacter_Type OR
	      type_basic_type(type_description(type)->structuredDes.array.type) == character_Type)))
       ))
    generateOutputPrototype (type, t, context);
  
  if (type->importInterfaceName == NULL AND
      (t == union_Type OR
       t == record_Type OR
       (t == sequence_Type AND
	NOT (type_basic_type(type_description(type)->structuredDes.sequence.type) == shortcharacter_Type OR
	     (type_basic_type(type_description(type)->structuredDes.sequence.type) == byte_Type) OR
	     (type_basic_type(type_description(type)->structuredDes.sequence.type) == character_Type))) OR
       (t == array_Type AND
	NOT (list_size(type_description(type)->structuredDes.array.dimensions) == 1 AND
	     (type_basic_type(type_description(type)->structuredDes.array.type) == byte_Type OR
	      type_basic_type(type_description(type)->structuredDes.array.type) == shortcharacter_Type OR
	      type_basic_type(type_description(type)->structuredDes.array.type) == character_Type)))
       ))
    generateSizeOfPrototype (type, t, context);
  
  if (type->importInterfaceName == NULL AND
      (t == union_Type OR
       t == record_Type OR
       (t == sequence_Type AND (!TypeIsString(type))) OR
       (t == array_Type)
       ))
    generateInputPrototype (type, t, context);
  
  if (type->importInterfaceName == NULL AND
      (t == union_Type OR
       t == record_Type OR
       t == optional_Type OR
       t == sequence_Type OR
       t == array_Type))
    generateFreePrototype (type, t, context);
/*  
  if (t == sequence_Type &&
      type_basic_type (type_description (type)->structuredDes.sequence.type) == byte_Type)
    {
      generateSequenceCreatePrototype (type, context);
    }
*/
}

void generateCHeaders (
    Interface 	interface,
    FILE 	*file)
{
    struct context_s 	context;
    list 		sorted = new_list ();

    context.file = file;
    context.interface = interface;
    context.class = NULL;
    fprintf (file, "#ifndef __%s_h_\n", c_interface_name (interface));
    fprintf (file, "#define __%s_h_\n", c_interface_name (interface));
    generateBoilerplate (file, interface);
    generateNecessaryIncludes (&context);
    generateNormalIncludes (&context);
    list_enumerate (interface->constants, (void (*)(refany, refany)) declareConstant, &context);
    fprintf (file, "\n");
    list_enumerate (interface->classes, (void (*)(refany, refany)) declareClassType, &context);
    list_enumerate (interface->types, sortTypesForDeclaration, sorted);
    fprintf (file, "\n");
    list_enumerate (interface->types, (void (*)(refany, refany)) typedefType, &context);
    fprintf (file, "\n");
    list_enumerate (sorted, (void (*)(refany, refany)) declareType, &context);
    fprintf (file, "\n");
    list_enumerate (interface->exceptions, (void (*)(refany, refany)) declareException, &context);
    fprintf (file, "\nextern void _%s_CatchException (ilu_Call, ILU_C_ENVIRONMENT *, ilu_cardinal);\n",
	     c_interface_name(interface));
    fprintf (file, "extern void _%s_SendException (ilu_Call, ILU_C_ENVIRONMENT *);\n", c_interface_name(interface));
    fprintf (file, "\n");
    list_enumerate (interface->classes, (void (*)(refany, refany)) declareCClass, &context);
    list_enumerate (interface->types, (void (*)(refany, refany)) generateSeqProto, &context);
    list_enumerate (interface->types, (void (*)(refany, refany)) generateTypeIoProto, &context);
    fprintf (file, "\n");
    fprintf (file, "extern void %s__Initialize();\n\n", c_interface_name(interface));
    fprintf (file, "extern void %s__InitializeServer();\n\n", c_interface_name(interface));
    fprintf (file, "#endif /* ifndef __%s_h_ */\n", c_interface_name(interface));
}

static void sortArgTypes (
    Argument 	arg,
    list 	sorted)
{
  sortTypesForDeclaration (arg->type, sorted);  
}

static void sortMethodTypes (
    Procedure 	m,
    list 	sorted)
{
    if (!m->returnOptional)
        sortTypesForDeclaration (m->returnType, sorted);
    list_enumerate (m->arguments, (void (*)(refany, refany)) sortArgTypes, sorted);
}

static void sortTypesForDeclaration (
    Type 	type,
    list 	sorted)
{
    enum PrimitiveTypes t;
    static list 	pending = NULL;

    if (type == NULL)
        return;
    if (pending == NULL)
      pending = new_list ();
    t = type_basic_type (type);
    if (list_find (sorted, matchPointer, type) != NULL || 
		list_find (pending, matchPointer, type) != NULL)
        return;
    else {
        list_insert (pending, type);
        if (type->importInterfaceName == NULL &&
	  	( t == record_Type || 	
		  t == array_Type || 
		  t == union_Type || 
		  t == sequence_Type || 
		  t == object_Type)) {
  	    switch (t) {
	    case record_Type:
	        list_enumerate (
			type_description (type)->structuredDes.record, 
			(void (*)(refany, refany)) sortArgTypes, 
			sorted);
	        break;
	    case union_Type:
	        list_enumerate (
			type_description (type)->structuredDes.uniond.types, 
			(void (*)(refany, refany)) sortArgTypes, 
			sorted);
	        break;
	    case array_Type:
	        if (!type_description (type)->structuredDes.array.optional)
	  	    sortTypesForDeclaration (
			type_description (type)->structuredDes.array.type, 
			sorted);
	        break;
	    case sequence_Type:
	        sortTypesForDeclaration (
			type_description (type)->structuredDes.sequence.type, 
			sorted);
	        break;
	    case object_Type:
	        list_enumerate (
			class_object (type)->superclasses, 
	        	(void (*)(refany, refany)) sortTypesForDeclaration,
			sorted);
	        list_enumerate (
			class_object (type)->methods, 
			(void (*)(refany, refany)) sortMethodTypes, 
			sorted);
	        break;

	      default:
		break;
	    }
	}
        if (list_find (sorted, matchPointer, type) == NULL)
	    list_insert (sorted, type);
        list_remove (pending, type);
    }
}
