#ifndef _ILU_H_
#define _ILU_H_

#include <stdio.h>

#define BEGINARGS	/*
#define ENDARGS		*/

/* ==================== basic types ==================== */

typedef enum ilu_boolean_enum { ilu_TRUE = 1, ilu_FALSE = 0 } ilu_boolean;

typedef long int ilu_integer;
typedef short int ilu_shortinteger;

typedef unsigned long int ilu_cardinal;
typedef unsigned short int ilu_shortcardinal;

typedef double ilu_real;
typedef float ilu_shortreal;

typedef char * ilu_string;
typedef unsigned char * ilu_opaque;
typedef unsigned char * ilu_bytes;
typedef unsigned char ilu_byte;

typedef unsigned short ilu_character;
typedef unsigned char ilu_shortcharacter;

typedef char * ilu_refany;
typedef char * ilu_private;

typedef void (*ilu_void_procedure)();
typedef ilu_boolean (*ilu_boolean_procedure)();

/* ==================== internal structs ==================== */

typedef enum ilu_ProtocolTypes {
  ilu_ProtocolType_None,
  ilu_ProtocolType_SunRPC,		/* "sunrpc_2" */
  ilu_ProtocolType_Courier,		/* "xeroxcourier" */
  ilu_ProtocolType_DCE,			/* "osfdce" */
  ilu_ProtocolType_Micro1,		/* "micro1" */
} ilu_ProtocolType;

typedef enum ilu_ProtocolExceptions {
  ilu_ProtocolException_Success = 0,
  ilu_ProtocolException_NoSuchClassAtServer = 1,
  ilu_ProtocolException_ClassVersionMismatch = 2,
  ilu_ProtocolException_NoSuchMethodOnClass = 3,
  ilu_ProtocolException_GarbageArguments = 4,
  ilu_ProtocolException_Unknown = 5,
  ilu_ProtocolException_LostConnection = 6,
  ilu_ProtocolException_RequestRejected = 7,
  ilu_ProtocolException_RequestTimeout = 8
} ilu_ProtocolException;

typedef enum ilu_PacketTypes {
  ilu_PacketType_Request = 0,
  ilu_PacketType_Reply = 1
} ilu_PacketType;

typedef enum ilu_TransportTypes {
  ilu_TransportType_None = 0,		/* bogus type */
  ilu_TransportType_TCP = 1,		/* "tcp" */
  ilu_TransportType_UDP = 2,		/* "udp" */
  ilu_TransportType_XNS = 3,		/* "xns" */
  ilu_TransportType_Memory = 4		/* "memory" */
} ilu_TransportType;

enum ilu_PipeDirections { ilu_PipeSink, ilu_PipeSource };

typedef char * ilu_Exception;			/* address of exception description */

typedef struct _ilu_Server_s * ilu_Server;	/* handle held by client on server */

typedef struct _ilu_Client_s * ilu_Client;	/* handle held by server on client */

typedef struct _ilu_Connection_s * ilu_Connection;	/* wrapper for bytestream connection */

typedef struct _ilu_Object_s * ilu_Object;	/* wrapper around server for instances */

typedef struct _ilu_Pipe_s * ilu_Pipe;		/* pipe for connection to other module */

typedef struct _ilu_TransportClass_s *ilu_TransportClass;	/* methods for Transport */

typedef struct _ilu_Transport_s *ilu_Transport;	/* abstraction of a TCP/IP or XNS Transport */

typedef struct _ilu_Protocol_s * ilu_Protocol;	/* protocol binding */

typedef struct _ilu_PortClass_s * ilu_PortClass;	/* methods for a Port */

typedef struct _ilu_Port_s * ilu_Port;		/* handle held by server on bytestream */

typedef struct _ilu_Mooring_s * ilu_Mooring;	/* abstraction of a listen socket */

typedef struct _ilu_Class_s * ilu_Class;	/* class description for server */

typedef struct _ilu_Method_s * ilu_Method;	/* method description for server */

typedef struct _ilu_Call_s * ilu_Call;		/* call description */

typedef ilu_refany ilu_Lock;			/* slot for lock implementation's use */

struct _ilu_Protocol_s {

  ilu_ProtocolType	type;

  ilu_boolean	(*begin_request)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_Method method, ilu_cardinal arg_size 
#endif
);
  ilu_boolean	(*finish_request)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call 
#endif
);

  ilu_boolean	(*begin_reply)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_boolean exceptions_possible, ilu_cardinal reply_size 
#endif
);
  ilu_boolean	(*finish_reply)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call 
#endif
);

  ilu_boolean	(*begin_exception)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_cardinal exception_code, ilu_cardinal reply_size 
#endif
);
  ilu_boolean	(*finish_exception)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call 
#endif
);

  ilu_boolean	(*output_integer)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_integer i 
#endif
);
  ilu_boolean	(*input_integer)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_integer *i 
#endif
);
  ilu_cardinal	(*size_of_integer)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_integer i 
#endif
);

  ilu_boolean	(*output_cardinal)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_cardinal i 
#endif
);
  ilu_boolean	(*input_cardinal)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_cardinal *i 
#endif
);
  ilu_cardinal	(*size_of_cardinal)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_cardinal i 
#endif
);

  ilu_boolean	(*output_shortinteger)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortinteger i 
#endif
);
  ilu_boolean	(*input_shortinteger)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortinteger *i 
#endif
);
  ilu_cardinal	(*size_of_shortinteger)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortinteger i 
#endif
);

  ilu_boolean	(*output_shortcardinal)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortcardinal i 
#endif
);
  ilu_boolean	(*input_shortcardinal)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortcardinal *i 
#endif
);
  ilu_cardinal	(*size_of_shortcardinal)(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortcardinal i 
#endif
);

  ilu_boolean	(*output_real)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_real i 
#endif
);
  ilu_boolean	(*input_real)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_real *i 
#endif
);
  ilu_cardinal	(*size_of_real)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_real i 
#endif
);

  ilu_boolean	(*output_shortreal)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortreal i 
#endif
);
  ilu_boolean	(*input_shortreal)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortreal *i 
#endif
);
  ilu_cardinal	(*size_of_shortreal)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortreal i 
#endif
);

  ilu_boolean	(*output_byte)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_byte i 
#endif
);
  ilu_boolean	(*input_byte)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_byte *i 
#endif
);
  ilu_cardinal	(*size_of_byte)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_byte i 
#endif
);

  /* this is a Unicode character */
  ilu_boolean	(*output_character)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_character i 
#endif
);
  ilu_boolean	(*input_character)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_character *i 
#endif
);
  ilu_cardinal	(*size_of_character)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_character i 
#endif
);

  /* this is an ASCII character */
  ilu_boolean	(*output_shortchar)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortcharacter i 
#endif
);
  ilu_boolean	(*input_shortchar)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortcharacter *i 
#endif
);
  ilu_cardinal	(*size_of_shortchar)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_shortcharacter i 
#endif
);

  ilu_boolean	(*output_enum_code)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_cardinal i 
#endif
);
  ilu_boolean	(*input_enum_code)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_cardinal *i 
#endif
);
  ilu_cardinal	(*size_of_enum_code)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_cardinal i 
#endif
);

  /* a string is a sequence of shortcharacter */
  ilu_boolean	(*output_string)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_string s, ilu_cardinal length
#endif
);
  ilu_boolean	(*input_string)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_string *s, ilu_cardinal *length
#endif
);
  ilu_cardinal	(*size_of_string)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_string s, ilu_cardinal length
#endif
);

  /* a stringvec is a vector of shortcharacter -- not null-terminated */
  ilu_boolean	(*output_stringvec)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_string s, ilu_cardinal length
#endif
);
  ilu_boolean	(*input_stringvec)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_string *s, ilu_cardinal length
#endif
);
  ilu_cardinal	(*size_of_stringvec)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_string s, ilu_cardinal length
#endif
);

  /* opaque is a vector of bytes */
  ilu_boolean	(*output_opaque)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_opaque s, ilu_cardinal length
#endif
);
  ilu_boolean	(*input_opaque)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_opaque *s, ilu_cardinal length
#endif
);
  ilu_cardinal	(*size_of_opaque)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_opaque s, ilu_cardinal length
#endif
);

  /* bytes is a sequence of bytes */
  ilu_boolean	(*output_bytes)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_bytes s, ilu_cardinal length
#endif
);
  ilu_boolean	(*input_bytes)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_bytes *s, ilu_cardinal *length
#endif
);
  ilu_cardinal	(*size_of_bytes)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_bytes s, ilu_cardinal length
#endif
);

  ilu_boolean	(*output_pipe)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_Pipe i
#endif
);
  ilu_boolean	(*input_pipe)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_Pipe *i
#endif
);
  ilu_cardinal	(*size_of_pipe)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_Pipe i
#endif
);

  ilu_boolean	(*skip_bytes)		(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_cardinal numBytes 
#endif
);

  /* some functions concerned with string binding handles */

  ilu_string	(*form_handle)	(
#ifdef AllowFunctionPrototypes
 ilu_Class class, ilu_Port port
#endif
);

  /* lower-level functions used by the language runtime */

  ilu_opaque	(*read_packet)		(
#ifdef AllowFunctionPrototypes
 ilu_Transport bs, ilu_cardinal *packet_length, ilu_cardinal *packet_type, ilu_cardinal *serial_number 
#endif
);

  void		(*free_packet)		(
#ifdef AllowFunctionPrototypes
 ilu_refany protocol_data
#endif
);

  ilu_boolean	(*interpret_request)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_opaque packet, ilu_cardinal packet_length 
#endif
);

  enum ilu_ProtocolExceptions
    		(*interpret_reply)	(
#ifdef AllowFunctionPrototypes
 ilu_Call call, ilu_opaque packet, ilu_cardinal packet_length, ilu_cardinal *exception_code 
#endif
);

  ilu_refany	(*create_data_block)	(
#ifdef AllowFunctionPrototypes
#endif
);

  void		(*free_data_block)	(
#ifdef AllowFunctionPrototypes
 ilu_refany block
#endif
);

};

struct _ilu_TransportClass_s {

  ilu_TransportType	type;

  ilu_refany (*interpret_info)		(
#ifdef AllowFunctionPrototypes
 ilu_string info
#endif
);

  ilu_string (*form_info)		(
#ifdef AllowFunctionPrototypes
  ilu_refany parameterblock
#endif
);

  ilu_boolean (*connect)		(
#ifdef AllowFunctionPrototypes
 ilu_Transport self
#endif
);

  void (*close)				(
#ifdef AllowFunctionPrototypes
 ilu_Transport bs 
#endif
);

  ilu_boolean	(*data_present_p)	(
#ifdef AllowFunctionPrototypes
 ilu_Transport bs 
#endif
);

  /* returns FALSE if error occurred, TRUE if input is available */
  ilu_boolean	(*wait_for_input)	(
#ifdef AllowFunctionPrototypes
 ilu_Transport bs 
#endif
);

  ilu_cardinal	(*read_bytes)		(
#ifdef AllowFunctionPrototypes
 ilu_Transport bs, ilu_bytes buffer, ilu_cardinal bufferSize
#endif
);
  ilu_cardinal	(*write_bytes)		(
#ifdef AllowFunctionPrototypes
 ilu_Transport bs, ilu_bytes bytes, ilu_cardinal bytesLength
#endif
);

  void 		(*flush_output)		(
#ifdef AllowFunctionPrototypes
 ilu_Transport bs 
#endif
);

  ilu_Mooring	(*create_mooring)		(
#ifdef AllowFunctionPrototypes
  ilu_private mooringInfo
#endif
);

};

struct _ilu_Transport_s {

  ilu_Lock lock;
  ilu_TransportClass class;			/* methods and type */
  int fd;					/* every Transport has a UNIX file descriptor */
  ilu_refany data;				/* variable data structure for transport-private data */
};

struct _ilu_Connection_s {
  ilu_Lock lock;				/* lock for concurrent access */
  ilu_Protocol protocol;
  ilu_refany protocol_data;
  ilu_Transport transport;			/* actual byte stream */
  ilu_Port port;				/* NULL on client side, points to port on server side */
};

struct _ilu_Method_s {				/* read-only; no locks needed */
  ilu_string name;
  ilu_cardinal id;
  ilu_boolean cacheable;			/* functional? */
  ilu_boolean asynchronous;			/* need to wait after calling? */
  ilu_Exception *exceptionVector;		/* list of possible exceptions */
  ilu_cardinal exceptionCount;			/* number of exceptions in list */
  ilu_void_procedure stubproc;
};

struct _ilu_Class_s {				/* read-only: no locks needed */

  ilu_string name;				/* ILU name of class */
  ilu_string brand;				/* brand on class */
  ilu_string unique_id;				/* unique id for type graph of class */
  ilu_boolean singleton;			/* TRUE (1) if class is a singleton */
  ilu_string authentication;			/* non-NULL with name of authentication type, if any */
  ilu_Method methods;
  ilu_cardinal method_count;
  ilu_Class superclass;				/* chain of links to root */
  ilu_string superclassname;			/* name of superclass */
};

struct _ilu_Call_s {
  ilu_Lock		lock;			/* lock for concurrent use */
  ilu_cardinal		serialNumber;		/* serial number of request */
  ilu_Object		object;			/* object method was invoked on */
  ilu_Method		method;			/* ID number of method */
  ilu_Connection	connection;		/* connection which points to (server or client) */
  ilu_refany		private;		/* slot for lang-specific implementation's use */
};

struct _ilu_Pipe_s {
  ilu_Lock lock;
  ilu_Mooring mooring;				/* non-NULL for local pipes */
  ilu_Call call;				/* wrapper around connection */
  ilu_Protocol protocol;			/* protocol for pipe object */
  ilu_string contact_info;			/* contact info for transport connection */
  ilu_boolean sink_p;				/* TRUE if pipe end is a sink */
  ilu_boolean valid;				/* TRUE if pipe can be read/written */
  ilu_string type;				/* name of type of pipe */
};

struct _ilu_Mooring_s {

  ilu_Lock lock;

  int fd;			/* has an FD, like a Transport */

  ilu_boolean (*connection_pending_p)	(
#ifdef AllowFunctionPrototypes
 ilu_Mooring self 
#endif
);

  ilu_Transport (*accept_connection)	(
#ifdef AllowFunctionPrototypes
 ilu_Mooring self
#endif
);

  ilu_TransportClass transportClass;	/* kind of transport returned by accept_connection */
  ilu_private data;
};

struct _ilu_Port_s {		/* this is a network connection on which a server listens for requests */

  ilu_Lock lock;		/* lock for concurrent access */
  ilu_Protocol protocol;	/* protocol being used */
  ilu_Mooring mooring;		/* byte stream socket this port listens on */
  ilu_private objects;		/* hash table of objects keyed by SBH */
  ilu_cardinal class_count;	/* count of classes exported */
  ilu_private classes;		/* hash table of classes exported keyed by pointer to class -- to find class from ID with */
  ilu_boolean singleton;	/* true if a singleton class is exported via this port */
};

struct _ilu_Server_s {

  ilu_Lock lock;		/* lock for concurrent access */
  ilu_Connection connection;	/* NULL for true instances, non-NULL for client instances */
  ilu_string serverHandle;	/* of the form '<instance-id>@<protocol>_<protocol-specific-data>' */
  ilu_private objects;		/* hash table of objects on this server */
};

struct _ilu_Object_s {

  ilu_Lock lock;		/* lock for concurrent access -- mainly read-only, so seldom used */
  ilu_string oid;
  ilu_string SBH;		/* actually a cache, lazily eval'ed; may be NULL at any time */
  ilu_Server server;
  ilu_Class  class;
  ilu_private languageSpecificObj;	/* slot to store language-specific pointer in */
};

#include <iluExports.h>

#endif /* _ILU_H_ */
