/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/

/*
$Id: cplusplus.c,v 1.13 1994/04/06 01:39:19 severson Exp $
*/
#ifdef MACOS
#pragma segment islcppmain
#endif

#ifndef MACOS
#include <unistd.h>		/* for access W_OK */
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/errno.h>
#endif
#include <sys/stat.h>		/* for stat */

#include <time.h>		/* for ctime() */

#include "cplusplus.h"

extern string cplusplus_interface_name(Interface i);
static void generate_c_boilerplate(FILE *file, Interface parse);

char *OutputDirectory = ".";
char *ProgramName = "c++-stubber";
char *NamesFile = NULL;
boolean GenerateImakefile = FALSE;
boolean GenerateServerSkeleton = FALSE;
boolean GenerateClasses = FALSE;

extern boolean ReadSynonyms (string filename);	/* from names.c */

static void GenerateHeaders (Interface parse)
{
  char filename[1000];
  FILE *file;

#ifdef MACOS
  sprintf (filename, "%s.H", cplusplus_interface_name(parse));
#else
  sprintf (filename, "%s/%s.H", OutputDirectory, cplusplus_interface_name(parse));
#endif

  if ((file = fopen (filename, "w")) == NULL)
    {
      fprintf (stderr, "Couldn't open output file %s.\n", filename);
      exit (1);
    }
  printf ("header file interface %s to %s...\n", cplusplus_interface_name(parse), filename);
  generate_c_boilerplate (file, parse);
  generate_headers (parse, file);
  fclose (file);
}

static void GenerateCode (Interface parse)
{
  char filename[1000];
  FILE *file;

#ifdef MACOS
  sprintf (filename, "%s.cp", cplusplus_interface_name(parse));
#else
  sprintf (filename, "%s/%s.cc", OutputDirectory, cplusplus_interface_name(parse));
#endif
  if ((file = fopen (filename, "w")) == NULL)
    {
      fprintf (stderr, "Couldn't open client stubs output file %s.\n", filename);
      exit (1);
    }
  printf ("code for interface %s to %s...\n", cplusplus_interface_name(parse), filename);
  generate_c_boilerplate (file, parse);
  generate_code (parse, file);
  fclose (file);

#ifdef MACOS
  sprintf (filename, "%s-server-stubs.cp", cplusplus_interface_name(parse));
#else
  sprintf (filename, "%s/%s-server-stubs.cc", OutputDirectory, cplusplus_interface_name(parse));
#endif
  if ((file = fopen (filename, "w")) == NULL)
    {
      fprintf (stderr, "Couldn't open server stubs output file %s.\n", filename);
      exit (1);
    }
  printf ("code for server stubs of interface %s to %s...\n", cplusplus_interface_name(parse), filename);
  generate_c_boilerplate (file, parse);
  generate_server_code (parse, file);
  fclose (file);
}

static void generate_imakefile (Interface parse, FILE *file)
{
  struct context_s c;

  c.interface = parse;
  c.file = file;
}

static boolean makedir (char *dirname)
{
#ifdef MACOS
	return TRUE;
#else
  struct stat s;

  if (stat (dirname, &s) == 0)
    return (S_ISDIR(s.st_mode) AND (access(dirname, W_OK) == 0));
  else
    {
      char buf[1000];
      sprintf (buf, "mkdir %s", dirname);
      return ((system(buf) >> 8) == 0);
    }
#endif /* MACOS */
}

static void GenerateStubs (Interface parse)
{
  char filename[1000];
  FILE *file;

  if (! makedir (OutputDirectory))
    {
      fprintf (stderr, "Couldn't create output directory %s.\n", OutputDirectory);
      exit (1);
    }

  if (GenerateClasses)
    {
      GenerateHeaders (parse);
      GenerateCode (parse);
    }

  if (GenerateImakefile)
    {
      sprintf (filename, "%s/Imakefile", OutputDirectory);
      if ((file = fopen (filename, "w")) == NULL)
	{
	  fprintf (stderr, "Couldn't open output file %s.\n", filename);
	  exit (1);
	}
      printf ("ILU-style Imakefile to %s...\n", filename);
      generate_imakefile (parse, file);
      fclose (file);
    }
}

static void PrintUsage (void)
{
  fprintf (stderr, "Usage:  %s [-dir OUTPUTDIRECTORY] [-imakefile] [-serverskeleton] [-classes] [-renames NAMESFILE] ISLFILE [ISLFILE ...]\n", ProgramName);
}

static boolean ParseArgs (int *pac, char ***pav)
{
  int ac = *pac;
  char **av = *pav;

  ac--;
  av++;
  while (*av[0] == '-')
    {
      if (strcmp(*av, "-dir") == 0)
	OutputDirectory = *++av;
      else if (strcmp(*av, "-imakefile") == 0)
	GenerateImakefile = TRUE;
      else if (strcmp(*av, "-serverskeleton") == 0)
	GenerateServerSkeleton = TRUE;
      else if (strcmp(*av, "-renames") == 0)
	NamesFile = *++av;
      else if (strcmp(*av, "-classes") == 0)
	GenerateClasses = TRUE;
      else
	{
	  fprintf (stderr, "%s:  Invalid switch \"%s\".\n", ProgramName, *av);
	  PrintUsage();
	  return (FALSE);
	}
      ac--;
      av++;
    }

  if (!(GenerateServerSkeleton || GenerateImakefile || GenerateClasses))
    {
      GenerateClasses = TRUE;
    }

  *pac = ac;
  *pav = av;
  return (TRUE);
}

void
main (int ac, char **av, char **envp)
{
  list s;
  char **filename;
  extern Interface GetInterface(string, string);

  ProgramName = av[0];

  if (ac < 2)
    {
      PrintUsage();
      exit(1);
    }

  if (!ParseArgs (&ac, &av))
    exit(1);

  if (NamesFile != NULL)
    {
      if (!ReadSynonyms (NamesFile))
	{
	  fprintf (stderr, "Couldn't read names file %s.\n", NamesFile);
	  exit (1);
	};
    };      

  for (filename = av;  *filename != NULL;  filename += 1)
    {
      if ((s = ParseFile (*filename)) == NULL)
	{
	  fprintf (stderr, "Couldn't find or parse %s.\n", *filename);
	  exit (1);
	}
      list_enumerate (s, (iluparser_EnumProc) GenerateStubs, NULL);
    }
  exit(0);
}

#ifndef MACOS

extern Interface GetInterface(string, string);

static char *ModTime (char *path)
{
  static char timebuf[30];
  struct stat statbuf;

  stat (path, &statbuf);
  strcpy (timebuf, (char *) ctime(&statbuf.st_mtime));
  timebuf[24] = '\0';
  return (timebuf);
}

static char *GoodGetLogin (void)
{
  char *name;
  struct passwd *pw;

  if (((name = cuserid(NULL)) == NULL)
      && (name = (char *) getlogin()) == NULL
      && (name = (char *) (((pw = getpwuid(getuid())) == NULL) ? NULL : pw->pw_name)) == NULL
      && (name = (char *) getenv("USER")) == NULL)
    return "nobody";
  else
    return name;
}
#else /* MACOS */
 
extern Interface GetInterface(string, string);
 
static char *ModTime (char *path)
{
return "Jan 15, 1692";
}
 
static char *GoodGetLogin (void)
{
return "Macintosh C++ user";
}
 
#endif /* MACOS */

static void PrintImportedFileInfoForC (Imported s, FILE *file)
{
  Interface i = GetInterface (s->name, s->filename);

  if (i == NULL)
    {
      fprintf (stderr, "Couldn't find interface \"%s\".\n", s->name);
      exit(1);
    }
  else
    fprintf (file, ",\n * and \"%s\" of %s", i->filename, ModTime(i->filename));
}

static void generate_c_boilerplate (FILE *file, Interface parse)
{
  time_t clock = time(0);
  char *now;

  now = ilu_strdup(ctime(&clock));
  now[strlen(now) - 1] = '\0';
  
  fprintf (file, "/* this file was automatically generated\n * at %s by %s\n * running \"%s\" of %s\n",
	   now, GoodGetLogin(), ProgramName, ModTime(ProgramName));
  fprintf (file, " * on \"%s\" of %s", parse->filename, ModTime(parse->filename));
  if (list_size(parse->imports) > 0)
    list_enumerate (parse->imports, (iluparser_EnumProc) PrintImportedFileInfoForC, file);
  fprintf (file, ".\n */\n\n");
}
