;;; -*- Mode:Lisp; Package: ILU; Syntax:COMMON-LISP; Base:10 -*-
#|
Copyright (c) 1991, 1992, 1993, 1994 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: ilu-kernel.lisp,v 1.4 1994/05/10 02:09:50 janssen Exp $
|#

(cl:in-package :ilu)

;;;;;;;;;;;;;;;;;;;; some simple C functions ;;;;;;;;;;;;;;;;;;;;

;; locking unconstrained

(define-c-function bytencopy
    "copy a C byte sequence into a lisp byte vector, using C memmove()"
    "ilulisp_bytencopy" (:byte-sequence :pointer :fixnum) :void)

(define-c-function free
    "free malloc'ed space"
    "free" (:pointer) :void :inline t)

;;;;;;;;;;;;;;; random ILU kernel functions ;;;;;;;;;;;;;;;

;; locking unconstrained

(define-c-function set-debug-level
    "set the kernel debugging level.  The argument is a bitmask, each
     bit selecting debug messages on some functional unit."
    "ilu_SetDebugLevel" (:fixnum) :void)

(define-c-function ilu_generate-server-id
  "Generate universally unique string from host's IP address, time, pid, etc."
  "ilu_InventID" (:fixnum) :pointer)

;;;;;;;;;;;;;;; ILU kernel object manipulation ;;;;;;;;;;;;;;;

;; L1 >= {obj's server}; L2, main unconstrained
(define-c-function get-language-specific-object
    "Return Lisp object associated with kernel object (arg 1)"
  "ilu_GetLanguageSpecificObject" (:ilu-object) :pointer :inline t)

;; Inside (obj's server, obj's type)
(define-c-function register-language-specific-object
    "Set Lisp object of kernel object (arg 1) to be (arg 2).  Arg 2 is index returned by ilu:register-lisp-value."
  "ilu_RegisterLanguageSpecificObject" (:ilu-object :pointer) :void :inline t)

;;  before: L1 = {};
;;  after:  result!=NULL => Inside(result's server, static_type);
;;  after:  result==NULL => L1 = {};
;;  forall conn: (L2 >= {conn.iomu}) => (L2 >= {conn.callmu});
;;  Main otherwise unconstrained
(define-c-function object-of-sbh
    "Return kernel object associated with SBH (arg 1)
with type hinted at by optional unique_id (arg 2).  Arg 3 is ilu_Class."
  "ilu_ObjectOfSBH" (:string :string :pointer) :ilu-object :inline t)

;; L1 >= {obj's server}; L1_sup < prmu
(define-c-function ilu_sbh-of-object
    "Returns the kernel object's string binding handle"
  "ilu_SBHOfObject" (:ilu-object) :pointer :inline t)

;;  before: 				       L1 disjoint {cmu, server};
;;  before: cl collectible		    => L1  not >=  {gcmu};
;;  before: cl collectible & server surrogate => Main Invariant holds;
;;  after:  Inside(server, cl)
(define-c-function ilu_enter-server
    "go to Inside(SERVER, CLASS)"
  "ilu_EnterServer" (:pointer :pointer) :void :inline t)

;;  before: Inside(server, cl);
;;  after:				      L1 disjoint {cmu, server};
;;  after: cl collectible			   => L1  not >=  {gcmu};
;;  after: cl collectible & server surrogate => Main Invariant holds
(define-c-function ilu_exit-server
    "Exit from Inside(SERVER, CLASS)"
  "ilu_ExitServer" (:pointer :pointer) :void :inline t)

;; L1, L2, Main unconstrained
;; (But be careful about holding directly onto an ilu_Object)

(define-c-function ilulisp_instance-id
    "Return instance ID of object"
  "ilu_IhOfObject" (:ilu-object) :pointer)

(define-c-function ilu_ilu-class
    "ilu_Class of kernel object"
  "ilu_ClassOfObject" (:ilu-object) :pointer :inline t)

(define-c-function ilu_ilu-server
    "ilu_Server of kernel object"
  "ilu_ServerOfObject" (:ilu-object) :pointer :inline t)

;;;;;;;;;;;;;;; ILU kernel method manipulation ;;;;;;;;;;;;;;;

;; L1, L2, Main unconstrained

(define-c-function find-method-by-id
    "Return ilu_Method on object (arg 1) indicated by index (arg 3)"
  "ilu_FindMethodByID" (:pointer :fixnum) :pointer :inline t)

(define-c-function id-of-method
    "Return the ID if the ilu_Method"
  "ilulisp_IDOfMethod" (:pointer) :cardinal :inline t)

;;;;;;;;;;;;;;; ILU kernel class manipulation ;;;;;;;;;;;;;;;

;; L1, L2, Main unconstrained
(define-c-function ilulisp_id-of-class
    "Return unique_id field of class (arg 1)"
  "ilulisp_IDOfClass" (:pointer) :pointer :inline t)

;; L1_sup < otmu
;; L2, Main unconstrained

(define-c-function ilu_register-class
    "Register ilu_Class (arg 1) as being in use in this address space"
  "ilu_RegisterClass" (:pointer) :void :inline t)

(define-c-function ilu_find-class-from-id
    "Return pointer to class record, given pointer to class UID"
  "ilu_FindClassFromID" (:pointer) :pointer :inline t)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  Call primitive functions
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; after: L2 >= {call's conn's callmu, iomu} iff result non-NULL
(define-c-function ilu_begin-call
  "Build a call object on SERVER"
  "ilu_BeginCall" (:pointer) :ilu-call :inline t)

;; L2 >= {call's conn's callmu, iomu}
;; L1, Main unconstrained
;; L1_sup < prmu
(define-c-function begin-request
  "Begin a request"
  "ilu_BeginRequest" (:ilu-call :pointer :pointer :cardinal) :void :inline t)

;; Main Invariant holds
(define-c-function finish-request
    "Finish the request (flush the message to the server)"
  "ilu_FinishRequest" (:ilu-call) :void :inline t)

;;  before: L2 not >=   {call's conn's iomu},
;;	  L2     >=   {call's conn's callmu} iff protocol not concurrent;
;;   after: L2     >=   {call's conn's callmu, iomu} if result is true,
;;	  L2 disjoint {call's conn's callmu, iomu} if result is false.
(define-c-function ilu_begin-reply
    "Start a reply"
  "ilu_BeginReply"  (:ilu-call :fixnum :integer) :void :inline t)

;; Main Invariant holds
;; L2    >=    {call's conn's callmu, iomu} before,
;; L2 disjoint {call's conn's callmu, iomu} after
(define-c-function finish-reply
    "Finish the reply (flush the message to the caller)"
  "ilu_FinishReply" (:ilu-call) :void :inline t)

;;  before: L2 not >=   {call's conn's iomu},
;;	  L2     >=   {call's conn's callmu} iff protocol not concurrent;
;;   after: L2     >=   {call's conn's callmu, iomu} if result is true,
;;	  L2 disjoint {call's conn's callmu, iomu} if result is false.
(define-c-function begin-exception
    "Start an exception"
  "ilu_BeginException" (:ilu-call :integer :integer) :void :inline t)

;; Main Invariant holds
;; L2    >=    {call's conn's callmu, iomu} before,
;; L2 disjoint {call's conn's callmu, iomu} after
(define-c-function finish-exception
    "Finish the exception"
  "ilu_FinishException" (:ilu-call) :void :inline t)

;; L2    >=    {call's conn's callmu, iomu} before,
;; L2 disjoint {call's conn's callmu, iomu} after
(define-c-function finish-call
    "end the scope of the call"
  "ilu_FinishCall" (:ilu-call) :void :inline t)

;; Main Invariant holds
(define-c-function ilu_get-reply
    "Read the reply"
  "ilu_GetReply" (:ilu-call :cardinal-pointer) :fixnum)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  Server functions
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; L2, Main unconstrained
;; L1 < port's server
(define-c-function file-descriptor-of-mooring-of-port
    "Return int fd of mooring"
    "ilulisp_FileDescriptorOfMooringOfPort" (:pointer) :fixnum)

;; L1_sup < conn's server
(define-c-function file-descriptor-of-connection
    "Return int fd of connection"
    "ilu_FileDescriptorOfConnection" (:pointer) :fixnum)

;; L1_sup < smu
;; L2, Main unconstrained
(define-c-function ilu_create-true-server
  "Takes string ID of server, and optional OBJECT-TABLE, returns pointer to server"
  "ilu_CreateTrueServer" (:pointer :pointer) :pointer)

;; L1, L2, Main unconstrained
(define-c-function set-default-server
    "Sets the ILU default server to be server (arg 1)"
  "ilu_SetDefaultServer" (:pointer) :void)

;; L1_sup < s
(define-c-function set-server-default-port
    "Sets the default port of SERVER to be PORT"
  "ilu_SetServerDefaultPort" (:pointer :pointer) :void)

;; Main Invariant holds
(define-c-function create-port
    "Creates an ilu port on SERVER with protocol as specified by PROTOCOL \
     and transport as specified by TRANSPORT"
  "ilu_CreatePort" (:pointer :string :string) :pointer)

;; L1_sup < cmu
;; Main Invariant holds
(define-c-function handle-ilu-connection
    "Called by server to create a connection on PORT"
    "ilulisp_HandleNewConnection"
    (:pointer) :pointer)

(define-c-function ilulisp_get-request
    "Called by server to begin the input of a request"
  "ilulisp_ReceiveRequest"
  (:pointer :cardinal-pointer :cardinal-pointer :cardinal-pointer) :fixnum)

(define-c-function ilu_request-read
    "Called by the server to indicate that it has finished reading the arguments of a request"
  "ilu_RequestRead"
  (:pointer) :void)

(define-c-function ilu_no-reply
    "Called by the server to indicate that this function has no reply"
  "ilu_NoReply"
  (:pointer) :void)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  Binding functions
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;  before: Inside(s, cl)
;;  after:				 L1 disjoint {cmu, s};
;;  after: cl collectible		      => L1  not >=  {gcmu};
;;  after: cl collectible & s surrogate => Main Invariant holds;
;;  where s = obj's server and cl = obj's type.
;;  (We don't really need to hold cmu for surrogate or non-collectible
;;   objects, but this is convenient because ilu_Enter/ExitServer can
;;   be used.)
(define-c-function ilu_publish-object
    "Called to register object's OID with domain binding service"
  "ilu_PublishObject"
  (:ilu-object) :pointer)
    
;;  before: Inside(s, cl)
;;  after:				 L1 disjoint {cmu, s};
;;  after: cl collectible		      => L1  not >=  {gcmu};
;;  after: cl collectible & s surrogate => Main Invariant holds;
;;  where s = obj's server and cl = obj's type.
;;  (We don't really need to hold cmu for surrogate or non-collectible
;;   objects, but this is convenient because ilu_Enter/ExitServer can
;;   be used.)
(define-c-function ilu_withdraw-published-object
    "Called to withdraw registration"
  "ilu_WithdrawObject"
  (:ilu-object :pointer) :fixnum)

;;  before: L1 = {};
;;  after:  result!=NULL => Inside(result's server, pclass);
;;  after:  result==NULL => L1 = {};
;;  forall conn: (L2 >= {conn.iomu}) => (L2 >= {conn.callmu});
;;  Main otherwise unconstrained */
(define-c-function ilu_lookup-object-by-oid
    "Given an oid, return the kernel object associated with it"
  "ilu_LookupObject"
  (:string :ilu-class) :ilu-object)

;;  L1 >= {the object's server}
;;  L1 >= {gcmu} if cl collectible
(define-c-function ilu_find-or-create-true-object
    "Create true object if not found"
  "ilu_FindOrCreateTrueObject"
  (:pointer :pointer :ilu-class :fixnum) :ilu-object)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  This is *only* for debugging.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-c-function ilu_set-dump-on-assert-failure
    "0 causes not to SEGV on assert failure, 1 causes SEGV"
  "_ilu_SetDumpOnAssertFailure"
  (:fixnum) :void)
