/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: simpbind.c,v 1.3 1994/04/08 21:42:10 janssen Exp $ */
/* Last tweaked by Mike Spreitzer March 15, 1994 3:43 pm PST */

#define _POSIX_SOURCE

#ifdef MACOS
#pragma segment ilu
#endif

#include <unistd.h>
#include <string.h>
#include <time.h>

#include "ilu.h"
#include "iluntrnl.h"
#include "object.h"

#define OPTIONAL(x)	x

char *ilu_BindingDirectory = ILU_BINDING_DIRECTORY;

/*before: Inside(s, cl)
  after:				 L1 disjoint {cmu, s};
  after: cl collectible		      => L1  not >=  {gcmu};
  after: cl collectible & s surrogate => Main Invariant holds;
  where s = obj's server and cl = obj's type.
  (We don't really need to hold cmu for surrogate or non-collectible
   objects, but this is convenient because ilu_Enter/ExitServer can
   be used.)*/
PASS(OPTIONAL(char *)) ilu_PublishObject (ilu_Object obj)
{
  char *oid;
  char *sbh;
  char buf[1000];
  FILE *f;
  char *proof = NULL;

  if ((sbh = ilu_SBHOfObject(obj)) == NULL)
    {
      DEBUG(OBJECT_DEBUG, (stderr, "ilu_PublishObject:  object 0x%x not exported.\n", obj));
      return (NULL);
    }
  else if (!ilu_ParseStringBindingHandle (sbh, &oid, NULL))
    {
      DEBUG(OBJECT_DEBUG, (stderr, "ilu_PublishObject:  can't parse sbh <%s> for object 0x%x.\n",
			   sbh, obj));
    }
  else
    {
      sprintf (buf, "%s/%s", ilu_BindingDirectory, oid);
      free(oid);
      if (access(buf, R_OK) == 0 && access(buf, W_OK) != 0)
	{
	  DEBUG(EXPORT_DEBUG, (stderr, "ilu_PublishObject:  OID %s already published.\n", buf));
	}
      else if ((f = fopen (buf, "w+")) == NULL)
	{
	  DEBUG(EXPORT_DEBUG, (stderr, "ilu_PublishObject:  Can't open file %s.\n", buf));
	}
      else
	{
	  proof = _ilu_Strdup(ilu_InventID());
	  fprintf (f, "%s\n%s\n%s\n", proof, sbh, ilu_MstidOfObject(obj));
	  fclose(f);
	}
    }
  ilu_ExitServer (object_server(obj), object_class(obj));
  return (proof);
}

/*before: Inside(s, cl)
  after:				 L1 disjoint {cmu, s};
  after: cl collectible		      => L1  not >=  {gcmu};
  after: cl collectible & s surrogate => Main Invariant holds;
  where s = obj's server and cl = obj's type.
  (We don't really need to hold cmu for surrogate or non-collectible
   objects, but this is convenient because ilu_Enter/ExitServer can
   be used.)*/
ilu_boolean ilu_WithdrawObject (ilu_Object obj, PASS(char *) ownership_proof)
{
  char *oid;
  char *sbh;
  char buf[1000];
  FILE *f;
  ilu_boolean result = ilu_FALSE;

  if ((sbh = ilu_SBHOfObject(obj)) == NULL)
    {
      DEBUG(OBJECT_DEBUG, (stderr, "ilu_WithdrawObject:  object 0x%x not exported.\n", obj));
    }
  else if (!ilu_ParseStringBindingHandle (sbh, &oid, NULL))
    {
      DEBUG(OBJECT_DEBUG, (stderr, "ilu_WithdrawObject:  can't parse sbh <%s> for object 0x%x.\n",
			   sbh, obj));
    }
  else
    {
      sprintf (buf, "%s/%s", ilu_BindingDirectory, oid);
      if (access(buf, R_OK) == 0 && access(buf, W_OK) != 0)
	{
	  DEBUG(EXPORT_DEBUG, (stderr, "ilu_WithdrawObject:  Can't access registry file %s.\n", buf));
	}
      else if ((f = fopen (buf, "r+")) == NULL)
	{
	  DEBUG(EXPORT_DEBUG, (stderr, "ilu_WithdrawObject:  Can't open registry file %s.\n", buf));
	}
      else
	{
	  char buf2[1000];

	  if (fgets (buf2, sizeof(buf2), f) == NULL)
	    {
	      DEBUG(EXPORT_DEBUG, (stderr, "ilu_WithdrawObject:  Bad registry file %s.\n", buf));
	      fclose(f);
	    }
	  else if (strncmp (ownership_proof, buf2, strlen(ownership_proof)) != 0)
	    {
	      DEBUG(EXPORT_DEBUG, (stderr, "ilu_WithdrawObject:  no match on ownership proofs with proof %s.\n",
				   ownership_proof));
	      fclose(f);
	    }
	  else
	    {
	      unlink(buf);
	      fclose(f);
	      result = ilu_TRUE;
	    }
	}
    }
  free(ownership_proof);
  ilu_ExitServer (object_server(obj), object_class(obj));
  return result;
}

/*before: L1 = {};
  after:  result!=NULL => Inside(result's server, pclass);
  after:  result==NULL => L1 = {};
  forall conn: (L2 >= {conn.iomu}) => (L2 >= {conn.callmu});
  Main otherwise unconstrained*/
OPTIONAL(ilu_Object) ilu_LookupObject (char *oid, ilu_Class pclass)
{
  char buf[1000];
  FILE *f;

  sprintf (buf, "%s/%s", ilu_BindingDirectory, oid);
  if (access(buf, R_OK) != 0)
    {
      DEBUG(INCOMING_DEBUG, (stderr, "ilu_LookupObject:  No such object %s.\n", buf));
      return (NULL);
    }
  if ((f = fopen (buf, "r")) == NULL)
    {
      DEBUG(INCOMING_DEBUG, (stderr, "ilu_LookupObject:  Can't open registry file %s.\n", buf));
      return (ilu_FALSE);
    }
  else
    {
      char proof[1000], sbh[1000], mstid[1000];
      ilu_Object obj;

      if (fgets (proof, sizeof(proof), f) == NULL
	  || fgets (sbh, sizeof(sbh), f) == NULL
	  || fgets (mstid, sizeof(mstid), f) == NULL)
	{
	  DEBUG(INCOMING_DEBUG, (stderr, "ilu_LookupObject:  Bad registry file %s.\n", buf));
	  fclose(f);
	  return (NULL);
	}
      fclose(f);

      proof[strlen(proof)-1] = '\0';
      sbh[strlen(sbh)-1] = '\0';
      mstid[strlen(mstid)-1] = '\0';

      DEBUG(INCOMING_DEBUG, (stderr, "ilu_LookupObject:  found SBH=<%s>, mstid=<%s>, pclass=<%s>\n",
			     sbh, mstid, pclass->cl_name));

      if ((obj = ilu_ObjectOfSBH (sbh, mstid, pclass)) == NULL)
	{
	  DEBUG(INCOMING_DEBUG, (stderr, "ilu_LookupObject:  Bad object info.\n"));
	  return (NULL);
	}
      else
	{
	  ilu_boolean status;

	  ilu_ExitServer (object_server(obj), object_class(obj));
	  status = ilu_PingObject (obj);
	  ilu_EnterServer (object_server(obj), object_class(obj));
	  if (!status)
	    {
	      DEBUG(OBJECT_DEBUG, (stderr, "ilu_LookupObject:  Bad ping of object %s\n", sbh));
	      ilu_ExitServer(object_server(obj), object_class(obj));
	      return (NULL);
	    }
	  return (obj);
	}
    }      
}
