/*| -*- Mode: C -*-
/*|------------------------------------------------------------
/*|
/*| File: 	pipe.c
/*| Created: 	Tue Jan 28 15:40:30 1992
/*| Author: 	Bill Janssen (janssen@holmes) 
/*| $Locker:  $
/*|
/*|------------------------------------------------------------
/*|
/*| Description: 
/*|
/*|   Code to support pipes.
/*|
/*|------------------------------------------------------------
/*|
/*/
/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* Last tweaked by Mike Spreitzer November 10, 1993 8:54 am PST */
#ifndef lint
    static char xerox_copyright[] = "\
    \
    Copyright 1992 Xerox Corporation \
    All Rights Reserved";
#endif /* lint */
/*|------------------------------------------------------------
/*|
/*|  "$Header: /ilu/src/RCS/pipe.c,v 1.12 1994/02/15 20:33:29 janssen Exp $"
/*/
#ifndef lint
      static char rcs_id[] = "$Header: /ilu/src/RCS/pipe.c,v 1.12 1994/02/15 20:33:29 janssen Exp $";
#endif /* lint */
/*|
/*|------------------------------------------------------------
/*/

#include <ilu.h>

#include "iluntrnl.h"

#include "pipe.h"
#include "protocol.h"
#include "mooring.h"

ilu_Pipe ilu_Pipe_Create (ilu_string contact_info, ilu_string type, ilu_boolean sink_p)
{
  ilu_TransportClass tc;
  ilu_Protocol p;
  ilu_string protocol_info, mooring_info;

  _ilu_ParseConnectInfo (contact_info, NULL, &protocol_info, NULL, &mooring_info);

  if (((tc = _ilu_GetTransportClassByName(mooring_info)) != NULL)
      && (p = _ilu_GetProtocolFromInfo(protocol_info)) != NULL)
    {
      ilu_Pipe new = (ilu_Pipe) malloc(sizeof(struct _ilu_Pipe_s));
      if (sink_p) {
	      new->pi_mooring = (*(tc->tc_create_mooring))((*(tc->tc_interpret_info))(mooring_info));
      } else {
	      new->pi_mooring = NULL;
      }
      new->pi_call = NULL;
      new->pi_protocol = _ilu_GetProtocolFromInfo (protocol_info);
      new->pi_contact_info = _ilu_Strdup(contact_info);
      new->pi_sink_p = sink_p;
      new->pi_valid = FALSE;
      new->pi_type = type;
      return (new);
    }
  else
    return (NULL);
}

ilu_string _ilu_Pipe_ContactInfo (ilu_Pipe p)
{
  ilu_string s = NULL;

  if (p != NULL)
    {
      if (pipe_contact_info(p) != NULL)
	s = pipe_contact_info(p);
      else
	{
	  if (pipe_mooring(p) != NULL)		/* local pipe */
	    {
	      char buf[1000];
	      ilu_string pinfo, minfo;

	      if ((pinfo = protocol_form_handle(pipe_protocol(p), NULL)) != NULL)
		{
		  if ((minfo = mooring_form_handle(pipe_mooring(p))) != NULL)
		    {
		      sprintf (buf, "%s|%s", pinfo, minfo);
		      pipe_contact_info(p) = _ilu_Strdup(buf);
		      s = pipe_contact_info(p);
		      free (minfo);
		    }
		  free(pinfo);
		}
	    }
	}
      ilu_ReleaseReadLock(pipe_lock(p));
    }
  return (s);
}

ilu_boolean ilu_Pipe_Open (ilu_Pipe p)
{
  ilu_string s;
  ilu_Connection c;
  ilu_boolean status = FALSE;

  if (p != NULL && ilu_AcquireWriteLock(pipe_lock(p)))
    {
      if (pipe_call(p)!=NULL)
	status = TRUE;
      else
	{
	  if ((pipe_mooring(p) == NULL) /* unopened source pipe */
	      && (s = _ilu_Pipe_ContactInfo(p)) != NULL
	      && (c = _ilu_CreateConnectionFromInfo(s)) != NULL)
	    {
	      pipe_call(p) = ilu_BuildCall (NULL, c, NULL, NULL);
	      pipe_valid(p) = TRUE;
	      status = TRUE;
	    }
	  else
	    {
              /* server side -- wait for connection */ 
	      ilu_Transport trans;

	      if ((trans=mooring_accept(pipe_mooring(p)))==NULL)
	         {
		   status = FALSE;
	         }
	      else
	         {
		   c = _ilu_CreateConnection(trans, pipe_contact_info(p),
					     pipe_protocol(p),
					     NULL, NULL, NULL);
		   pipe_call(p) = ilu_BuildCall (NULL, c, NULL, NULL);
		   pipe_valid(p) = TRUE;
		   status = TRUE;
	         }
	    }
	}
      ilu_ReleaseWriteLock(pipe_lock(p));
    }
  return(status);
}

void ilu_Pipe_Destroy (ilu_Pipe p)
{
  if (p == NULL)
    return;
}

ilu_boolean ilu_Pipe_WillBlock (ilu_Pipe p)
{
  return (TRUE);
}

ilu_boolean ilu_Pipe_OtherEndGone (ilu_Pipe p)
{
}

ilu_string ilu_Pipe_Type (ilu_Pipe p)
{
}

ilu_Call ilu_Pipe_Call (ilu_Pipe p)
{
	return pipe_call(p);
}
