/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
/* $Id: locks.c,v 1.18 1994/05/10 19:51:49 janssen Exp $ */
/* Last tweaked by Mike Spreitzer March 17, 1994 11:03 pm PST */

#define _POSIX_SOURCE

#include "ilu.h"
#include "iluntrnl.h"

/*L1 not meaningful; this module implements L1 locks;
  L2, Main unconstrained*/


typedef struct {
  ilu_string d1, d2;
  int held;
} DefaultMutex;

static ilu_private Default_CreateMutex(ilu_string d1, ilu_string d2)
{ DefaultMutex *dm = (DefaultMutex*) malloc(sizeof(DefaultMutex));
  dm->d1 = _ilu_Strdup(d1);
  dm->d2 = _ilu_Strdup(d2);
  dm->held = 0;
  return ((ilu_private) dm);
}

static void Default_AcquireMutex(ilu_private m)
{ DefaultMutex *dm = (DefaultMutex*) m;
  ASSERT(!dm->held, buf,
	 (buf, "Trying to acquire held mutex %s%s", dm->d1, dm->d2));
  dm->held = 1;
}

static void Default_HoldMutex(ilu_private m)
{ DefaultMutex *dm = (DefaultMutex*) m;
  ASSERT(dm->held, buf,
	 (buf, "Not holding mutex %s%s", dm->d1, dm->d2));
}

static void Default_ReleaseMutex(ilu_private m)
{ DefaultMutex *dm = (DefaultMutex*) m;
  ASSERT(dm->held, buf,
	 (buf, "Trying to release non-held mutex %s%s", dm->d1, dm->d2));
  dm->held = 0;
}

static void Default_DestroyMutex(ilu_private m)
{ return; }

static ilu_LockTech Default_LockTech[1] = {
	{Default_CreateMutex, Default_AcquireMutex,
	 Default_HoldMutex, Default_ReleaseMutex, Default_DestroyMutex,
	 NULL, NULL, NULL, NULL} };

static ilu_LockTech *theLockTech = Default_LockTech;
static int ltPhase = 0;

static DefaultMutex def_smu = {"global ", "smu", 0};
static DefaultMutex def_otmu = {"global ", "otmu", 0};
static DefaultMutex def_cmu = {"global ", "cmu", 0};
static DefaultMutex def_prmu = {"global ", "prmu", 0};
static DefaultMutex def_trmu = {"global ", "trmu", 0};
static DefaultMutex def_gcmu = {"global ", "gcmu", 0};
static DefaultMutex def_daimu = {"global ", "daimu", 0};

ilu_Lock ilu_smu = &def_smu;
ilu_Lock ilu_otmu = &def_otmu;
ilu_Lock ilu_cmu = &def_cmu;
ilu_Lock ilu_prmu = &def_prmu;
ilu_Lock ilu_trmu = &def_trmu;
ilu_Lock ilu_gcmu = &def_gcmu;
ilu_Lock ilu_daimu = &def_daimu;

ilu_private _ilu_CreateMutex(ilu_string d1, ilu_string d2)
{
  ilu_private m;

  ltPhase = 1;
  DEBUG(LOCK_DEBUG, (stderr, "_ilu_CreateMutex:  %s, %s\n", d1, d2));
  m = (theLockTech->lt_mcreate)(d1, d2);
  DEBUG(LOCK_DEBUG, (stderr, "_ilu_CreateMutex:  => 0x%x\n", (void *) m));
  return m;
}

void _ilu_AcquireMutex(ilu_private m)
{
  ltPhase = 1;
  DEBUG(LOCK_DEBUG, (stderr, "_ilu_AcquireMutex:  0x%x\n", (void *) m));
  (theLockTech->lt_acquire)(m);
  return;
}

void _ilu_HoldMutex(ilu_private m)
{
  ltPhase = 1;
  DEBUG(LOCK_DEBUG, (stderr, "_ilu_HoldMutex:  0x%x\n", (void *) m));
  (theLockTech->lt_hold)(m);
  return;
}

void _ilu_ReleaseMutex(ilu_private m)
{
  ltPhase = 1;
  DEBUG(LOCK_DEBUG, (stderr, "_ilu_ReleaseMutex:  0x%x\n", (void *) m));
  (theLockTech->lt_release)(m);
  return;
}

void _ilu_DestroyMutex(ilu_private m)
{
  ltPhase = 1;
  DEBUG(LOCK_DEBUG, (stderr, "_ilu_DestroyMutex:  0x%x\n", (void *) m));
  (theLockTech->lt_mdestroy)(m);
  return;
}

ilu_boolean _ilu_CanCondition(void)
{
  if (theLockTech->lt_ccreate != NULL)
       return TRUE;
  else return FALSE;
}

ilu_private _ilu_CreateCondition(ilu_string d1, ilu_string d2)
{
  ilu_private c;

  ltPhase = 1;
  _ilu_Assert(theLockTech->lt_ccreate != NULL, "CreateCondition");
  DEBUG(LOCK_DEBUG, (stderr, "_ilu_CreateCondition:  %s, %s\n", d1, d2));
  c = (*theLockTech->lt_ccreate)(d1, d2);
  DEBUG(LOCK_DEBUG, (stderr, "_ilu_CreateCondition:  => 0x%x\n", (void *) c));
  return (c);
}

void _ilu_NotifyCondition(ilu_private c)
{
  ltPhase = 1;
  _ilu_Assert(theLockTech->lt_notify != NULL, "NotifyCondition");
  DEBUG(LOCK_DEBUG, (stderr, "_ilu_NotifyCondition:  0x%x\n", (void *) c));
  (*theLockTech->lt_notify)(c);
}

void _ilu_DestroyCondition(ilu_private c)
{
  ltPhase = 1;
  _ilu_Assert(theLockTech->lt_cdestroy != NULL, "DestroyCondition");
  DEBUG(LOCK_DEBUG, (stderr, "_ilu_DestroyCondition:  0x%x\n", (void *) c));
  (*theLockTech->lt_cdestroy)(c);
}

void _ilu_WaitCondition(ilu_private c, ilu_private m)
{
  ltPhase = 1;
  _ilu_Assert(theLockTech->lt_wait != NULL, "WaitCondition");
  DEBUG(LOCK_DEBUG, (stderr, "_ilu_WaitCondition:  c = 0x%x, m = 0x%x\n",
		     (void *) c, (void *) m));
  (*theLockTech->lt_wait)(c, m);
}

void ilu_RegisterLockTech(ilu_LockTech *lt)
{
  if (lt != NULL)
    theLockTech = lt;
  DEBUG(LOCK_DEBUG, (stderr, "ilu_RegisterLockTech (0x%x), ltPhase == %d\n",
		     lt, ltPhase));
  _ilu_Assert(ltPhase == 0, "RegisterLockTech");
  ilu_smu	= _ilu_CreateMutex("global ", "smu");
  ilu_otmu	= _ilu_CreateMutex("global ", "otmu");
  ilu_cmu	= _ilu_CreateMutex("global ", "cmu");
  ilu_prmu	= _ilu_CreateMutex("global ", "prmu");
  ilu_trmu	= _ilu_CreateMutex("global ", "trmu");
  ilu_gcmu	= _ilu_CreateMutex("global ", "gcmu");
  ilu_daimu	= _ilu_CreateMutex("global ", "daimu");
  return;
}

