/*
 * llist.h --  definitions for linked-list manipulation routines provided by
 *		general linked list package
 *
 */

typedef struct ilu_llist_entry_s ilu_llist_entry;

struct ilu_llist_entry_s {
  ilu_llist_entry *next, *prev;
};

/* note:  These routines never allocate or free llist entries;  That
 * responsibility is left to the caller.
 */

/* _ilu_llist_add() -- add an element to the end of a linked list */
void _ilu_llist_add(ilu_llist_entry *ele,ilu_llist_entry **head,
		ilu_llist_entry **tail);

/* _ilu_llist_del() -- delete an element from a linked list */
void _ilu_llist_del(ilu_llist_entry *ele,ilu_llist_entry **head,
		ilu_llist_entry **tail);

/* we could provide an iterator, but we'll let the caller do that... */
