#ifndef __ilu_c_h_
#define __ilu_c_h_
/*
** Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.
**
** Unlimited use, reproduction, and distribution of this software is
** permitted.  Any copy of this software must include both the above
** copyright notice of Xerox Corporation and this paragraph.  Any
** distribution of this software must comply with all applicable United
** States export control laws.  This software is made available AS IS,
** and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
** INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
** PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
** THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
** CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
** XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/
 
#include <stdlib.h>	/* for malloc */

#include <ilu.h>

#define CORBA12		/* CORBA 1.2 spec for now */

#define OPTIONAL(x)	x
#define PASS(x)		x
#define RETAIN(x)	x
#define GLOBAL(x)	x
 
/* Note:  Things beginning with "ilu_" are exported from the ILU kernel,
          things beginning with "ILU_C_" are from the ILU ANSI C runtime
          for application use, and things beginning with "_ILU_C_" are
	  exported for use only by automatically generated code. */

/*==================================================*/
/*==================================================*/
/*           For internal use                       */
/*==================================================*/
/*==================================================*/

/* 
** C class implementation 
** the C class table(s) are
** generated by the stubber
** and represent the class
** and method heirarchy. each
** class iindicated in isl
** generates a class structure.
** the class structure ILU_C_Class
** contains a pointer to the
** ilu_Class and an array of 
** methods. 
*/

/*
** stub internal needs
*/

typedef struct CCls {
    ilu_Class   c;
    void         (*methods[ 1 ])();
} _ILU_C_MethodBlock;
 
typedef _ILU_C_MethodBlock **ILU_C_Type;

typedef struct {
  ILU_C_Type	type;
  ilu_Server	server;
  ilu_Object	instanceId;
  char *	nmsHandle;
  void *	data;
} ILU_C_Object;

typedef struct {
    unsigned long	_maximum;
    unsigned long	_length;
    char		*_buffer;
} ILU_C_Sequence_s, *ILU_C_Sequence;

typedef ilu_Exception	ILU_C_ExceptionCode;

/* provide functions from ilu.isl directly */
typedef char * ilu_CString;

void ilu_CString__Free (ilu_CString);

/*before: not Inside (cobj->server, cobj->type->c) */
/*after:  return != NULL => Inside(cobj->server, cobj->type->c) */
ilu_Object	_ILU_C_KernelObjOfObj (ILU_C_Object *);

/* L1, L2, Main unconstrained */
void _ILU_C_RegisterSurrogateCType (GLOBAL(ilu_Class) ilutype, GLOBAL(ILU_C_Type) ctype);

/* L1, L2, Main unconstrained */
void *		_ILU_C_FindMethod (RETAIN(ILU_C_Object *), GLOBAL(ilu_Class), int);

/*Main invariant holds
  before:  L2     >=   {call's conn's callmu, iomu}
  after:  L2 not >= {call's conn's         iomu},
  after:  L2     >= {call's conn's callmu} iff protocol not concurrent*/
ilu_boolean	_ILU_C_FinishParameters (ilu_Call, OPTIONAL(ILU_C_Object *));

/* Main invariant holds */
ILU_C_Object *	_ILU_C_CreateTrueObject (ILU_C_Type type, OPTIONAL(ilu_string) instance_handle, OPTIONAL(ilu_Server) server, void *client_data);

/* Main invariant holds */
ILU_C_Object *	_ILU_C_GetServerSingleton (ilu_Server s, ilu_Class c);

/* L1 = {}; L2 >= {call's conn's callmu, iomu} */
ILU_C_Object *	_ILU_C_InputObject (ilu_Call call, ilu_Class putative_class, ilu_boolean discriminator_p);

/* Main invariant holds */
ilu_boolean	_ILU_C_OutputObject (ilu_Call call, ILU_C_Object *obj, ilu_Class putative_class, ilu_boolean discriminator_p);

/* Main invariant holds */
ilu_cardinal	_ILU_C_SizeOfObject (ilu_Call call, ILU_C_Object *obj, ilu_Class putative_class, ilu_boolean discriminator_p);

/* locking Unrestricted */
ilu_Method	_ILU_C_MethodOfCall (ilu_Call call);

/* Unrestricted */
unsigned int	_ILU_C_SafeStrlen (RETAIN(char *str));

/* Unrestricted */
PASS(char *)	_ILU_C_Strdup (RETAIN(char *str));

/* Main invariant holds */
RETAIN(char *)	_ILU_C_GetNMSHandle (GLOBAL(ILU_C_Object *));

/* Main invariant holds */
void		_ILU_C_SetNMSHandle (ILU_C_Object *, PASS(char *) handle);

/*======== sequence methods ========================*/

/* locking is unconstrained in these */

void	 	_ILU_C_AppendGeneric (ILU_C_Sequence h, char *p, int sz);
/* append an element pointed at by `p' of size `sz' to `h' */

void		_ILU_C_EveryElement(ILU_C_Sequence h, void (*proc)(void *,void *), int sz, void *data);
/* map `proc' over the elements of `h' (each element of size `sz'), calling with (<element>, `data') */

void		_ILU_C_PopGeneric (ILU_C_Sequence h, char *p, int sz);
/* remove the first element of `h', and return it in buffer pointed at by `p', of size `sz' */

void		_ILU_C_PushGeneric (ILU_C_Sequence h, char *p, int sz);
/* push the new element pointed at by `p', of size `sz', onto the beginning of `p' */

/*==================================================*/
/*==================================================*/
/*               For application developers         */
/*==================================================*/
/*==================================================*/

/*==== Types =======================================*/

/*L1_sup < otmu*/
/*L2, Main unconstrained*/
ilu_Class	ILU_C_FindILUClassByTypeName ( ilu_string classname );

/*L1_sup < otmu*/
/*L2, Main unconstrained*/
ilu_Class	ILU_C_FindILUClassByTypeID ( ilu_string class_unique_id );

/* Locking unconstrained */
GLOBAL(OPTIONAL(ilu_string))	ILU_C_ClassName ( RETAIN(ILU_C_Object *) );

/* Locking unconstrained */
GLOBAL(OPTIONAL(ilu_string))	ILU_C_ClassID ( RETAIN(ILU_C_Object *) );

/* locking Unrestricted */
ilu_Class	ILU_C_ClassRecordOfInstance (ILU_C_Object *o);	/* returns typecode for object */

/*==== Object manipulation =========================*/

/*In all of these, the Main Invariant should hold */

ilu_string	ILU_C_SBHOfObject ( ILU_C_Object * obj );
/* given an object, returns a string form which is its name and contact information */

ILU_C_Object *	ILU_C_SBHToObject (char *sbh, OPTIONAL(char *) mostSpecificTypeID, OPTIONAL(ilu_Class) putative_type);
/* takes the string form of an object, along with information about its type, and returns an object */

OPTIONAL(PASS(char *)) ILU_C_PublishObject ( ILU_C_Object *obj );
/* publishes the OID of the object in a domain-wide registry */

ilu_boolean	ILU_C_WithdrawObject ( ILU_C_Object *obj, PASS(char *) proof);
/* removes the OID of the object from the domain-wide registry.  "proof" is the string returned from the publish call. */

OPTIONAL(GLOBAL(ILU_C_Object *))
     ILU_C_LookupObject ( RETAIN(char *) oid, ilu_Class pclass );
/* find and return the object specified by "oid" by consulting the local registry.  "pclass" is the putative class of the object, though type of the actual object returned may be a subclass. */

/*==== Servers =====================================*/

void 		ILU_C_Run (void);
/* Called to animate a server or other program.  Invokes the event handling loop.  Never returns. */

extern ilu_Server	ILU_C_DefaultServer;
/* Can be set to choose the default server.  Note that the default port must be chosen in lockstep. */

extern ilu_Port		ILU_C_DefaultPort;
/* Can be set to determine the default port */

/* Main invariant holds */
ilu_Server	ILU_C_InitializeServer(OPTIONAL(RETAIN(char *)) serverID,
				       OPTIONAL(GLOBAL(ilu_ObjectTable)) obj_tab,
				       OPTIONAL(RETAIN(char *)) protocol,
				       OPTIONAL(RETAIN(char *)) transport,
				       ilu_boolean setdefaultport);

/*==================================================*/
/*==================================================*/
/*          CORBA-specified interface               */
/*==================================================*/
/*==================================================*/

#ifdef CORBA11

/* in all of these, the Main Invariant holds */

typedef ILU_C_Object *	Object;

typedef enum { StExcep_NO_EXCEPTION, StExcep_USER_EXCEPTION, StExcep_SYSTEM_EXCEPTION } StExcep_exception_type;
typedef enum { StExcep_YES, StExcep_NO, StExcep_MAYBE } StExcep_completion_status;

#define NO_EXCEPTION		StExcep_NO_EXCEPTION
#define USER_EXCEPTION		StExcep_USER_EXCEPTION
#define SYSTEM_EXCEPTION	StExcep_SYSTEM_EXCEPTION

#define ILU_C_RAISE_SYSTEM(p,ename,mcode,ccode)	((p)->_major = StExcep_SYSTEM_EXCEPTION, \
						 (p)->returnCode = ex_StExcep_##ename), \
						 (p)->ptr = (void*)malloc(sizeof(StExcep_ex_body)), \
						 ((StExcep_ex_body *)((p)->ptr))->minor = (mcode), \
						 ((StExcep_ex_body *)((p)->ptr))->completed = StExcep_##ccode), \
						 (p)->freeRoutine = NULL, (p))
#define ILU_C_OBJECT		Object
#define ILU_C_ENVIRONMENT	Environment

typedef struct _Environment_s {
    StExcep_exception_type	_major;
    ILU_C_ExceptionCode		returnCode;
    void			*ptr;
    void			(*freeRoutine)(void *);	/* called to free subsidiary storage, if any */
} Environment;

typedef struct {
  unsigned long minor;
  StExcep_completion_status completed;
} StExcep_ex_body;

void		exception_free( Environment * );
char *		exception_id( Environment * );
void *		exception_value( Environment * );

extern ILU_C_ExceptionCode	ex_StExcep_UNKNOWN;
extern ILU_C_ExceptionCode	ex_StExcep_BAD_PARAM;
extern ILU_C_ExceptionCode	ex_StExcep_NO_MEMORY;
extern ILU_C_ExceptionCode	ex_StExcep_IMP_LIMIT;
extern ILU_C_ExceptionCode	ex_StExcep_COMM_FAILURE;
extern ILU_C_ExceptionCode	ex_StExcep_INV_OBJREF;
extern ILU_C_ExceptionCode	ex_StExcep_NO_PERMISSION;
extern ILU_C_ExceptionCode	ex_StExcep_INTERNAL;
extern ILU_C_ExceptionCode	ex_StExcep_MARSHAL;
extern ILU_C_ExceptionCode	ex_StExcep_INITIALIZE;
extern ILU_C_ExceptionCode	ex_StExcep_NO_IMPLEMENT;
extern ILU_C_ExceptionCode	ex_StExcep_BAD_TYPECODE;
extern ILU_C_ExceptionCode	ex_StExcep_BAD_OPERATION;
extern ILU_C_ExceptionCode	ex_StExcep_NO_RESOURCES;
extern ILU_C_ExceptionCode	ex_StExcep_NO_RESPONSE;
extern ILU_C_ExceptionCode	ex_StExcep_PERSIST_STORE;
extern ILU_C_ExceptionCode	ex_StExcep_BAD_INV_ORDER;
extern ILU_C_ExceptionCode	ex_StExcep_TRANSIENT;
extern ILU_C_ExceptionCode	ex_StExcep_FREE_MEM;
extern ILU_C_ExceptionCode	ex_StExcep_INV_IDENT;
extern ILU_C_ExceptionCode	ex_StExcep_INV_FLAG;
extern ILU_C_ExceptionCode	ex_StExcep_INTF_REPOS;
extern ILU_C_ExceptionCode	ex_StExcep_CONTEXT;
extern ILU_C_ExceptionCode	ex_StExcep_OBJ_ADAPTER;
extern ILU_C_ExceptionCode	ex_StExcep_DATA_CONVERSION;

/* ORB operations */

typedef void		ORBStatus;
typedef void		*NVList;
typedef void		*Context;
typedef void		*Identifier;
typedef void		*NamedValue;
typedef void		*Request;
typedef void		*ImplementationDef;
typedef void		*InterfaceDef;
typedef long		OperationDef;
typedef long		Flags;

extern ILU_C_Object	ILU_C_ORB[];	/* should be first parameter to any ORB operation */

char *		ORB_object_to_string (Object theORB, Environment *, Object);
Object		ORB_string_to_object (Object theORB, Environment *, char * );
ORBStatus 	ORB_create_list (Object theORB, Environment*, long, NVList* );
ORBStatus 	ORB_create_operation_list (Object theORB, Environment*, OperationDef, NVList*);
ORBStatus 	ORB_get_default_context(Object theORB, Environment*, Context *);

void		ORBfree (void *);	/* free returned storage with this */

/* Object operations */
ImplementationDef 	Object_get_implementation (Object, Environment *);
InterfaceDef 		Object_get_interface (Object, Environment *);
int	 		Object_is_nil (Object, Environment *);
Object 			Object_duplicate (Object, Environment *);
void	 		Object_release( Object, Environment * );
ORBStatus	 	Object_create_request (Object, Environment *,
					       Context, Identifier, NVList,
					       NamedValue *, Request *,
					       Flags);

/* Main invariant holds */
void		_ILU_C_SetProtocolError (Environment *, ilu_ProtocolException);

#define ILU_C_RAISE_SYSTEM(p,ename,mcode,ccode)	((p)->_major = StExcep_SYSTEM_EXCEPTION, \
						 (p)->returnCode = ex_StExcep_##ename), \
						 (p)->ptr = (void*)malloc(sizeof(StExcep_ex_body)), \
						 ((StExcep_ex_body *)((p)->ptr))->minor = (mcode), \
						 ((StExcep_ex_body *)((p)->ptr))->completed = StExcep_##ccode), \
						 (p)->freeRoutine = NULL, (p))
#define ILU_C_OBJECT		Object
#define ILU_C_ENVIRONMENT	Environment
#define ILU_C_SUCCESSFUL(s)	((s)->_major == StExcept_NO_EXCEPTION)
#define ILU_C_SET_SUCCESSFUL(s)	((s)->_major = StExcept_NO_EXCEPTION)
#define ILU_C_NO_EXCEPTION	StExcep_NO_EXCEPTION
#define ILU_C_USER_EXCEPTION	StExcep_USER_EXCEPTION
#define ILU_C_SYSTEM_EXCEPTION	StExcep_SYSTEM_EXCEPTION
#define ILU_C_EXCEPTION_ID(e)	exception_id(e)
#define ILU_C_EXCEPTION_FREE(e)	exception_free(e)
#define ILU_C_EXCEPTION_VALUE(e) exception_value(e)

#endif

#ifdef CORBA12	/* CORBA 1.2 */

/* in all of these, the Main Invariant holds */

typedef ilu_integer		CORBA_long;
typedef ilu_shortinteger	CORBA_short;
typedef ilu_cardinal		CORBA_unsigned_long;
typedef ilu_shortcardinal	CORBA_unsigned_short;
typedef ilu_shortreal		CORBA_float;		
typedef ilu_real		CORBA_double;
typedef ilu_shortcharacter	CORBA_char;
typedef ilu_byte		CORBA_octet;
typedef unsigned char		CORBA_boolean;
typedef ilu_cardinal		CORBA_enum;
typedef ILU_C_Object *		CORBA_Object;
		
typedef enum { CORBA_NO_EXCEPTION, CORBA_USER_EXCEPTION, CORBA_SYSTEM_EXCEPTION } CORBA_exception_type;
typedef enum { CORBA_COMPLETED_YES, CORBA_COMPLETED_NO, CORBA_COMPLETED_MAYBE } CORBA_completion_status;

typedef struct _Environment_s {
    CORBA_exception_type	_major;
    ILU_C_ExceptionCode		returnCode;
    void			*ptr;
    void			(*freeRoutine)(void *);	/* called to free subsidiary storage, if any */
} CORBA_Environment;

typedef struct {
  unsigned long minor;
  CORBA_completion_status completed;
} CORBA_ex_body;

void		CORBA_exception_free( CORBA_Environment * );
char *		CORBA_exception_id( CORBA_Environment * );
void *		CORBA_exception_value( CORBA_Environment * );

extern ILU_C_ExceptionCode	ex_CORBA_UNKNOWN;
extern ILU_C_ExceptionCode	ex_CORBA_BAD_PARAM;
extern ILU_C_ExceptionCode	ex_CORBA_NO_MEMORY;
extern ILU_C_ExceptionCode	ex_CORBA_IMP_LIMIT;
extern ILU_C_ExceptionCode	ex_CORBA_COMM_FAILURE;
extern ILU_C_ExceptionCode	ex_CORBA_INV_OBJREF;
extern ILU_C_ExceptionCode	ex_CORBA_NO_PERMISSION;
extern ILU_C_ExceptionCode	ex_CORBA_INTERNAL;
extern ILU_C_ExceptionCode	ex_CORBA_MARSHAL;
extern ILU_C_ExceptionCode	ex_CORBA_INITIALIZE;
extern ILU_C_ExceptionCode	ex_CORBA_NO_IMPLEMENT;
extern ILU_C_ExceptionCode	ex_CORBA_BAD_TYPECODE;
extern ILU_C_ExceptionCode	ex_CORBA_BAD_OPERATION;
extern ILU_C_ExceptionCode	ex_CORBA_NO_RESOURCES;
extern ILU_C_ExceptionCode	ex_CORBA_NO_RESPONSE;
extern ILU_C_ExceptionCode	ex_CORBA_PERSIST_STORE;
extern ILU_C_ExceptionCode	ex_CORBA_BAD_INV_ORDER;
extern ILU_C_ExceptionCode	ex_CORBA_TRANSIENT;
extern ILU_C_ExceptionCode	ex_CORBA_FREE_MEM;
extern ILU_C_ExceptionCode	ex_CORBA_INV_IDENT;
extern ILU_C_ExceptionCode	ex_CORBA_INV_FLAG;
extern ILU_C_ExceptionCode	ex_CORBA_INTF_REPOS;
extern ILU_C_ExceptionCode	ex_CORBA_BAD_CONTEXT;
extern ILU_C_ExceptionCode	ex_CORBA_OBJ_ADAPTER;
extern ILU_C_ExceptionCode	ex_CORBA_DATA_CONVERSION;

/* ORB operations */

typedef void		CORBA_ORBStatus;
typedef void *		CORBA_Context;

extern CORBA_Object ILU_C_ORB;	/* should be first parameter to any ORB operation */

char *		CORBA_ORB_object_to_string (CORBA_Object theORB, CORBA_Environment *, CORBA_Object);
CORBA_Object	CORBA_ORB_string_to_object (CORBA_Object theORB, CORBA_Environment *, char * );
CORBA_ORBStatus	CORBA_ORB_get_default_context (CORBA_Object theORB, CORBA_Environment*, CORBA_Context *);

void		CORBA_free (void *);	/* free returned storage with this */

/* Object operations */
CORBA_boolean 		CORBA_Object_is_nil (CORBA_Object, CORBA_Environment *);
CORBA_Object		CORBA_Object_duplicate (CORBA_Object, CORBA_Environment *);
void	 		CORBA_Object_release( CORBA_Object, CORBA_Environment * );

/* Main invariant holds */
void		_ILU_C_SetProtocolError (CORBA_Environment *, ilu_ProtocolException);

#define ILU_C_OBJECT		CORBA_Object
#define ILU_C_ENVIRONMENT	CORBA_Environment
#define ILU_C_SUCCESSFUL(s)	((s)->_major == CORBA_NO_EXCEPTION)
#define ILU_C_SET_SUCCESSFUL(s)	((s)->_major = CORBA_NO_EXCEPTION)
#define ILU_C_NO_EXCEPTION	CORBA_NO_EXCEPTION
#define ILU_C_USER_EXCEPTION	CORBA_USER_EXCEPTION
#define ILU_C_SYSTEM_EXCEPTION	CORBA_SYSTEM_EXCEPTION
#define ILU_C_EXCEPTION_ID(e)	CORBA_exception_id(e)
#define ILU_C_EXCEPTION_FREE(e)	CORBA_exception_free(e)
#define ILU_C_EXCEPTION_VALUE(e) CORBA_exception_value(e)

#define ILU_C_RAISE_SYSTEM(p,ename,mcode,ccode)	((p)->_major = CORBA_SYSTEM_EXCEPTION, \
						 (p)->returnCode = ex_CORBA_##ename, \
						 (p)->ptr = (void*)malloc(sizeof(CORBA_ex_body)), \
						 ((CORBA_ex_body *)((p)->ptr))->minor = (mcode), \
						 ((CORBA_ex_body *)((p)->ptr))->completed = CORBA_COMPLETED_##ccode, \
						 (p)->freeRoutine = NULL, (p))

#endif /* CORBA12 */


#undef OPTIONAL
#undef RETAIN
#undef PASS
#undef GLOBAL

#endif

