/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*/

#define __ILU_IMPLEMENTATION_ 1

extern "C" {
#include "ilu-c++.h"
#include "iluxport.h"
};

#include "ilu.H"
#include <iluServer.H>

#include <stdio.h>	/* I/O defs (including popen and pclose) */
#include <sys/types.h>
#include <errno.h>
#include <sys/errno.h>

/* portability hack since we don't have access to kernel headers */
#ifndef ANSI_STRERROR
#ifdef SUNOS
#define ANSI_STRERROR(errnum)	(sys_errlist[errnum])
#else
#define ANSI_STRERROR	strerror
#endif
#endif

iluObjectTable::~iluObjectTable()
{
  fprintf(stderr, "default destructor for iluObjectTable was called!\n");
}

/* First, a simple input dispatch loop */

static iluMainLoop *theML = NULL;

static void CallRun(int *stop)
{
  theML->Run(stop);
  return;
}

static void CallExit (int *stop)
{
  theML->Exit(stop);
}

static ilu_boolean CallRegisterInput(int fd,
				     void (*proc)(int fd, void * rock),
				     void * rock)
{
  return ((ilu_boolean) theML->RegisterInputHandler(fd, proc, rock));
}

static ilu_boolean CallUnregisterInput(int fd)
{
  return ((ilu_boolean) theML->UnregisterInputHandler(fd));
}

static ilu_boolean CallRegisterOutput(int fd,
				     void (*proc)(int fd,
						  void * rock),
				     void * rock)
{
  return ((ilu_boolean) theML->RegisterOutputHandler(fd, proc, rock));
}

static ilu_boolean CallUnregisterOutput(int fd)
{
  return ((ilu_boolean) theML->UnregisterOutputHandler(fd));
}

static ilu_Alarm CallCreateAlarm (void)
{
  return (theML->CreateAlarm());
}

static void CallSetAlarm (ilu_Alarm alarm, ilu_FineTime t, void (*proc)(void * rock), void * rock)
{
  theML->SetAlarm (alarm, t, proc, rock);
}

static void CallUnsetAlarm (ilu_Alarm alarm)
{
  theML->ClearAlarm (alarm);
}

static ilu_MainLoop kml = { CallRun, CallExit, CallRegisterInput, CallUnregisterInput, CallRegisterInput, CallUnregisterInput, CallCreateAlarm, CallSetAlarm, CallUnsetAlarm };

void iluServer::iluSetMainLoop(iluMainLoop *ml)
{
  theML = ml;
  ilu_SetMainLoop(&kml);
  return;
}


/* This routine handles the dispatching of an incoming request */

static void ReadServiceRequest (int fd, void *arg)
{
  ilu_ReceiveRequestStatus s;
  ilu_Connection conn = (ilu_Connection) arg;
  ilu_Call call;
  ilu_Class ptype;
  ilu_Method method;
  ilu_Cardinal serial_number;

  ilu_UnregisterInputSource(fd);
  s = ilu::ReceiveRequest (conn, &call, &ptype, &method, &serial_number);
  ilu_RegisterInputSource (fd, ReadServiceRequest, arg);
  if (s == ilu_no_request
      || s == ilu_read_failed
      || s == ilu_not_request
      || s == ilu_interp_failed
      || s == ilu_conn_closed)
    {
      ilu_UnregisterInputSource(fd);
      ilu::CloseConnection (conn);
    }
  else if (s == ilu_builtin_meth)
    {}
  else if (s == ilu_good_request)
    {
      (*method->me_stubproc)(call);
    }
}

/* When a request for a new connection to the server is received,
   we have to handle it. */

/*ARGSUSED*/
void ReadConnectionRequest (int, void *arg)
{
  ilu_Port p;
  int fd2;
  ilu_Connection conn;

  p = (ilu_Port) arg;
  if ((conn = ilu::HandleNewConnection(p)) == NULL)
    {
      fprintf (stderr, "iluServer::ReadConnectionRequest:  Error:  Unable to accept incoming connection.\n");
    }
  else if ((fd2 = ilu::FileDescriptorOfConnection(conn)) < 0)
    {
      fprintf (stderr, "iluServer::ReadConnectionRequest:  Error:  Unable to get file descriptor of new connection.\n");
      ilu::CloseConnection (conn);
    }
  else
    {
      ilu_RegisterInputSource (fd2, ReadServiceRequest, conn);
    }
}

static ilu_KernelObject Call_object_of_ih(ilu_ObjectTable self,
					  ilu_string ih)
{
  iluObjectTable *objtab = (iluObjectTable *) self->ot_rock;
  iluObject * obj = (iluObject *) objtab->ObjectOfIH(ih);
  return obj->ILUEnsureKernelObject();
}

static void Call_free_self(ilu_ObjectTable self)
{
  iluObjectTable *objtab = (iluObjectTable *) self->ot_rock;
  delete objtab;
  free((char *) self);
  return;
}

iluServer::iluServer (	char *serviceID /* = NULL */,
			iluObjectTable *objtab /* = NULL */)
{
  ilu_ObjectTable kot;
  if (objtab == NULL)
    kot = NULL;
  else
    {
      kot = (ilu_ObjectTable) malloc(sizeof(ilu_ObjectTable));
      kot->ot_object_of_ih = Call_object_of_ih;
      kot->ot_free_self = Call_free_self;
      kot->ot_rock = (void *) objtab;
  }
  
  if ((serviceID == NULL) || (strlen(serviceID) == 0))
    serviceID = ilu_InventID();

  ks = ilu_CreateTrueServer(serviceID, kot);
  return;
}

ilu_Boolean iluServer::AddPort(	char *protocolType,
				char *transportType,
				ilu_Boolean be_default)
{
  char *DefaultTransport = "tcp_localhost_0";
  char *DefaultProtocol = "sunrpc_";
  char *t, *p;
  int fd;
  ilu_Port nu;
  nu = ilu::CreatePort (ks,
	p = (protocolType == NULL) ? DefaultProtocol : protocolType,
	t = (transportType == NULL) ? DefaultTransport : transportType);
  if (nu == NULL) {
      fprintf (stderr, "iluServer::Start:  Error:  Couldn't open port with transport = \"%s\" and protocol = \"%s\".\n", t, p);
      return(ilu_FALSE);
    }
  if (be_default) ilu::SetServerDefaultPort(ks, nu);
  fd = ilu::FileDescriptorOfMooringOfPort (nu);
  ilu_RegisterInputSource (fd, ReadConnectionRequest, (void *) nu);
  return (ilu_TRUE);
}

void iluServer::Run()
{
  int stop = 0;

  ilu_RunMainLoop(&stop);
}
