/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: rwho2Client.cc,v 1.4 1994/05/06 02:40:39 janssen Exp $
*/

#include <rwho2.H>
#include <stdio.h>

static void PrintUser (rwho2_T_user *u, void *)
{
  rwho2Status status;
  char *name;

  name = u->Name(&status);
  if (status.returnCode != NULL)
    {
      fprintf (stderr, "Exception \"%s\" (%d) signalled on request Name with user 0x%x\n",
	       status.returnCode, status.values.anyvalue, u);
      return;
    }
  
  printf ("   %s\n", name);
}

int main (int ac, char **av)
{
  ilu_Cardinal arg;
  rwho2_T_userRec *users;
  rwho2Status status;
  ilu_CString uptime;

  if (ac < 2)
    {
      fprintf (stderr, "Usage:  rwho-client <machine> [ <machine> ... ]\n");
      return (1);
    }

  for (arg = 1;  av[arg] != NULL;  arg += 1)
    {
      char description[1000];
      class rwho2_T_machine *m;

      if ((m = rwho2_T_machine::ILUCreateFromSBH(av[arg], NULL /* rwho2_T_machine::ILUClassRecord->unique_id */)) != NULL)
	{
	  char *name, *time;

	  name = m->Name(&status);
	  if (status.returnCode != NULL)
	    {
	      fprintf (stderr, "Exception \"%s\" (%d) signalled on request Name with server on machine %s.\n",
		       status.returnCode, status.values.anyvalue, av[arg]);
	      continue;
	    }
	  time = m->StartTime(&status);
	  if (status.returnCode != NULL)
	    {
	      fprintf (stderr, "Exception \"%s\" (%d) signalled on request StartTime with server on machine %s.\n",
		       status.returnCode, status.values.anyvalue, av[arg]);
	      continue;
	    }

	  printf ("== %s  (server started %s)\n\n", name, time);

	  uptime = m->Status (&status);
	  if (status.returnCode == NULL)
	    printf ("Status:  %s\n\n", uptime);
	  else
	    fprintf (stderr, "status of Status is \"%s\" (0x%x)\n",
		    status.returnCode, status.values.anyvalue);

	  users = m->ListUsers (&status);
	  if (status.returnCode == NULL)
	    {
	      printf ("Users at %s:\n", users->time);
	      (users->users)->Enumerate (PrintUser, NULL);
	      printf ("\n");
	    }
	  else
	    fprintf (stderr, "status of ListUsers is \"%s\" (0x%x)\n",
		     status.returnCode, status.values.anyvalue);

	  delete m;
	}
      else
	printf ("couldn't find instance of rwho2.machine on host %s\n", av[arg]);
    }
  return (0);
}
