(* This file was automatically generated at April 8, 1993 4:36:56
   pm PDT by spreitze running m3-stubber of April 8, 1993 4:57:33
   pm PDT on /tilde/spreitze/ilu/src/examples/foo/Foo.isl of
   03-May-93 08:20:01 PDT. *)
(* Last tweaked by Mike Spreitzer November 18, 1993 2:34 pm PST *)

UNSAFE MODULE Foo_y EXPORTS Foo, Foo_x;
IMPORT Fmt, Ilu, IluBasics, IluRuntime, M3toC, Thread;

PROCEDURE Get_IS (call: IluRuntime.Call; VAR val: IS)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR len: IluRuntime.Cardinal;
  BEGIN
    len := IluRuntime.InputSequence(call, -1);
    val := NEW(IS, len);
    FOR i := 0 TO len - 1 DO
      val[i] := IluRuntime.InputInteger(call);
    END (*for*);
    IluRuntime.EndSequence(call);
  END Get_IS;

PROCEDURE Put_IS (call: IluRuntime.Call; READONLY val: IS)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR len := NUMBER(val^);
  BEGIN
    IluRuntime.OutputSequence(call, len, -1);
    FOR i := 0 TO len - 1 DO
      IluRuntime.OutputInteger(call, val[i]);
    END (*for*);
    IluRuntime.EndSequence(call);
  END Put_IS;

PROCEDURE SizeOf_IS (call: IluRuntime.Call; READONLY val: IS):
  IluRuntime.Cardinal RAISES {} =
  VAR len := NUMBER(val^);
  VAR size: IluRuntime.Cardinal;
  BEGIN
    size := IluRuntime.SizeSequence(call, len, -1);
    FOR i := 0 TO len - 1 DO
      INC(size, IluRuntime.SizeInteger(call, val[i]));
    END (*for*);
    IluRuntime.EndSequence(call);
    RETURN size;
  END SizeOf_IS;

PROCEDURE Get_RS (call: IluRuntime.Call; VAR val: RS)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR len: IluRuntime.Cardinal;
  BEGIN
    len := IluRuntime.InputSequence(call, -1);
    val := NEW(RS, len);
    FOR i := 0 TO len - 1 DO Get_R(call, val[i]); END (*for*);
    IluRuntime.EndSequence(call);
  END Get_RS;

PROCEDURE Put_RS (call: IluRuntime.Call; READONLY val: RS)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR len := NUMBER(val^);
  BEGIN
    IluRuntime.OutputSequence(call, len, -1);
    FOR i := 0 TO len - 1 DO Put_R(call, val[i]); END (*for*);
    IluRuntime.EndSequence(call);
  END Put_RS;

PROCEDURE SizeOf_RS (call: IluRuntime.Call; READONLY val: RS):
  IluRuntime.Cardinal RAISES {} =
  VAR len := NUMBER(val^);
  VAR size: IluRuntime.Cardinal;
  BEGIN
    size := IluRuntime.SizeSequence(call, len, -1);
    FOR i := 0 TO len - 1 DO
      INC(size, SizeOf_R(call, val[i]));
    END (*for*);
    IluRuntime.EndSequence(call);
    RETURN size;
  END SizeOf_RS;

PROCEDURE Get_CSS (call: IluRuntime.Call; VAR val: CSS)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR len: IluRuntime.Cardinal;
  BEGIN
    len := IluRuntime.InputSequence(call, -1);
    val := NEW(CSS, len);
    FOR i := 0 TO len - 1 DO
      val[i] := IluRuntime.InputString(call, -1);
    END (*for*);
    IluRuntime.EndSequence(call);
  END Get_CSS;

PROCEDURE Put_CSS (call: IluRuntime.Call; READONLY val: CSS)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR len := NUMBER(val^);
  BEGIN
    IluRuntime.OutputSequence(call, len, -1);
    FOR i := 0 TO len - 1 DO
      IluRuntime.OutputString(call, val[i]);
    END (*for*);
    IluRuntime.EndSequence(call);
  END Put_CSS;

PROCEDURE SizeOf_CSS (         call: IluRuntime.Call;
                      READONLY val : CSS          ):
  IluRuntime.Cardinal RAISES {} =
  VAR len := NUMBER(val^);
  VAR size: IluRuntime.Cardinal;
  BEGIN
    size := IluRuntime.SizeSequence(call, len, -1);
    FOR i := 0 TO len - 1 DO
      INC(size, IluRuntime.SizeString(call, val[i]));
    END (*for*);
    IluRuntime.EndSequence(call);
    RETURN size;
  END SizeOf_CSS;

PROCEDURE Get_A0 (call: IluRuntime.Call; VAR val: A0)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  BEGIN
    IluRuntime.InputOpaque(call, val);
  END Get_A0;

PROCEDURE Put_A0 (call: IluRuntime.Call; READONLY val: A0)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  BEGIN
    IluRuntime.OutputOpaque(call, val);
  END Put_A0;

PROCEDURE SizeOf_A0 (call: IluRuntime.Call; READONLY val: A0):
  IluRuntime.Cardinal RAISES {} =
  BEGIN
    RETURN IluRuntime.SizeOpaque(call, val);
  END SizeOf_A0;

PROCEDURE Get_A1 (call: IluRuntime.Call; VAR val: A1)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  BEGIN
    IluRuntime.InputArray(call);
    FOR i := 0 TO 2 DO
      val[i] := IluRuntime.InputString(call, -1);
    END (*for*);
    IluRuntime.EndArray(call);
  END Get_A1;

PROCEDURE Put_A1 (call: IluRuntime.Call; READONLY val: A1)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  BEGIN
    IluRuntime.OutputArray(call);
    FOR i := 0 TO 2 DO
      IluRuntime.OutputString(call, val[i]);
    END (*for*);
    IluRuntime.EndArray(call);
  END Put_A1;

PROCEDURE SizeOf_A1 (call: IluRuntime.Call; READONLY val: A1):
  IluRuntime.Cardinal RAISES {} =
  VAR size: IluRuntime.Cardinal;
  BEGIN
    size := IluRuntime.SizeArray(call);
    FOR i := 0 TO 2 DO
      INC(size, IluRuntime.SizeString(call, val[i]));
    END (*for*);
    IluRuntime.EndArray(call);
    RETURN size;
  END SizeOf_A1;

PROCEDURE Get_R (call: IluRuntime.Call; VAR val: R)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  BEGIN
    IluRuntime.InputRecord(call);
    val.i := IluRuntime.InputInteger(call);
    Get_CSS(call, val.css);
    Get_A1(call, val.a);
    IluRuntime.EndRecord(call);
  END Get_R;

PROCEDURE Put_R (call: IluRuntime.Call; READONLY val: R)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  BEGIN
    IluRuntime.OutputRecord(call);
    IluRuntime.OutputInteger(call, val.i);
    Put_CSS(call, val.css);
    Put_A1(call, val.a);
    IluRuntime.EndRecord(call);
  END Put_R;

PROCEDURE SizeOf_R (call: IluRuntime.Call; READONLY val: R):
  IluRuntime.Cardinal RAISES {} =
  VAR size: IluRuntime.Cardinal;
  BEGIN
    size := IluRuntime.SizeRecord(call);
    INC(size, IluRuntime.SizeInteger(call, val.i));
    INC(size, SizeOf_CSS(call, val.css));
    INC(size, SizeOf_A1(call, val.a));
    IluRuntime.EndRecord(call);
    RETURN size;
  END SizeOf_R;

PROCEDURE Get_RO (call: IluRuntime.Call; VAR val: RO)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR present := IluRuntime.InputOptional(call);
  BEGIN
    IF present THEN
      val := NEW(RO);
      Get_R(call, val^);
    ELSE
      val := NIL
    END;
  END Get_RO;

PROCEDURE Put_RO (call: IluRuntime.Call; READONLY val: RO)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  BEGIN
    IluRuntime.OutputOptional(call, val # NIL);
    IF val # NIL THEN Put_R(call, val^) END;
  END Put_RO;

PROCEDURE SizeOf_RO (call: IluRuntime.Call; READONLY val: RO):
  IluRuntime.Cardinal RAISES {} =
  VAR size := IluRuntime.SizeOptional(call, val # NIL);
  BEGIN
    IF val # NIL THEN size := size + SizeOf_R(call, val^) END;
    RETURN size;
  END SizeOf_RO;

PROCEDURE Get_OO (call: IluRuntime.Call; VAR val: OO)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR present := IluRuntime.InputOptional(call);
  BEGIN
    IF present THEN
      TYPECASE IluRuntime.InputM3Object(
                 call, FALSE, ObjectType_O) OF
      | O (x) => val := x;
      ELSE
        RAISE
          IluBasics.Failed(
            NEW(
              IluBasics.Failure,
              info := "got an unexpectedly-non-Foo.O object"))
      END (*typecase*)
    ELSE
      val := NIL
    END;
  END Get_OO;

PROCEDURE Put_OO (call: IluRuntime.Call; READONLY val: OO)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  BEGIN
    IluRuntime.OutputOptional(call, val # NIL);
    IF val # NIL THEN
      IluRuntime.OutputM3Object(call, val, FALSE, ObjectType_O);
    END;
  END Put_OO;

PROCEDURE SizeOf_OO (call: IluRuntime.Call; READONLY val: OO):
  IluRuntime.Cardinal RAISES {} =
  VAR size := IluRuntime.SizeOptional(call, val # NIL);
  BEGIN
    IF val # NIL THEN
      size :=
        size + IluRuntime.SizeM3Object(
                 call, val, FALSE, ObjectType_O)
    END;
    RETURN size;
  END SizeOf_OO;

PROCEDURE Get_U (call: IluRuntime.Call; VAR val: U)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  VAR disc := IluRuntime.InputUnion(call);
  BEGIN
    CASE disc OF
    | 0 =>
        VAR v: R;
        BEGIN
          Get_R(call, v);
          val := NEW(U_R, v := v);
        END;
    | 1 =>
        VAR v: RO;
        BEGIN
          Get_RO(call, v);
          val := NEW(U_RO, v := v);
        END;
    | 2 =>
        VAR v: CSS;
        BEGIN
          Get_CSS(call, v);
          val := NEW(U_CSS, v := v);
        END;
    | 3 =>
        VAR v: O;
        BEGIN
          TYPECASE IluRuntime.InputM3Object(
                     call, FALSE, ObjectType_O) OF
          | O (x) => v := x;
          ELSE
            RAISE
              IluBasics.Failed(
                NEW(
                  IluBasics.Failure,
                  info := "got an unexpectedly-non-Foo.O object"))
          END (*typecase*);
          val := NEW(U_O, v := v);
        END;
    | 4 =>
        VAR v: OO;
        BEGIN
          Get_OO(call, v);
          val := NEW(U_OO, v := v);
        END;
    | 5 =>
        val :=
          NEW(U_BOOLEAN, v := IluRuntime.InputBoolean(call));
    ELSE
      RAISE
        IluBasics.Failed(
          NEW(
            IluBasics.Failure,
            info :=
              Fmt.F("got %s as tag for a Foo.U", Fmt.Int(disc))))
    END (*case*);
    IluRuntime.EndUnion(call);
  END Get_U;

PROCEDURE Put_U (call: IluRuntime.Call; READONLY val: U)
  RAISES {IluBasics.Failed, Thread.Alerted} =
  BEGIN
    TYPECASE val OF
    | U_R (x) =>
        IluRuntime.OutputUnion(call, 0);
        Put_R(call, x.v);
    | U_RO (x) =>
        IluRuntime.OutputUnion(call, 1);
        Put_RO(call, x.v);
    | U_CSS (x) =>
        IluRuntime.OutputUnion(call, 2);
        Put_CSS(call, x.v);
    | U_O (x) =>
        IluRuntime.OutputUnion(call, 3);
        IluRuntime.OutputM3Object(call, x.v, FALSE, ObjectType_O);
    | U_OO (x) =>
        IluRuntime.OutputUnion(call, 4);
        Put_OO(call, x.v);
    | U_BOOLEAN (x) =>
        IluRuntime.OutputUnion(call, 5);
        IluRuntime.OutputBoolean(call, x.v);
    ELSE
      RAISE
        IluBasics.Failed(
          NEW(
            IluBasics.Failure,
            info := "can't marshall uexpected case of Foo.U"))
    END (*typecase*);
    IluRuntime.EndUnion(call);
  END Put_U;

PROCEDURE SizeOf_U (call: IluRuntime.Call; READONLY val: U):
  IluRuntime.Cardinal RAISES {} =
  VAR size: IluRuntime.Cardinal;
  BEGIN
    TYPECASE val OF
    | U_R (x) =>
        size :=
          IluRuntime.SizeUnion(call, 0) + SizeOf_R(call, x.v);
    | U_RO (x) =>
        size :=
          IluRuntime.SizeUnion(call, 1) + SizeOf_RO(call, x.v);
    | U_CSS (x) =>
        size :=
          IluRuntime.SizeUnion(call, 2) + SizeOf_CSS(call, x.v);
    | U_O (x) =>
        size :=
          IluRuntime.SizeUnion(call, 3)
            + IluRuntime.SizeM3Object(
                call, x.v, FALSE, ObjectType_O);
    | U_OO (x) =>
        size :=
          IluRuntime.SizeUnion(call, 4) + SizeOf_OO(call, x.v);
    | U_BOOLEAN (x) =>
        size :=
          IluRuntime.SizeUnion(call, 5)
            + IluRuntime.SizeBoolean(call, x.v);
    ELSE
      RETURN 0 (* later call to Put_U will flag this error *)
    END (*typecase*);
    IluRuntime.EndUnion(call);
    RETURN size;
  END SizeOf_U;


PROCEDURE Get_Exception (call: IluRuntime.Call; scode: INTEGER)
  RAISES {IluBasics.Failed, Thread.Alerted, E1, E2} =
  VAR exn: IluRuntime.Exception;
  BEGIN
    IF scode < 0 OR scode > call.method.exceptionCount THEN
      RAISE
        IluBasics.Failed(
          NEW(
            IluBasics.Failure,
            info := "unknown exception code " & Fmt.Int(scode)))
    END;
    exn := IluRuntime.ExceptionOfMethod(call.method, scode);
    IF exn = NIL THEN
      RAISE
        IluBasics.Failed(
          NEW(
            IluBasics.Failure,
            info := "bogus exception code " & Fmt.Int(scode)));
    ELSIF exn = Exception_Reps.E1 THEN
      VAR v: U;
      BEGIN
        Get_U(call, v);
        RAISE E1(v);
      END;
    ELSIF exn = Exception_Reps.E2 THEN
      RAISE E2(IluRuntime.InputInteger(call));
    ELSE
      RAISE
        IluBasics.Failed(
          NEW(
            IluBasics.Failure,
            info := "bogus exception code " & Fmt.Int(scode)));
    END (*case exn*);
  END Get_Exception;

PROCEDURE ILU_Get_Type_O (<*UNUSED*> self: Ilu.Object):
  IluRuntime.ObjectType =
  BEGIN
    RETURN ObjectType_O;
  END ILU_Get_Type_O;

PROCEDURE ILU_Qua_O (x: Ilu.Object): O =
  VAR ans := x.ILU_Qua_Type(ObjectType_O);
  BEGIN
    RETURN NARROW(ans, O);
  END ILU_Qua_O;

VAR
  started := FALSE;
  ExnVec_T_O_M_U_CSS_to_U: ARRAY [0 .. 1] OF IluRuntime.Exception;
  ExnVec_T_O_M_f_CSS_to_RO: ARRAY [0 .. 0] OF
                              IluRuntime.Exception;

PROCEDURE BeStarted () =
  BEGIN
    IF NOT started THEN
      started := TRUE;
      Exception_Reps.E1 := M3toC.TtoS("E1");
      Exception_Reps.E2 := M3toC.TtoS("E2");
      ExnVec_T_O_M_U_CSS_to_U :=
        ARRAY [0 .. 1] OF
          IluRuntime.Exception{
          Exception_Reps.E1, Exception_Reps.E2};
      ExnVec_T_O_M_f_CSS_to_RO :=
        ARRAY [0 .. 0] OF IluRuntime.Exception{Exception_Reps.E1};
      Methods_O :=
        ARRAY MethodNames_O OF
          IluRuntime.Method_Rec{
          IluRuntime.Method_Rec{
            name := M3toC.TtoS("U_CSS_to_U"), id := 1,
            cacheable := 0, asynchronous := 0, exceptionVector :=
            ADR(ExnVec_T_O_M_U_CSS_to_U[0]), exceptionCount := 2},
          IluRuntime.Method_Rec{
            name := M3toC.TtoS("f_CSS_to_RO"), id := 2,
            cacheable := 0, asynchronous := 0, exceptionVector :=
            ADR(ExnVec_T_O_M_f_CSS_to_RO[0]), exceptionCount := 1},
          IluRuntime.Method_Rec{
            name := M3toC.TtoS("R_ScS_to_F"), id := 3,
            cacheable := 0, asynchronous := 0, exceptionVector :=
            NIL, exceptionCount := 0},
          IluRuntime.Method_Rec{
            name := M3toC.TtoS("a_RO"), id := 4, cacheable := 0,
            asynchronous := 0, exceptionVector := NIL,
            exceptionCount := 0}};
      ObjectType_O :=
        NEW(
          IluRuntime.ObjectType, name := M3toC.TtoS("Foo.O"),
          brand := M3toC.TtoS(""),
          unique_id := M3toC.TtoS("ilu:f3yfcWZXNcktexvPdmFOeq980Ea"),
          singleton := 0, collectible := 0,
          authentication := NIL,
          methods := ADR(Methods_O[FIRST(MethodNames_O)]),
          method_count := 4, superclass_count := 0,
          superclasses := NIL, superclass_ids := NIL);
        <*FATAL IluBasics.Failed*>
      BEGIN
        IluRuntime.RegisterObjectType(
          ObjectType_O,
          NEW(IluRuntime.ObjectCreator, apply := Create_Lead_O))
      END (*block for fatal pragma*);
    END (*if not started*);
  END BeStarted;

BEGIN
END Foo_y.
