MODULE FooM3Server2 EXPORTS Main;
IMPORT Foo, Ilu, NameServer, Stdio, Thread, Time, Wr;

<*FATAL Thread.Alerted, Wr.Failure*>

TYPE
  TrueFoo = Foo.O OBJECT
              id: INTEGER
            OVERRIDES
              ILU_Get_Server := ILU_Get_Server;
              ILU_Qua_Type   := TrueFoo_Qua_Type;
              U_CSS_to_U     := U_CSS_to_U
            END;

VAR ts := Ilu.InitTrueServer(NEW(Ilu.TrueServer));
VAR fooType := Foo.ILU_Get_Type_O(NIL);

PROCEDURE ILU_Get_Server (<*UNUSED*> self: TrueFoo): Ilu.Server =
  BEGIN
    RETURN ts;
  END ILU_Get_Server;

PROCEDURE TrueFoo_Qua_Type (self: TrueFoo; ot: Ilu.ObjectType):
  Ilu.Object =
  BEGIN
    IF ot = fooType THEN RETURN self ELSE RETURN NIL END;
  END TrueFoo_Qua_Type;

PROCEDURE U_CSS_to_U (self: TrueFoo; u: Foo.U; css: Foo.CSS): Foo.U
  RAISES {Foo.E1, Foo.E2} =
  BEGIN
    CASE NUMBER(css^) OF
    | 0 => RETURN u;
    | 1 => RAISE Foo.E1(u);
    | 2 => RAISE Foo.E2(self.id);
    | 3 => RETURN NEW(Foo.U_CSS, v := css);
    | 4 => RETURN NEW(Foo.U_O, v := self);
    ELSE
      RETURN NEW(Foo.U_OO, v := NEW(TrueFoo, id := NUMBER(css^)));
    END (*case*);
  END U_CSS_to_U;

VAR fs1 := NEW(TrueFoo, id := 100);
VAR fs2 := NEW(TrueFoo, id := 200);
VAR sbh1, sbh2: TEXT;

BEGIN
  Ilu.Export_Server(ts, NEW(Ilu.SunRpc2), NEW(Ilu.TCP));

  sbh1 := Ilu.SbhFromObject(fs1);
  Wr.PutText(Stdio.stdout, "SBH1 is " & sbh1 & "\n");
  Wr.Flush(Stdio.stdout);
  NameServer.RegisterObject(fs1, "1");

  sbh2 := Ilu.SbhFromObject(fs2);
  Wr.PutText(Stdio.stdout, "SBH2 is " & sbh2 & "\n");
  Wr.Flush(Stdio.stdout);
  NameServer.RegisterObject(fs2, "2");

  LOOP
    (* Linebreak, if you PLEASE! *)
    Time.LongPause(10);
  END (*loop*);
END FooM3Server2.
