(in-package :user)

(proclaim '(optimize (compilation-speed 0) (safety 1) (speed 3)))

(defun fc-bm-label (i)
  (let ((j nil))
    (setq consistent nil)
    (loop for k in (aref current-domain i) while (not consistent) do
	  (cond ((setq consistent (<= (aref reason i) (aref reasons i k)))
		 (setf (aref v i) k)
		 (loop for temp from (+ i 1) to *n* while consistent do
		     (setq j temp
			   consistent (check-forwards i j)))
		 (cond ((not consistent)
			(setf (aref current-domain i) (remove k (aref current-domain i)))
			(undo-reductions i)
			(setf (aref reasons i k) (max-list (aref past-fc j))))
		       (consistent (setf (aref reasons i k) i))))
		(t (setf (aref current-domain i) (remove k (aref current-domain i))))))
    (cond (consistent (+ i 1))
	  (t i))))
;;;
;;; NOTE
;;; I have used reasons[i,k] instead of mcl[i,k] as in AISL-48-93, similarly
;;; I have used reason[i] instead of mbl[i], again as in AISL-48-93
;;;

(defun fc-bm-unlabel (i)
  (let ((h (- i 1))
	(r-i (aref reason i)))
    (undo-reductions h)
    (update-current-domain i)
    (cond ((and (> r-i 0) (> h r-i)); reason[i] about to increase!!
	   (loop for k in (aref domain i) do
		 (cond ((>= (aref reasons i k) r-i)
			(setf (aref reasons i k) i))))))
    (setf (aref reason i) h)
    (loop for j from (+ h 1) to *n* do
	  (setf (aref reason j) (min (aref reason j) h)))
    (setf (aref current-domain h)
	  (remove (aref v h) (aref current-domain h)))
    (setq consistent (aref current-domain h))
    h))

(defun fc-bm () (bcssp 'fc-bm-label 'fc-bm-unlabel))


(defun fc-bm-cbj-label (i)
  (let ((j nil))
    (setq consistent nil)
    (loop for k in (aref current-domain i) while (not consistent) do
	  (setq consistent (<= (aref reason i) (aref reasons i k)))
	  (cond (consistent
		 (setf (aref v i) k)
		 (loop for temp from (+ i 1) to *n* while consistent do
		       (setq j temp
			     consistent (check-forwards i j)))
		 (cond ((not consistent)
			(setf (aref current-domain i) (remove k (aref current-domain i)))
			(undo-reductions i)
			(setf (aref reasons i k) (max-list (aref past-fc j))
			      (aref culprit i k) j
			      (aref conf-set i)	(union (aref conf-set i) (aref past-fc j))))
		       (consistent (setf (aref reasons i k) i))))
		((not consistent)
		 (setf j (aref culprit i k)
		       (aref current-domain i) (remove k (aref current-domain i))
		       (aref conf-set i) (union (aref conf-set i) (aref past-fc j))))))
    (cond (consistent (+ i 1))
	  (t i))))
;;;
;;; I used culprit, and AISL-48-93 I used victim
;;; Victim (of domain annihilation) is more accurate
;;;

(defun fc-bm-cbj-unlabel (i)
  (let* ((cs (union (aref conf-set i) (aref past-fc i)))
	 (h (max-list cs))
	 (r-i (aref reason i))
	 (k (aref v h)))
    (cond ((> h r-i)
	   (loop for k in (aref domain i) do
		 (cond ((>= (aref reasons i k) r-i)
			(setf (aref reasons i k) i)))))); <<1>>
    (setf (aref conf-set h) (union (aref conf-set h) (remove h cs))
	  (aref current-domain h) (remove k (aref current-domain h))
	  ;(aref reasons h k) (max-list (remove h cs))    <<2>>
	  ;(aref culprit h k) i                           <<2>>
	  (aref reason i) h)
    (loop for j from (+ h 1) to *n* do
	  (setf (aref reason j) (min (aref reason j) h)))
    (loop for j from i downto (+ h 1) do
	  (setf (aref conf-set j) (list 0))
	  (undo-reductions j)
	  (update-current-domain j))
    (undo-reductions h)
    (setq consistent (aref current-domain h))
    h))
;;;
;;; <<1>> Consequently when reason[i] is zero, that is we are
;;;       jumping back from v[i], all information in mcl[i,k] is lost
;;; <<2>> Tempting, but incorrect
;;; <<3>> Tempting, but also incorrect. Consequently next time we
;;;        revist v[h] this instantiation will be tried.
;;;

(defun fc-bm-cbj () (bcssp 'fc-bm-cbj-label 'fc-bm-cbj-unlabel))

;;;
;;; NOTE: fc-bm-cbj can visit less nodes than fc-cbj!!
;;; The scenario is as follows: 
;;; (1) v[g] checks forward against v[l], such that max-list(past-fc[l]) = g
;;; (2) v[i] <- k annihilates v[l],
;;;     culprit[i,k] <- l, and
;;;     reasons[i,k] <- max-list(past-fc[l]), ie reasons[i,k] = g
;;; (3) assume we then jump back to v[h], where g<h.
;;;     and that v[h] <-k checks forward against v[j] removing a value from 
;;;     current-domain[j]. Therefore past-fc[j] is now {h}
;;; (4) we now move forwards to v[i] and attempt the instantiation v[i] <- k
;;;     This instantiation is disallowed as we have convincing proof that it
;;;     will result in domain annihilation for variable v[l]. However, if we had
;;;     performed forward checking against v[j] (as in fc-cbj), where i<j<l we would have
;;;     annihilated current-domain[j] and consequently jumped back to v[h],
;;;     (and fc-cbj visits more nodes than fc-bm-cbj).
;;; (4.a) However, if we had jumped back to v[h] this might have lead immediately
;;;       to a jump to v[f] where f<g.
;;; CONCLUSION: bm added to fc-cbj may save consistency checks, but saving
;;; consistency checks may result in a loss of backjumping information. This 
;;; loss of information may in turn result in an increase in nodes visited
;;;  with an increase in consistency checks.
;;;


(defun show-fc ()
  (let ((data nil))
    (loop for i from 1 to *n* do
	  (setq data nil)
	  (loop for k in (reverse (aref domain i)) do
		(push (aref reasons i k) data))
	  (print (list i
		       (aref v i)
		       (aref current-domain i)
		       data
		       (aref reason i)
		       (aref past-fc i)
		       (aref reductions i))))))
