/*
 *  Window setup functions
 *  X window operations
 *
 */

#include <stdio.h>
#include "display.h"
#include "constants.h"
#include "structures.h"
#include "parameters.h"


Window win = 0;			/* main screen */
Window b_win = 0;		/* behavior screen */
Window info_win = 0;		/* for numeric info */
static int screen;
static Visual *visual;
GC gc, b_gc, b_gc1, b_gc2;	/* window drawing GCs */
GC cgc,b_cgc;			/* clearing GCs */
GC igc;				/* info window GC */
static GC cpgc;			/* clearing pixmap GC */
static GC pgc;			/* setting pixmap GC */
static GC pgc2;			/* setting pixmap GC, wide lines */
Display *display;
Pixmap graphics_pm = 0;		/* for drawing flakey and environs */
Pixmap b_pm = 0;		/* for drawing behaviors */
Font font;


rotm screen_matrix;		/* to translate rw to screen coords */

/* buffer definitions for segments, boxes, points */

#define sX1_buf_MAX 3000
#define sX2_buf_MAX  200

XPoint      pX_buf[pX_buf_MAX];	/* buffers for points, segments, and boxes */
XSegment    sX1_buf[sX1_buf_MAX];
XSegment    sX2_buf[sX2_buf_MAX];
XRectangle  rX_buf[rX_buf_MAX];
XArc        aX_buf[aX_buf_MAX];

XPoint      *pX_buf_p = pX_buf; /* buffer ptrs for points, segments, and boxes */
XSegment    *sX_buf_p;		
XRectangle  *rX_buf_p = rX_buf;
XArc        *aX_buf_p = aX_buf;

int  pX_buf_n = 0;		/* buffer pointers */
int  rX_buf_n = 0;
int  aX_buf_n = 0;

static struct sX_data sX1, sX2;
struct sX_data *sx = &sX1;		/* set initial segment buffer */

/* start up a window with these dims */

int w_height, w_width;		/* height and width of display, in pixels */
int w_offset_x, w_offset_y;	/* center x,y offset, in pixels */
int w_offset_dx, w_offset_dy;	/* offset displacement from center screen */
float w_scale;

int b_height, b_width;		/* height and width of behavior display, in pixels */
#define B_HEIGHT 300
#define B_WIDTH 500

init_window(width,height,conv,argc,argv)
     int width, height, argc;
     float conv;
     char **argv;
{ 
  if (win == 0)
    { 
  w_width = width; 
  w_height = height; 
  set_window_center(0,0);	/* center of window, offset from real center */
  w_scale = conv;		/* pixels per mm */
  
  screen_matrix.a11 = 0.0;	/* set up the screen rotation/trans matrix */
  screen_matrix.a22 = 0.0;
  screen_matrix.a12 = - w_scale;
  screen_matrix.a21 = - w_scale;
  screen_matrix.a13 = w_offset_x;
  screen_matrix.a23 = w_offset_y;
  screen_matrix.a31 = 0.0;
  screen_matrix.a32 = 0.0;
  screen_matrix.a33 = 1.0;

  win = create_app(width,height+INFO_HEIGHT,argc,argv);
  resize_window();		/* check what we got */
  screen = DefaultScreen(display);

  graphics_pm = XCreatePixmap(display, win, width, height, 1); /* for double-buf */

  gc  = XCreateGC(display,win,0,NULL);
  XSetBackground(display, gc, WhitePixel(display,screen));
  XSetForeground(display, gc, BlackPixel(display,screen));
  XSetLineAttributes(display, gc, 0, LineSolid, CapButt, JoinMiter);
  XSetGraphicsExposures(display, gc, False);
                        
  font = XLoadFont(display,"-misc-fixed-bold-r-normal--13-100-100-100-c-70-iso8859-1");
  if ( font == 0  )
    { printf("can't find font\n"); exit(-1); }
  XSetFont(display, gc, font);

  cgc  = XCreateGC(display,win,0,NULL);
  XSetBackground(display, cgc, BlackPixel(display,screen));
  XSetForeground(display, cgc, WhitePixel(display,screen));
  XSetGraphicsExposures(display, cgc, False);

  pgc  = XCreateGC(display,graphics_pm,0,NULL);
  XSetForeground(display, pgc, BlackPixel(display,screen));
  XSetBackground(display, pgc, WhitePixel(display,screen));
  XSetLineAttributes(display, pgc, 0, LineSolid, CapButt, JoinMiter);
  XSetGraphicsExposures(display, pgc, False);

  pgc2 = XCreateGC(display,graphics_pm,0,NULL);
  XSetForeground(display, pgc2, BlackPixel(display,screen));
  XSetBackground(display, pgc2, WhitePixel(display,screen));
  XSetLineAttributes(display, pgc2, 3, LineSolid, CapButt, JoinMiter);
  XSetGraphicsExposures(display, pgc2, False);

  cpgc  = XCreateGC(display,graphics_pm,0,NULL);
  XSetForeground(display, cpgc, WhitePixel(display,screen));
  XSetBackground(display, cpgc, BlackPixel(display,screen));
  XSetGraphicsExposures(display, cpgc, False);

  igc  = XCreateGC(display,info_win,0,NULL);
  XSetGraphicsExposures(display, igc, False);
  XSetBackground(display, igc, WhitePixel(display,screen));
  XSetForeground(display, igc, BlackPixel(display,screen));
  XSetFont(display, igc, font);

  XSetWindowBackground(display, win, WhitePixel(display,screen)) ;
  XSetWindowBorder(display, win, BlackPixel(display,screen)) ;

  sX1.n = 0;			/* set up initial values */
  sX1.ofw = 0;			/* set up initial values */
  sX1.end = sX1_buf_MAX;
  sX1.p = sX1_buf;
  
  sX2.n = 0;
  sX2.ofw = 0;			/* set up initial values */
  sX2.end = sX2_buf_MAX;
  sX2.p = sX2_buf;

}

 if (b_win == 0) {		/* create behavior display */
  b_width = B_WIDTH; 
  b_height = B_HEIGHT; 
  b_win = create_b_win(b_width,b_height);

  b_pm = XCreatePixmap(display, win, b_width, b_height, 1); /* for double-buf */

  b_gc  = XCreateGC(display,b_win,0,NULL); /* draw on screen */
  XSetBackground(display, b_gc, WhitePixel(display,screen));
  XSetForeground(display, b_gc, BlackPixel(display,screen));
  XSetGraphicsExposures(display, b_gc, False);

  b_cgc  = XCreateGC(display,b_pm,0,NULL); /* clear screen */
  XSetBackground(display, b_cgc, BlackPixel(display,screen));
  XSetForeground(display, b_cgc, WhitePixel(display,screen));
  XSetGraphicsExposures(display, b_cgc, False);

  b_gc1  = XCreateGC(display,b_pm,0,NULL); /* thin draw */
  XSetBackground(display, b_gc1, WhitePixel(display,screen));
  XSetForeground(display, b_gc1, BlackPixel(display,screen));
  XSetLineAttributes(display, b_gc1, 1, LineSolid, CapButt, JoinMiter);
  XSetGraphicsExposures(display, b_gc1, False);

  b_gc2  = XCreateGC(display,b_pm,0,NULL); /* thin draw */
  XSetBackground(display, b_gc2, WhitePixel(display,screen));
  XSetForeground(display, b_gc2, BlackPixel(display,screen));
  XSetLineAttributes(display, b_gc2, 3, LineSolid, CapButt, JoinMiter);
  XSetGraphicsExposures(display, b_gc2, False);

  XSetWindowBackground(display, b_win, WhitePixel(display,screen)) ;
  XSetWindowBorder(display, b_win, BlackPixel(display,screen)) ;
  }
}

/* Invert window between black/white background */

void
change_window_color()		
{
  static int old_color = 0;
  old_color = 1 - old_color;
     if (win) {
       if (old_color) {
	 XSetWindowBackground(display, win, WhitePixel(display,screen)) ;
	 XSetWindowBorder(display, win, BlackPixel(display,screen)) ;

/*	 XSetWindowBackground(display, info_win, WhitePixel(display,screen)) ;
	 XSetWindowBorder(display, info_win, BlackPixel(display,screen)) ;
*/
	 XSetBackground(display, gc, WhitePixel(display,screen));
	 XSetForeground(display, gc, BlackPixel(display,screen));

	 XSetBackground(display, cgc, BlackPixel(display,screen));
	 XSetForeground(display, cgc, WhitePixel(display,screen));
       }
       else {
	 XSetWindowBackground(display, win, BlackPixel(display,screen)) ;
	 XSetWindowBorder(display, win, WhitePixel(display,screen)) ;


/*	 XSetWindowBackground(display, info_win, BlackPixel(display,screen)) ;
	 XSetWindowBorder(display, info_win, WhitePixel(display,screen)) ;
*/
	 XSetBackground(display, gc, BlackPixel(display,screen));
	 XSetForeground(display, gc, WhitePixel(display,screen));

	 XSetBackground(display, cgc, WhitePixel(display,screen));
	 XSetForeground(display, cgc, BlackPixel(display,screen));
       }
     }
   }


/* check for keyboard events on the window */

static int but_x, but_y; /* buffer for last button pressing */

button_x()			/* return button x position, RW coords */
{ 
  int x;
  x = (w_offset_y - but_y) / w_scale;
  return(x); 
}

button_y()			/* return button y position, RW coords */
{ 
  int y;
  y = (w_offset_x - but_x) / w_scale;
  return(y); 
}


/* show window */

show_window()
{
  check_alive;
  XRaiseWindow(display, win);
  XSync(display,1);
}

/* resize window */
resize_window()			/* set it to this width and height */
{
  XWindowAttributes wattr;
  if (win)
    {
      XGetWindowAttributes(display, win, &wattr);
      w_width = wattr.width;
      w_height = wattr.height;
      set_window_center(w_offset_dx,w_offset_dy);
      if (graphics_pm)
	XFreePixmap(display, graphics_pm); /* Free pixmap, create new one */
      graphics_pm = XCreatePixmap(display, win, w_width, w_height, 1); 
    }
}


kill_window()
{
  if (win)
    { XCloseDisplay(display); }	/* close all services for this client */
  win = 0;
}



/* switching vector buffer */

set_vector_buffer(w)		/* w = 0 is thin, w = 1 is thick */
{
  if (w) { sx = &sX2; }
  else   { sx = &sX1; }
}
    

/* clear the graphics window, then write to it */

int display_buffer()		/* display graphics buffer, clear it */
{
  int ofw;
  check_alive;

				/* do it for the main Flakey display */
  XFillRectangle(display, graphics_pm, cpgc, 0,  0, w_width, w_height); 
  XDrawPoints(display, graphics_pm, pgc, pX_buf, pX_buf_n, CoordModeOrigin);
  XDrawSegments(display, graphics_pm, pgc, sX1.p, sX1.n);
  XDrawSegments(display, graphics_pm, pgc2, sX2.p, sX2.n);
  XDrawRectangles(display, graphics_pm, pgc, rX_buf, rX_buf_n);
  XDrawArcs(display, graphics_pm, pgc2, aX_buf, aX_buf_n);
  XCopyPlane(display, graphics_pm, win, gc, 0, 0, w_width, w_height, 0, 0, 1); 

  XFlush(display);
  ofw = (sX1.ofw + sX2.ofw);

  pX_buf_n = 0;			/* reset buffers */
  rX_buf_n = 0;
  aX_buf_n = 0;
  sX1.n = 0;
  sX2.n = 0;
  sX1.ofw = 0;
  sX2.ofw = 0;

  pX_buf_p = pX_buf;		/* reset buffers */
  rX_buf_p = rX_buf;
  aX_buf_p = aX_buf;

  return(ofw);			/* > 0 if buffer overflow */
}


/* set window offset */

set_window_center(wx,wy)	/* offset of window center from real center */
{				/* in pixels */
  w_offset_x = (w_width >> 1) + wx;
  w_offset_y = (w_height >> 1) + wy;
  screen_matrix.a13 = w_offset_x;
  screen_matrix.a23 = w_offset_y;
  w_offset_dx = wx;		/* save these for reconfiguring */
  w_offset_dy = wy;
}


/* reset window offset to display flakey */

reset_window_center(x,y,thresh)	/* flakey's coords, threshold */
     
 {
   int temp;
   temp = w_scale * y;
   y = w_scale * x;
   x = temp;
   if ( ABS(x - w_offset_dx) > thresh || ABS(y - w_offset_dy) > thresh)
     { set_window_center(x,y); }
 }



/* set window scaling */

set_window_scale(s)
     float s;
{
  w_scale = s;
  screen_matrix.a12 = - w_scale;
  screen_matrix.a21 = - w_scale;
}


/* drawing on the behavior window */

void
draw_bs_bar(int x0,int y0,int l) 
{
  if ( l > BS_BAR) XDrawLine(display,b_pm,b_gc2,x0,y0,x0+BS_BAR,y0);
  else if ( l < -BS_BAR) XDrawLine(display,b_pm,b_gc2,x0,y0,x0-BS_BAR,y0);
  else XDrawLine(display,b_pm,b_gc2,x0,y0,x0+l,y0);
  XDrawLine(display,b_pm,b_gc1,x0,y0-20,x0,y0+20); /* draw vertical separator */
}  




