function zoomtool(ga,prop1,val1,prop2,val2,prop3,val3,prop4,val4, ...
    prop5,val5,prop6,val6,prop7,val7,prop8,val8,prop9,val9)
%ZOOMTOOL Axes zoom/measurement tool.
%	ZOOMTOOL activates the ZOOMTOOL on the current axes.
%
%	ZOOMTOOL(H) activates the ZOOMTOOL on the axes
%	specified by the handle H.
%
%	ZOOMTOOL(H,'PropertyName','PropertyValue',....)
%	activates ZOOMTOOL on the axes spectified by the handle
%	H with the specified property values set.  Valid
%	properties are:
%
%		QuitButton          'on' | off
%		SnapShotButton      'on' | off
%		HorizontalCursors   'on' | off
%		ZoomX               on | 'off'
%		ZoomY               on | 'off'
%		ZoomXY              'on' | off
%		Toggle              'on' | off
%		Pan		    on | 'off'
%		CursorCallBack      <str>
%		ToggleCallBack      <str>
%		ZoomCallBack        <str>
%
%	Once activated, ZOOMTOOL redraws the axis with two
%	vertical/horizontal cursors and several controls.
%
%	The cursor push button controls (one set for each cursor)
%	allow movement of the vertical cursor along the hori-
%	zontal axis. The horizontal cursor is automatically
%	adjusted to the magnitude of the corresponding sample
%	at the vertical cursor location. The push button
%	controls are:
%
%	"<" and ">" move the vertical cursor to the next
%		left or right sample.
%
%	"<<" and ">>" move the vertical cursor to the next
%		left or right peak.
%
%	A peak is defined a the next maxima or minima in the
%	curve formed by the vector values.
%
%       In addition to cursor manipulation with push buttons,
%       the cursors can also be manipulated with the mouse. A
%       single click on a curve will move the nearest cursor
%       (horizontal distance) to that point. The mouse button
%       can also be held down and the nearest cursor "dragged"
%       to the desired location.
%
%       The zoom push button controls (one set for the X-axis,
%       Y-axis, and both X- and Y-axis) are:
%
%           "> <" zooms in on the X-axis between the cursors.
%               Zooms to maximize the view of the Y-axis.
%
%           "< >" zooms out to the previous zoom limits.
%
%           "[ ]" zooms out to the full axis limits.
%
%       The X-Axis readouts are edit boxes. Using these edit
%       boxes, a desired location for the vertical cursors can
%       be entered. After pressing return, the cursor will be
%       moved to the new location. The "Delta X" readout is
%       also an edit box. It can be used to enter an offset
%       from cursor 1 to place cursor 2. Entering a location
%       such that a cursor would be located beyond the limits
%       of the axes will move the cursor to the axes limit.
%
%       The toggle push button ("T") toggles the attachment of
%       the cursor to next curve when an axes contains more than
%       one curve. Toggling to a specific curve can be accom-
%       plished with the mouse by simply selecting the desire
%       line.
%
%       If the handle, h, is omitted, the current axis is used.
%
%       Quitting ZOOMTOOL with the quit push button ("Q") leaves
%       the axes in the last zoomed state, removing the button
%       bars and readouts. after which the user can print or
%       otherwise treat the axes as any other axes.
%
%       Note: Only one ZOOMTOOL can be active in a single
%       figure window at a time. Multiple ZOOMTOOLs can be active
%       as long as they are attached to axes in different figure
%       windows. While active, ZOOMTOOL will cover the X-axis
%       label and may also cover the axes title.
%
%       See also ZOOMCLR ZOOMDOWN ZOOMLEFT ZOOMMENU ZOOMMOVE
%           ZOOMPKLF ZOOMPKRT ZOOMRGHT ZOOMSET ZOOMTGGL ZOOMTOOL
%           ZOOMUP ZOOMXFUL ZOOMXIN ZOOMXOUT ZOOMYFUL ZOOMYIN
%           ZOOMYOUT

%       Dennis W. Brown 1-10-94, DWB 1-31-94
%       Copyright (c) 1994 by Dennis W. Brown
%       May be freely distributed.
%       Not for use in commercial products.

% xtorage locations
% zoomcallback - UserData of "X" uicontrol text object

if nargin ~= 1,
    ga = gca;
end;

% find parent window
gf = get(ga,'Parent');

% check to see if already running in same figure window
if ~isempty(findpush(gf,'<<')),
    error('zoomtool: Only one zoomtool allowed in a single figure.');
end;

% crudely test to see if axes is 3d, is so, abort
if ~isempty(get(ga,'ZTickLabels')),
    error('zoomtool: Use not available with 3D plots...');
end;

% default properties
quitbutton = 'on';
snapshotbutton = 'on';
horzcursor = 'on';
zoomx = 'off';
zoomy = 'off';
zoomxy = 'on';
toggle = 'on';
pan = 'on';
cursorcallback = '';
zoomcallback = '';
togglecallback = '';

% handle and other variable storage
handles = zeros(40,1);

% must have first arg
if nargin > 1,
    for i = 1:(nargin-1)/2,
        prop = eval(['prop' int2str(i)]);
        val = eval(['val' int2str(i)]);
        if strcmp(lower(prop),'quitbutton'),
            if strcmp(lower(val),'off'),
                quitbutton = 'off';
            elseif strcmp(lower(val),'on'),
                quitbutton = 'on';
            else,
                error(['zoomtool: Invalid QuitButton property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'snapshotbutton'),
            if strcmp(lower(val),'off'),
                snapshotbutton = 'off';
            elseif strcmp(lower(val),'on'),
                snapshotbutton = 'on';
            else,
                error(['zoomtool: Invalid SnapShotButton property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'horizontalcursors'),
            if strcmp(lower(val),'off'),
                horzcursor = 'off';
            elseif strcmp(lower(val),'on'),
                horzcursor = 'on';
            else,
                error(['zoomtool: Invalid HorizontalCursor property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'zoomx'),
            if strcmp(lower(val),'off'),
                zoomx = 'off';
            elseif strcmp(lower(val),'on'),
                zoomx = 'on';
            else,
                error(['zoomtool: Invalid ZoomX property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'zoomy'),
            if strcmp(lower(val),'off'),
                zoomy = 'off';
            elseif strcmp(lower(val),'on'),
                zoomy = 'on';
            else,
                error(['zoomtool: Invalid ZoomY property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'zoomxy'),
            if strcmp(lower(val),'off'),
                zoomxy = 'off';
            elseif strcmp(lower(val),'on'),
                zoomxy = 'on';
            else,
                error(['zoomtool: Invalid ZoomXY property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'toggle'),
            if strcmp(lower(val),'off'),
                toggle = 'off';
            elseif strcmp(lower(val),'on'),
                toggle = 'on';
            else,
                error(['zoomtool: Invalid Toggle property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'pan'),
            if strcmp(lower(val),'off'),
                pan = 'off';
            elseif strcmp(lower(val),'on'),
                pan = 'on';
            else,
                error(['zoomtool: Invalid Pan property value "' val '".']);
            end;
        elseif strcmp(lower(prop),'cursorcallback'),
		cursorcallback = val;
        elseif strcmp(lower(prop),'togglecallback'),
		togglecallback = val;
        elseif strcmp(lower(prop),'zoomcallback'),
		zoomcallback = val;
        else
            error(['zoomtool: Invalid property "' prop '" specified.']);
        end;
    end;
end;

if ~isempty(cursorcallback),
	tgglcallback = ['zoomtggl(gca,''' ...
		 dblquote(cursorcallback) ''');' togglecallback];
else,
	tgglcallback = ['zoomtggl(gca);' togglecallback];
end;

% get handles to all lines currently in axes (used later here
%   and later)
[lcnt,lhand] = cntlines(ga);

% let the first line be the "zoomed" line
x = get(lhand(1),'XData');
y = get(lhand(1),'YData');

% setup for mouse movement or release
if isempty(cursorcallback)'
	set(lhand(1),'ButtonDownFcn','zoomdown');
else,
	set(lhand(1),'ButtonDownFcn',['zoomdown(''' ...
		dblquote(cursorcallback) ''');']);
end;

% abort if axes is empty
if lcnt == 0,
    error('zoomtool: No lines in axes...');
end;


% set all lines to toggle if selected
if lcnt == 1,
	toggle = 'off';
end;

if strcmp(toggle,'on'),
    for j = 1:lcnt,
        set(lhand(j),'ButtonDownFcn',tgglcallback);
    end;
end;
% get the extremes of all lines, this is necessary to set the
%   y limits if the zoomtool is ran against an axis that has
%   already been zoomed and to show all the y data if the first
%   line object in the stack does not contain the largest y
%   values of all line objects (believe me, it's all true).
extremes = zeros(lcnt,4);
for i = 1:lcnt,
    yt = get(lhand(i),'YData');
    xt = get(lhand(i),'XData');
    extremes(i,1) = min(xt);
    extremes(i,2) = max(xt);
    extremes(i,3) = min(yt);
    extremes(i,4) = max(yt);
end;
clear yt xt

% all lines must have same X-axis extremes, can have different
%   number of points in between
if all(extremes(:,1) ~= extremes(1,1)) | all(extremes(:,2) ~= extremes(1,2))
    error('zoomtool: Lines must have same X-axis endpoint values...');
end;

% get horizontal scale
xlen = length(x);
xmin = x(1);
xmax = x(xlen);
xdiff = xmax-xmin;

% insure zoom is full
set(ga,'XLim',[xmin xmax]);

% set new y limits, ensure data not coincident to border
ylim = [min(extremes(:,3)) max(extremes(:,4))];
delta = (ylim(2) - ylim(1)) * 0.05;
if delta == 0, delta = 1; end;
ylim(1) = ylim(1) - delta;
ylim(2) = ylim(2) + delta;
set(ga,'YLim',ylim);

% set horizontal factor
xfactor = (xmax - xmin) / (xlen - 1);

% Y zoom is much simpler

% add cursors to axis
v1 = floor(xlen/4);
v2 = floor(xlen*3/4);
h1 = y(v1);
h2 = y(v2);

handles(24) = crsrmake(ga,1001,'vertical',(v1-1) * xfactor + xmin,'--', ...
		['ga = findaxes(gcf,''zoomtool''); ' ...
		 'dog_x = crsrloc(ga,1001);' ...
		 'zoomset(ga,1,dog_x); clear dog_x;' ...
		  cursorcallback]);
handles(25) = crsrmake(ga,1002,'horizontal',h1,'--');
handles(26) = crsrmake(ga,2001,'vertical',(v2-1) * xfactor + xmin,'-.', ...
		['ga = findaxes(gcf,''zoomtool''); ' ...
		 'dog_x = crsrloc(ga,2001);' ...
		 'zoomset(ga,2,dog_x); clear dog_x;' ...
		  cursorcallback]);
handles(27) = crsrmake(ga,2002,'horizontal',h2,'-.');

% make horizontal cursors invisible if needed
set(findline(ga,1002),'Visible',horzcursor);
set(findline(ga,2002),'Visible',horzcursor);

% reset right border to make room for buttons
olda = get(ga,'units');
set(ga,'Units','normal');
b_hite = 0.04;
pos = get(ga,'Position');

% draw a frame first
b_frame = .004;
hh = uicontrol(gf,'Style','frame','Units','normal',...
	'Position',[pos(1)-b_frame pos(2)-2*b_hite-b_frame ...
		pos(3)+2*b_frame 2*b_hite+2*b_frame],...
	'String','zoomframe');


pos(2) = pos(2) + 2*b_hite;
pos(3) = pos(3) - 0.065;
pos(4) = pos(4) - 3*b_hite;
set(ga,'Position',pos);
set(ga,'Units',olda);
panvis = 'off';

if strcmp(computer,'PCWIN'),
	beditcolor = [1 1 1] * 0.7;
else,
	beditcolor = get(hh,'BackGroundColor');
end;

% add cursor control buttons along top
% store axis number in 'Value' property to use in callback
rvbase = pos(1);
lvbase = rvbase + pos(3);
hbase = pos(2) + pos(4);
b_width = b_hite;
uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[rvbase hbase b_width b_hite],...
    'String','<','UserData',ga,...
    'Callback',['zoomleft(get(get(gcf,''CurrentObject''),''UserData''),1,' ...
		'''' dblquote(cursorcallback) ''');']);

uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[rvbase+b_width hbase b_width b_hite],...
    'String','>','UserData',ga,...
    'Callback',['zoomrght(get(get(gcf,''CurrentObject''),''UserData''),1,' ...
		'''' dblquote(cursorcallback) ''');']);

uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[rvbase+2*b_width hbase b_width b_hite],...
    'String','<<','UserData',ga,...
    'Callback',['zoompklf(get(get(gcf,''CurrentObject''),''UserData''),1,' ...
		'''' dblquote(cursorcallback) ''');']);

uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[rvbase+3*b_width hbase b_width b_hite],...
    'String','>>','UserData',ga,...
    'Callback',['zoompkrt(get(get(gcf,''CurrentObject''),''UserData''),1,' ...
		'''' dblquote(cursorcallback) ''');']);

uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase-4*b_width hbase b_width b_hite],...
    'String','<','UserData',ga,...
    'Callback',['zoomleft(get(get(gcf,''CurrentObject''),''UserData''),2,' ...
		'''' dblquote(cursorcallback) ''');']);

uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase-3*b_width hbase b_width b_hite],...
    'String','>','UserData',ga,...
    'Callback',['zoomrght(get(get(gcf,''CurrentObject''),''UserData''),2,' ...
		'''' dblquote(cursorcallback) ''');']);

uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase-2*b_width hbase b_width b_hite],...
    'String','<<','UserData',ga,...
    'Callback',['zoompklf(get(get(gcf,''CurrentObject''),''UserData''),2,' ...
		'''' dblquote(cursorcallback) ''');']);

uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase-b_width hbase b_width b_hite],...
    'String','>>','UserData',ga,...
    'Callback',['zoompkrt(get(get(gcf,''CurrentObject''),''UserData''),2,' ...
		'''' dblquote(cursorcallback) ''');']);

uicontrol('Style','text','Units','normal','ForeGroundColor','black',...
    'Position',[rvbase hbase+b_hite 4*b_width b_hite],...
    'String','Cursor 1 - -');

uicontrol('Style','text','Units','normal','ForeGroundColor','black',...
    'Position',[lvbase-4*b_width hbase+b_hite 4*b_width b_hite],...
    'String','Cursor 2 -.');

handles(28) = xfactor;
handles(33) = xmin;		% actually min(x)
handles(34) = xmax;		% actually max(x)
handles(35) = min(y);
handles(36) = max(y);
handles(37) = length(y);
vpos = 1;

% zoom x icons

% vertical button bar
uicontrol('Style','Text','Units','normal','ForeGroundColor','black',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomx,'String','X','UserData',zoomcallback);
if strcmp(zoomx,'on'), vpos = vpos + 1; end;

% for the rest of the file
zoomcallback = dblquote(zoomcallback);

handles(1) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomx,'String','> <','UserData',[],...
    'Callback',['zoomxin(gcf,''' zoomcallback ''');']);
if strcmp(zoomx,'on'), vpos = vpos + 1; end;

handles(2) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomx,'String','< >','UserData',[],...
    'Callback',['zoomxout(gcf,''' zoomcallback ''');']);
if strcmp(zoomx,'on'), vpos = vpos + 1; end;

handles(3) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomx,'String','[ ]','UserData',[],...
    'Callback',['zoomxful(gcf,''' zoomcallback ''');']);
if strcmp(zoomx,'on'), vpos = vpos + 2; end;

% zoom y icons

uicontrol('Style','Text','Units','normal','ForeGroundColor','black',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomy,'String','Y');
if strcmp(zoomy,'on'), vpos = vpos + 1; end;

handles(4) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomy,'String','> <','UserData',[],...
    'Callback',['zoomyin(gcf,''' zoomcallback ''');']);
if strcmp(zoomy,'on'), vpos = vpos + 1; end;

handles(5) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomy,'String','< >','UserData',[],...
    'Callback',['zoomyout(gcf,''' zoomcallback ''');']);
if strcmp(zoomy,'on'), vpos = vpos + 1; end;

handles(6) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomy,'String','[ ]','UserData',[],...
    'Callback',['zoomyful(gcf,''' zoomcallback ''');']);
if strcmp(zoomy,'on'), vpos = vpos + 2; end;

% zoom xy icons

uicontrol('Style','Text','Units','normal','ForeGroundColor','black',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomxy,'String','XY');
if strcmp(zoomxy,'on'), vpos = vpos + 1; end;

handles(7) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomxy,'String','> <','UserData',[],...
    'Callback',...
    ['zoomxin(gcf,''' zoomcallback  ...
	''');zoomyin(gcf,''' zoomcallback ''');']);
if strcmp(zoomxy,'on'), vpos = vpos + 1; end;

handles(8) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomxy,'String','< >','UserData',[],...
    'Callback',...
    ['zoomyout(gcf,''' zoomcallback ...
     ''');zoomxout(gcf,''' zoomcallback ''');']);
if strcmp(zoomxy,'on'), vpos = vpos + 1; end;

handles(9) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',zoomxy,'String','[ ]','UserData',[],...
    'Callback',...
    ['zoomxful(gcf,''' zoomcallback ...
    ''');zoomyful(gcf,''' zoomcallback ''');']);
if strcmp(zoomxy,'on'), vpos = vpos + 2; end;

% toggle icon
handles(16) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'Visible',toggle,'String','T','UserData',lhand,...
    'Callback',tgglcallback);
if strcmp(pan,'on'), vpos = vpos + 2; end;

% turn off toggle button if not needed
if lcnt == 1,
    set(handles(16),'Visible','off');
end;

handles(10) = uicontrol(gcf,'Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',panvis,'String','<<<','UserData',pan,...
	'Interruptible','yes',...
	'Callback','zoompan(''left'');');
if strcmp(pan,'on'), vpos = vpos + 1; end;

handles(11) = uicontrol(gcf,'Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',panvis,'String','>>>','UserData',pan,...
	'Interruptible','yes',...
	'Callback','zoompan(''right'');');
if strcmp(pan,'on'), vpos = vpos + 1; end;

handles(12) = uicontrol(gcf,'Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',panvis,'String','===','UserData',pan,...
	'Interruptible','no',...
	'Callback','global SPC_PAN; SPC_PAN = 0;');
if strcmp(pan,'on'), vpos = vpos + 2; end;

handles(13) = uicontrol(gcf,'Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',panvis,'String','<-','UserData',pan,...
	'Interruptible','yes',...
	'Callback','zoompan(''page'',''left'');');
if strcmp(pan,'on'), vpos = vpos + 1; end;

handles(14) = uicontrol(gcf,'Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase-vpos*b_hite 1.5*b_width b_hite],...
    'visible',panvis,'String','->','UserData',pan,...
	'Interruptible','yes',...
	'Callback','zoompan(''page'',''right'');');
if strcmp(pan,'on'), vpos = vpos + 1; end;

% set zoom full limits
set(handles(3),'UserData',[xmin xmax]);

% get horizontal scale
ylim = get(ga,'YLim');

% set zoom full limits
set(handles(6),'UserData',ylim);
hbase = pos(2) - 3*b_hite;          % edit/text uicontrols readouts
tbase = pos(2) - 4*b_hite;          % text uicontrol labels

% set up Q button before changing b_width variable
handles(15) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase tbase 1.5*b_width b_hite],...
    'String','Q','UserData',[],...
    'Visible',quitbutton,...
    'Callback',...
    'zoomclr(gcf);');

% set up S button before changing b_width variable
handles(17) = uicontrol('Style','Pushbutton','Units','normal',...
    'Position',[lvbase hbase 1.5*b_width b_hite],...
    'String','S','UserData',lhand(1),...
    'Visible',snapshotbutton,...
    'Callback',...
    'snapsht2(findaxes(gcf,''zoomtool''));');

b_width = (lvbase - rvbase) / 6;
v1 = crsrloc(ga,1001);
v2 = crsrloc(ga,2001);
h1 = crsrloc(ga,1002);
h2 = crsrloc(ga,2002);

handles(18) = uicontrol('Style','edit','Units','normal',...
    'Position',[rvbase+0*b_width hbase b_width*.9 b_hite],...
    'String',num2str(v1),'UserData',ga,'Value',3001,...
    'BackGroundColor',beditcolor,'ForeGroundColor','black',...
    'Callback',['zoomset(get(get(gcf,''CurrentObject''),''UserData''),1,' ...
		'''' dblquote(cursorcallback) ''');']);

uicontrol('Style','text','Units','normal','ForeGroundColor','black',...
    'Position',[rvbase+0*b_width tbase b_width*.9 b_hite],...
    'UserData',togglecallback,'String','X - - -');

handles(19) = uicontrol('Style','text','Units','normal',...
    'Position',[rvbase+1*b_width hbase b_width*.9 b_hite],...
    'Visible',horzcursor,...
    'ForeGroundColor','black','String',num2str(h2),'UserData',ga);

uicontrol('Style','text','Units','normal',...
    'Position',[rvbase+1*b_width tbase b_width*.9 b_hite],...
    'Visible',horzcursor,...
    'ForeGroundColor','black','String','Y - - -');

handles(20) = uicontrol('Style','edit','Units','normal',...
    'Position',[rvbase+2*b_width hbase b_width*.9 b_hite],...
    'String',num2str(abs(v2-v1)),'UserData',ga,'Value',3003,...
    'BackGroundColor',beditcolor,'ForeGroundColor','black',...
    'Callback',['zoomset(get(get(gcf,''CurrentObject''),''UserData''),3,' ...
		'''' dblquote(cursorcallback) ''');']);

uicontrol('Style','text','Units','normal',...
    'Position',[rvbase+2*b_width tbase b_width*.9 b_hite],...
    'ForeGroundColor','black','String','Delta X');

handles(21) = uicontrol('Style','text','Units','normal',...
    'Position',[rvbase+3*b_width hbase b_width*.9 b_hite],...
    'Visible',horzcursor,...
    'ForeGroundColor','black','String',num2str(abs(h2-h1)),'UserData',ga);

uicontrol('Style','text','Units','normal',...
    'Position',[rvbase+3*b_width tbase b_width*.9 b_hite],...
    'Visible',horzcursor,...
    'ForeGroundColor','black','String','Delta Y');

handles(22) = uicontrol('Style','edit','Units','normal',...
    'Position',[rvbase+4*b_width hbase b_width*.9 b_hite],...
    'String',num2str(v2),'UserData',ga,'Value',3002,...
    'BackGroundColor',beditcolor,'ForeGroundColor','black',...
    'Callback',['zoomset(get(get(gcf,''CurrentObject''),''UserData''),2,' ...
		'''' dblquote(cursorcallback) ''');']);

uicontrol('Style','text','Units','normal',...
    'Position',[rvbase+4*b_width tbase b_width*.9 b_hite],...
    'ForeGroundColor','black','String','X -.-.');

handles(23) = uicontrol('Style','text','Units','normal',...
    'Position',[rvbase+5*b_width hbase b_width*.9 b_hite],...
    'Visible',horzcursor,...
    'ForeGroundColor','black','String',num2str(h2),'UserData',ga);

uicontrol('Style','text','Units','normal',...
    'Position',[rvbase+5*b_width tbase b_width*.9 b_hite],...
    'Visible',horzcursor,...
    'ForeGroundColor','black','String','Y -.-.');

set(gf,'CurrentAxes',ga);

handles(39) = lhand(1);
handles(40) = ga;

% save handles in uicontrol text object
gg=uicontrol(gf,'Style','text','String','zoomtool',...
	'Visible','off','UserData',handles);

% don't allow another plot to be added without first closing
% the zoomtool.
set(gf,'NextPlot','New');

% identify zoomtool axis
set(ga,'UserData','zoomtool');
