% README file for the SPC Toolbox
% LT Dennis W. Brown
% Naval Postgraduate School, Monterey, CA
%
% Last update: Jul 6, 1994
%
%
% New interactive tools
% ---------------------
%
%    Command arguments:
%	x = Nx1 or 1xN vector
%	fs = sampling frequency (default is 8192 Hz)
%	a,b = filter coeffiecients
%
% sigedit(x) or sigedit(x,fs)	Signal editing (cut & paste).
% voicedit(x) or voicedit(x,fs)	Speech signal editing.
% sigfilt(x) or sigfilt(x,fs)	Signal filtering (analog 
%				prototypes).
% spect2d(x) or spect2d(x,fs)	Spectral estimation (classical,
%				AR/MA/ARMA, MUSIC).
% spect3d(x) or spect3d(x,fs)	Spectral surface estimation 
%				(time/freq/magnitude).
% sigmodel(x) or sigmodel(x,fs)	Signal modeling (AR/MA/ARMA).
%
% 
% Sample test data
% ----------------
% Type "spcdata" at Matlab prompt to load.
%
% seatsit.voc (see loadvoc) 	Speech signal of the phrase
%				"the seat, sit" with 60-Hz
%				line noise (fs=8192Hz).
% uuu.mat			Speech signal of /u/ phoneme
%				(fs=8192Hz).
% t0x.mat			AR/ARMA data sets t01, t02, 
%				t03, t04 from Prof Therrien's 
%				book.
% datax.mat			Spectrum analysis data sets
%				dataa, datab, datac, datad, datae
%				from Prof Therrien's book.
%
%
% SPC Toolbox for MS-Windows Matlab
% ---------------------------------
%
% The SPC Toolbox is now available for downloading to a 
% floppy disk which can then be used to install the SPC
% Toolbox on a PC running Matlab for Windows.  To 
% download a copy:
%
% 1. Log into a Sun with a floppy drive on the ECE network.
%
% 2. Start Matlab 4.1 (matlab).
% 
% 3. Execute "spcpath" from the Matlab prompt to access the
% SPC Toolbox.
%
% 4. Place a 1.4M high density floppy disk into the disk drive.
%
% 5. Execute "spc2flop" from the Matlab prompt.  You'll be 
% asked if you want to format the floppy.  After formatting,
% the SPC Toolbox files will be copied to a directory called
% "spctools" on the floppy.  After completion, the disk will
% automatically be ejected from the drive.  The toolbox will
% use the full 1.4M floppy.
% 
% 6. To load SPC Tools onto a PC, from the MS-DOS prompt change
% to the "\matlab\toolbox" directory.
% 
% 7. Place the floppy into a drive and execute
% 
% 	xcopy a:\spctools spctools /s
% 
% from the MS-DOS prompt.  If you have not loaded SPC previously
% (e.g. the \matlab\toolbox\spctools directory does not already
% exist), you'll be asked if "spctools" is a directory or a 
% filename.  Respond that it is a directory.  After a lot of 
% disk activity, SPC Tools will be loaded onto your hard drive.
% 
% 8. To complete installation, add the following directories to
% the "\matlab\matlabrc.m" file where the matlabpath variable
% is set.
% 
%	....
%	'e:\matlab\toolbox\spctools;',...
%	'e:\matlab\toolbox\spctools\spcgui;',...
%	'e:\matlab\toolbox\spctools\spcline;',...
%	'e:\matlab\toolbox\spctools\spcprog;',...
%	'e:\matlab\toolbox\spctools\spcspch;',...
%	'e:\matlab\toolbox\spctools\spccomms;',...
%	'e:\matlab\toolbox\spctools\spcutil;',...
%	'e:\matlab\toolbox\spctools\spcsspi;',...
%	...
% 
% The sspitool functions will not be useful to most people (an
% additional licensed program is required) so you can delete
% that directory and omit it from matlabrc.m if you wish.
% You may find the LOADSSPI and SAVESSPI functions useful for
% as a storage option to *.mat files.
% 
% The toolbox is periodically updated.  To find the last date
% it was updated, look at the date in the Readme.m file (type 
% "whatsnew spctools" from the Matlab command prompt to read
% the Readme.m file from within Matlab).
% 
% If you have any troubles, email LT Dennis Brown at 
% browndw@ece.nps.navy.mil.
% 
% ---------------------------------------------------------------
% 
% If this scrolled too fast for you to read, use the 
% command "more on" before typing "whatsnew spctools".
% 
% 
% The End!
