;;; -*- Package: Ra-1-User-Interface; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

;;; File converted on  3-Nov-87 16:29:51 from source CONSEQUENT-FUNCTIONS
;;; Original source {LISPDEV:LAIR:OHIO-STATE}<TOOLSET>RA-1>CONSEQUENT-FUNCTIONS.;1 created  3-Nov-87 17:09:48



(DEFUN CONSIDERING-CONSEQUENT (I TRACE-WINDOW) 
                               "Inverts a consequent while considering"
   (PCL::WITH-SLOTS* (GRID-LEFT-EDGE GRID-BOTTOM-EDGE GRID-ELEMENT-WIDTH
				     GRID-ELEMENT-HEIGHT GRID-HEIGHT
				     GRID-WIDTH)
		     TRACE-WINDOW
          (LET ((BOX-LEFT-EDGE-X (+ GRID-LEFT-EDGE (* 
                                                     GRID-ELEMENT-WIDTH
                                                      (1- GRID-WIDTH)))
                       )
                (BOX-LEFT-EDGE-Y (IL:BOTTOMOFGRIDCOORD (- GRID-HEIGHT 1 
                                                          I)
                                        (LIST GRID-LEFT-EDGE 
                                              GRID-BOTTOM-EDGE 
                                              GRID-ELEMENT-WIDTH 
                                              GRID-ELEMENT-HEIGHT))))
               (IL:DSPFILL (LIST BOX-LEFT-EDGE-X BOX-LEFT-EDGE-Y 
                                 GRID-ELEMENT-WIDTH GRID-ELEMENT-HEIGHT
                                 )
                      IL:BLACKSHADE
                      'IL:INVERT WINDOW))))


(DEFUN DECONSIDERING-CONSEQUENT (I TRACE-WINDOW) 
                          "Inverts a consequent back after considering"
   (PCL::WITH-SLOTS* (GRID-LEFT-EDGE GRID-BOTTOM-EDGE GRID-ELEMENT-WIDTH
				     GRID-ELEMENT-HEIGHT GRID-HEIGHT
				     GRID-WIDTH)
		     TRACE-WINDOW
          (LET ((BOX-LEFT-EDGE-X (+ GRID-LEFT-EDGE (* 
                                                     GRID-ELEMENT-WIDTH
                                                      (1- GRID-WIDTH)))
                       )
                (BOX-LEFT-EDGE-Y (IL:BOTTOMOFGRIDCOORD (- GRID-HEIGHT 1 
                                                          I)
                                        (LIST GRID-LEFT-EDGE 
                                              GRID-BOTTOM-EDGE 
                                              GRID-ELEMENT-WIDTH 
                                              GRID-ELEMENT-HEIGHT))))
               (IL:DSPFILL (LIST BOX-LEFT-EDGE-X BOX-LEFT-EDGE-Y 
                                 GRID-ELEMENT-WIDTH GRID-ELEMENT-HEIGHT
                                 )
                      IL:BLACKSHADE
                      'IL:INVERT WINDOW))))


(DEFUN STUFF-CONSEQUENT (TRACE-WINDOW RESULT) 
                      "Displays the result in the corner of the window"
   (PCL::WITH-SLOTS* (WINDOW)
		     TRACE-WINDOW 
          (LET ((FONT-HEIGHT (IL:FONTPROP IL:DEFAULTFONT 'IL:HEIGHT))
                (REGION (IL:WINDOWPROP WINDOW 'IL:REGION)))
               (IL:DSPYPOSITION (- (FOURTH REGION)
                                   15 FONT-HEIGHT)
                      WINDOW)
               (IL:DSPXPOSITION
                (- (THIRD REGION)
                   (* (IL:CHARWIDTH 87 IL:SMALLFONT)
                      (+ 9                 ; 8 being the number of
                                           ; characters in "Result: "

                         (LENGTH (WRITE-TO-STRING RESULT)))))
                WINDOW)
               (IL:PRIN1 (CONCATENATE 'STRING "Result: " (
                                                        WRITE-TO-STRING
                                                          RESULT))
                      WINDOW))))


(DEFUN YES-CONSEQUENT (I TRACE-WINDOW) "Boxes a consequent"
   (PCL::WITH-SLOTS* (GRID-LEFT-EDGE GRID-BOTTOM-EDGE GRID-ELEMENT-WIDTH
				     GRID-ELEMENT-HEIGHT GRID-HEIGHT
				     GRID-WIDTH)
		     TRACE-WINDOW
          (LET ((BOX-LEFT-EDGE-X (+ GRID-LEFT-EDGE (* 
                                                     GRID-ELEMENT-WIDTH
                                                      (1- GRID-WIDTH)))
                       )
                (BOX-LEFT-EDGE-Y (IL:BOTTOMOFGRIDCOORD (- GRID-HEIGHT 1 
                                                          I)
                                        (LIST GRID-LEFT-EDGE 
                                              GRID-BOTTOM-EDGE 
                                              GRID-ELEMENT-WIDTH 
                                              GRID-ELEMENT-HEIGHT))))
               (IL:MOVETO BOX-LEFT-EDGE-X BOX-LEFT-EDGE-Y WINDOW)
               (IL:RELDRAWTO GRID-ELEMENT-WIDTH 0 3 'IL:PAINT WINDOW)
               (IL:RELDRAWTO 0 GRID-ELEMENT-HEIGHT 3 'IL:PAINT WINDOW)
               (IL:RELDRAWTO (- GRID-ELEMENT-WIDTH)
                      0 3 'IL:PAINT WINDOW)
               (IL:RELDRAWTO 0 (- GRID-ELEMENT-HEIGHT)
                      3
                      'IL:PAINT WINDOW))))
