;;; -*- Package: Ra-1-User-Interface; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

;;; File converted on  3-Nov-87 16:29:51 from source BOX-FUNCTIONS
;;; Original source {LISPDEV:LAIR:OHIO-STATE}<TOOLSET>RA-1>BOX-FUNCTIONS.;1 created  3-Nov-87 16:50:02



(DEFUN CONSIDERING-BOX (Y X TRACE-WINDOW) "Inverts a box"
   (PCL::WITH-SLOTS* (GRID-LEFT-EDGE GRID-BOTTOM-EDGE GRID-ELEMENT-WIDTH
				     GRID-ELEMENT-HEIGHT GRID-HEIGHT)
		     TRACE-WINDOW
          (LET ((BOX-LEFT-EDGE-X (IL:LEFTOFGRIDCOORD X
                                        (LIST GRID-LEFT-EDGE 
                                              GRID-BOTTOM-EDGE 
                                              GRID-ELEMENT-WIDTH 
                                              GRID-ELEMENT-HEIGHT)))
                (BOX-LEFT-EDGE-Y (IL:BOTTOMOFGRIDCOORD (- GRID-HEIGHT Y 
                                                          1)
                                        (LIST GRID-LEFT-EDGE 
                                              GRID-BOTTOM-EDGE 
                                              GRID-ELEMENT-WIDTH 
                                              GRID-ELEMENT-HEIGHT))))
               (IL:DSPFILL (LIST BOX-LEFT-EDGE-X BOX-LEFT-EDGE-Y 
                                 GRID-ELEMENT-WIDTH GRID-ELEMENT-HEIGHT
                                 )
                      IL:BLACKSHADE
                      'IL:INVERT WINDOW))))


(DEFUN DECONSIDERING-BOX (Y X TRACE-WINDOW) "Inverts a box"
   (PCL::WITH-SLOTS* (GRID-LEFT-EDGE GRID-BOTTOM-EDGE GRID-ELEMENT-WIDTH
				     GRID-ELEMENT-HEIGHT GRID-HEIGHT)
		     TRACE-WINDOW
          (LET ((BOX-LEFT-EDGE-X (IL:LEFTOFGRIDCOORD X
                                        (LIST GRID-LEFT-EDGE 
                                              GRID-BOTTOM-EDGE 
                                              GRID-ELEMENT-WIDTH 
                                              GRID-ELEMENT-HEIGHT)))
                (BOX-LEFT-EDGE-Y (IL:BOTTOMOFGRIDCOORD (- GRID-HEIGHT Y 
                                                          1)
                                        (LIST GRID-LEFT-EDGE 
                                              GRID-BOTTOM-EDGE 
                                              GRID-ELEMENT-WIDTH 
                                              GRID-ELEMENT-HEIGHT))))
               (IL:DSPFILL (LIST BOX-LEFT-EDGE-X BOX-LEFT-EDGE-Y 
                                 GRID-ELEMENT-WIDTH GRID-ELEMENT-HEIGHT
                                 )
                      IL:BLACKSHADE
                      'IL:INVERT WINDOW))))


(DEFUN YES-BOX (Y X TRACE-WINDOW) "Boxes a box"
   (PCL::WITH-SLOTS* (GRID-LEFT-EDGE GRID-BOTTOM-EDGE GRID-ELEMENT-WIDTH
				     GRID-ELEMENT-HEIGHT GRID-HEIGHT)
		     TRACE-WINDOW
          (LET ((BOX-LEFT-EDGE-X (IL:LEFTOFGRIDCOORD X
                                        (LIST GRID-LEFT-EDGE 
                                              GRID-BOTTOM-EDGE 
                                              GRID-ELEMENT-WIDTH 
                                              GRID-ELEMENT-HEIGHT)))
                (BOX-LEFT-EDGE-Y (IL:BOTTOMOFGRIDCOORD (- GRID-HEIGHT Y 
                                                          1)
                                        (LIST GRID-LEFT-EDGE 
                                              GRID-BOTTOM-EDGE 
                                              GRID-ELEMENT-WIDTH 
                                              GRID-ELEMENT-HEIGHT))))
               (IL:MOVETO BOX-LEFT-EDGE-X BOX-LEFT-EDGE-Y WINDOW)
               (IL:RELDRAWTO GRID-ELEMENT-WIDTH 0 3 'IL:PAINT WINDOW)
               (IL:RELDRAWTO 0 GRID-ELEMENT-HEIGHT 3 'IL:PAINT WINDOW)
               (IL:RELDRAWTO (- GRID-ELEMENT-WIDTH)
                      0 3 'IL:PAINT WINDOW)
               (IL:RELDRAWTO 0 (- GRID-ELEMENT-HEIGHT)
                      3
                      'IL:PAINT WINDOW))))


(DEFUN NO-BOX (Y X TRACE-WINDOW) 
                          "Displays a box with the element crossed out"
   (PCL::WITH-SLOTS* (GRID-LEFT-EDGE GRID-BOTTOM-EDGE GRID-ELEMENT-WIDTH
				     GRID-ELEMENT-HEIGHT GRID-HEIGHT)
		     TRACE-WINDOW
          (LET ((BOX-LEFT-EDGE-X (IL:LEFTOFGRIDCOORD X
                                        (LIST GRID-LEFT-EDGE 
                                              GRID-BOTTOM-EDGE 
                                              GRID-ELEMENT-WIDTH 
                                              GRID-ELEMENT-HEIGHT)))
                (BOX-LEFT-EDGE-Y (IL:BOTTOMOFGRIDCOORD (- GRID-HEIGHT Y 
                                                          1)
                                        (LIST GRID-LEFT-EDGE 
                                              GRID-BOTTOM-EDGE 
                                              GRID-ELEMENT-WIDTH 
                                              GRID-ELEMENT-HEIGHT))))
               (IL:DRAWLINE BOX-LEFT-EDGE-X BOX-LEFT-EDGE-Y
                      (+ BOX-LEFT-EDGE-X GRID-ELEMENT-WIDTH)
                      (+ BOX-LEFT-EDGE-Y GRID-ELEMENT-HEIGHT)
                      1
                      'IL:PAINT WINDOW))))



