;;; -*- Package: Toolset-user-interface; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset-user-interface)

;;;
;;;
;;; Raw CL functions for display
;;;

;; Box functions


(defun considering-table-cell (x y &optional (trace-window *trace-output*))
  "Tells which cell we're working on"

  (format trace-window "Currently working on cell located at (~A,~A)"
		 x y))

(defun deconsidering-table-cell (x y &optional (trace-window *trace-output*))
  "Sez we're done with cell"

  (format trace-window "Done working on cell located at (~A,~A)"
		 x y))

(defun yes-table-cell (x y &optional (trace-window *trace-output*))
  "Confirms a cell"

  (if (eq x 0) (terpri trace-window))
  (format trace-window "~V,2T T" x))

(defun no-table-cell (x y &optional (trace-window *trace-output*))
  "De-confirms a cell"

  (format trace-window "~V,2T F~%" x))


;; Consequent functions (not used)

(defun considering-consequent (i &optional (trace-window *trace-output*))
  "Considering a consequent"

  (format trace-window "Currently working on consequent ~A"
		 i))

(defun deconsidering-consequent (i &optional (trace-window *trace-output*))
  "Sez we're done with a cell"

  (format trace-window "Done working on consequent ~A"
		 i))

(defun stuff-consequent (result &optional (trace-window *trace-output*))
  "Confirms a consequnet, prints it value"

  (format trace-window "Value of the consequent was ~A"
		 result))

(defun stuff-no-match (result &optional (trace-window *trace-output*))
  "sez we worked on a no-match"

  (format trace-window "Value of the no-match was ~A"
	    	result))