;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

;;; Create the dragon toolbed::*puff*, set up its first engrams and
;;; action record, and set toolbed::*current-dragon* to point to it.
;;;  toolbed::*puff* is actually imported into Toolset, but use fully
;;;  qualified names just to make sure...

(defun hatch-puff nil
  (declare (special toolbed::*puff* toolbed::*current-dragon*))

  (if (and (boundp 'toolbed::*puff*)
	   (typep toolbed::*puff* 'dragon))
      (toolbed::destroy toolbed::*puff*))

  (defparameter toolbed::*puff* (pcl::*make-instance 'dragon))

  (setf (slot-value *puff* 'display-name) "puff"
	(slot-value *puff* 'unique-name) 'toolbed::*puff*
	(slot-value *puff* 'memory-retention-limit) 10000
	(slot-value *puff* 'memory-retention-warning-limit) 9000)
  (setf (slot-value *puff* 'current-engram)
	(pcl::*make-instance 'toolbed::engram))
  (setf (slot-value (slot-value *puff* 'current-engram) 'whose-memory?) 
	*puff*)
  (setf (slot-value (slot-value *puff* 'current-engram)
		    'toolbed::first-action-record)
	(pcl::*make-instance 'toolbed::action-record))
  (setf toolbed::*current-dragon* toolbed::*puff*)
  (return-from hatch-puff *puff*))

(defmacro start-solving (case classifier verb &rest args)
  (declare (special *puff* *current-dragon* *current-case*
		    *idb-flushed-list* *trace-output*))
  `(let ((engram (pcl::*make-instance 'toolbed::engram))
	 (a-record (pcl::*make-instance 'toolbed::action-record))
	 result
	 (dragon (if (and (typep ,classifier 'classifier)
			  (member ',verb '(establish establish-refine refine)))
		     (eval 
		      (get-top-node
		       (slot-value ,classifier 'hierarchy)))
		     ,classifier)))

     (setf *current-dragon* *puff*)
     (if (not (equal *current-case* ',case))
	 (setf *current-case* ',case
	       *idb-flushed-list* nil))
     (setf (slot-value *current-dragon* 'current-engram) engram)
     (setf (slot-value engram 'whose-memory?) *puff*
	   (slot-value engram 'case) ',case
	   (slot-value engram 'first-action-record) a-record)

     (setf result (invoke dragon ',verb ,@(quote-list args)))
     (format *trace-output*
	     "~%~%~%~%~% The final return value from ~A was ~A.~%~%"
	     (slot-value  dragon 'display-name) result)
     (push (slot-value *current-dragon* 'current-engram)
	   (slot-value *current-dragon* 'memory))
     result))


