;;; -*- Package: Toolbed; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolbed)

(DEFMETHOD DESTROY ((ENGRAM ENGRAM))
   (LET ((CURRENT-RECORD NIL)
         (TEMP-ENGRAM NIL)
         (TEMP-MEMORY NIL)
         (DRAGON (SLOT-VALUE ENGRAM 'WHOSE-MEMORY?))
         (TEMP-RECORD NIL))
        (IF (EQUAL (SLOT-VALUE DRAGON 'CURRENT-ENGRAM)
                   ENGRAM)
            (PROGN (SETF (SLOT-VALUE DRAGON 'CURRENT-ENGRAM)
                         NIL)
                   (PROGN (DOLIST (TEMP-ENGRAM (SLOT-VALUE DRAGON
                                                      'MEMORY))
                                 (IF (NOT (EQUAL TEMP-ENGRAM ENGRAM))
                                     (PUSH TEMP-ENGRAM TEMP-MEMORY)))
                          (SETF (SLOT-VALUE DRAGON 'MEMORY)
                                (REVERSE TEMP-MEMORY))
                          (SETF TEMP-ENGRAM NIL)
                          (SETF TEMP-MEMORY NIL)))
            (PROGN (DOLIST (TEMP-ENGRAM (SLOT-VALUE DRAGON 'MEMORY))
                          (IF (NOT (EQUAL TEMP-ENGRAM ENGRAM))
                              (PUSH TEMP-ENGRAM TEMP-MEMORY)))
                   (SETF (SLOT-VALUE DRAGON 'MEMORY)
                         TEMP-MEMORY)
                   (SETF TEMP-ENGRAM NIL)
                   (SETF TEMP-MEMORY NIL)))
        (SETF (SLOT-VALUE ENGRAM 'WHOSE-MEMORY?)
              NIL)
        (DO ((CURRENT-RECORD (SLOT-VALUE ENGRAM 'FIRST-ACTION-RECORD)))
            ((NULL CURRENT-RECORD)
             NIL)
            (SETF (SLOT-VALUE CURRENT-RECORD 'INCLUDING-ENGRAM)
                  NIL)
            (SETF (SLOT-VALUE CURRENT-RECORD 'PREVIOUS-RECORD)
                  NIL)
            (SETF (SLOT-VALUE CURRENT-RECORD 'BODY)
                  NIL)
            (IF (TYPEP CURRENT-RECORD 'TRANSACTION-RECORD)
                (PROGN (SETF (SLOT-VALUE CURRENT-RECORD `CONTACTEE)
                             NIL)
                       (IF (NOT (toolset::slot-empty-p current-record
					      'contactee-engram-pointer))
                           (SETF (SLOT-VALUE (SLOT-VALUE CURRENT-RECORD
                                                    '
                                               CONTACTEE-ENGRAM-POINTER
                                                    )
                                        'INVOKERS-TRANSACTION-RECORD)
                                 NIL))
                       (SETF (SLOT-VALUE CURRENT-RECORD '
                                    CONTACTEE-ENGRAM-POINTER)
                             NIL)
                       (SETF (SLOT-VALUE CURRENT-RECORD '
                                    FINAL-JUDGEMENT)
                             NIL)
                       (IF (TYPEP CURRENT-RECORD 'CONSULTATION-RECORD)
                           (PROGN (SETF (SLOT-VALUE CURRENT-RECORD
                                               'DRAGON-RECOMMENDATION)
                                        NIL)
                                  (SETF (SLOT-VALUE CURRENT-RECORD
                                               'USER-COMMENT)
                                        NIL)))))
            (SETF TEMP-RECORD (SLOT-VALUE CURRENT-RECORD 'NEXT-RECORD))
            (SETF (SLOT-VALUE CURRENT-RECORD 'NEXT-RECORD)
                  NIL)
            (SETF CURRENT-RECORD TEMP-RECORD))
        (SETF CURRENT-RECORD NIL)
        (SETF TEMP-RECORD NIL)
        (SETF (SLOT-VALUE ENGRAM 'FIRST-ACTION-RECORD)
              NIL)
        (SETF (SLOT-VALUE ENGRAM 'LAST-ACTION-RECORD)
              NIL)
        (IF (NOT (toolset::slot-empty-p engram 'invokers-transaction-record))
            (PROGN (SETF (SLOT-VALUE (SLOT-VALUE ENGRAM '
                                            INVOKERS-TRANSACTION-RECORD
                                            )
                                'CONTACTEE-ENGRAM-POINTER)
                         'toolset::DESTROYED)
                   (SETF (SLOT-VALUE ENGRAM '
                                INVOKERS-TRANSACTION-RECORD)
                         NIL)))
        (SETF (SLOT-VALUE ENGRAM 'BODY)
              NIL)
        (SETF ENGRAM NIL)))


(DEFMETHOD DESTROY ((DRAGON DRAGON))
   (LET ((ENGRAM NIL)
         (TEMP-DRAGON-NAME NIL))
        (SETF (SLOT-VALUE DRAGON 'CURRENT-ENGRAM)
              NIL)
        (IF (NOT (toolset::slot-empty-p dragon 'memory))
            (DOLIST (ENGRAM (SLOT-VALUE DRAGON 'MEMORY))
                   (SETF (SLOT-VALUE ENGRAM 'WHOSE-MEMORY?)
                         'toolset::DESTROYED)
                   (IF (AND (NOT (toolset::slot-empty-p
				  engram 'invokers-transaction-record))
                            (NOT (EQUAL (SLOT-VALUE ENGRAM '
                                            INVOKERS-TRANSACTION-RECORD
                                               )
                                        'toolset::DESTROYED)))
                       (SETF (SLOT-VALUE (SLOT-VALUE ENGRAM
                                                '
                                            INVOKERS-TRANSACTION-RECORD
                                                )
                                    'CONTACTEE)
                             'toolset::DESTROYED))))
        (SETF TEMP-DRAGON-NAME (SLOT-VALUE DRAGON 'UNIQUE-NAME))
        (SETF (SLOT-VALUE DRAGON 'UNIQUE-NAME)
              'toolset::DESTROYED)
        (SET TEMP-DRAGON-NAME NIL)
        (SETF DRAGON NIL)
        (SETF ENGRAM NIL)))


(DEFUN FLUSH-CASE (CASE)
   (DECLARE (SPECIAL *INVOCATION-TRACE-FLAG* *TRACE-OUTPUT* *PUFF*))
   (LET (ENGRAM TEMPMEMORY)
        (IF *INVOCATION-TRACE-FLAG* (FORMAT *TRACE-OUTPUT* 
                                     "~% Flushing case ~A from memory." 
                                           CASE))
        (DOLIST (ENGRAM (SLOT-VALUE *PUFF* 'MEMORY))
               (IF (EQUAL (SLOT-VALUE ENGRAM 'CASE)
                          CASE)
                   (MEMORY-VIRUS ENGRAM)
                   (PUSH ENGRAM TEMPMEMORY)))
        (SETF (SLOT-VALUE *PUFF* 'MEMORY)
              (REVERSE TEMPMEMORY))
        (SETF ENGRAM NIL)
        (SETF TEMPMEMORY NIL)
        (IF *INVOCATION-TRACE-FLAG* (FORMAT *TRACE-OUTPUT* 
                        "~% All engrams of case ~A have been destroyed" 
                                           CASE))))


(DEFUN FLUSH-MEMORY
   NIL (DECLARE (SPECIAL *PUFF* *INVOCATION-TRACE-FLAG* *TRACE-OUTPUT*)
              )
       (LET (ENGRAM (DRAGON *PUFF*))
       
       ;; This function will destroy the substructure started
       
       ;; at DRAGON.  To flush a case, type (Flush-memory
       
       ;; name) where name is the first invoked dragon of the
       
       ;; case.

            (SETF DRAGON *PUFF*)
            (IF *INVOCATION-TRACE-FLAG* (FORMAT *TRACE-OUTPUT* 
                                               "~% Flushing ~A"
                                               (SLOT-VALUE DRAGON
                                                      'DISPLAY-NAME)))
	    (IF (NOT (toolset::slot-empty-p dragon 'memory))
		(DOLIST (ENGRAM (SLOT-VALUE DRAGON 'MEMORY))
			(FORMAT *TRACE-OUTPUT* 
				"~% destroying another engram of puff")
			(IF (NOT (OR (NULL ENGRAM)
				     (EQUAL ENGRAM 'DESTROYED)))
			    (MEMORY-VIRUS ENGRAM))))
            (SETF ENGRAM NIL)
            (SETF (SLOT-VALUE DRAGON 'CURRENT-ENGRAM)
                  NIL)
            (SETF (SLOT-VALUE DRAGON 'MEMORY)
                  NIL)
            (SETF DRAGON NIL)))


(DEFUN MEMORY-VIRUS (ENGRAM)
   (LET (CURRENT-RECORD TEMP-RECORD TEMP-MEMORY TEMP-ENGRAM)
       
       ;; this function eliminates the pointers pointing to
       
       ;; ENGRAM and recursively calls MEMORY-VIRUS on all
       
       ;; engrams which ENGRAM points to.

        (IF *INVOCATION-TRACE-FLAG* (FORMAT *TRACE-OUTPUT* 
                                        "~%  Attacking an engram of ~A"
                                           (SLOT-VALUE
                                            (SLOT-VALUE ENGRAM
                                                   'WHOSE-MEMORY?)
                                            'DISPLAY-NAME)))
       
       ;; wipe out all action/trans/consultation-records of
       
       ;; ENGRAM

        (DO ((CURRENT-RECORD (SLOT-VALUE ENGRAM 'FIRST-ACTION-RECORD)))
            ((NULL CURRENT-RECORD)
             NIL)
            (SETF (SLOT-VALUE CURRENT-RECORD 'INCLUDING-ENGRAM)
                  NIL)
            (SETF (SLOT-VALUE CURRENT-RECORD 'PREVIOUS-RECORD)
                  NIL)
            (SETF (SLOT-VALUE CURRENT-RECORD 'BODY)
                  NIL)
       
       ;; If the record is a TRANSACTION-RECORD then take care
       
       ;; of contactee pointer and contactee-engram-pointer

            (IF (TYPEP CURRENT-RECORD 'TRANSACTION-RECORD)
                (PROGN (IF (SLOT-VALUE CURRENT-RECORD 'CONTACTEE)
                           (SETF (SLOT-VALUE CURRENT-RECORD
                                        'CONTACTEE)
                                 NIL))
                       (SETF (SLOT-VALUE CURRENT-RECORD '
                                    FINAL-JUDGEMENT)
                             NIL)
                       (IF (SLOT-VALUE CURRENT-RECORD '
                                  CONTACTEE-ENGRAM-POINTER)
                           (PROGN (MEMORY-VIRUS (SLOT-VALUE
                                                 CURRENT-RECORD
                                                 '
                                               CONTACTEE-ENGRAM-POINTER
                                                 ))
                                  (SETF (SLOT-VALUE CURRENT-RECORD
                                               '
                                               CONTACTEE-ENGRAM-POINTER
                                               )
                                        NIL)))))
            (SETF TEMP-RECORD (SLOT-VALUE CURRENT-RECORD 'NEXT-RECORD))
            (SETF (SLOT-VALUE CURRENT-RECORD 'NEXT-RECORD)
                  NIL)
            (SETF CURRENT-RECORD TEMP-RECORD))
       
       ;; eliminate engram from memory list and current-engram
       
       ;; slot of dragon if it is the current-engram of the
       
       ;; dragon

        (IF (EQUAL (SLOT-VALUE (SLOT-VALUE ENGRAM 'WHOSE-MEMORY?)
                          'CURRENT-ENGRAM)
                   ENGRAM)
            (SETF (SLOT-VALUE (SLOT-VALUE ENGRAM 'WHOSE-MEMORY?)
                         'CURRENT-ENGRAM)
                  NIL))
        (SETF TEMP-MEMORY NIL)
        (DOLIST (TEMP-ENGRAM (SLOT-VALUE (SLOT-VALUE ENGRAM
                                                'WHOSE-MEMORY?)
                                    'MEMORY))
               (IF (NOT (EQUAL TEMP-ENGRAM ENGRAM))
                   (PUSH TEMP-ENGRAM TEMP-MEMORY)))
       
       ;; wipe out the rest of the pointers

        (SETF (SLOT-VALUE (SLOT-VALUE ENGRAM 'WHOSE-MEMORY?)
                     'MEMORY)
              (REVERSE TEMP-MEMORY))
        (SETF TEMP-MEMORY NIL)
        (SETF CURRENT-RECORD NIL)
        (SETF TEMP-RECORD NIL)
        (SETF (SLOT-VALUE ENGRAM 'BODY)
              NIL)
        (SETF (SLOT-VALUE ENGRAM 'FIRST-ACTION-RECORD)
              NIL)
        (SETF (SLOT-VALUE ENGRAM 'LAST-ACTION-RECORD)
              NIL)
        (SETF (SLOT-VALUE ENGRAM 'WHOSE-MEMORY?)
              NIL)
        (SETF (SLOT-VALUE ENGRAM 'INVOKERS-TRANSACTION-RECORD)
              NIL)
        (SETF ENGRAM NIL)))
