;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(defmethod cast-spell ((drag recognition-agent)
                       args report-to) 

;;; Default spell-casting method for all recognition-agents. Spells
;;; are cast on all appropriate features. Arguments are assumed to be
;;; of the form (verb args). Cast-spell returns the handle which has
;;; been created or found.
 (get-monitor-handle
  drag report-to 
       
       ;; construct eval-form: (invoke <drag> 'judge 'arg 'arg)

  (cons 'invoke (cons (slot-value drag 'unique-name)
                      (mapcar #'(lambda (arg)
                                       (list 'quote arg)) args)))
       
       ;; construct list of clos objects this RA is dependent on

  (let ((dependents nil)
        feature)
       (do ((index 0 (+ index 1)))
           ((>= index (slot-value drag 'number-of-features))
            dependents)
           (setf feature (aref (slot-value drag 'display-features)
                               index))
           (cond
              ((and (listp feature)
                    (equal (first feature)
                           'judge))
       
       ;; display-feature has the form (judge <dragon>
       ;; <args>...). From this build a cons: (child .
       ;; spell-arguments-for-child) and add it to the
       ;; dependents list.

               (setf dependents (cons (cons (eval (second feature))
                                            (cons (first feature)
                                                  (cddr feature)))
                                      dependents))))))))
