;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFUN ADD-DRAGON-TO-CONCEPTS (NAME CONCEPTS)
   (DECLARE (SPECIAL *ASSOCIATED-CONCEPTS-LIST*))
   (DOLIST (CONCEPT CONCEPTS)
          (LET ((CONC-LIST (ASSOC CONCEPT *ASSOCIATED-CONCEPTS-LIST*)))
               (IF CONC-LIST (IF (NULL (MEMBER NAME (CDR CONC-LIST)))
                                 (SETF (CDR CONC-LIST)
                                       (CONS NAME (CDR CONC-LIST))))
                   (SETF *ASSOCIATED-CONCEPTS-LIST*
                         (ACONS CONCEPT (CONS NAME NIL)
                                *ASSOCIATED-CONCEPTS-LIST*))))))


(DEFUN RETURN-ASSOCIATED-CONCEPTS (DRAGON)
   (DECLARE (SPECIAL *ASSOCIATED-CONCEPTS-LIST*))
   (LET ((CONC-LIST NIL))
        (DOLIST (CONCEPT *ASSOCIATED-CONCEPTS-LIST*)
               (IF (MEMBER DRAGON (CDR CONCEPT))
                   (SETF CONC-LIST (CONS (CAR CONCEPT)
                                         CONC-LIST))))
        (RETURN-FROM RETURN-ASSOCIATED-CONCEPTS CONC-LIST)))


(DEFUN RETURN-ASSOCIATED-DRAGONS (CONCEPT) (DECLARE (SPECIAL 
                                             *ASSOCIATED-CONCEPTS-LIST*
                                                           ))
                                           (RETURN-FROM
                                            RETURN-ASSOCIATED-DRAGONS
                                            (CDR (ASSOC CONCEPT 
                                             *ASSOCIATED-CONCEPTS-LIST*
                                                        ))))

