;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFUN PARSE-CONTROLLER-SLOT (RA-INSTANCE RA-TYPE) "Function to turn CONTROL-ADDITIONS= and TRACING-CONTROLLER-ADDITIONS= specifications into parsed-controller and parsed-tracing-controller slots."
   (DECLARE (SPECIAL *VERB-LIST*))
   (IF
    (NOT (slot-empty-p ra-instance 'control-additions))
    (WITH-SLOTS
     (UNIQUE-NAME CONTROL-ADDITIONS TRACING-CONTROL-ADDITIONS 
			PARSED-CONTROLLER PARSED-TRACING-CONTROLLER)
     RA-INSTANCE
     (LET
      ((RESULT-LIST NIL)
       (TRACING-RESULT-LIST NIL)
       (RESULT NIL)
       (SLOT-LIST (APPEND '(UNIQUE-NAME DISPLAY-NAME TOOL-USER-SLOTS 
				ASSOCIATED-CONCEPTS COMPONENTS
				COMPONENT-OF MEMORY MEMORY-CURRENT-SIZE
				MEMORY-RETENTION-LIMIT 
				MEMORY-RETENTION-WARNING-LIMIT
				CURRENT-ENGRAM SPECIFIC-FUNCTION
				RATIONALE DISCLAIMER EXPERT AUTHOR
				CITATIONS OTHER-KNOWLEDGE-SOURCES
				CREATION-DATE LAST-MODIFICATION-DATE
				TRACE-FLAG TRACE-WINDOW)
			  (CASE RA-TYPE
				(FREE-FORM-RECOGNITION-AGENT 
				  '(CONFIDENCE-VALUE FEATURE-CACHE
				     NUMBER-OF-FEATURES FEATURES
				     OUTPUT-DESTINATION TRANSFORMS
				     PATTERNS NUMBER-OF-PATTERNS
				     TESTS TOP-NODE HIERARCHY
				     MATCH-CONFIDENCE NO-MATCH-CONFIDENCE
				     ASSOCIATED-CONFIDENCES MATCH-ACTION
				     MATCH-ACTIONS NO-MATCH-ACTION 
				     SUCCESS-THRESHOLD SUCCESS-THRESHOLDS))
				(DISCRETE-PATTERN-RECOGNITION-AGENT
				  '(TESTS SUCCESS-THRESHOLD MATCH-CONFIDENCE
					  NO-MATCH-CONFIDENCE MATCH-ACTION
					  NO-MATCH-ACTION))
				(MATCH-1-RECOGNITION-AGENT
				  '(PATTERNS NUMBER-OF-PATTERNS
					     SUCCESS-THRESHOLDS MATCH-ACTIONS
					     NO-MATCH-ACTION
					     ASSOCIATED-CONFIDENCES
					     NO-MATCH-CONFIDENCE))
				(STUB-IDB '(ANSWER-CACHE saved-case-cache))
				(classifier '(hierarchy))
				(classification-specialist
				 '(establish-reject refine-form
						    translator
					    establish-confidence-vocabulary
						    subspecialists
						    superspecialists
						    classifier
						    suspend-threshold
						    establish-threshold
						    status
						    refine-result
						    parent-join
						    established-action
						    not-established-action
						    case
						    use-cache))
				(OTHERWISE '())))))

      (IF (slot-empty-p RA-INSTANCE 'PARSED-TRACING-CONTROLLER)
	  (SETF PARSED-TRACING-CONTROLLER NIL))
      (IF (slot-empty-p RA-INSTANCE 'TRACING-CONTROL-ADDITIONS)
	  (SETF TRACING-CONTROL-ADDITIONS NIL))
      (DOLIST
       (SPECIFIER CONTROL-ADDITIONS)
       (IF (NOT (SYMBOLP (CAR SPECIFIER)))
           (ERROR "ERROR: In ~S in ~S, the syntax of controllers requires that the specification of a behavior start with a verb." 
                  SPECIFIER UNIQUE-NAME))
       (SETF
        RESULT
        (CONS
         (CAR SPECIFIER)
         (LIST
          'LAMBDA
          `,(if (not (or (member '&optional (second specifier))
			 (member '&rest (second specifier))))
		(append (SECOND SPECIFIER) '(&optional answer-type))
	        (second specifier))
          `(WITH-SLOTS ,SLOT-LIST
	       ,(SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME)
                  ,(CONS 'PROGN 
			 (MAPCAR #'TRANSFORM-PATTERN-REFERENCES
				 (MAPCAR #'
				  TRANSFORM-CONFIDENCE-REFERENCES
				  (MAPCAR #'
				   TRANSFORM-INVOKE-FORMS
				   (CDDR SPECIFIER)))))))))
       (SETF RESULT-LIST (CONS RESULT RESULT-LIST))
       (IF
        (MEMBER (CAR SPECIFIER)
               (MAPCAR #'CAR TRACING-CONTROL-ADDITIONS))
        (SETF
         TRACING-RESULT-LIST
         (CONS
          (CONS
           (CAR SPECIFIER)
           (LIST
            'LAMBDA
            `,(if (not (member '&optional (second specifier)))
		  (append (SECOND SPECIFIER) '(&optional answer-type))
		  (second specifier))
            `(WITH-SLOTS ,SLOT-LIST
	       ,(SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME)
              ,(CONS
                'PROGN
                (MAPCAR
                 #'TRANSFORM-PATTERN-REFERENCES
                 (MAPCAR
                  #'TRANSFORM-CONFIDENCE-REFERENCES
                  (MAPCAR #'TRANSFORM-INVOKE-FORMS
                         (CDDR 
			  (NTH 
			   (POSITION 
			    (CAR SPECIFIER)
			    (MAPCAR #'CAR 
				    TRACING-CONTROL-ADDITIONS))
			   TRACING-CONTROL-ADDITIONS)))))))))
          TRACING-RESULT-LIST))
          (SETF TRACING-RESULT-LIST (CONS RESULT TRACING-RESULT-LIST)))

       (IF (NOT (MEMBER (CAR SPECIFIER)
                       *VERB-LIST*))
           (SETF *VERB-LIST* (CONS (CAR SPECIFIER)
                                   *VERB-LIST*))))
      (SETF PARSED-CONTROLLER RESULT-LIST)
      (SETF PARSED-TRACING-CONTROLLER TRACING-RESULT-LIST)
      (FORMAT *TRACE-OUTPUT* "User-specified control-additions and tracing-control-additions installed in ~S. ~%" 
             UNIQUE-NAME)))))




(DEFUN COMPILE-CONTROLLER (CONTROLLER-LIST) "Takes an assoc list of VERB LAMBDA pairs, and compiles the lambdas, returning another assoc list."
   (LET ((COMPILED-LIST NIL))
        (DOLIST (VERB-LAMBDA CONTROLLER-LIST)
               (SETF COMPILED-LIST (ACONS (CAR VERB-LAMBDA)
                                          (COMPILE NIL (CDR VERB-LAMBDA
                                                            ))
                                          COMPILED-LIST)))
        (RETURN-FROM COMPILE-CONTROLLER (reverse COMPILED-LIST))))



