;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFMETHOD tracing-controllers ((RA MATCH-1-RECOGNITION-AGENT)) 
  "Build tracing judge for match-1."
  (LET
   ((ARGS (CADR (ASSOC 'JUDGE (SLOT-VALUE RA 'ARGUMENTS)))))
   (RETURN-FROM
    tracing-controllers
    (acons
     'judge
      `(LAMBDA
	,(append args '(&optional result-type))
	(DECLARE (SPECIAL *CURRENT-DRAGON*))
	(BLOCK
         JUDGE-BLOCK
         (FLUSH-FEATURE-CACHE)
         (LET
          ((K 0)
           RESULT)
          (DOTIMES
           (I ,(SLOT-VALUE RA 'NUMBER-OF-PATTERNS))
           (DOTIMES (J ,(SLOT-VALUE RA 'NUMBER-OF-FEATURES))
		    (IF (TRACED-TEST I J)
			(SETF K (1+ K)))
		    (IF (>= K (AREF (SLOT-VALUE *CURRENT-DRAGON*
						'SUCCESS-THRESHOLDS)
				    I))
			(PROGN (SETF RESULT (TRACED-CONSEQUENT I))
			       (SETF (SLOT-VALUE *CURRENT-DRAGON*
						 'CONFIDENCE-VALUE)
				     RESULT)
			       (REMEMBER 'PATTERN I RESULT)
			       (EVAL (AREF (SLOT-VALUE *CURRENT-DRAGON*
						       'MATCH-ACTIONS)
					   I))
			       (RETURN-FROM JUDGE-BLOCK RESULT)))))
          (SETF RESULT (TRACED-NO-MATCH))
          (SETF (SLOT-VALUE *CURRENT-DRAGON* 'CONFIDENCE-VALUE)
                RESULT)
          (EVAL (SLOT-VALUE *CURRENT-DRAGON* 'NO-MATCH-ACTION))
          (RETURN-FROM JUDGE-BLOCK RESULT)))) nil))))




(DEFMETHOD controllers ((RA MATCH-1-RECOGNITION-AGENT)) 
  "Build judge lambda for match-1."
  (LET
   ((COND-BODY NIL)
    (COND-CLAUSE-BUILDER NIL)
    THRESHOLD NUMBER-OF-TS (ARGS (CADR (ASSOC 'JUDGE
					      (SLOT-VALUE
					       RA
					       'ARGUMENTS)))))
       
   ;; transform the test block into a list of COND clauses:

   (DOTIMES
    (P (SLOT-VALUE RA 'NUMBER-OF-PATTERNS))
    
    ;; stuff a row of tests into the clause builder
    
    (DOTIMES (J (SLOT-VALUE RA 'NUMBER-OF-FEATURES))
             (PUSH (AREF (SLOT-VALUE RA 'TEST-BLOCK) P J)
                   COND-CLAUSE-BUILDER))
    (SETF COND-CLAUSE-BUILDER (DELETE 'T COND-CLAUSE-BUILDER))
       
    ;; number of T's removed

    (SETF NUMBER-OF-TS (- (SLOT-VALUE RA 'NUMBER-OF-FEATURES) 
			  (LENGTH 
			   COND-CLAUSE-BUILDER)))
       
    ;;  threshold is lowered by the number of tests which
    ;; automatically succeed

    (SETF THRESHOLD (- (AREF (SLOT-VALUE RA 'SUCCESS-THRESHOLDS) P)
		       NUMBER-OF-TS))
    (COND
       
     ;; if the number of T's is greater than the
     ;; succeess-theshold,
       
     ;; automatically succeed

     ((>= NUMBER-OF-TS (AREF (SLOT-VALUE RA 'SUCCESS-THRESHOLDS) P))
      (SETF COND-CLAUSE-BUILDER
	    `(T (REMEMBER 'PATTERN ,P ,(AREF 
					(SLOT-VALUE RA 
						    'ASSOCIATED-CONFIDENCES) 
					P))
		(EVAL ,(AREF (SLOT-VALUE RA 'MATCH-ACTIONS) P))
		,(AREF (SLOT-VALUE RA 'ASSOCIATED-CONFIDENCES) P))))
       
     ;; if success-threshold is greater than the number of
     ;; tests remaining (need to try all the tests), make AND
     ;; of the tests

     ((>= THRESHOLD (LENGTH COND-CLAUSE-BUILDER))
      (SETF COND-CLAUSE-BUILDER (NREVERSE COND-CLAUSE-BUILDER))
      (SETF COND-CLAUSE-BUILDER (CONS 'AND COND-CLAUSE-BUILDER))
      (SETF COND-CLAUSE-BUILDER
	    (LIST COND-CLAUSE-BUILDER 

		  `(REMEMBER 'PATTERN ,P 
			     ,(AREF 
			       (SLOT-VALUE RA 
					   'ASSOCIATED-CONFIDENCES) 
			       P))
		  `(EVAL ,(AREF (SLOT-VALUE RA 'MATCH-ACTIONS) P))
		  `,(AREF (SLOT-VALUE RA 'ASSOCIATED-CONFIDENCES) P))))
     (T
       
      ;; have to go through it the hard way

      (SETF COND-CLAUSE-BUILDER (NREVERSE COND-CLAUSE-BUILDER))
      (SETF
       COND-CLAUSE-BUILDER
       (LIST
	`(DO* ((I ,THRESHOLD)
	       (K 0 (1+ K))
	       (TEST ',(NTH 0 COND-CLAUSE-BUILDER)
		     (NTH K ',COND-CLAUSE-BUILDER)))
       
	      ;; loop until you run out of tests or you don't have
	      ;; enough tests left to possibly make the threshold

	      ((OR (>= K ,(LENGTH COND-CLAUSE-BUILDER))
		   (< (- ,(LENGTH COND-CLAUSE-BUILDER) K)
		      I)))
	      (IF (EVAL TEST)
		  (SETF I (1- I)))
	      (IF (<= I 0)
		  (RETURN T)))
	`(REMEMBER 'PATTERN ,P ,(AREF (SLOT-VALUE RA 
						  'ASSOCIATED-CONFIDENCES) P))
	`(EVAL ,(AREF (SLOT-VALUE RA 'MATCH-ACTIONS) P))
	`,(AREF (SLOT-VALUE RA 'ASSOCIATED-CONFIDENCES) P)))))
    (PUSH COND-CLAUSE-BUILDER COND-BODY)
    (SETF COND-CLAUSE-BUILDER NIL))
   
   ;; slap on the NO-MATCH confidence as the T-clause

   (PUSH `(T (EVAL ,(SLOT-VALUE RA 'NO-MATCH-ACTION))
	     ,(SLOT-VALUE RA 'NO-MATCH-CONFIDENCE)) COND-BODY)
       
   ;; turn it rightside up 
   
   (SETF COND-BODY (NREVERSE COND-BODY))
       
   ;; cons on the COND

   (SETF COND-BODY (CONS 'COND COND-BODY))
   (RETURN-FROM 
    controllers
    (acons
     'judge
     `(LAMBDA ,(append ARGS '(&optional result-type))
	      (DECLARE (SPECIAL *CURRENT-DRAGON*))
	      (FLUSH-FEATURE-CACHE)
	      (SETF (SLOT-VALUE *CURRENT-DRAGON* 'CONFIDENCE-VALUE)
                         ,COND-BODY)) nil))))


