(DEFINE-FILE-INFO PACKAGE (LET ((*PACKAGE*)) (* ;; 
"Put IN Seven EXtremely Random USEr Interface COmmands ") (CLPROVIDE "WEB-EDITOR") (CLIN-PACKAGE 
"WEB" NICKNAMES (QUOTE ("WEB-EDITOR"))) (* ;; "EXPORT") (CLFLET ((XCL-USEREXPORT-FROM-WEB (&REST 
XCL-USERSYMBOL-NAMES) (LET ((XCL-USERPKG (CLFIND-PACKAGE "WEB"))) (CLDOLIST (XCL-USERNAME 
XCL-USERSYMBOL-NAMES) (EXPORT (CLINTERN XCL-USERNAME XCL-USERPKG) XCL-USERPKG))))) (* ;; 
"Class Definitions and Slot Access") (XCL-USEREXPORT-FROM-WEB "WEB-EDITOR" "WEB-NODE" "NODE-NAME" 
"NODE-LINKS" "NODE-BACK-LINKS" "LOCAL-COMMANDS" "NODE-MOVER-P" "TITLE-ITEMS" "LEFT-BUTTON-ITEMS" 
"MIDDLE-BUTTON-ITEMS" "RIGHT-BUTTON-ITEMS" "BROWSE-FONT") (* ;; "For Subclassing") (XCL-USEREXPORT-FROM-WEB
 "GET-LABEL" "GET-SUBS" "ICON-TITLE" "NODE-MENU-ITEMS" "REORDER-TREE" "MOVE-NODE") (* ;; "Top Level") 
(XCL-USEREXPORT-FROM-WEB "MAKE-WEB-EDITOR" "INITIALIZE-EDITOR" "BROWSE" "DISPLAY-BROWSER" "DESTROY" 
"ADD-NODE" "NOTICE-NODE" "REMOVE-NODE" "RENAME-NODE") (* ;; "Window Operations") (XCL-USEREXPORT-FROM-WEB
 "SHRINK" "MOVE" "CLEAR" "PROMPT-PRINT" "PROMPT-READ" "PROMPT-FOR-LIST" "PROMPT-FOR-STRING" 
"PROMPT-FOR-WORD") (* ;; "Recomputing and Changing parameters") (XCL-USEREXPORT-FROM-WEB "RECOMPUTE"
 "RECOMPUTE-IN-PLACE" "RECOMPUTE-LABELS" "RECOMPUTE-IF-OPEN" "CLEAR-LABEL-CACHE" "CHANGE-FONT-SIZE" 
"CHANGE-FORMAT" "SHAPE-TO-HOLD") (* ;; "For CLOS-BROWSER???") (XCL-USEREXPORT-FROM-WEB "BOXED-NODE" 
"BOX-NODE")) (* ;; "USE") (CLUSE-PACKAGE (QUOTE ("PCL" "LISP" "XCL")) "WEB") (* ;; "IMPORT") (CLFLET
 ((XCL-USERIMPORT-FROM-PACKAGE (XCL-USERNAMES XCL-USERFROM &OPTIONAL XCL-USERSHADOW-P) (LET ((
XCL-USERFROM-PACKAGE (CLFIND-PACKAGE XCL-USERFROM))) (CLFUNCALL (CLIF XCL-USERSHADOW-P (
CLFUNCTION CLSHADOWING-IMPORT) (CLFUNCTION IMPORT)) (CLMAPCAR (CLFUNCTION (CLLAMBDA (XCL-USERNAME
) (CLINTERN XCL-USERNAME XCL-USERFROM-PACKAGE))) XCL-USERNAMES))))) (XCL-USERIMPORT-FROM-PACKAGE
 (QUOTE ("CLASSES" "METHODS")) "PCL") (XCL-USERIMPORT-FROM-PACKAGE (QUOTE ("FUNCTIONS" "FNS" 
"VARIABLES" "VARS" "BITMAPS" "COMS")) "IL")) (CLFIND-PACKAGE "WEB")) READTABLE "XCL" BASE 10)
(il:filecreated "31-Aug-88 10:21:16" il:|{NB:PARC:XEROX}<COMMONLENS>0.6M>WEB-EDITOR.;5| 79093  

      il:|changes| il:|to:|  (classes web-node web-editor) (il:types web-editor)

      il:|previous| il:|date:| " 5-Aug-88 17:07:18" il:|{NB:PARC:XEROX}<COMMONLENS>0.6M>WEB-EDITOR.;4|
)


; Copyright (c) 1987, 1988 by Xerox Corporation.  All rights reserved.

(il:prettycomprint il:web-editorcoms)

(il:rpaqq il:web-editorcoms ((coms il:* file-header-coms) (il:* il:|;;| "") (il:* il:|;;;| "WEB EDITOR ") (il:* il:|;;| "") (il:* il:|;;| "Package Setup") (il:declare\: il:dontcopy (il:props (il:web-editor il:makefile-environment) (il:web-editor il:filetype))) (il:* il:|;;| "Global Variables") (il:* il:|;;| "global for cross-editor boxed node destination (like caret for current tty process copy and move destinations)") (variables destination-browser) (coms (il:* il:\; "Client Interface") (il:* il:|;;| "Web Node Class") (classes web-node) (il:* il:|;;| " Web Editor  Class") (classes web-editor) (il:* il:|;;| "Top Level") (functions make-web-editor) (methods (initialize-editor (web-editor)) (destroy (web-editor)) (browse (web-editor))) (methods (il:* il:|;;| "For Subclassing") (get-label (web-editor web-node)) (get-subs (web-editor web-node)) (icon-title (web-editor)) (il:* il:|;;| "Adding, Removing, Hiding Nodes.") (add-node (web-editor web-node)) (notice-node (web-editor web-node web-node)) (remove-node (web-editor web-node)) (delete-from-browser (web-editor)) (remove-from-bad-list (web-editor)) (il:* il:|;;| "") (rename-node (web-editor web-node))) (il:* il:\; "")) (coms (il:* il:\; "Window System Interface") (methods (create-window (web-editor)) (setup-window (web-editor)) (detach-lisp-window (web-editor)) (shrink (web-editor)) (set-outer-region (web-editor)) (set-region (web-editor)) (update (web-editor)) (move (web-editor)) (move1 (web-editor)) (after-move (web-editor)) (after-reshape (web-editor)) (scroll-window (web-editor)) (clear (web-editor)) (il:* il:|;;| "Prompt Window Interactions ") (get-prompt-window (web-editor)) (remove-prompt-window (web-editor)) (prompt-print (web-editor)) (prompt-read (web-editor)) (prompt-for-list (web-editor)) (prompt-for-string (web-editor)) (prompt-for-word (web-editor))) (functions move-down-p) (fns web-window-after-move-fn web-window-button-event-fn web-window-reshape-fn web-window-close-fn il:|PromptRead|) (fns web-window-expand-fn) (functions web-window-icon-fn) (bitmaps *web-editor-icon-bm* *web-editor-icon-mask*) (variables *web-editor-template*) (vars (il:*d-window-default-stream* il:promptwindow) (web-stream il:promptwindow))) (coms (il:* il:\; "Layout and Display Engine") (vars il:|BrowserMargin| il:|MaxLatticeHeight| il:|MaxLatticeWidth|) (il:specvars il:|MaxLatticeHeight| il:|MaxLatticeWidth|) (vars il:grayshade1 il:grayshade2 il:grayshade3 il:grayshade4) (fns tree-roots child-nodes reachable-nodes!) (methods (display-browser (web-editor)) (browser-objects (web-editor)) (get-node-list (web-editor)) (obj-name-pair (web-editor)) (graph-fits (web-editor)) (node-region (web-editor)) (il:* il:\; "") (recompute (web-editor)) (recompute-in-place (web-editor)) (recompute-labels (web-editor)) (recompute-if-open (web-editor)) (clear-label-cache (web-editor)) (object-from-label (web-editor)) (change-font-size (web-editor)) (change-format (web-editor)) (change-max-label-size (web-editor)) (shape-to-hold (web-editor)) (il:* il:\; "") (il:* il:\; "Node Marking and Selecting") (get-display-label (web-editor)) (box-node (web-editor)) (unmark-nodes (web-editor)) (highlight-node (web-editor)) (shade-node (web-editor)) (display-node-hightlights (web-editor)) (display-node-shading (web-editor)) (remove-highlights (web-editor)) (remove-shading (web-editor)) (flash-node (web-editor)) (flip-node (web-editor)) (position-node (web-editor))) (fns box-print-string break-string-for-boxing box-window-node)) (coms (il:* il:\; "Button Events") (fns find-selected-node) (methods (button-event-fn (web-editor)) (left-selection (web-editor)) (middle-selection (web-editor)) (right-selection (web-editor)) (title-selection (web-editor)) (node-selection (web-editor)) (node-action (web-editor)) (node-menu-items (web-node)) (il:* il:|;;| "") (choice-menu (web-editor)) (do-selected-command (web-editor)) (when-menu-item-held (web-editor)) (item-menu (web-editor)) (get-menu-items (web-editor)) (clear-menu-cache (web-editor))) (fns web-menu-whenselectedfn window-when-held-fn) (fns sub-item-selection dual-sub-items window-when-held-fn do-menu-method dual-menu dual-selection) (il:* il:\; "Node Moving Protocol") (methods (node-move (web-editor)) (node-move-shallow (web-editor)) (scions (web-node)) (make-reg-assoc (web-editor)) (reorder-tree (web-editor)) (move-node (web-node)))) (il:* il:\; "") (il:* il:|;;| "") (il:declare\: il:donteval@load il:doeval@compile il:dontcopy il:compilervars (il:addvars (il:nlama) (il:nlaml) (il:lama window-when-held-fn window-when-held-fn web-window-expand-fn web-window-reshape-fn web-window-button-event-fn web-window-after-move-fn)))))

(il:rpaqq file-header-coms ((il:* il:|;;;| "***************************************") (il:* il:|;;;| " Copyright (c) 1987 by Xerox Corporation.  All rights reserved.") (il:* il:|;;;| "Use and copying of this software and preparation of derivative works based upon this software are permitted.  Any distribution of this software or derivative works must comply with all applicable United States export control laws.") (il:* il:|;;;| "This software is made available AS IS, and Xerox Corporation makes no  warranty about the software, its performance or its conformity to any specification.") (il:* il:|;;;| "Any person obtaining a copy of this software is requested to send their name and post office or electronic mail address to:") (il:* il:|;;;| "   CLOS Coordinator") (il:* il:|;;;| "   Xerox Artifical Intelligence Systems   ") (il:* il:|;;;| "   2550 Hanover St.") (il:* il:|;;;| "   Palo Alto, CA 94303") (il:* il:|;;;| "(or send internet mail to CLOSSupport.pa@Xerox.arpa)") (il:* il:|;;;| " ****************************************") (il:* il:|;;;| "") (il:* il:|;;;| "Print out a copyright notice when loading") (il:* il:|;;;| "") (il:p (format t "~&;WEB-EDITOR Copyright (c) 1987, Xerox Corporation.  All rights reserved.~%") (provide "WEB-EDITOR"))))



(il:* il:|;;;| "***************************************")




(il:* il:|;;;| " Copyright (c) 1987 by Xerox Corporation.  All rights reserved.")




(il:* il:|;;;| 
"Use and copying of this software and preparation of derivative works based upon this software are permitted.  Any distribution of this software or derivative works must comply with all applicable United States export control laws."
)




(il:* il:|;;;| 
"This software is made available AS IS, and Xerox Corporation makes no  warranty about the software, its performance or its conformity to any specification."
)




(il:* il:|;;;| 
"Any person obtaining a copy of this software is requested to send their name and post office or electronic mail address to:"
)




(il:* il:|;;;| "   CLOS Coordinator")




(il:* il:|;;;| "   Xerox Artifical Intelligence Systems   ")




(il:* il:|;;;| "   2550 Hanover St.")




(il:* il:|;;;| "   Palo Alto, CA 94303")




(il:* il:|;;;| "(or send internet mail to CLOSSupport.pa@Xerox.arpa)")




(il:* il:|;;;| " ****************************************")




(il:* il:|;;;| "")




(il:* il:|;;;| "Print out a copyright notice when loading")




(il:* il:|;;;| "")


(format t "~&;WEB-EDITOR Copyright (c) 1987, Xerox Corporation.  All rights reserved.~%")

(provide "WEB-EDITOR")



(il:* il:|;;| "")




(il:* il:|;;;| "WEB EDITOR ")




(il:* il:|;;| "")




(il:* il:|;;| "Package Setup")

(il:declare\: il:dontcopy 

(il:putprops il:web-editor il:makefile-environment (:package (let ((*package*)) (il:* il:|;;| "Put IN Seven EXtremely Random USEr Interface COmmands ") (provide "WEB-EDITOR") (in-package "WEB" :nicknames (quote ("WEB-EDITOR"))) (il:* il:|;;| "EXPORT") (flet ((xcl-user::export-from-web (&rest xcl-user::symbol-names) (let ((xcl-user::pkg (find-package "WEB"))) (dolist (xcl-user::name xcl-user::symbol-names) (export (intern xcl-user::name xcl-user::pkg) xcl-user::pkg))))) (il:* il:|;;| "Class Definitions and Slot Access") (xcl-user::export-from-web "WEB-EDITOR" "WEB-NODE" "NODE-NAME" "NODE-LINKS" "NODE-BACK-LINKS" "LOCAL-COMMANDS" "NODE-MOVER-P" "TITLE-ITEMS" "LEFT-BUTTON-ITEMS" "MIDDLE-BUTTON-ITEMS" "RIGHT-BUTTON-ITEMS" "BROWSE-FONT") (il:* il:|;;| "For Subclassing") (xcl-user::export-from-web "GET-LABEL" "GET-SUBS" "ICON-TITLE" "NODE-MENU-ITEMS" "REORDER-TREE" "MOVE-NODE") (il:* il:|;;| "Top Level") (xcl-user::export-from-web "MAKE-WEB-EDITOR" "INITIALIZE-EDITOR" "BROWSE" "DISPLAY-BROWSER" "DESTROY" "ADD-NODE" "NOTICE-NODE" "REMOVE-NODE" "RENAME-NODE") (il:* il:|;;| "Window Operations") (xcl-user::export-from-web "SHRINK" "MOVE" "CLEAR" "PROMPT-PRINT" "PROMPT-READ" "PROMPT-FOR-LIST" "PROMPT-FOR-STRING" "PROMPT-FOR-WORD") (il:* il:|;;| "Recomputing and Changing parameters") (xcl-user::export-from-web "RECOMPUTE" "RECOMPUTE-IN-PLACE" "RECOMPUTE-LABELS" "RECOMPUTE-IF-OPEN" "CLEAR-LABEL-CACHE" "CHANGE-FONT-SIZE" "CHANGE-FORMAT" "SHAPE-TO-HOLD") (il:* il:|;;| "For CLOS-BROWSER???") (xcl-user::export-from-web "BOXED-NODE" "BOX-NODE")) (il:* il:|;;| "USE") (use-package (quote ("PCL" "LISP" "XCL")) "WEB") (il:* il:|;;| "IMPORT") (flet ((xcl-user::import-from-package (xcl-user::names xcl-user::from &optional xcl-user::shadow-p) (let ((xcl-user::from-package (find-package xcl-user::from))) (funcall (if xcl-user::shadow-p (function shadowing-import) (function import)) (mapcar (function (lambda (xcl-user::name) (intern xcl-user::name xcl-user::from-package))) xcl-user::names))))) (xcl-user::import-from-package (quote ("CLASSES" "METHODS")) "PCL") (xcl-user::import-from-package (quote ("FUNCTIONS" "FNS" "VARIABLES" "VARS" "BITMAPS" "COMS")) "IL")) (find-package "WEB")) :readtable "XCL" :base 10))

(il:putprops il:web-editor il:filetype :compile-file)
)



(il:* il:|;;| "Global Variables")




(il:* il:|;;| 
"global for cross-editor boxed node destination (like caret for current tty process copy and move destinations)"
)


(defglobalparameter destination-browser nil "global for cross-editor boxed node destination (like caret for current tty process copy and move destinations)")



(il:* il:\; "Client Interface")




(il:* il:|;;| "Web Node Class")


(defclass web-node nil ((name :initform nil (il:* il:\; "Name of Node") :accessor node-name) (to-links :initform nil (il:* il:\; "Nodes that this Node has Links TO") :accessor get-to-links :accessor node-links) (parent :initform nil :accessor node-back-links)))



(il:* il:|;;| " Web Editor  Class")


(defclass web-editor nil ((il:* il:|;;| "NODES ") (starting-list :initform nil (il:* il:\; "list of objects used to compute this browser")) (good-list :initform nil (il:* il:\; "limit choices to this set")) (bad-list :initform nil (il:* il:\; "Don't put in any items on this set")) (il:* il:|;;| "GRAPHER FORMAT") (top-align :initform nil) (browse-font :initform (il:fontcreate (quote (il:helvetica 10 il:bold)))) (browse-font-family :initform (quote il:helvetica)) (browse-font-face :initform (quote il:bold)) (graph-format :initform (quote (il:lattice))) (graph-format-choices :allocation :class :initform (quote ((il:horizontal/lattice (quote (il:lattice))) (il:vertical/lattice (quote (il:vertical il:lattice))) (il:horizontal/tree (quote (il:copies/only))) (il:vertical/tree (quote (il:vertical il:copies/only)))))) (il:* il:|;;| "WINDOW Interface") (window :initform nil) (title :initform "Web Editor" (il:* il:\; "If not NIL will be put in title of window")) (left :initform 0 (il:* il:\; "left position of window")) (bottom :initform 0 (il:* il:\; "bottom position of window")) (width :initform 64) (height :initform 32) (il:* il:|;;| "NODE Labels") (label-cache :initform nil) (label-max-lines :initform nil (il:* il:|;;| "the maximum number of lines to use in 'boxed' labels -- note that if the label wont fit within the LabelMaxLines and LabelMaxCharsWidth restrictions, it will be truncated")) (label-max-chars-width :initform nil (il:* il:|;;| "the maximum width for labels -- if label is too big, it will be 'boxed'")) (il:* il:|;;| "NODE Operations") (last-selected-object :initform nil (il:* il:\; "last object selected")) (boxed-node :initform nil (il:* il:\; "last item Boxed, if any")) (box-line-width :allocation :class (il:* il:|;;| "width to make box for BoxNode") :initform 1) (node-mover-p :allocation :class :initform nil) (il:* il:|;;| "MENUS") (cache-menu-p :initform t) (menu-cache :initform nil (il:* il:\; "Will Cache Menus only if CACHE-MENU-P is T")) (local-commands :allocation :class (il:* il:|;;| "messages that should be sent to browser when item seleted in menu, even if object does understand them") :initform (quote (box-node recompute add-root))) (title-items :allocation :class (il:* il:|;;| "Items for menu of selections in title of window") :initform (quote (("Recompute" recompute "" (il:subitems ("Recompute" recompute "Recompute lattice from starting objects") ("Recompute Labels" recompute-labels "Recomputes the labels") ("Recompute In Place" recompute-in-place "Recompute keeping current view in window"))) ("Shape To Hold" shape-to-hold "Make window large or small enough to just hold graph") ("Change Font Size" change-font-size "Choose a new size Font") ("Change Format" change-format "Change format between lattice and tree")))) (left-button-items :allocation :class (il:* il:|;;| "Menu items for LeftButton seletion -- Value sent as message to object or browser -- see LocalCommands") :initform (quote (("Box Node" box-node "Draw box around selected node.
Unboxed by another BoxNode") ("Pretty Print" pp "Prettyprint selected item")))) (middle-button-items :allocation :class (il:* il:|;;| "Menu items for MiddleButton seletion -- Value sent as message to object or browser -- see LocalCommands") :initform (quote (("Inspect" il:|Inspect| inspect "Inspect selected item") ("Edit" edit-object "Edit selected item") ("Delete From Browser" delete-from-browser "Do not show item or its subs")))) (right-button-items :allocation :class :initform (quote (("Close" (closew (("Close" closew) ("Destroy" destroy)))) ("Snap" snap) ("Paint" paint) ("Clear" clear) ("Bury" bury) ("Repaint" repaint) ("Hardcopy" (hardcopy (("Hardcopy to File" hardcopy-to-file) ("Hardcopy to Printer" hardcopy-to-printer)))) ("Move" move) ("Shape" shape) ("Shrink" shrink))) (il:* il:\; "Items to be done if Right button is selected"))))



(il:* il:|;;| "Top Level")


(defun make-web-editor nil (let ((editor (make-instance (quote web-editor)))) (initialize-editor editor)))

(defmethod initialize-editor ((self web-editor)) (let nil (create-window self) self))

(defmethod destroy ((self web-editor)) (let* ((window (slot-value self (quote window))) (icon-window (il:windowprop window (quote il:iconwindow)))) (il:closew window) (if icon-window (il:closew icon-window)) (detach-lisp-window self)))

(defmethod browse ((self web-editor) &optional browse-list window-or-title good-list position) (il:* il:\; "11-Sep-84 07:24") (il:* il:\; "Call Show and then shape to hold and move for first time") (cond ((il:windowp window-or-title) (setf (slot-value self (quote window)) window-or-title)) (window-or-title (setf (slot-value self (quote title)) window-or-title))) (cond ((and browse-list (il:nlistp browse-list)) (il:setq browse-list (list browse-list)))) (setf (slot-value self (quote starting-list)) browse-list) (setf (slot-value self (quote good-list)) good-list) (display-browser self) (shape-to-hold self) (move self position) self)

(defmethod get-label ((web-editor web-editor) (node web-node)) (il:* il:\; "Get a label for an object to be displayed in the browser.") (node-name node))

(defmethod get-subs ((editor web-editor) (node web-node)) (il:* il:\; "Gets a set of subs from an object for browsing") (node-links node))

(defmethod icon-title ((self web-editor)) (il:* il:\; "18-Jan-85 15:35") (il:* il:|;;| "Compute the icont title for this browser") (quote |Web Editor|))

(defmethod add-node ((web-editor web-editor) (new-node web-node)) (il:* il:\; "11-Dec-86 10:23") (il:* il:|;;| "Add a new node to the browser.") (pushnew new-node (slot-value web-editor (quote starting-list))) (if (slot-value web-editor (quote good-list)) (pushnew new-node (slot-value web-editor (quote good-list)))))

(defmethod notice-node ((web-editor web-editor) (web-node web-node) (parent-node web-node)) (push web-node (slot-value parent-node (quote to-links))) (add-node web-editor web-node))

(defmethod remove-node ((web-editor web-editor) (bye-node web-node)) (with-slots (starting-list good-list bad-list) web-editor (il:* il:|;;| "") (setf starting-list (delete bye-node starting-list)) (if good-list (setf good-list (delete bye-node good-list))) (if bad-list (setf bad-list (delete bye-node bad-list))) (setf (node-links (node-back-links bye-node)) (delete bye-node (node-links (node-back-links bye-node))))))

(defmethod delete-from-browser ((self web-editor) obj obj-name) (il:* il:\; " 5-Aug-86 16:50") (il:* il:|;;| "Place on badList for Browser") (pushnew obj (slot-value self (quote bad-list))) (recompute self))

(defmethod remove-from-bad-list ((self web-editor)) (il:* il:\; "28-Dec-85 10:04") (il:* il:\; "Remove an item from BadList to allow it to be displayed once again") (cond ((null (slot-value self (quote bad-list))) (il:clrprompt) (il:promptprint "No BadList items.")) (t (prog ((il:|item| (il:menu (il:|create| il:menu il:title il:_ "BadList Items" il:items il:_ (slot-value self (quote bad-list)))))) (cond (il:|item| (setf (slot-value self (quote bad-list)) (quote (il:dremove il:|item| (slot-value self (quote bad-list))))) (recompute self)) (t (il:clrprompt) (il:promptprint "Nothing Selected")))))))

(defmethod rename-node ((web-editor web-editor) (web-node web-node) new-name) (setf (node-name web-node) new-name) (clear-label-cache web-editor web-node))



(il:* il:\; "")




(il:* il:\; "Window System Interface")


(defmethod create-window ((self web-editor)) (il:* il:\; "10-Apr-86 14:32") (il:* il:\; "Create the Lisp window for this window but don't open it.") (let ((window (il:createw (il:createregion il:lastmousex il:lastmousey 25 25) (slot-value self (quote title)) nil t))) (setf (slot-value self (quote window)) window) (setup-window self) window))

(defmethod setup-window ((self web-editor)) (il:* il:\; "10-Apr-86 14:32") (il:* il:\; "Create the Lisp window for this window but don't open it.") (let ((window (slot-value self (quote window)))) (il:windowprop window (quote web-editor) self) (il:windowprop window (quote il:iconfn) (quote web-window-icon-fn)) (il:windowprop window (quote il:buttoneventfn) (quote web-window-button-event-fn)) (il:windowaddprop window (quote il:aftermovefn) (quote web-window-after-move-fn)) (il:windowaddprop window (quote il:reshapefn) (quote web-window-reshape-fn)) (il:windowaddprop window (quote il:closefn) (quote web-window-close-fn)) (il:windowprop window (quote il:iconfn) (quote web-window-icon-fn)) (il:* il:\; "window should be invert so that links etc.  can be erased") (il:dspoperation (quote il:invert) window) (il:* il:\; "kludge: because GRAPHER adds its own COPYBUTTONEVENTFN") (il:windowprop window (quote il:copybuttoneventfn) nil) (il:windowprop window (quote il:title) (slot-value self (quote title))) window))

(defmethod detach-lisp-window ((self web-editor)) (il:* il:\; " 8-Apr-87 17:25") (il:* il:|;;;| "Forget about the current lisp window") (let ((val (slot-value self (quote window)))) (il:|if| (il:windowp val) il:|then| (setf (slot-value self (quote window)) nil) (il:windowprop val (quote web-editor) nil) (il:windowprop val (quote il:rightbuttonfn) nil) (il:windowprop val (quote il:buttoneventfn) nil) nil il:|else| nil)))

(defmethod shrink ((self web-editor) &optional towhat pos expandfn) (let* ((window (slot-value self (quote window)))) (if (il:windowp window) (il:shrinkw window towhat pos expandfn))))

(defmethod set-outer-region ((self web-editor) region no-update-flg) (il:* il:\; "16-Apr-86 13:21") (il:* il:|;;;| "Make Loops Window have region parameters") (setf (slot-value self (quote left)) (il:|fetch| il:left il:|of| region)) (setf (slot-value self (quote bottom)) (il:|fetch| il:bottom il:|of| region)) (setf (slot-value self (quote width)) (il:|fetch| il:width il:|of| region)) (setf (slot-value self (quote height)) (il:|fetch| il:height il:|of| region)) (il:|if| (not no-update-flg) il:|then| (update self)) region)

(defmethod set-region ((self web-editor) region &optional no-update-flg) (il:* il:\; "16-Apr-86 13:22") (il:* il:|;;;| "Make Loops Window have region parameters") (set-outer-region self (il:createregion (il:|fetch| il:left il:|of| region) (il:|fetch| il:bottom il:|of| region) (il:widthifwindow (il:|fetch| il:width il:|of| region) (il:windowprop (slot-value self (quote window)) (quote il:border))) (il:heightifwindow (il:|fetch| il:height il:|of| region) (slot-value self (quote title)) (il:windowprop (slot-value self (quote window)) (quote il:border)))) no-update-flg))

(defmethod update ((self web-editor)) (il:* il:\; "29-Sep-86 11:56") (il:* il:|;;| "make the Lisp window be consistent with ivs") (let* ((window (slot-value self (quote window))) (region (and (slot-value self (quote width)) (slot-value self (quote height)) (il:|create| il:region il:left il:_ (or (slot-value self (quote left)) (setf (slot-value self (quote left)) il:lastmousex)) il:bottom il:_ (or (slot-value self (quote bottom)) (setf (slot-value self (quote bottom)) il:lastmousey)) il:width il:_ (slot-value self (quote width)) il:height il:_ (slot-value self (quote height)))))) (cond ((and region (not (il:equal region (il:windowprop window (quote il:region))))) (il:* il:\; "The shape has changed.  --- This is complicated because of ATTACHEDWINDOWS.") (let* ((attached-windows (il:windowprop window (quote il:attachedwindows))) (attachment-specs (il:|for| il:\w il:|in| attached-windows il:|collect| (list (il:windowprop il:\w (quote il:dowindowcomfn)) (il:windowprop il:\w (quote il:whereattached)) (il:windowprop il:\w (quote il:passtomaincoms)))))) (il:|for| il:\w il:|in| attached-windows il:|do| (il:detachwindow il:\w)) (il:shapew window region) (il:|for| il:\w il:|in| attached-windows il:|as| il:|spec| il:|in| attachment-specs il:|do| (il:attachwindow il:\w window (caadr il:|spec|) (cdadr il:|spec|)) (il:windowprop il:\w (quote il:dowindowcomfn) (car il:|spec|)) (il:windowprop il:\w (quote il:passtomaincoms) (caddr il:|spec|)))))) (and (not (il:equal (slot-value self (quote title)) (il:windowprop window (quote il:title)))) (il:windowprop window (quote il:title) (slot-value self (quote title))))))

(defmethod move ((self web-editor) x-or-pos y) (il:* il:\; "11-Sep-86 13:24") (il:* il:|;;;| "Move the window") (move1 self (or x-or-pos (let* ((entire-region (il:windowregion (slot-value self (quote window)))) (pos (il:getboxposition (il:|fetch| il:width il:|of| entire-region) (il:|fetch| il:height il:|of| entire-region) (il:|fetch| il:left il:|of| entire-region) (il:|fetch| il:bottom il:|of| entire-region)))) (il:|create| il:position il:xcoord il:_ (il:plus (il:|fetch| il:xcoord il:|of| pos) (il:difference (slot-value self (quote left)) (il:|fetch| il:left il:|of| entire-region))) il:ycoord il:_ (il:plus (il:|fetch| il:ycoord il:|of| pos) (il:difference (slot-value self (quote bottom)) (il:|fetch| il:bottom il:|of| entire-region)))))) y))

(defmethod move1 ((self web-editor) x-or-pos y) (il:* il:\; "13-Aug-86 19:10") (il:* il:|;;| "Move the window") (let ((needs-update? (not (il:subregionp (il:constant (il:createregion 0 0 il:screenwidth il:screenheight)) (il:windowprop (slot-value self (quote window)) (quote il:region)))))) (prog1 (il:movew (slot-value self (quote window)) x-or-pos y) (il:* il:\; "The left and right IVs are updated by the message AfterMove") (cond (needs-update? (update self))))))

(defmethod after-move ((self web-editor)) (il:* il:\; "10-Apr-86 16:10") (il:* il:|;;;| "The window has been moved.  Update the left and bottom") (let ((region (il:windowprop (slot-value self (quote window)) (quote il:region)))) (setf (slot-value self (quote left)) (il:|fetch| il:left il:|of| region)) (setf (slot-value self (quote bottom)) (il:|fetch| il:bottom il:|of| region))))

(defmethod after-reshape ((self web-editor) old-bitmap-image old-region old-screen-region) (il:* il:\; "10-Apr-86 16:12") (il:* il:|;;;| "The window has been reshaped") (let ((region (il:windowprop (slot-value self (quote window)) (quote il:region)))) (setf (slot-value self (quote left)) (il:|fetch| il:left il:|of| region)) (setf (slot-value self (quote bottom)) (il:|fetch| il:bottom il:|of| region)) (setf (slot-value self (quote width)) (il:|fetch| il:width il:|of| region)) (setf (slot-value self (quote height)) (il:|fetch| il:height il:|of| region)) (il:reshapebyrepaintfn (slot-value self (quote window)) old-bitmap-image old-region old-screen-region)))

(defmethod scroll-window ((self web-editor) dsp-x dsp-y window-x window-y) (il:* il:\; "10-Apr-86 14:58") (il:* il:|;;;| "scroll the window to set the point dspX,dspY in the given window position -- default is the lower left corner.  If any x or y is a FIXP, it is treated as a absolute position.  If FLOATP, it is treated as a relative position.  Return the position of the new lower left corner.") (let* ((window (slot-value self (quote window))) (visible-region (il:dspclippingregion nil window)) (extent (il:windowprop window (quote il:extent)))) (il:* il:\; "figure out what to do with default and relative offsets") (il:setq window-x (il:|if| (null window-x) il:|then| 0 il:|elseif| (il:floatp window-x) il:|then| (il:fix (il:times window-x (il:windowprop window (quote il:width)))) il:|else| window-x)) (il:setq window-y (il:|if| (null window-y) il:|then| 0 il:|elseif| (il:floatp window-y) il:|then| (il:fix (il:times window-y (il:windowprop window (quote il:height)))) il:|else| window-y)) (il:setq dsp-x (il:|if| (null dsp-x) il:|then| (il:|fetch| il:left il:|of| visible-region) il:|elseif| (il:floatp dsp-x) il:|then| (il:fix (il:times dsp-x (il:|fetch| il:width il:|of| extent))) il:|else| dsp-x)) (il:setq dsp-y (il:|if| (null dsp-y) il:|then| (il:iminus (il:|fetch| il:bottom il:|of| visible-region)) il:|elseif| (il:floatp dsp-y) il:|then| (il:fix (il:times dsp-y (il:|fetch| il:height il:|of| extent))) il:|else| dsp-y)) (il:scrollw window (il:iplus window-x (il:idifference (il:|fetch| il:left il:|of| visible-region) dsp-x)) (il:iplus window-y (il:idifference (il:|fetch| il:bottom il:|of| visible-region) dsp-y))) (il:* il:\; "return the resulting position") (il:setq visible-region (il:dspclippingregion nil window)) (il:|create| il:position il:xcoord il:_ (il:|fetch| il:left il:|of| visible-region) il:ycoord il:_ (il:|fetch| il:bottom il:|of| visible-region))))

(defmethod clear ((self web-editor)) (il:* il:\; "empty the window of active regions, return the window") (let ((window (slot-value self (quote window)))) (il:windowprop window (quote il:graph) nil) (il:clearw window) window))

(defmethod get-prompt-window ((self web-editor) &optional lines font-def) (il:* il:\; " 8-Apr-87 15:43") (il:* il:|;;| "Return the current prompt window") (let ((w (il:getpromptwindow (slot-value self (quote window)) (or lines 2) (or (il:fontcreate font-def))))) (if font-def (il:dspfont (il:fontcreate font-def) w)) w))

(defmethod remove-prompt-window ((self web-editor)) (il:* il:\; " 8-Apr-87 15:43") (il:removepromptwindow (slot-value self (quote window))))

(defmethod prompt-print ((self web-editor) prompt) (il:* il:\; "13-Aug-86 18:46") (il:* il:|;;| "Prints out a prompt in an attached prompt window") (il:prin1 prompt (get-prompt-window self)))

(defmethod prompt-read ((self web-editor) msg) (il:* il:\; "13-Aug-86 19:15") (il:* il:|;;| "Prompt the user for some input, using an attached prompt window") (let ((p-window (get-prompt-window self))) (il:clearw p-window) (prog1 (il:|PromptRead| msg p-window t) (il:clearw p-window) (il:detachwindow p-window) (il:closew p-window))))

(defmethod prompt-for-list ((self web-editor) prompt-str initial-string) (il:* il:\; " 8-Apr-87 16:44") (il:* il:|;;;| "Prompt user in prompt window for a list of words.") (let ((p-window (get-prompt-window self))) (il:resetform (il:ttydisplaystream p-window) (il:clearw p-window) (il:ttyin prompt-str nil nil (quote (il:noraise)) nil nil initial-string))))

(defmethod prompt-for-string ((self web-editor) prompt-str initial-str) (il:* il:\; "13-Aug-86 18:42") (il:* il:|;;;| "Prompt user in prompt window for a string.") (let ((p-window (get-prompt-window self)) value) (il:resetform (il:ttydisplaystream p-window) (il:clearw p-window) (setq value (il:ttyin prompt-str nil nil (quote (string il:noraise)) nil nil initial-str)) (il:clearw p-window)) (remove-prompt-window self) value))

(defmethod prompt-for-word ((self web-editor) &optional prompt-str initial-word) (il:* il:\; " 8-Apr-87 16:43") (il:* il:|;;;| "Prompt user in prompt window for a word.") (car (prompt-for-list self prompt-str initial-word)))

(defmacro move-down-p nil (quote (or (il:keydownp (quote il:move)) (il:shiftdownp (quote il:ctrl)))))
(il:defineq

(web-window-after-move-fn
(lambda (window) (il:* il:\; "Edited 13-Jul-87 15:59 by Rao") (il:* il:\; "10-Apr-86 16:16") (il:* il:|;;;| "The SimpleWindow AFTERMOVEFN") (let ((w (il:windowprop window (quote web-editor)))) (and w (after-move w))))
)

(web-window-button-event-fn
(lambda (window) (il:* il:\; "Edited 13-Jul-87 13:38 by Rao") (il:* il:\; "11-Sep-86 13:50") (let ((window-for-menu (il:windowprop window (quote web-editor)))) (declare (il:specvars window-for-menu)) (il:totopw window) (button-event-fn window-for-menu)))
)

(web-window-reshape-fn
(lambda (window il:|oldBitmapImage| il:|oldRegion| il:|oldScreenRegion|) (il:* il:\; "Edited 12-Jun-87 15:56 by Rao") (il:* il:\; " 9-May-86 10:07") (il:* il:|;;;| "The RESHAPEFN for a Window") (let ((il:\w (il:windowprop window (quote web-editor)))) (and il:\w (after-reshape il:\w il:|oldBitmapImage| il:|oldRegion|))))
)

(web-window-close-fn
(il:lambda (window) (il:* il:\; "Edited 12-Jun-87 11:42 by Rao") (il:* il:\; "Remove link back to LoopsWindow") (il:windowprop window (quote web-editor) nil))
)

(il:|PromptRead|
(il:lambda (prompt-string window same-line?) (il:* il:\; "Edited 20-Jul-87 16:20 by Rao") (il:* il:\; "Printout promptString in promptwindow and return value of expression read there") (prog (newvalue) (il:resetlst (il:resetsave (il:ttydisplaystream (or window il:promptwindow))) (il:resetsave (il:tty.process (il:this.process))) (il:clrprompt) (il:resetsave (il:printlevel 4 3)) (il:|printout| t prompt-string) (il:|if| same-line? il:|then| (il:|printout| t "> ") il:|else| (il:|printout| t t "> ")) (il:clearbuf t t) (il:* il:\; "clear tty buffer because it sometimes has stuff left.") (il:allow.button.events) (il:setq newvalue (car (il:ersetq (il:ttyinread t t))))) (return newvalue)))
)
)
(il:defineq

(web-window-expand-fn
(lambda (window) (il:* il:\; "Edited 13-Nov-87 12:58 by Rao") (il:* il:\; "19-Feb-85 13:58") (il:* il:|;;| "When a browser window is expanded, it should be recomputed") (let ((self (il:windowprop window (quote web-editor)))) (recompute-in-place self)))
)
)

(defun web-window-icon-fn (window icon) (let nil (or icon (il:titlediconw *web-editor-template* (icon-title (il:windowprop window (quote web-editor))) nil (quote (0 . 0)) t (quote il:bottom) (il:constant (list (il:charcode "-") (il:charcode il:space) (il:charcode il:eol)))))))

(il:rpaqq *web-editor-icon-bm* #*(60 75)OOOOOOOOOOOO@@@@OOOOOOOOOOOOH@@@L@@@@@@@@@@AL@@@L@@@@@@@@@@AF@@@L@@@@@@@@@@AC@@@L@@@@@@@@@@AAH@@L@@@@@@@@@@A@L@@L@@@@@@@@@@A@F@@LOON@@@@@@OO@C@@LOON@@@@@@OO@AH@LOOO@@@@@@OO@@L@LOONH@@@@AOO@@F@LOOND@@@@BOOOOO@L@@@B@@@@DOOOHC@L@@@ACOOLH@@@@C@L@@@@KOOM@@@@@C@L@@@@GOON@@@@@C@L@@@@KOOM@@@@@C@L@@@ACOOLH@@@@C@LOOOB@@@@DOOOHC@LOOOD@@@@BOOOHC@LOOOH@@@@AOOOHC@LOOOD@@@@@OOOHC@LOOOB@@@@@OOOHC@L@@@ACOOO@@@@@C@L@@@@KOOO@@@@@C@L@@@@GOOO@@@@@C@L@@@@COOO@@@@@C@L@@@@COOO@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@L@@@@@@@@@@@@@C@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@)

(il:rpaqq *web-editor-icon-mask* #*(60 75)OOOOOOOOOOOO@@@@OOOOOOOOOOOOH@@@OOOOOOOOOOOOL@@@OOOOOOOOOOOON@@@OOOOOOOOOOOOO@@@OOOOOOOOOOOOOH@@OOOOOOOOOOOOOL@@OOOOOOOOOOOOON@@OOOOOOOOOOOOOO@@OOOOOOOOOOOOOOH@OOOOOOOOOOOOOOL@OOOOOOOOOOOOOON@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@OOOOOOOOOOOOOOO@)

(defvar *web-editor-template* (il:|create| il:titledicon il:icon il:_ *web-editor-icon-bm* il:mask il:_ *web-editor-icon-mask* il:titlereg il:_ (il:createregion 5 2 50 30)))

(il:rpaq il:*d-window-default-stream* il:promptwindow)

(il:rpaq web-stream il:promptwindow)



(il:* il:\; "Layout and Display Engine")


(il:rpaqq il:|BrowserMargin| 0)

(il:rpaqq il:|MaxLatticeHeight| 750)

(il:rpaqq il:|MaxLatticeWidth| 900)
(il:declare\: il:doeval@compile il:dontcopy

(il:specvars il:|MaxLatticeHeight| il:|MaxLatticeWidth|)
)

(il:rpaqq il:grayshade1 1)

(il:rpaqq il:grayshade2 1025)

(il:rpaqq il:grayshade3 64510)

(il:rpaqq il:grayshade4 65534)
(il:defineq

(tree-roots
(il:lambda (node-lst) (il:* il:\; "Edited 10-Jul-87 19:22 by Rao") (il:* il:\; "29-Sep-86 19:46") (il:* il:|;;| "Computes a minimal set of root nodes for a lattice --- those with no connections TO them in list of nodes, or a single node from a cycle of nodes.") (prog ((root-nodes (il:ldifference node-lst (il:|for| il:|node| il:|in| node-lst il:|join| (child-nodes il:|node| node-lst)))) reachable-nodes not-reachable-nodes) (setq reachable-nodes (il:copy root-nodes)) (setq not-reachable-nodes (il:ldifference node-lst reachable-nodes)) (il:* il:\; "recompute the nodes that can't be reached from the current rootNodes") il:|RecomputeReachableNodes| (il:* il:|;;| "Compute the transitive closure of the set of reachableNodes --- updating the notReachableNodes at the same time") (il:|for| il:|node| il:|in| reachable-nodes il:|do| (il:|for| il:|childNode| il:|in| (child-nodes il:|node| node-lst) il:|when| (il:memb il:|childNode| not-reachable-nodes) il:|do| (il:* il:|;;| "put the newly found reachable node at the end of the list, so we will find it later on during this iteration") (il:nconc1 reachable-nodes il:|childNode|) (setq not-reachable-nodes (il:dremove il:|childNode| not-reachable-nodes)))) (il:* il:\; "if we can reach all the nodes, fine...") (il:|if| (null not-reachable-nodes) il:|then| (il:* il:\; "Now need to prune down to a minimal set") (il:|bind| (il:|stable?| il:_ nil) il:|until| il:|stable?| il:|do| (setq il:|stable?| t) (il:|for| il:|node| il:|in| root-nodes il:|bind| il:|extraRoots| il:|do| (setq il:|extraRoots| (il:dremove il:|node| (il:intersection root-nodes (reachable-nodes! il:|node| node-lst)))) (il:|if| il:|extraRoots| il:|then| (setq il:|stable?| nil) (setq root-nodes (il:ldifference root-nodes il:|extraRoots|)) (return t)) il:|finally| (return nil))) (il:* il:\; "return the node ids, not the GRAPHNODES") (return (il:|for| il:|node| il:|in| root-nodes il:|collect| (il:|fetch| il:nodeid il:|of| il:|node|))) il:|else| (il:* il:\; "must be a cycle.  Select the least prolific node in the cycle as the a new root node.") (il:|push| root-nodes (let ((prolific-node (il:|for| il:|node| il:|in| not-reachable-nodes il:|smallest| (il:length (il:|fetch| il:tonodes il:|of| il:|node|))))) (setq not-reachable-nodes (il:dremove prolific-node not-reachable-nodes)) prolific-node)) (go il:|RecomputeReachableNodes|))))
)

(child-nodes
(il:lambda (parent-node node-list) (il:* il:\; "Edited 10-Jul-87 19:23 by Rao") (il:* il:\; " 8-Oct-85 14:15") (il:* il:\; "Find all GRAPHNODES that are immediatly reachable from this node") (il:|for| il:|label| il:|in| (il:|fetch| il:tonodes il:|of| parent-node) il:|collect| (il:|for| il:|node| il:|in| node-list il:|thereis| (eq il:|label| (il:|fetch| il:nodeid il:|of| il:|node|)))))
)

(reachable-nodes!
(il:lambda (il:|root| il:|nodeList|) (il:* il:\; "30-Sep-86 10:22") (il:* il:\; il:|Return| il:\a il:|list| il:|of| il:|all| il:|nodes| il:|that| il:|are| il:|reachable| il:|from| il:|the| il:|root|) (let ((il:|reachableNodes| (list il:|root|))) (il:|for| il:|node| il:|in| il:|reachableNodes| il:|do| (il:|for| il:|childNode| il:|in| (child-nodes il:|node| il:|nodeList|) il:|when| (not (il:memb il:|childNode| il:|reachableNodes|)) il:|do| (il:* il:\; il:|put| il:|the| il:|newly| il:|found| il:|reachable| il:|node| il:|at| il:|the| il:|end| il:|of| il:|the| il:|list,| il:|so| il:|we| il:|will| il:|find| il:|it| il:|later| il:|on| il:|during| il:|this| il:|iteration|) (il:nconc1 il:|reachableNodes| il:|childNode|))) il:|reachableNodes|))
)
)

(defmethod display-browser ((self web-editor)) (il:* il:\; "29-Sep-86 12:15") (il:* il:\; "New method template") (let ((nodelst (and (slot-value self (quote starting-list)) (get-node-list self (slot-value self (quote starting-list)) (slot-value self (quote good-list)))))) (cond (nodelst (il:showgraph (il:layoutgraph nodelst (tree-roots nodelst) (slot-value self (quote graph-format)) (slot-value self (quote browse-font))) (slot-value self (quote window)) nil nil (slot-value self (quote top-align))) (il:* il:\; "kludge to reset the window props") (setup-window self)) (t (clear self)))))

(defmethod browser-objects ((il:|self| web-editor)) (il:* il:\; "28-May-84 12:58") (il:* il:\; "Return a list of all the objects shown in the browser") (il:|for| il:|node| il:|in| (il:|fetch| il:graphnodes il:|of| (il:windowprop (slot-value il:|self| (quote window)) (quote il:graph))) il:|when| (il:nlistp (car il:|node|)) il:|collect| (car il:|node|)))

(defmethod get-node-list ((self web-editor) browse-list good-list) (il:* il:\; "21-Mar-85 14:09") (il:* il:|;;| "Compute the node data structures of the tree starting at browseList.  If goodList is given, only include elements of it.  If goodList=T make it be browseList.") (declare (il:globalvars il:whiteshade)) (cond ((eq good-list t) (il:setq good-list browse-list))) (prog (subs pair node (old-nodes (il:|fetch| il:graphnodes il:|of| (il:windowprop (slot-value self (quote window)) (quote il:graph)))) (obj-list (cons))) (il:* il:|;;| "first make objList which is a list of pairs (object  . objName).  objName will be used as a title for a node in the browser.  This structure will be replaced by a graphNode when it is processed.  The nodeID of the graphNode will be the object, and the label will be the name.") (il:|for| il:|objOrName| il:|in| browse-list il:|do| (and (il:setq pair (obj-name-pair self il:|objOrName|)) (not (il:fassoc (car pair) (car obj-list))) (il:tconc obj-list pair))) (il:* il:|;;| "Now MAP ON list so pair can be replaced by graphNode") (il:|for| pair il:|name| il:|obj| il:|subObjs| il:|on| (car obj-list) il:|when| (il:nlistp (il:setq il:|name| (cdar pair))) il:|do| (il:setq il:|subObjs| (cons)) (il:|for| il:|sub| il:|objPair| il:|obj1| il:|in| (get-subs self (il:setq il:|obj| (caar pair))) il:|do| (il:* il:|;;| "ObjNamePair returns NIL for destroyed objects.  include only members of goodList in subs if given.  Add to objList only once") (il:setq il:|obj1| (cond ((eq (car il:|sub|) (quote il:|Link Parameters|)) (cadr il:|sub|)) (t il:|sub|))) (cond ((il:setq il:|objPair| (obj-name-pair self il:|obj1|)) (cond ((not (il:fassoc il:|obj1| (car obj-list))) (il:tconc obj-list il:|objPair|))) (il:tconc il:|subObjs| il:|sub|)))) (rplaca pair (il:setq node (or (il:fassoc il:|obj| old-nodes) (il:|create| il:graphnode il:nodeid il:_ il:|obj| il:nodeborder il:_ (list (il:add1 (slot-value self (quote box-line-width))) il:whiteshade))))) (il:|replace| il:tonodes il:|of| node il:|with| (car il:|subObjs|)) (il:|replace| il:nodelabel il:|of| node il:|with| il:|name|) (il:|replace| il:nodefont il:|of| node il:|with| (slot-value self (quote browse-font))) (il:|replace| il:nodewidth il:|of| node il:|with| nil) (il:|replace| il:nodeheight il:|of| node il:|with| nil)) (return (car obj-list))))

(defmethod obj-name-pair ((il:|self| web-editor) il:|obj|) (il:* il:|;;| "Make a pair (object  . objName) where objName is label to be used in browser") (let nil (il:|if| (null il:|obj|) il:|then| nil il:|elseif| (and (slot-value il:|self| (quote good-list)) (not (il:fmemb il:|obj| (slot-value il:|self| (quote good-list))))) il:|then| nil il:|elseif| (il:fmemb il:|obj| (slot-value il:|self| (quote bad-list))) il:|then| nil il:|else| (cons il:|obj| (get-display-label il:|self| il:|obj|)))))

(defmethod graph-fits ((|self| web-editor)) (il:* il:\; "24-Apr-86 15:00") (il:* il:|;;;| "Tests if graph fits in region") (let ((|window| (slot-value |self| (quote window)))) (let ((|width| 0) (|height| 0) (|region| (il:windowprop |window| (quote il:region))) (|nodes| (il:|fetch| il:graphnodes il:|of| (il:windowprop |window| (quote il:graph))))) (cond (|nodes| (il:setq |width| (il:widthifwindow (il:idifference (il:max/right |nodes|) (il:min/left |nodes|)) (il:windowprop |window| (quote il:border)))) (il:setq |height| (il:heightifwindow (il:idifference (il:max/top |nodes|) (il:min/bottom |nodes|)) (il:windowprop |window| (quote il:title)) (il:windowprop |window| (quote il:border)))))) (not (or (il:igreaterp |width| (il:|fetch| il:width il:|of| |region|)) (il:igreaterp |height| (il:|fetch| il:height il:|of| |region|)))))))

(defmethod node-region ((il:|self| web-editor) il:|object|) (il:* il:\; "10-Dec-84 18:26") (il:* il:|;;| "what region does the object occupy in the display stream?") (let ((il:|node| (il:fassoc (cond ((il:litatom il:|object|) (il:setq il:|object| (il:|GetObjectRec| il:|object|))) (t il:|object|)) (il:|fetch| il:graphnodes il:|of| (il:windowprop (slot-value il:|self| (quote window)) (quote il:graph)))))) (il:|if| il:|node| il:|then| (il:|create| il:region il:left il:_ (il:idifference (il:|fetch| il:xcoord il:|of| (il:|fetch| il:nodeposition il:|of| il:|node|)) (il:iquotient (il:|fetch| il:nodewidth il:|of| il:|node|) 2)) il:bottom il:_ (il:idifference (il:|fetch| il:ycoord il:|of| (il:|fetch| il:nodeposition il:|of| il:|node|)) (il:iquotient (il:|fetch| il:nodeheight il:|of| il:|node|) 2)) il:width il:_ (il:|fetch| il:nodewidth il:|of| il:|node|) il:height il:_ (il:|fetch| il:nodeheight il:|of| il:|node|)))))

(defmethod recompute ((self web-editor) &optional dont-reshape-flg) (il:* il:\; " 8-Apr-87 14:42") (il:* il:\; "Recompute the browseGraph in the same window") (prog ((graph-fits (graph-fits self))) (display-browser self) (cond ((or dont-reshape-flg (null graph-fits)) (il:* il:\; "Dont Reshape or rescroll.  Assume window wants to stay the same size")) (t (shape-to-hold self)))) self)

(defmethod recompute-in-place ((il:|self| web-editor)) (il:* il:\; "10-Dec-84 18:27") (il:* il:|;;;| "recompute the graph, maintaining the current position") (let* ((il:|visibleRegion| (il:dspclippingregion nil (slot-value il:|self| (quote window)))) (il:\x (il:|fetch| il:left il:|of| il:|visibleRegion|)) (il:\y (il:|fetch| il:bottom il:|of| il:|visibleRegion|))) (il:* il:\; "if we want to RecomputeInPlace, we must want the window to be kept the same") (recompute il:|self| t) (il:* il:\; "we had to save x and y because visibleRegion gets clobbered by Recompute! Suprise!") (scroll-window il:|self| il:\x il:\y)))

(defmethod recompute-labels ((|self| web-editor)) (il:* il:\; "27-Feb-85 11:27") (il:* il:\; "recompute the graph, including the labels") (clear-label-cache |self| t) (recompute |self|))

(defmethod recompute-if-open ((web-editor web-editor)) (il:* il:\; "27-Aug-86 12:37") (if (il:openwp (slot-value web-editor (quote window))) (recompute web-editor)))

(defmethod clear-label-cache ((web-editor web-editor) objects) (il:* il:\; " 5-Dec-85 12:02") (let (cached-label) (il:* il:|;;| "Delete the cached label for these items") (cond ((eq objects t) (setf (slot-value web-editor (quote label-cache)) nil)) (t (if (atom objects) (setq objects (cons objects))) (dolist (obj objects) (if (setq cached-label (il:assoc obj (slot-value web-editor (quote label-cache)))) (setf (slot-value web-editor (quote label-cache)) (il:dremove cached-label (slot-value web-editor (quote label-cache))))))))))

(defmethod object-from-label ((self web-editor) label) (il:* il:\; " 4-Jan-85 18:20") (il:* il:|;;| "What object has this label?") (let ((object-node (il:|for| il:|node| il:|in| (il:|fetch| il:graphnodes il:|of| (il:windowprop (slot-value self (quote window)) (quote il:graph))) il:|thereis| (il:equal label (il:|fetch| il:nodelabel il:|of| il:|node|))))) (il:|if| (il:nlistp (car object-node)) il:|then| (car object-node) il:|else| nil)))

(defmethod change-font-size ((web-editor web-editor) size) (il:* il:\; "13-Dec-84 13:04") (il:* il:\; "Change the font size from whatever it is to size") (when (or size (setq size (il:menu (il:|create| il:menu il:title il:_ "Select Desired Size" il:changeoffsetflg il:_ t il:items il:_ (quote (("Abort" nil) 8 10 12 16)))))) (setf (slot-value web-editor (quote browse-font)) (il:fontcreate (il:bquote ((il:\\\, (slot-value web-editor (quote browse-font-family))) (il:\\\, size) (il:\\\, (slot-value web-editor (quote browse-font-face))))))) (il:* il:\; "clear out the label cache!") (recompute-labels web-editor)))

(defmethod change-format ((|self| web-editor) |format|) (il:* il:\; "21-Apr-84 19:52") (il:* il:\; "Change format between Lattice and Tree") (cond ((il:listp |format|) (setf (slot-value |self| (quote graph-format)) |format|)) ((setq |format| (il:menu (il:|create| il:menu il:items il:_ (slot-value |self| (quote graph-format-choices))))) (setf (slot-value |self| (quote graph-format)) |format|))) (recompute |self|))

(defmethod change-max-label-size ((self web-editor) new-max-width new-max-lines) (il:* il:\; "13-Dec-84 13:05") (il:* il:\; "change the max label dimensions and redisplay the nodes -- if new size is NULL, don't change") (il:|if| new-max-lines il:|then| (setf (slot-value self (quote label-max-lines)) new-max-lines)) (il:|if| new-max-width il:|then| (setf (slot-value self (quote label-max-chars-width)) new-max-width)) (il:* il:\; "clear out the label cache") (recompute-labels self))

(defmethod shape-to-hold ((self web-editor)) (il:* il:\; "13-Jan-87 16:52") (il:* il:|;;| "Shape the browse window to just hold the nodes with BrowserMargin to spare") (let* ((window (slot-value self (quote window))) (region (il:windowprop window (quote il:region))) (nodes (il:|fetch| il:graphnodes il:|of| (il:windowprop window (quote il:graph)))) (min-width (il:iplus 5 (il:stringwidth (slot-value self (quote title)) (il:dspfont nil il:|WindowTitleDisplayStream|)))) (min-height (il:fontheight (il:dspfont nil window))) left bottom height width right top) (if nodes (progn (setq left (il:min/left nodes)) (setq bottom (il:min/bottom nodes)) (setq right (il:max/right nodes)) (setq top (il:max/top nodes)) (setq width (il:imax min-width (il:imin il:|MaxLatticeWidth| (il:widthifwindow (il:plus il:|BrowserMargin| (il:idifference right left)) (il:windowprop window (quote il:border)))))) (setq height (il:imax min-height (il:imin il:|MaxLatticeHeight| (il:plus il:|BrowserMargin| (il:idifference top bottom))))) (unless (and (il:eqp width (il:|fetch| il:width il:|of| region)) (il:eqp (il:heightifwindow height (il:windowprop window (quote il:title)) (il:windowprop window (quote il:border))) (il:|fetch| il:height il:|of| region))) (set-region self (il:createregion (il:|fetch| il:left il:|of| region) (il:|fetch| il:bottom il:|of| region) width height) nil))) (il:* il:|;;| "ELSE") (set-region self (il:createregion (il:|fetch| il:left il:|of| region) (il:|fetch| il:bottom il:|of| region) min-width min-height)))))

(defmethod get-display-label ((self web-editor) object) (il:* il:|;;;| "get the display label.  use the cache if it provides the answer;  if not, and maxLabelWidth is set, use it to compute the appropriate bit map and then cache the result.") (let ((cached-label (il:assoc object (slot-value self (quote label-cache))))) (if cached-label (cdr cached-label) (let ((new-label (box-print-string (get-label self object) (slot-value self (quote label-max-chars-width)) (slot-value self (quote label-max-lines)) (slot-value self (quote browse-font))))) (il:|if| (il:listp new-label) il:|then| (il:* il:\; "GRAPHER dies if the label is a list") (il:setq new-label (il:mkstring new-label))) (push (cons object new-label) (slot-value self (quote label-cache))) new-label))))

(defmethod box-node ((self web-editor) object keep-previous-box) (il:* il:\; " 8-Apr-87 18:34") "Puts a box around the node in the graph representing the object" (il:* il:|;;| "If there was a previously boxed node, remove the box from around it and set it to nil") (when (and (not keep-previous-box) destination-browser (slot-value destination-browser (quote boxed-node))) (highlight-node destination-browser (slot-value destination-browser (quote boxed-node)) (quote il:invert)) (setf (slot-value destination-browser (quote boxed-node)) nil)) (setq destination-browser self) (il:* il:\; "update the global") (highlight-node self object (slot-value self (quote box-line-width))) (setf (slot-value self (quote boxed-node)) object))

(defmethod unmark-nodes ((il:|self| web-editor)) (il:* il:\; "10-Dec-84 12:27") (il:* il:\; "clear the graph nodes, removing all shading and highlighting") (remove-highlights il:|self|) (remove-shading il:|self|))

(defmethod highlight-node ((self web-editor) object width shade) (il:* il:\; "13-Dec-85 15:16") (il:* il:|;;;| "highlight a node by surronding it with a shaded box") (let ((node (il:fassoc object (il:|fetch| il:graphnodes il:|of| (il:windowprop (slot-value self (quote window)) (quote il:graph)))))) (and node (display-node-hightlights self node shade width))))

(defmethod shade-node ((il:|self| web-editor) il:|object| il:|shade|) (il:* il:\; "15-Jan-87 18:34") (il:* il:|;;| "shade the background of a node") (let ((il:|node| (il:fassoc (cond ((il:litatom il:|object|) (il:setq il:|object| (il:|GetObjectRec| il:|object|))) (t il:|object|)) (il:|fetch| il:graphnodes il:|of| (il:windowprop (slot-value il:|self| (quote window)) (quote il:graph)))))) (il:|if| il:|node| il:|then| (il:|if| (il:bitmapp (il:|fetch| il:nodelabel il:|of| il:|node|)) il:|then| (il:* il:|;;| "Need to forget the old bitmap, in case it already has a shade blt'ed into it.  This will fail if the GetDisplayLabel msg returns something different from the previous value, but what can you do?") (clear-label-cache il:|self| il:|object|) (let ((il:|newLabel| (get-display-label il:|self| il:|object|))) (il:|replace| il:nodelabel il:|of| il:|node| il:|with| il:|newLabel|) (il:|if| (and il:|shade| (il:bitmapp il:|newLabel|)) il:|then| (il:bitblt nil nil nil il:|newLabel| nil nil nil nil (quote il:texture) (quote il:paint) il:|shade|)))) (display-node-shading il:|self| il:|node| il:|shade|))))

(defmethod display-node-hightlights ((self web-editor) node shade box-width) (il:reset/node/border node (cond (shade (list box-width shade)) (t box-width)) (slot-value self (quote window))))

(defmethod display-node-shading ((self web-editor) node shade) (il:* il:\; "13-Dec-85 15:13") (il:* il:\; "New method template") (il:reset/node/labelshade node (or shade il:whiteshade) (slot-value self (quote window))))

(defmethod remove-highlights ((il:|self| web-editor)) (il:* il:\; "13-Dec-85 15:16") (il:* il:|;;;| "gets rid of all highlighting in the lattice") (il:|for| il:|node| il:|in| (il:|fetch| il:graphnodes il:|of| (il:windowprop (slot-value il:|self| (quote window)) (quote il:graph))) il:|do| (display-node-hightlights il:|self| il:|node| nil)) (setf (slot-value il:|self| (quote boxed-node)) nil))

(defmethod remove-shading ((il:|self| web-editor)) (il:* il:\; "13-Dec-85 15:14") (il:* il:|;;;| "gets rid of all shading in the lattice") (il:|for| il:|node| il:|in| (il:|fetch| il:graphnodes il:|of| (il:windowprop (slot-value il:|self| (quote window)) (quote il:graph))) il:|do| (display-node-shading il:|self| il:|node| il:whiteshade)))

(defmethod flash-node ((il:|self| web-editor) il:|node| il:n il:|flashTime| il:|leaveFlipped?|) (il:* il:\; "12-Dec-84 16:09") (il:* il:\; "Flip node N times") (il:setq il:|node| (il:fassoc (cond ((il:litatom il:|node|) (il:setq il:|node| (il:|GetObjectRec| il:|node|))) (t il:|node|)) (il:|fetch| il:graphnodes il:|of| (il:windowprop (slot-value il:|self| (quote window)) (quote il:graph))))) (il:|if| il:|node| il:|then| (il:|for| il:\i il:|from| 1 il:|to| (or il:n 3) il:|do| (il:flipnode il:|node| (slot-value il:|self| (quote window))) (il:dismiss (or il:|flashTime| 300)) (il:flipnode il:|node| (slot-value il:|self| (quote window))) (il:dismiss (or il:|flashTime| 300))) (il:|if| il:|leaveFlipped?| il:|then| (il:flipnode il:|node| (slot-value il:|self| (quote window))))))

(defmethod flip-node ((self web-editor) object) (il:* il:\; "13-Dec-85 15:18") (il:* il:\; "Inverts the video around the node in the graph representing the object") (let ((node (il:fassoc object (il:|fetch| il:graphnodes il:|of| (il:windowprop (slot-value self (quote window)) (quote il:graph)))))) (and node (display-node-shading self node (il:inverted/shade/for/grapher (il:|fetch| il:nodelabelshade il:|of| node))))))

(defmethod position-node ((self web-editor) object window-x window-y) (il:* il:\; "10-Dec-84 18:24") (il:* il:|;;;| "scrolls the window so that the node is in the given position of the window.  If windowX or windowY is a FLOATP, it it taken to be a window-relative postion;  if a FIXP, it is a window-absolute position.") (let ((region (node-region self object))) (il:|if| region il:|then| (scroll-window self (il:|fetch| il:left il:|of| region) (il:|fetch| il:bottom il:|of| region) window-x window-y))))
(il:defineq

(box-print-string
(il:lambda (string max-chars-width max-lines font old-bitmap) (il:* il:\; "Edited 29-Jan-88 15:06 by Rao") (il:* il:|;;| "return a bitmap containing the string, in the given font, with MAX-WIDTH at most width") (il:* il:\; "sizes of NULL or 0 mean no max size") (il:setq max-chars-width (or max-chars-width 0)) (il:setq max-lines (or max-lines 0)) (il:|if| (il:zerop max-chars-width) il:|then| (il:* il:\; "no max width, then just return the STRING") string il:|else| (prog ((max-width (il:itimes max-chars-width (il:stringwidth "A" font))) (nchars (il:nchars string)) (nlines 0) (spos 0) (region (il:constant (il:|create| il:region))) (true-max-width 0) nextpos dsp substr) (il:setq string (il:mkstring string)) (il:* il:\; "we need to find the size of the resultant bitmap") il:nextbreak (il:|if| (il:ilessp spos nchars) il:|then| (il:|add| nlines 1) (il:* il:\; "at least one character, even if exceed MAX-WIDTH") (il:setq nextpos (il:imax 1 (car (break-string-for-boxing (il:substring string (il:add1 spos) -1) max-width font)))) (il:setq true-max-width (il:imax true-max-width (il:stringwidth (il:substring string (il:add1 spos) (il:iplus spos nextpos)) font))) (il:|add| spos nextpos) (go il:nextbreak)) (il:|if| (not (il:zerop max-lines)) il:|then| (il:setq nlines (il:imin max-lines nlines))) (il:* il:\; "that we have the size, lets build it") (il:setq dsp (il:dspcreate (il:|if| (and old-bitmap (not (or (il:greaterp true-max-width (il:bitmapwidth old-bitmap)) (il:greaterp (il:itimes nlines (il:fontprop font (quote il:height))) (il:bitmapheight old-bitmap))))) il:|then| old-bitmap il:|else| (il:bitmapcreate true-max-width (il:itimes nlines (il:fontprop font (quote il:height))))))) (il:dspfont font dsp) (il:dspreset dsp) (il:setq spos 0) (il:|replace| il:left il:|of| region il:|with| 0) (il:|replace| il:width il:|of| region il:|with| true-max-width) (il:|replace| il:height il:|of| region il:|with| (il:fontprop font (quote il:height))) (il:|replace| il:bottom il:|of| region il:|with| (il:itimes nlines (il:fontprop font (quote il:height)))) il:nextpiece (il:|add| nlines -1) (il:|if| (il:ilessp spos nchars) il:|then| (il:setq nextpos (il:imax 1 (car (break-string-for-boxing (il:substring string (il:add1 spos) -1) true-max-width font)))) (il:setq substr (il:substring string (il:add1 spos) (il:iplus nextpos spos))) (il:|replace| il:bottom il:|of| region il:|with| (il:idifference (il:|fetch| il:bottom il:|of| region) (il:|fetch| il:height il:|of| region))) (il:|if| (and (il:zerop nlines) (il:ilessp (il:iplus nextpos spos) nchars)) il:|then| (il:* il:\; "we need to abbreviate!") (il:centerprintinregion (il:concat (il:substring substr 1 -3) "...") region dsp) (go il:alldone) il:|else| (il:* il:\; "out this piece") (il:centerprintinregion substr region dsp) (il:|add| spos nextpos) (go il:nextpiece))) il:alldone (return (il:dspdestination nil dsp)))))
)

(break-string-for-boxing
(il:lambda (il:msg il:width il:font) (il:* il:\; "11-Dec-84 10:29") (il:* il:\; il:|Stolen| il:|from| il:|the| il:|function| il:iconw.formatline il:-- il:|modified| il:|to| il:|try| il:|to| il:|break| il:|at| "word" il:|boundaries,| il:|whatever| il:|they| il:|are|) (il:* il:\; il:\a il:|list| il:|of| il:|the| il:|char#| il:|relative| il:|to| il:|char| 1 il:|of| il:|where| il:|to| il:|break| il:|next| il:|line,| il:|and| il:|how| il:|much| il:|space| il:|was| left il:|over| (il:|for| il:|centering| il:&\c)) (cond (il:msg (il:* il:\; il:|there| il:|really| il:|is| il:\a il:|title,| il:|go| il:|ahead| il:|and| il:|format| il:|the| il:|next| il:|line.|) (il:|bind| (il:tx il:_ 0) (il:lastb il:_ 0) (il:ch il:_ 0) (il:tmsg il:_ (il:openstringstream il:msg)) (il:msglen il:_ (il:nchars il:msg)) il:|for| il:i il:|from| 1 il:|by| 1 il:|do| (il:* il:\; il:|thru| il:|the| il:|characters| il:|one| il:|by| il:|one.|) (cond ((il:igreaterp il:tx il:width) (il:* il:\; il:|past| il:|the| il:|right| il:|margin.| il:|Time| il:|to| il:|stop.|) (il:closef? il:tmsg) (return (cond ((il:listp il:lastb) (il:* il:\; il:|is| il:\a il:|space| il:|we| il:|can| il:|break| il:|the| il:|line| il:|at.| il:|Break| il:|there.|) il:lastb) (t (il:* il:\; il:|were| il:|no| il:|spaces| il:|on| il:|this| il:|line.| il:|Break| il:|after| il:|the| il:|last| il:|character| il:|that| il:|did| il:|fit.|) (cons (il:idifference il:i 2) (il:idifference il:width (il:idifference il:tx (il:charwidth il:ch il:font)))))))) ((il:eofp il:tmsg) (il:* il:\; il:|was| il:|the| il:|last| il:|character.|) (il:closef? il:tmsg) (return (cons (il:sub1 il:i) (il:idifference il:width il:tx)))) (t (il:* il:\; il:|at| il:|the| il:|next| il:|character.|) (il:setq il:ch (il:bin il:tmsg)) (il:selcharq il:ch ((il:space il:\. il:\: il:\; il:\, / il:\\ il:* - il:\#) (il:* il:\; il:|where| il:|word| il:|breaks| il:|are,| il:|so| il:|we| il:|can| il:|back| il:|up| il:|and| il:|split| il:|lines| il:|there| il:|if| il:|possible.|) (il:setq il:lastb (cons il:i (il:idifference il:width il:tx)))) (il:cr (il:* il:\; il:|forces| il:\a il:|new| il:|line.|) (return (cons (il:iminus il:i) (il:idifference il:width il:tx)))) (il:|if| (and (not (il:u-casep (il:character il:ch))) (not (il:eofp il:tmsg)) (il:u-casep (il:peekc il:tmsg))) il:|then| (il:* il:\; il:|from| il:|upper| il:|to| il:|lower| il:|case| il:|is| il:|also| il:\a il:|word| il:|break|) (il:setq il:lastb (cons il:i (il:idifference il:width il:tx))))) (il:setq il:tx (il:iplus il:tx (il:charwidth il:ch il:font))))))) (t (il:* il:\; il:|isn't| il:\a il:|title;| il:|return| il:\a il:|dummy| il:|entry| il:|for| il:|the| il:|line| il:|formatter.|) (cons 0 il:width))))
)

(box-window-node
(il:lambda (il:|nodeLabel| window) (il:* il:\; "Edited 29-Jan-88 11:31 by Rao") (il:* il:\; " 7-Sep-84 14:36") (il:* il:|;;| "a box around the node with nodeLabel in the graph.  A nodeLabel in browsers is an object.  Does nothing if node not found.") (prog (il:|node| il:|nodes|) (cond ((and (il:windowp window) (il:setq il:|nodes| (il:|fetch| il:graphnodes il:|of| (il:windowprop window (quote il:graph)))) (il:setq il:|node| (il:fassoc il:|nodeLabel| il:|nodes|))) (il:drawareabox (il:gn/left il:|node|) (il:gn/bottom il:|node|) (il:|fetch| il:nodewidth il:|of| il:|node|) (il:|fetch| il:nodeheight il:|of| il:|node|) 1 (quote il:invert) window)))))
)
)



(il:* il:\; "Button Events")

(il:defineq

(find-selected-node
(il:lambda (window) (il:* il:\; "Edited 12-Nov-87 01:30 by Rao") (il:* il:\; "10-Dec-84 17:53") (il:* il:|;;| "Used in BUTTONEVENTFN and gets called whenever cursor moves or button is down.  Adapted from APPLYTOSELECTEDNODE in GRAPHER package;  returns the selected item rather than applying a function on the inside of the button event fn.") (il:* il:|;;| "Also this was modified to pop up the middle button menu on button down rather than button up.") (prog ((loops-window (il:windowprop window (quote web-editor))) (nodelst (il:|fetch| (il:graph il:graphnodes) il:|of| (il:windowprop window (quote il:graph)))) (ds (il:windowprop window (quote il:dsp))) button oldpos reg now near) (il:* il:\; "note which button is down.") (il:* il:\; "get the region of this window.") (il:setq reg (il:windowprop window (quote il:region))) (il:|until| (il:lastmousestate (or il:left il:middle)) il:|do| (il:getmousestate)) (il:setq near (il:nodelst/as/menu nodelst (il:setq oldpos (il:cursorposition nil ds)))) il:flip (il:* il:|;;| "This is kirk's quick hack to get middle button to bring up immediately.") (when (il:lastmousestate il:middle) (return (il:|fetch| il:nodeid il:|of| near))) (and now (il:flipnode now ds)) (and near (il:flipnode near ds)) (il:setq now near) il:lp (il:* il:\; "wait for a button up or move out of region") (il:getmousestate) (cond ((il:lastmousestate (and (not il:left) (not il:middle))) (il:* il:\; "left button up, process it.") (and now (il:flipnode now ds)) (il:* il:\; "NOW node has been selected.") (return (il:|fetch| il:nodeid il:|of| now))) ((not (il:inside? (il:windowprop window (quote il:region)) il:lastmousex il:lastmousey)) (il:* il:\; "outside of region, return") (and now (il:flipnode now ds)) (return)) ((eq now (il:setq near (il:nodelst/as/menu nodelst (il:cursorposition nil ds oldpos)))) (go il:lp)) (t (go il:flip)))))
)
)

(defmethod button-event-fn ((self web-editor)) (il:* il:\; " 2-Jan-86 16:41") (il:* il:\; "Called when there is a button event in a Loops Window") (let ((window (slot-value self (quote window)))) (or (il:ersetq (cond ((null (il:insidep (il:dspclippingregion nil window) (il:lastmousex window) (il:lastmousey window))) (title-selection self)) ((il:mousestate il:left) (left-selection self)) ((il:mousestate il:middle) (middle-selection self)) ((il:mousestate il:right) (right-selection self)))))))

(defmethod left-selection ((self web-editor)) (if (move-down-p) (if (slot-value self (quote node-mover-p)) (node-move self) (node-move-shallow self)) (node-selection self (quote il:left))))

(defmethod middle-selection ((self web-editor)) (il:* il:\; "15-May-85 19:04") (il:* il:|;;| "This function called from the GRAPHER package when a node is selected with the middle mouse button.  If no node is selected then just returns.") (prog (selection object (window (slot-value self (quote window))) (web-editor self)) (declare (il:specvars object web-editor)) (cond ((null (il:setq object (find-selected-node window))) (return))) (setf (slot-value web-editor (quote last-selected-object)) object) (il:getmousestate) (flip-node self object) (il:setq selection (or (node-action self object (quote il:middle)) (progn (flip-node self object) (return nil)))) (flip-node self object) (do-selected-command web-editor selection object)))

(defmethod right-selection ((self web-editor)) (il:* il:\; "17-Apr-84 15:46") (il:* il:\; "Do RightButtonItems on selection.") (let* ((choice (choice-menu self (quote right-button-items)))) (if choice (funcall choice self))))

(defmethod title-selection ((self web-editor)) (il:* il:\; "17-Apr-84 15:35") (il:* il:|;;| " Do TitleItems if selected in title area.  Replaces TitleSelection in Window because this one does evaluation in TTY process, and saves events on history") (let* ((choice (choice-menu self (quote title-items)))) (if choice (funcall choice self))))

(defmethod node-selection ((self web-editor) button) (let* ((window (slot-value self (quote window))) (object (find-selected-node window))) (declare (il:specvars object)) (il:* il:\; "SPECVARS for whenHeldFn") (if (listp object) (setq object (car object))) (cond ((not (null object)) (setf (slot-value self (quote last-selected-object)) object))) (il:getmousestate) (when object (let ((selector (node-action self object button))) (cond (selector (do-selected-command self selector object)))))))

(defmethod node-action ((self web-editor) node button) (il:* il:\; " 8-Apr-87 17:11") (declare (il:specvars window-for-menu)) (let ((window-for-menu self)) (il:getmousestate) (choice-menu self (il:* il:|;;| " A Hook for letting nodes tailor menu items.") (node-menu-items node button))))

(defmethod node-menu-items ((node web-node) button) (case button (il:left (quote left-button-items)) (il:middle (quote middle-button-items))))

(defmethod choice-menu ((self web-editor) item-cv) (il:* il:\; "29-Dec-85 13:54") (il:* il:|;;| "Create a menu which allows subitems to be displayed.  Cache it in  the web-editor ") (let (items menu) (setq menu (rest (assoc item-cv (slot-value self (quote menu-cache))))) (cond ((and menu (il:type? il:menu menu)) (il:menu menu)) ((not (listp (setq items (get-menu-items self item-cv)))) items) (t (il:setq menu (il:create il:menu il:items il:_ items il:menuoffset il:_ (il:createposition -1 0) il:whenselectedfn il:_ (quote web-menu-whenselectedfn) il:whenheldfn il:_ (quote window-when-held-fn) il:changeoffsetflg il:_ t il:centerflg il:_ t)) (il:* il:\; "Cache menu if menus is T") (if (slot-value self (quote cache-menu-p)) (setf (slot-value self (quote menu-cache)) (acons item-cv menu (slot-value self (quote menu-cache))))) (il:menu menu)))))

(defmethod do-selected-command ((web-editor web-editor) command obj &optional node) (il:* il:\; "17-Sep-86 17:49") (il:* il:|;;| "Do the selected command or forwards it to the object") (if command (il:* il:|;;| "Take care of being passed in a dummy node from browser in Lattice mode.  --- Dummy nodes are indicated by having the object in a list") (let ((args (if (il:listp command) (cdr command) nil)) (command (if (il:listp command) (car command) command)) (obj (if (il:listp obj) (car obj) obj))) (when (il:fmemb command (slot-value web-editor (quote local-commands))) (setq args (cons obj args)) (setq obj web-editor)) (il:* il:|;;| "Grays out the node at the beginning of the command, and ungrays it when the command completes.") (setq node obj) (if node (progn (shade-node web-editor node il:grayshade2) (apply command obj args) (shade-node web-editor node il:whiteshade)) (apply command obj args)))))

(defmethod when-menu-item-held ((self web-editor) item menu key) (il:* il:\; " 8-Apr-87 17:13") (il:* il:|;;;| "What to do when the menu item is held") (il:promptprint (or (cond ((il:nlistp item) nil) (t (caddr item))) "When released this item will be selected")))

(defmethod item-menu ((self web-editor) items title) (il:* il:\; "21-Apr-84 09:31") (il:* il:\; "Create a simnple (one level) menu which will not overflow height of screen") (il:|create| il:menu il:items il:_ items il:menucolumns il:_ (il:add1 (il:iquotient (il:itimes (il:fontheight il:menufont) (il:length items)) 750)) il:title il:_ title il:changeoffsetflg il:_ t))

(defmethod get-menu-items ((self web-editor) item-cv) (il:* il:\; "23-Oct-84 12:36") (il:* il:\; "Get item list for menu") (slot-value self item-cv))

(defmethod clear-menu-cache ((self web-editor)) (il:* il:\; "11-Apr-86 14:46") (il:* il:\; "Delete Menus saved on menus") (setf (slot-value self (quote menu-cache)) nil) self)
(il:defineq

(web-menu-whenselectedfn
(il:lambda (item menu button) (il:* il:\; "Edited 14-Jul-87 17:43 by Rao") (il:* il:\; "13-DEC-83 21:03") (prog (second-element) (return (cond ((il:nlistp item) item) ((il:nlistp (il:setq second-element (cadr item))) second-element) ((eq (car second-element) (quote progn)) (il:eval second-element)) (t second-element)))))
)

(window-when-held-fn
(lambda (item menu key) (il:* il:\; "Edited  9-Jul-87 11:58 by Rao") (il:* il:\; "29-Dec-85 15:28") (il:* il:\; "Send to window the message to respond to time out on menu") (declare (il:specvars window-for-menu)) (when-menu-item-held window-for-menu item menu key))
)
)
(il:defineq

(sub-item-selection
(il:lambda (item menu button) (il:* il:\; "Edited 14-Jul-87 17:13 by Rao") (il:* il:\; "13-DEC-83 21:03") (il:* il:|;;| "menu WHENSELECTEDFN which allows differential selection on LEFT and middle button.  For such differential selection item should be of form --- (itemSeenInMenu (leftValue midValue)) --- where midValue can be an atom which is directly returned when item is selected with middle, or midValue can be an itemList, which will be displayed in a subselection menu") (prog (it it1) (return (cond ((il:nlistp item) item) ((il:nlistp (il:setq it (cadr item))) it) ((eq (il:setq it1 (car it)) (quote quote)) (cadr it)) ((eq it1 (quote progn)) (il:eval it)) ((il:listp it1) (il:eval it1)) (t it1)))))
)

(dual-sub-items
(il:lambda (menu item) (il:* il:\; "Edited 14-Jul-87 17:14 by Rao") (il:* il:\; "13-DEC-83 21:07") (il:* il:|;;| "menu WHENSELECTEDFN which allows differential selection on LEFT and middle button.  For such differential selection item should be of form --- (itemSeenInMenu (leftValue midValue)) --- where midValue can be an atom which is directly returned when item is selected with middle, or midValue can be an itemList, which will be displayed in a subselection menu") (prog (it it1) (return (cond ((or (il:nlistp item) (il:nlistp (il:setq it (cadr item))) (eq (il:setq it1 (car it)) (quote quote)) (eq it1 (quote progn)) (il:nlistp (il:setq it1 (cadr it)))) nil) (t it1)))))
)

(window-when-held-fn
(lambda (item menu key) (il:* il:\; "Edited  9-Jul-87 11:58 by Rao") (il:* il:\; "29-Dec-85 15:28") (il:* il:\; "Send to window the message to respond to time out on menu") (declare (il:specvars window-for-menu)) (when-menu-item-held window-for-menu item menu key))
)

(do-menu-method
(il:lambda (object items) (il:* il:\; "Edited 14-Jul-87 17:15 by Rao") (il:* il:\; "13-NOV-83 16:20") (prog ((selector (and items (dual-menu items)))) (and selector (return (funcall selector object)))))
)

(dual-menu
(il:lambda (items when-held-fn) (il:* il:\; "Edited 14-Jul-87 17:16 by Rao") (il:* il:\; " 9-FEB-84 16:17") (il:* il:\; "and pops up a menu which allows differential selection on LEFT an middle buttons") (il:menu (il:|create| il:menu il:items il:_ items il:whenselectedfn il:_ (quote sub-item-selection) il:subitemfn il:_ (quote dual-sub-items) il:whenheldfn il:_ when-held-fn il:changeoffsetflg il:_ t)))
)

(dual-selection
(il:lambda (item menu button) (il:* il:\; "Edited 14-Jul-87 17:28 by Rao") (il:* il:\; "29-MAR-83 17:57") (il:* il:|;;| "MENU WHENSELECTEDFN which allows differential selection on LEFT and middle button.  For such differential selection ITEM should be of form --- (itemSeenInMenu (leftValue midValue)) --- where midValue can be an atom which is directly returned when ITEM is selected with middle, or midValue can be an itemList, which will be displayed in a subselection MENU") (prog (it it1) (return (cond ((il:nlistp item) item) ((il:nlistp (il:setq it (cadr item))) it) ((eq (il:setq it1 (car it)) (quote quote)) (cadr it)) ((eq it1 (quote progn)) (il:eval it)) ((eq button (quote il:left)) (cond ((il:listp it1) (il:eval it1)) (t it1))) ((il:nlistp (il:setq it1 (cadr it))) it1) (t (dual-menu it1))))))
)
)



(il:* il:\; "Node Moving Protocol")


(defmethod node-move ((self web-editor)) (let ((old-regions (make-reg-assoc self)) new-regions moved-pair new-father closest-pair) (node-move-shallow self) (setq new-regions (make-reg-assoc self)) (setq moved-pair (il:|for| |npair| il:|in| new-regions il:|as| |opair| il:|in| old-regions il:|thereis| (not (il:equal (car |opair|) (car |npair|))))) (when (and moved-pair (il:* il:|;;| "The moved guy has a parent") (slot-value (cdr moved-pair) (quote parent))) (il:dremove moved-pair new-regions) (setq new-regions (il:* il:|;;| "Collect the pairs that havn't changed.") (il:|bind| (scions-of-moved il:_ (scions (cdr moved-pair))) il:|for| pair il:|in| new-regions il:|unless| (il:member (cdr pair) scions-of-moved) il:|collect| pair)) (setq closest-pair (il:|bind| (\b il:_ (il:|fetch| il:bottom il:|of| (car moved-pair))) (\l il:_ (il:|fetch| il:left il:|of| (car moved-pair))) il:|for| |pair| il:|in| new-regions il:|smallest| (il:plus (abs (il:idifference (il:|fetch| il:bottom il:|of| (car |pair|)) \b)) (abs (il:idifference (il:|fetch| il:left il:|of| (car |pair|)) \l))))) (il:* il:|;;| "Either make moved node a sibling or a child of the node it is now closest to.") (il:|if| (il:igreaterp (il:idifference (il:|fetch| il:left il:|of| (car moved-pair)) (il:|fetch| il:left il:|of| (car closest-pair))) 15) il:|then| (il:setq new-father (cdr closest-pair)) il:|else| (il:setq new-father (or (slot-value (cdr closest-pair) (quote parent)) (cdr closest-pair)))) (move-node (cdr moved-pair) new-father) (reorder-tree self new-father)) (recompute self)))

(defmethod node-move-shallow ((self web-editor)) (il:* il:|;;| "Just moves the node graphically with no deep impact") (let ((window (slot-value self (quote window)))) (il:resetlst (il:resetsave nil (list (il:function il:dspoperation) (il:dspoperation (quote il:invert) window) window)) (il:getmousestate) (il:* il:\; "Here to move a node.") (il:dspoperation (quote il:invert) window) (il:editmovenode window))))

(defmethod scions ((self web-node)) (il:* il:\; "14-Nov-86 03:01") (il:* il:\; "Used by the Node Mover") (let ((to-links (get-to-links self))) (append to-links (il:|for| il:|child| il:|in| to-links il:|join| (scions il:|child|)))))

(defmethod make-reg-assoc ((self web-editor)) (il:* il:\; "14-Nov-86 02:08") (il:* il:\; "Ho hum") (il:|for| x il:|in| (slot-value self (quote starting-list)) il:|collect| (cons (node-region self x) x)))

(defmethod reorder-tree ((self web-editor) root) (il:* il:\; "14-Nov-86 02:35") (let ((children (get-to-links root))) (if children (il:sort children (function (il:lambda (c1 c2) (let ((r1 (node-region self c1)) (r2 (node-region self c2))) (il:lessp (il:|fetch| il:bottom il:|of| r1) (il:|fetch| il:bottom il:|of| r2)))))))))

(defmethod move-node ((self web-node) new-parent) (il:* il:\; "29-Jan-87 17:55") (let ((old-parent (slot-value self (quote parent)))) (unless (eq old-parent new-parent) (setf (slot-value self (quote parent)) new-parent) (setf (slot-value old-parent (quote to-links)) (il:dremove self (slot-value old-parent (quote to-links)))) (setf (slot-value new-parent (quote to-links)) (il:nconc1 (slot-value new-parent (quote to-links)) self)) t)))



(il:* il:\; "")




(il:* il:|;;| "")

(il:declare\: il:donteval@load il:doeval@compile il:dontcopy il:compilervars 

(il:addtovar il:nlama)

(il:addtovar il:nlaml)

(il:addtovar il:lama window-when-held-fn window-when-held-fn web-window-expand-fn web-window-reshape-fn web-window-button-event-fn web-window-after-move-fn)
)
(il:putprops il:web-editor il:copyright ("Xerox Corporation" 1987 1988))
(il:declare\: il:dontcopy
  (il:filemap (nil (31598 33405 (web-window-after-move-fn 31611 . 31860) (web-window-button-event-fn 
31862 . 32150) (web-window-reshape-fn 32152 . 32502) (web-window-close-fn 32504 . 32689) (
il:|PromptRead| 32691 . 33403)) (33406 33701 (web-window-expand-fn 33419 . 33699)) (37122 40689 (
tree-roots 37135 . 39509) (child-nodes 39511 . 39917) (reachable-nodes! 39919 . 40687)) (57650 63961 (
box-print-string 57663 . 60565) (break-string-for-boxing 60567 . 63283) (box-window-node 63285 . 63959
)) (63999 65899 (find-selected-node 64012 . 65897)) (71549 72211 (web-menu-whenselectedfn 71562 . 
71915) (window-when-held-fn 71917 . 72209)) (72212 75438 (sub-item-selection 72225 . 72959) (
dual-sub-items 72961 . 73661) (window-when-held-fn 73663 . 73955) (do-menu-method 73957 . 74181) (
dual-menu 74183 . 74605) (dual-selection 74607 . 75436)))))
il:stop
