;;;-*-Mode:LISP; Package:(PCL LISP 1000); Base:10; Syntax:Common-lisp -*-
;;;
;;; *************************************************************************
;;; Copyright (c) 1985, 1986, 1987, 1988 Xerox Corporation.
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Xerox Corporation makes no
;;; warranty about the software, its performance or its conformity to any
;;; specification.
;;; 
;;; Any person obtaining a copy of this software is requested to send their
;;; name and post office or electronic mail address to:
;;;   CommonLoops Coordinator
;;;   Xerox PARC
;;;   3333 Coyote Hill Rd.
;;;   Palo Alto, CA 94304
;;; (or send Arpanet mail to CommonLoops-Coordinator.pa@Xerox.arpa)
;;;
;;; Suggestions, comments and requests for improvements are also welcome.
;;; *************************************************************************
;;;

(in-package 'pcl)

(defvar *early-defclass-forms*
  '(

    (defclass t () ())

    (defclass object (t) ())

    (defclass class (object) ())

    (defclass standard-class (class)
	 ((name
	    :initform nil
	    :accessor class-name)
	  (class-precedence-list
	    :initform (list *the-class-object* *the-class-t*)
	    :accessor class-precedence-list
	    :accessor class-class-precedence-list)
	  (local-supers
	    :initform ()
	    :accessor class-local-supers)
	  (local-slots
	    :initform ()
	    :accessor class-local-slots)
	  (direct-subclasses
	    :initform ()
	    :accessor class-direct-subclasses)
	  (direct-methods
	    :initform ()
;	    :accessor class-direct-methods        ;This is defined by hand
	                                          ;during bootstrapping.
	    )
	  (forward-referenced-supers
	    :initform ()
	    :accessor class-forward-referenced-supers)
	  (no-of-instance-slots
	    :initform 0
	    :accessor class-no-of-instance-slots)
	  (slots
	    :initform ()
	    :accessor class-slots)
	  (wrapper
	    :initform nil
	    :accessor class-wrapper)
	  (direct-generic-functions
	    :initform ())			;Reader for this is defined
						;by hand.
						;There is no writer for this
						;since this value is derived
						;from direct-methods.
	  (prototype
	    :initform nil)
	  (options
	    :initform ()
	    :accessor class-options)
	  (constructors
	    :initform ()
	    :accessor class-constructors)
	  
	  (all-default-initargs
	    :initform ()
	    :accessor class-all-default-initargs)))

    (defclass standard-slot-description (object)
	 ((name
	    :initform nil
;	    :accessor slotd-name                ;This is defined by hand
						;during bootstrapping.
	    )
	  (keyword
	    :initform nil
	    :accessor slotd-keyword)
	  (initform
	    :initform *slotd-unsupplied*
	    :accessor slotd-initform)
	  (initfunction
	    :initform *slotd-unsupplied*
	    :accessor slotd-initfunction)
	  (readers
	    :initform nil
	    :accessor slotd-readers)
	  (writers
	    :initform nil
	    :accessor slotd-writers)
	  (initargs
	    :initform nil
	    :accessor slotd-initargs)
	  (allocation
	    :initform nil
	    :accessor slotd-allocation)
	  (type
	    :initform nil
	    :accessor slotd-type)
	  (documentation
	    :initform ""
	    :accessor slotd-documentation)))
      

    ))

(defvar *fsc-defclass-forms*
  '((defclass funcallable-standard-class (standard-class)
      ())))

(defvar *methods-defclass-forms*
  '(
    
      
    (defclass standard-method ()
	 ((function
	    :initform nil
	    :reader method-function)
	  (generic-function
	    :initform nil
	    :accessor method-generic-function)
	  (type-specifiers
	    :initform ()
	    :accessor method-type-specifiers)
	  (arglist
	    :initform ()
	    :accessor method-arglist)
	  (qualifiers
	    :initform ()
	    :accessor method-qualifiers)
	  (documentation
	    :initform nil
	    :accessor method-documentation)))

    (defclass standard-reader/writer-method (standard-method)
	 ((slot-name :initform nil))
      ;; There is a hand coded reader method for this which appears
      ;; in the beginning of methods.  See the comment there.
      ;(:reader-prefix reader/writer-method)
      )

    (defclass standard-reader-method (standard-reader/writer-method) ())
    (defclass standard-writer-method (standard-reader/writer-method) ())
    
    (defclass standard-generic-function ()
        ((name
	   :initform nil
	   :accessor generic-function-name)
	 (methods
	   :initform ()
	   :accessor generic-function-methods)
	 (discriminator-code
	   :initform ()
	   :accessor generic-function-discriminator-code)
	 (classical-method-table
	   :initform nil
	   :accessor generic-function-classical-method-table)
	 (combined-methods
	   :initform nil
	   :accessor generic-function-combined-methods)
	 (cache
	   :initform ()
	   :accessor generic-function-cache)
	 (pretty-arglist
	   :initform ()
	   :accessor generic-function-pretty-arglist)
	 (method-class
	   :initform (find-class 'standard-method)
	   :accessor generic-function-method-class)
	 (dispatch-order
	   :initform :default
	   :accessor generic-function-dispatch-order)
	 )
      (:metaclass funcallable-standard-class))
    
    ))


;;;
;;; Convert a function name to its standard setf function name.  We don't
;;; use non-symbolic "function-specs" yet because we keep hoping they will
;;; go away.
;;;
(eval-when (compile load eval)

(defvar *setf-function-names* (make-hash-table :size 200 :test #'eq))

(defun get-setf-function-name (name)
  (or (gethash name *setf-function-names*)
      (setf (gethash name *setf-function-names*)
	    (intern (let ((*package* *the-pcl-package*)
			  (*print-case* :upcase)
			  (*print-gensym* 't))
		      (format nil "~A ~S" 'setf name))
		    *the-pcl-package*))))

);eval-when

;;;
;;; Call this to define a setf macro for a function with the same behavior as
;;; specified by the SETF function cleanup proposal.  Specifically, this will
;;; cause: (SETF (FOO a b) x) to expand to (|SETF FOO| x a b).
;;;
;;; do-standard-defsetf is a macro interface for use at top-level in files.
;;; do-standard-defsetf-1 is a functional interface.
;;; 

(defmacro do-standard-defsetf (function-name)
  (let ((setf-function-name (get-setf-function-name function-name)))
    #-TI
    `(defsetf ,function-name (&rest accessor-args) (new-value)
       `(,',setf-function-name ,new-value ,@accessor-args))
    #+TI
    `(define-setf-method ,function-name (&rest accessor-args)
       (let ((tempvars (mapcar #'(lambda (ignore) (gensym)) accessor-args))
	     (storevar (gensym)))
	 (values tempvars
		 accessor-args
		 (list storevar)
		 `(,',setf-function-name ,storevar ,@tempvars)
		 `(,',function-name ,@tempvars))))))

(defun do-standard-defsetf-1 (generic-function-name)
  (let* ((setf-name (get-setf-function-name generic-function-name)))
    (do-defsetf generic-function-name
		'(&rest accessor-args)	      
		'(new-value)
		``(,',setf-name ,new-value ,@accessor-args))))

(defun do-defsetf (access store-or-args &optional store-vars &rest body)
  (let #+Genera ((si:inhibit-fdefine-warnings t))
       #-Genera ()
    #+Lispm (setq body (copy-list body))
    (if body
	(eval #-TI
	      `(defsetf ,access ,store-or-args ,store-vars ,@body)
	      #+TI ; assume store-or-args is (&rest accessor-args)
	      `(define-setf-method ,access ,store-or-args
		 (let ((tempvars (mapcar #'(lambda (ignore) (gensym))
					 ,(second store-or-args)))
		       (storevar (gensym)))
		   (values tempvars
			   ,(second store-or-args)
			   (list storevar)
			   (let ((,(first store-vars) storevar)
				 (,(second store-or-args) tempvars))
			     ,@body)
			   `(,',access ,@tempvars)))))
	(eval `(defsetf ,access ,store-or-args)))))


;;;
;;; Random defsets that will be able to go away once the cleanup proposal
;;; to standardize a default behavior for setf is implemented.
;;;
(defmacro do-standard-defsetfs (&rest function-names)
  `(progn ,.(mapcar #'(lambda (fn) `(do-standard-defsetf ,fn))
		    function-names)))

(do-standard-defsetfs method-function-plist
		      method-function-get
		      get-setf-function
		      gdefinition
		      class-options
		      class-instance-slots
		      slotd-name
		      slot-value--std
		      slot-value--fsc
		      slot-value-using-class
		      )


;;;
;;; make-setf-method-lambda-list is used by any part of PCL that has to
;;; construct the lambda-list of a setf-method from an access lambda list
;;; and a new value lambda list.  This function is not a documented part
;;; part of CLOS, because it is so simple, but it is a documented part of
;;; PCL because of the error-checking it provides.
;;; 
(defun make-setf-method-lambda-list (access-lambda-list new-value-lambda-list)
  (when (or (cdr new-value-lambda-list)
	    (memq (car new-value-lambda-list) lambda-list-keywords))
    (error "The new-value lambda-list is only allowed to contain one~%~
            argument, and it must be a required argument.~%~
            The new-value lambda-list ~S is illegal."
	   new-value-lambda-list))
  (append new-value-lambda-list access-lambda-list))



;;;
;;; This is like fdefinition on the Lispm.  If Common Lisp had something like
;;; function specs I wouldn't need this.  On the other hand, I don't like the
;;; way this really works so maybe function specs aren't really right either?
;;; 
;;; I also don't understand the real implications of a Lisp-1 on this sort of
;;; thing.  Certainly some of the lossage in all of this is because these
;;; SPECs name global definitions.
;;;
;;; Note that this implementation is set up so that an implementation which
;;; has a 'real' function spec mechanism can use that instead and in that way
;;; get rid of setf generic function names.
;;;
(defmacro parse-gspec (spec
		       (non-setf-var . non-setf-case)
		       (setf-var . setf-case))
  (declare (indentation 1 1))
  (once-only (spec)
    `(cond ((symbolp ,spec)
	    (let ((,non-setf-var ,spec)) ,@non-setf-case))
	   ((and (listp ,spec)
		 (eq (car ,spec) 'setf)
		 (symbolp (cadr ,spec)))
	    (let ((,setf-var (cadr ,spec))) ,@setf-case))
	   (t
	    (error "Can't understand ~S as a generic function specifier.~%~
                    It must be either a symbol which can name a function or~%~
                    a like ~S, where the car is the symbol ~S and the cadr~%~
                    is a symbol which can name a generic function."
		   ,spec '(setf <foo>) 'setf)))))


(defun gboundp (spec)
  (parse-gspec spec
    (name (fboundp name))
    (name (fboundp (get-setf-function-name name)))))

(defun gmakunbound (spec)
  (parse-gspec spec
    (name (fmakunbound name))
    (name (fmakunbound (get-setf-function-name name)))))

(defun gdefinition (spec)
  (parse-gspec spec
    (name (or (macro-function name)		;??
	      (symbol-function name)))
    (name (symbol-function (get-setf-function-name name)))))

(defun SETF\ GDEFINITION (new-value spec)
  (parse-gspec spec
    (name (setf (symbol-function name)
		new-value))
    (name (setf (symbol-function (get-setf-function-name name))
		new-value))))

(defun get-setf-function (name)
  (gdefinition `(setf ,name)))

(defun SETF\ GET-SETF-FUNCTION (new-value name)
  (setf (gdefinition name) new-value))



(defun do-satisfies-deftype (name predicate)
  (let* ((specifier `(satisfies ,predicate))
	 (expand-fn #'(lambda (&rest ignore)
			(declare (ignore ignore))
			specifier)))
    ;; Specific ports can insert their own way of doing this.  Many
    ;; ports may find the expand-fn defined above useful.
    ;;
    (or #+:Genera
	(setf (get name 'deftype) expand-fn)
	#+(and :Lucid (not :Prime))
	(system::define-macro `(deftype ,name) expand-fn nil)
	#+ExCL
	(setf (get name 'excl::deftype-expander) expand-fn)
	#+:coral
	(setf (get name 'ccl::deftype-expander) expand-fn)

	;; This is the default for ports for which we don't know any
	;; better.  Note that for most ports, providing this definition
	;; should just speed up class definition.  It shouldn't have an
	;; effect on performance of most user code.
	(eval `(deftype ,name () '(satisfies ,predicate))))))

(defun make-type-predicate-name (class-name)
  (symbol-append class-name " predicate" (symbol-package class-name)))


;;;
;;; Do the defsetfs for accessors defined by defclass's in the bootstrap.
;;; These have to be here because we want to be able to compile setfs of
;;; calls to those accessors before we have actually been able to evaluate
;;; those defclass forms.
;;;
(defun define-early-setfs-and-type-predicates ()
  (dolist (forms-var '(*early-defclass-forms*
		       *fsc-defclass-forms*
		       *methods-defclass-forms*))
    (dolist (defclass (eval forms-var))
      (destructuring-bind (ignore name supers slots . options)
			  defclass
	(unless (eq name 't)
	  (do-satisfies-deftype name (make-type-predicate-name name)))
	
	(dolist (slot slots)
	  (let ((slot-options (cdr slot)))
	    (loop (when (null slot-options) (return t))
		  (when (eq (car slot-options) ':accessor)
		    (do-standard-defsetf-1 (cadr slot-options)))
		  (setq slot-options (cddr slot-options)))))

	(dolist (option options)
	  (when (and (listp option)
		     (eq (car option) :accessor-prefix))
	    (setq option (cadr option))
	    (dolist (slot slots)
	      (if (null option)
		  (do-standard-defsetf-1 (car slot))
		  (do-standard-defsetf-1
		    (symbol-append (symbol-name option)
				   (symbol-name (car slot))))))))))))


(eval-when (load eval)
  (define-early-setfs-and-type-predicates))

;;;
;;; Extra little defsetfs which we need now.
;;; 

(defsetf slot-value set-slot-value)

(defsetf slot-value-always (object slot-name &optional default) (new-value)
  `(put-slot-always ,object ,slot-name ,new-value))


(defvar *the-class-t*)
(defvar *the-class-object*)

(pushnew 'class *variable-declarations*)
(pushnew 'variable-rebinding *variable-declarations*)

(defun variable-class (var env)
  (caddr (variable-declaration 'class var env)))


;;;
;;; This is used by combined methods to communicate the next methods to
;;; the methods they call.  This variable is captured by a lexical variable
;;; of the methods to give it the proper lexical scope.
;;; 
(defvar *next-methods* nil)




