;;
;;
;;      Title : Dictionary Command Interpreter
;;
;;      Function : This is a command interpreter to the dictionary
;;                 and analyser functions
;;
;;      Author :  Alan W Black  November 1985
;;                Dept of Artificial Intelligence
;;                University of Edinburgh
;;
;;      Copyright Graeme Ritchie, Alan Black,
;;                Steve Pulman and Graham Russell  1987
;;
;;         ---------------------------------------------
;;         |    Not to be used for military purposes   |
;;         ---------------------------------------------
;;
;;      Description :
;;         This is designed as a UNIX level command, although written
;;         in lisp the user should be unaware of that fact.  For
;;         details of the usage of the interpreter see the latest version
;;         of the user document "Dictionary and Morphological Analyser" 
;;
;;      Parameters :
;;      Returns :
;;      Side Effect :
;;
;;      External references :
;;
;;      System functions used :
;;        Name     type      Args #  type                 Comment
;;
;;      Restrictions :
;;         Note that "usemap" must be changed to 'usemap when this
;;         file is compiled on opus 37.85
;;

(declare
   (special
      $ldprint
   )
)

(princ "Loading in system")
(terpri)
(include "keywords")

(let ( (usemap (assoc (DK-USEMAP) environment)) )
   (cond
      ((null usemap)   ;;  usemap variable not set
	 nil
      )
      (t               ;; add usemap to search path
         (eval (list 'sstatus 'load-search-path
                   (append
	              (list (cdr usemap))
	              (status load-search-path))))
      )
   )
)
(include "morphan.l")  ;; the command interpreter

(defun top-level ()
(setq $ldprint nil)    ;; no loading info
   (cond
      ((eq (argv -1) 4)   ;; if one parmater is given it is a directory
         (D-Start (argv 3))
      )
      (t                  ;; zero or more than 1 param just load without 
         (D-Start)        ;; specify a directory
      )
   )
   (exit)        ;; exit from lisp too
)

(reset)
