
;;
;;   Example spelling rule set
;;
;;   For use in the term unification analyser
;;

SurfaceAlphabet
        { a b c d e f g h i j k l m n o p q r s t u v w x y z }
SurfaceSets
        C is { b c d f g h j k l m n p q r s t v w x z }
        CC is { b d f h j k l m n p q r s t v w x y z }
        NA is { b c d e f g h j k l m n o p q r s t u v w x y z }
        S is { s x z }
        V is { a e i o u }
        = is { a b c d e f g h i j k l m n o p q r s t u v w x y z }
LexicalAlphabet      ;; comments can appear if required
        { a b c d e f g h i j k l m n o p q r s t u v w x y z + }
LexicalSets
        C is { b c d f g h j k l m n p q r s t v w x z }
        NA is { b c d e f g h j k l m n o p q r s t u v w x y z + } 
        S is { s x z }
        V is { a e i o u }
        = is { a b c d e f g h i j k l m n o p q r s t u v w x y z + } 
DefaultPairs
        +:0 e:0    ;; actually not necessary in this description
Rules

Epenthesis
        +:e   <=>  { < s:s h:h > S:S y:i }  ---  s:s
                or  < c:c h:h > --- s:s
Gemination
        +:X  <=>  < V:V =:X > --- V:V
                where X in { b d f g l m n p r s t }
Y-replacement
        y:i   <=>  C:C --- < +:= NA:NA >
Elision
        e:0   <=>  =:CC --- < +:0 V:V >
                or  < C:C V:V > ---  < +:0 e:e >
                or  { g:g c:c } ---  < +:0 { e:e i:i } >
I-Spelling
        i:y   <=>  =:= --- < e:0 +:0 i:i >
