#|*****************************************************************************

      R E A D   I N   A   S I N G L E   I N S T A N C E   F R O M   F I L E   
                                                                              
  This file (and especially "readinstance") may need to be modified for 
particular applications.

*****************************************************************************|#

(provide "read-inst")

#|----------------------------------------------------------------11/May/88----
   Function  - MAKE-ATT-NAMES
       
   Inputs    -> number of atts to make 
       
   Returns   -> a list (ATT-1 ATT-2 ...) up to input number
     Use this function whenever there are no explicit attribute names.
     Otherwise, just use a defvar for var names (this of course has no 
     bearing on the actual computation -- printout purposes only).
-------------------------------------------------------------------KThompso--|#

(defun make-att-names (number) 
  (let ((names))
    (dotimes (i number names)
      (setf names 
	  (append 
	     names 
	     (list 
	      (intern
	       (concatenate 'string "ATT-" (princ-to-string (1+ i))))))
	  ))))


#|----------------------------------------------------------------11/May/88----
   Function  - READINSTANCE
       
   Inputs    -> input-stream
    
   Returns   -> nil if there are no more objects to be read (or in case of
        error), or the list of atoms representing the components of the
        new object ("comps"). Each atom has the attribute values stored in
        a property list.

Thus below we will return a list (D1 OBJ1), where OBJ1 has the 35 attributes
on its plist, as well as the 'given D1.

  WARNING: currently, each component must have the same number of
attributes, and there must be a putprop for each of them. (there are 35
below.)

The input file for Michalski's soybean diseases has lines like this below:
2 1 2 1 1 1 1 2 0 2 1 1 0 2 2 0 0 0 1 0 1 2 0 1 0 0 0 3 4 0 0 0 0 0 1 D4-1
There are 35 attributes and the class information (D1-4).

-------------------------------------------------------------------KThompso-|#

(defun readinstance (input-stream num-atts)
  (let ((first-token (eatcomments input-stream))   ;next token
	(given-name nil)                           ; (category information)
	)
    (if first-token
       (progn
	(putprop 'OBJ first-token (elt *ATT-NAMES* 0))
        (dotimes (i (1- num-atts))                         ;attributes 2-21
	   (putprop 'obj
		    (read input-stream)
		    (elt *ATT-NAMES* (1+ i))))
	(setq given-name (eatcomments input-stream))
	(putprop 'obj given-name 'given)    ;36 attribute is category
	t              ;returning true
	)

       nil)            ;if not first-token
))

#|----------------------------------------------------------------03/May/88----
   Function  - EATCOMMENTS

   Inputs    -> input-stream
       
   Returns   -> the next non-comment token (comments are "%")
-------------------------------------------------------------------KThompso-|#

(defun eatcomments (input-stream)
  (if (equal (peek-char t input-stream nil nil) #\%)
      (progn (read-line input-stream)
             (eatcomments input-stream))
      (read input-stream nil nil)))


#|----------------------------------------------------------------11/Jun/88----
   Function  - READ-ATT-TYPE
       
   Inputs    -> input-stream and num-atts
       
   Returns   -> list of size num-atts of :nominal or :numeric.  These are
      assumed to be just on one line, separated by spaces.
-------------------------------------------------------------------KThompso--|#

(defun read-att-type (input-stream num-atts)
  (prog1
      (loop for i from 1 to num-atts 
	    collect 
	    (let ((token (eatcomments input-stream)))
	      (case token
		 (n :numeric)
		 (s :nominal))))))
;;      (read-line input-stream)  I used to have this at the end; messed things
;;                                up, though not sure why.  
