
#|*****************************************************************************

     F U N C T I O N S   T H A T  C H A N G E  F O R   C O B W E B
			 A N D   C L A S S I T
	    (D E A L I N G   W I T H   A T T R I B U T E S)
*****************************************************************************|#

(provide "node-atts")

(require "struct")
(require "globals")
(require "loop" "/ci/ci/worldm/bin/loop")
(use-package "LOOP")

; (proclaim '(optimize (safety 0) (speed 3)))


(defmacro not-present (attribute-value)
  `(eq ,attribute-value '?))

(defmacro is-present (attribute-value)
  `(not (eq ,attribute-value '?)))

(defmacro numeric (name)
   `(eq (cdr (assoc ,name *TYPE-LIST*)) :numeric))

(defmacro numericp (attr)
  `(eq (basic-att-key ,attr) :numeric))


#|----------------------------------------------------------------15/Jun/88----
   Function  - PROB-ATT=VALUE
       
   Inputs    -> a node in the tree, with its atts updated.
       
   Returns   -> the attscore to be kept at that node, representing the
                 1/sigma (for CLASSIT) or P(A=V/c) for that node.  Is this
                 correct to divide by att-acount and not node-count at all?

                                                                  03/Jun/88----
                In answer to above, yes.  But need to multiply by
                att-acount/node-count also.  This is salience weight; see
                p. 127 Fisher's thesis.  So this function returns a slightly
                different number now.

MODIFIED for Classit-2
   For starters, the Salience weight is removed. Also, need to find the 
   appropriate attributes, given the list of att-names. Finally, this
   returns the average of the 1/sigma, or P(A=V_c) scores.
   NOTE: this is used solely for thresholding....

-------------------------------------------------------------------KThompso--|#

; REMOVED because I think I'm handling different numbers of attributes
;  via attention (??)

; (defmacro salience (att node)  ;will be 1 if no missing attribute value.
;   `(/ (basic-att-acount ,att)
;       (node-count ,node)))

(defun prob-att=value (node att-names)

    (loop for att-name in att-names
	  for attribute = (find-att att-name (node-atts node))
	  if attribute
	  collect
	   (if (numericp attribute)                              
                                                                      ;CLASSIT:
	    (inverse (sqrt (NumAtt-variance attribute)))
							              ;COBWEB:
	    (loop for value-pair in (NomAtt-values attribute)
		   sum (square (/ (cdr value-pair)
				  (NomAtt-acount attribute)))
	    )
           ) into totallist
	  finally
	     (return (/ (apply '+ totallist) (length totallist)))
))


#|----------------------------------------------------------------09/Jun/88----
  INTEGRATE-INTO-ATTS
  This function integrates a new obj into the atts list of a node.
 
  Inputs: the atts list, (OBJ), and a list of attribute names.
  Outputs: the new att list (note: each att should be an explicit
     copy, not a copy of the pointer).
MODIFIED for Classit-2 4/89, JHG
  att-names is now the list of attributes we've seen so far. This may be
  either longer or shorter than old-atts. That is, this code contains stuff
  for "Familiarization": learning new (un-seen) attributes.
------------------------------------------------------------------Pyoung----|# 

(defun integrate-into-atts (old-atts att-names)
  (loop for old-att in old-atts
        for attname = (find (basic-att-name old-att) att-names)
        for new-value = (get 'OBJ attname)
	do
	   (setq att-names (remove attname att-names))
        collect

	(if (null attname) old-att     ; We haven't look at attname yet...
	(if (numericp old-att)
	  (if (is-present new-value)            ; Numeric Attribute
	    (let ((new-NumAtt
		   (make-NumAtt
	             :acount  (1+ (NumAtt-acount old-att))
		     :name    (NumAtt-name old-att)
		     :sum     (+ new-value (NumAtt-sum old-att))
		     :sum2    (+ (square new-value) (NumAtt-sum2 old-att)))))
	      (setf (NumAtt-variance new-NumAtt)
		      (determine-variance new-NumAtt))
	      new-NumAtt)
	    (copy-NumAtt old-att))              ;attribute is "?"

	  (if (is-present new-value)            ; Nominal Attribute
	    (let ((new-NomAtt
		   (make-NomAtt
	             :acount  (1+ (NomAtt-acount old-att))
		     :name    (NomAtt-name old-att)
		     :values  
	              (add-to-values-list (NomAtt-values old-att) new-value))))
	      new-NomAtt)
	    (copy-NomAtt old-att))              ;attribute is "?"
	))
        into new-att-list
    finally
       (if (null att-names) (return new-att-list)  ;No new attributes
           (return (append new-att-list (create-atts att-names)))
       )
))

#|----------------------------------------------------------------09/Jun/88----
  CREATE-ATTS
  creates a new att list for a given obj
 
  Inputs: The attribute name list (and OBJ, the instance).
          ALSO uses the global *TYPE-LIST* (inside "numeric").
  Outputs: The new atts list.

MODIFIED 6/25/89 by JHG for attention
  If the attribute has the value '?, we simply do not make an "att" for
  that attribute. Therefore the "new atts list" may be shorter than attribute
  name list.
------------------------------------------------------------------Pyoung----|# 

(defun create-atts (att-list)
  (loop for attname in att-list
        for new-value = (get 'OBJ attname)
	if (is-present new-value)	                 ;if value exists
        collect
	(if (numeric attname)             ;CLASSIT
	    (make-NumAtt :name attname
			 :acount 1
			 :sum new-value
			 :sum2 (square new-value)
			 :variance *ACUITY*

	    )
	                                  ;COBWEB
	    (make-NomAtt :name attname
			 :acount 1
			 :values `((,new-value . 1))

	    )
	)
))

#|----------------------------------------------------------------09/Jun/88----
   Function  - COMBINE-ATTS
     combine atts for merged node
       
   Inputs    -> two attribute lists
       
   Returns   -> a new structure, with the proper fields merged.
     "proper fields" is: acount for both CLASSIT and COBWEB,
                         sum, sum2, and variance for CLASSIT
                         values for COBWEB
MODIFIED 4/17/89 for attention -JHG
    Actually, combine-atts is completely new -- I've moved the old code to
   combine-1att. I did this because for Classit/2, attributes may be in any
   order. This means that we need to combine those attributes from the two
   attribute lists whose names match. Any attributes in list1, but not in 
   list2, and vice-versa, we must simply append to this "mushed-atts" list.
-------------------------------------------------------------------KThompso--|#

(defun combine-atts (att-list1 att-list2)
  (loop for att1 in att-list1
        for att2 = (find-att (basic-att-name att1) att-list2)
	if att2
	  do (setq att-list2 (remove att2 att-list2))
          and collect (combine-1att att1 att2) into mushed-atts
	else
          collect att1 into only-one
	finally
	  (return (append mushed-atts only-one att-list2))
))

(defun combine-1att (att1 att2)

   (if (numericp att1)
	  (let ((new-NumAtt                                 ;CLASSIT
		 (make-NumAtt
		       :name   (NumAtt-name att1)
		       :childscore (/ (+ (NumAtt-childscore att1)
					 (NumAtt-childscore att2))
				      2)    ;(The average of the two scores.)
		       :acount (+ (NumAtt-acount att1) (NumAtt-acount att2))
		       :sum    (+ (NumAtt-sum att1)    (NumAtt-sum att2))
		       :sum2   (+ (NumAtt-sum2 att1)   (NumAtt-sum2 att2)))))
	    (setf (NumAtt-variance new-NumAtt) (determine-variance new-NumAtt))
	    new-NumAtt)

	  (let ((new-NomAtt                                 ;COBWEB
		 (make-NomAtt
		       :name   (NomAtt-name att1)
		       :childscore (/ (+ (NomAtt-childscore att1)
					 (NomAtt-childscore att2))
				      2)    ;(The average of the two scores.)
		       :acount (+ (NomAtt-acount att1) (NomAtt-acount att2)))))
	    (setf (NomAtt-values new-NomAtt)
		  (combine-values (NomAtt-values att1) (NomAtt-values att2)))
	    new-NomAtt)
   )
)


;*------------------------------------------------------------------10/Apr/89-*
;*  Function  - FIND-ATT
;* 
;*  Inputs    -> an attribute name, and a list of attributes.
;* 
;*  Returns   -> the matching attribute from the list.
;*---------------------------------------------------------------------JHG----*

(defun find-att (attr-name att-list)
   
   (loop for attr in att-list 
	 if (eq (basic-att-name attr) attr-name)
	 return attr
))

;*------------------------------------------------------------------05/Apr/89-*
;*  Function  - LOOPCHILD  (Function used only by determine-CU-att)
;* 
;*  Inputs    -> the children, and the attribute
;* 
;*  Returns   -> Two values: the parent "on the fly" variance for that 
;*      attribute, and the weighted sum of the children variance for that
;*      attribute. (Weighted by P(c), the probability of each class.)
;*      This needs to do different things for numeric and nominal cases;
;*      hence, the separate calls to W-NumAtt and W-NomAtt.
;* MODIFIED 6/8/89
;*      The parent on-the-fly score is now stored permanently in Par-att.
;*---------------------------------------------------------------------JHG----*

(defun loopChild (children attribute Par-att parentcnt)

 (let ((childcnt 0))
   (loop for child in children
	 for ClassAtt = (find-att attribute (node-atts child))
	 for Prob = (/ (node-count child) (float parentcnt))

      if ClassAtt 
      do              ;If "attribute" exists in this child.... 

	 (setq childcnt (1+ childcnt)) and
	 if (numericp ClassAtt)         ;A Numeric attribute
	      sum (* (W-NumAtt ClassAtt Par-att)
		     Prob
		  ) into totalVar
	 else                           ;A Nominal attribute
	      sum (* (W-NomAtt ClassAtt Par-att)
		     Prob
		  ) into totalscore
      finally
         (return
	 (cond ((eq (basic-att-acount Par-att) 0)
		(values '? '? '?))   ;no children had this attribute.
	       ((numeric attribute)
	        (setf (NumAtt-variance Par-att)
		   (determine-variance Par-att))
	        (values 
		        (inverse (sqrt (NumAtt-variance Par-att))) 
		         totalVar childcnt
	        ))
	       ( t
		 (values
		   (loop for value-pair in (NomAtt-values Par-att)
		         sum (square (/ (cdr value-pair)
				        (NomAtt-acount Par-att))))
		   totalscore childcnt)
	       )
         ))
  )
))

;*------------------------------------------------------------------18/Apr/89-*
;*  Function  - BEST-VAL
;* 
;*  Inputs    -> an attribute
;* 
;*  Returns   -> The best (predicted) value for that attribute. For
;*      numeric attributes, this is the mean; for symbolic attributes,
;*      the value with the highest count.
;*      Currently, this is only used by Halt-test.
;*---------------------------------------------------------------------JHG----*

(defun best-val (child-att)

  (cond ((null child-att) '?)
        ((numericp child-att)
	                  ; for CLASSIT, return the mean.
         (/ (NumAtt-sum child-att) (NumAtt-acount child-att)))
	( t
	                  ; for COBWEB, return the highest count value.
         (loop for pair in (NomAtt-values child-att)
	    with best-cnt = 0 and value 
	    if (> (cdr pair) best-cnt) do
	      (setq value (car pair))
	      (setq best-cnt (cdr pair))
	    finally 
	      (return value)
	 ))
  )
)

;*------------------------------------------------------------------04/Jun/89-*
;*  Function  - WORST-VAL
;* 
;*  Inputs    -> parentatt, the attribute at the parent, and the value at the
;*     `best' child.
;* 
;*  Returns   ->  The `worst' value for the given attribute. This is computed
;*     by adding the standard deviation to the mean at the parent. (This is 
;*     added or subtracted depending on the value of the `best' child.)
;*     if there is no parent attribute, then we return "?", the symbol for 
;*     unknown. 
;*        For nominal attributes, this is the value with the lowest count
;*     (excluding the childval -- this is what the "remove (assoc..." does).
;*     There is also a clause for the case where there is only one value in
;*     the parentatt.
;*    USED by Halt-test (compute-disjunct).
;*---------------------------------------------------------------------JHG----*

(defun worst-val (parentatt childval)

  (cond ((null parentatt) '?)
	((eq childval '?) '?)
	((numericp parentatt) ; (CLASSIT)
	 (let ((mean (/ (NumAtt-sum parentatt) (NumAtt-acount parentatt))))
	      (if (< childval mean)
		  (+ (* 2 (sqrt (NumAtt-variance parentatt))) mean)
		  (- (* 2 (sqrt (NumAtt-variance parentatt)) mean)))
	 ))
	( t ; (COBWEB)
	  (let ((parent-values (NomAtt-values parentatt)))
	    (if (eq 1 (length parent-values)) (caar parent-values)
	      ;else
                (loop for pair in
		        (remove (assoc childval parent-values) parent-values)
		      with worst-cnt and value
		      if (or (null value)
		             (< (cdr pair) worst-cnt)) do
		        (setq value (car pair))
			(setq worst-cnt (cdr pair))
		      finally
		        (return value)
		))

	  ))
  )
)

#|*****************************************************************************

  F U N C T I O N S   S P E C I F I C   T O   C O B W E B   O N L Y

*****************************************************************************|#

#|----------------------------------------------------------------09/Jun/88----
                                                                  (COBWEB only)
   Function  - COMBINE-VALUES 
     takes 2 new value lists and combines them pairwise 
     e.g. (combine-values '((red . 3) (blue . 2) (black . 1))         
                          '((blue . 3) (red . 1)))                    
     returns ((black . 1) (blue . 5) (red . 4))                       
   Inputs    -> two value-lists.
       
   Returns   -> the combined list
-------------------------------------------------------------------KThompso--|#

(defun combine-values (list1 list2)
  (let ((all-values (union (mapcar #'car list1) (mapcar #'car list2))))
    (loop for value in all-values
          collect
          (let ((val1 (assoc value list1))
                (val2 (assoc value list2)))
            (cons value (+ (if val1 (cdr val1) 0)
                           (if val2 (cdr val2) 0)))))))


#|----------------------------------------------------------------11/May/88----
                                                                  (COBWEB only)
   Function  - ADD-TO-VALUES-LIST
      increment the count of the appropriate value, or add a new pair
      (new-value . 1).
   Inputs    -> existing value list, new value
       value-lists look like ((red . 3) (blue . 2) (black . 1))
       new-value   could be  red, or blue.
   Returns   -> new value list
-------------------------------------------------------------------KThompso--|#

(defun add-to-values-list (value-list new-value)
  (let* ((new-list (copy-tree value-list))
         (pair (assoc new-value new-list)))
    (if pair
      (progn
          (incf (cdr pair))
          new-list)
      (cons `(,new-value . 1) new-list))))


;*------------------------------------------------------------------10/Apr/89-*
;*  Function  - W-NOMATT (used by determine-CU-att)
;* 
;*  Inputs    -> A *nominal* attribute, and the (temporary) total att.
;* 
;*  Returns   -> The W-score for that attribute: in this case, the sum of
;*      probabilities that the attribute has a given value. Also modifies
;*      the total att, so that a parent list of (value . count) is built. 
;*      (Note that "combine-values" is called.)
;*---------------------------------------------------------------------JHG----*

(defun W-NomAtt (child-att total-att)

  (setf (NomAtt-acount total-att)
	(+ (NomAtt-acount total-att) (NomAtt-acount child-att)))
  (setf (NomAtt-values total-att) 
	(combine-values (NomAtt-values total-att) (NomAtt-values child-att)))
  (loop for value-pair in (NomAtt-values child-att)
        sum (square (/ (cdr value-pair)
		      (NomAtt-acount child-att)))
  )
)


#|*****************************************************************************

  F U N C T I O N S   S P E C I F I C   T O   C L A S S I T   O N L Y

*****************************************************************************|#

#|----------------------------------------------------------------15/Jun/88----
                                                                 (CLASSIT only)
   Function  - DETERMINE-VARIANCE 
       
   Inputs    -> an att with acount, sum, and sum2 set.
       
   Returns   -> the variance
------------------------------------------------------------------Pyoung----|#

(defmacro determine-variance (att)
  `(if (zerop (NumAtt-acount ,att))
     0                                             ;don't use at level above.
     (let* ((avg (/ (NumAtt-sum ,att) (NumAtt-acount ,att)))
	    (numerator (+ (* (square avg) (NumAtt-acount ,att))
			  (- (* 2 avg (NumAtt-sum ,att)))
			  (NumAtt-sum2 ,att)))
	    (variance (/ numerator (NumAtt-acount ,att))))
	(if (< variance *ACUITY*)
	  *ACUITY*
	  variance))))


;*------------------------------------------------------------------10/Apr/89-*
;*  Function  - W-NUMATT (used by determine-CU-att)
;* 
;*  Inputs    -> a *numeric* attribute from the child, and the (temporary)
;*      total att.
;* 
;*  Returns   -> The W-score for that attribute, for that node. (In contrast
;*      to node-attscore, which is summed over all attributes.) ALSO modifies
;*      total-att, which is used to compute the on-the-fly parent. 
;*---------------------------------------------------------------------JHG----*

(defun W-NumAtt (child-att total-att)
  
  (setf (NumAtt-acount total-att) 
     (+ (NumAtt-acount total-att) (NumAtt-acount child-att)))
  (setf (NumAtt-sum total-att) 
     (+ (NumAtt-sum total-att) (NumAtt-sum child-att)))
  (setf (NumAtt-sum2 total-att) 
     (+ (NumAtt-sum2 total-att) (NumAtt-sum2 child-att)))

  (inverse (sqrt (NumAtt-variance child-att)))
)

