;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

(in-package 'user)

(export '(*brules* *facts*))

(setf *domain* 'plan-recognition)

(setf *brules*
  '(
    ; shopping
    
    (<- (inst ?g going) (inst ?s shopping) (go-step ?s ?g)) ; by Charniak
    (<- (goer ?g ?p) (inst ?s shopping) (go-step ?s ?g) (shopper ?s ?p))
    (<- (dest-go ?g ?str) (inst ?s shopping) (go-step ?s ?g) (store ?s ?str))
    (<- (inst ?sp shopping-place) (inst ?s shopping) (store ?s ?sp))
    
    (<- (inst ?f finding) (inst ?s shopping) (find-step ?s ?f))
    (<- (finder ?f ?a) (inst ?s shopping) (find-step ?s ?f) (shopper ?s ?a))
    (<- (thing-found ?f ?tf) (inst ?s shopping) (find-step ?s ?f) (thing-shopped-for ?s ?tf))
    
    (<- (inst ?b buying) (inst ?s shopping) (buy-step ?s ?b))
    (<- (buyer ?b ?p) (inst ?s shopping) (buy-step ?s ?b) (shopper ?s ?p))
    (<- (thing-bought ?b ?tb) (inst ?s shopping) (buy-step ?s ?b)
	                      (thing-shopped-for ?s ?tb))

    (<- (inst ?p paying) (inst ?b buying) (pay-step ?b ?p))
    (<- (payer ?p ?a) (inst ?b buying) (pay-step ?b ?p) (buyer ?b ?a))
    (<- (thing-paid ?p ?tp) (inst ?b buying) (pay-step ?b ?p) (thing-bought ?b ?tp))
    
    (<- (inst ?str smarket) (inst ?s smarket-shopping) (store ?s ?str))  ; by Charniak
    (<- (inst ?f food) (inst ?s smarket-shopping) (thing-shopped-for ?s ?f)) ; by Charniak

    (<- (inst ?ls liquor-store) (inst ?s liqst-shopping) (store ?s ?ls))
    (<- (inst ?l liquor) (inst ?s liqst-shopping) (thing-shopped-for ?s ?l))

    ; robbing
    
    (<- (inst ?g getting) (inst ?r robbing) (get-weapon-step ?r ?g))
    (<- (agent-get ?g ?a) (inst ?r robbing) (get-weapon-step ?r ?g) (robber ?r ?a))
    (<- (patient-get ?g ?w) (inst ?r robbing) (get-weapon-step ?r ?g) (weapon-rob ?r ?w))

    (<- (inst ?g going) (inst ?r robbing) (go-step ?r ?g))
    (<- (goer ?g ?a) (inst ?r robbing) (go-step ?r ?g) (robber ?r ?a))
    (<- (dest-go ?g ?p) (inst ?r robbing) (go-step ?r ?g) (place-rob ?r ?p))

    (<- (inst ?p pointing) (inst ?r robbing) (point-weapon-step ?r ?p))
    (<- (agent-point ?p ?a) (inst ?r robbing) (point-weapon-step ?r ?p) (robber ?r ?a))
    (<- (patient-point ?p ?a) (inst ?r robbing) (point-weapon-step ?r ?p) (victim-rob ?r ?a))
    (<- (instr-point ?p ?i) (inst ?r robbing) (point-weapon-step ?r ?p) (weapon-rob ?r ?i))
    (<- (inst ?i weapon) (inst ?r robbing) (weapon-rob ?r ?i))

    (<- (inst ?g getting) (inst ?r robbing) (get-valuable-step ?r ?g))
    (<- (agent-get ?g ?a) (inst ?r robbing) (get-valuable-step ?r ?g) (robber ?r ?a))
    (<- (patient-get ?g ?t) (inst ?r robbing) (get-valuable-step ?r ?g) (thing-robbed ?r ?t))
    (<- (from-get ?g ?a) (inst ?r robbing) (get-valuable-step ?r ?g) (victim-rob ?r ?a))
    (<- (inst ?t valuable) (inst ?r robbing) (thing-robbed ?r ?t))

    ; restaurant dining

    (<- (inst ?g going) (inst ?d rest-dining) (go-step ?d ?g))
    (<- (goer ?g ?a) (inst ?d rest-dining) (go-step ?d ?g) (diner ?d ?a))
    (<- (dest-go ?g ?r) (inst ?d rest-dining) (go-step ?d ?g) (restaurant ?d ?r))
    (<- (inst ?r restaurant) (inst ?d rest-dining) (restaurant ?d ?r))

    (<- (inst ?o ordering) (inst ?d rest-dining) (order-step ?d ?o))
    (<- (agent-order ?o ?a) (inst ?d rest-dining) (order-step ?d ?o) (diner ?d ?a))
    (<- (patient-order ?o ?p) (inst ?d rest-dining) (order-step ?d ?o) (rest-thing-ordered ?d ?p))

    (<- (inst ?o drinking) (inst ?d rest-dining) (drink-step ?d ?o))
    (<- (drinker ?o ?a) (inst ?d rest-dining) (drink-step ?d ?o) (diner ?d ?a))
    (<- (patient-drink ?o ?p) (inst ?d rest-dining) (drink-step ?d ?o) (rest-thing-drunk ?d ?p))
    (<- (instr-drink ?o ?p) (inst ?d rest-dining) (drink-step ?d ?o) (rest-drink-straw ?d ?p))

    (<- (inst ?o paying) (inst ?d rest-dining) (pay-step ?d ?o))
    (<- (payer ?o ?a) (inst ?d rest-dining) (pay-step ?d ?o) (diner ?d ?a))
    (<- (thing-paid ?o ?p) (inst ?d rest-dining) (pay-step ?d ?o) (rest-thing-ordered ?d ?p))

    (<- (inst ?g getting) (inst ?d drinking) (get-straw-step ?d ?g))
    (<- (agent-get ?g ?a) (inst ?d drinking) (get-straw-step ?d ?g) (drinker ?d ?a))
    (<- (patient-get ?g ?p) (inst ?d drinking) (get-straw-step ?d ?g) (instr-drink ?d ?p))

    (<- (inst ?p putting) (inst ?d drinking) (put-straw-step ?d ?p))
    (<- (agent-put ?p ?a) (inst ?d drinking) (put-straw-step ?d ?p) (drinker ?d ?a))
    (<- (patient-put ?p ?a) (inst ?d drinking) (put-straw-step ?d ?p) (instr-drink ?d ?a))
    (<- (inst ?a straw) (inst ?d drinking) (instr-drink ?d ?a))
    (<- (place-put ?p ?a) (inst ?d drinking) (put-straw-step ?d ?p) (patient-drink ?d ?a))

    (<- (inst ?i ingesting) (inst ?d drinking) (ingest-step ?d ?i))
    (<- (agent-ingest ?i ?a) (inst ?d drinking) (ingest-step ?d ?i) (drinker ?d ?a))
    (<- (patient-ingest ?i ?p) (inst ?d drinking) (ingest-step ?d ?i) (patient-drink ?d ?p))
    (<- (instr-ingest ?i ?p) (inst ?d drinking) (ingest-step ?d ?i) (instr-drink ?d ?p))

    ; going-by-vehicle

    (<- (inst ?g going) (inst ?v going-by-vehicle) (go-step ?v ?g))
    (<- (goer ?g ?a) (inst ?v going-by-vehicle) (go-step ?v ?g) (goer ?v ?a))
    (<- (dest-go ?g ?s) (inst ?v going-by-vehicle) (go-step ?v ?g) (source-go ?v ?s))
    
    (<- (inst ?o getting-on) (inst ?v going-by-vehicle) (get-on-step ?v ?o))
    (<- (agent-get-on ?o ?a) (inst ?v going-by-vehicle) (get-on-step ?v ?o) (goer ?v ?a))
    (<- (patient-get-on ?o ?w) (inst ?v going-by-vehicle) (get-on-step ?v ?o) (vehicle ?v ?w))
    (<- (place-get-on ?o ?p) (inst ?v going-by-vehicle) (get-on-step ?v ?o) (source-go ?v ?p))
    (<- (inst ?w vehicle) (inst ?v going-by-vehicle) (vehicle ?v ?w))
    
    (<- (inst ?s sitting) (inst ?v going-by-vehicle) (sit-step ?v ?s))
    (<- (agent-sit ?s ?a) (inst ?v going-by-vehicle) (sit-step ?v ?s) (goer ?v ?a))
    (<- (patient-sit ?s ?p) (inst ?v going-by-vehicle) (sit-step ?v ?s) (vehicle-seat ?v ?p))
    (<- (inst ?p seat) (inst ?v going-by-vehicle) (vehicle-seat ?v ?p))
    (<- (in ?p ?w) (inst ?v going-by-vehicle) (vehicle-seat ?v ?p) (vehicle ?v ?w))

    (<- (inst ?o getting-off) (inst ?v going-by-vehicle) (get-off-step ?v ?o))
    (<- (agent-get-off ?o ?a) (inst ?v going-by-vehicle) (get-off-step ?v ?o) (goer ?v ?a))
    (<- (patient-get-off ?o ?w) (inst ?v going-by-vehicle) (get-off-step ?v ?o) (vehicle ?v ?w))
    (<- (place-get-off ?o ?p) (inst ?v going-by-vehicle) (get-off-step ?v ?o) (dest-go ?v ?p))

    ; going-by-bus, -taxi, -plane

    (<- (inst ?v bus) (inst ?b going-by-bus) (vehicle ?b ?v))
    (<- (inst ?v taxi) (inst ?t going-by-taxi) (vehicle ?t ?v))
    (<- (inst ?v plane) (inst ?p going-by-plane) (vehicle ?p ?v))

    ; going-by-bus
    
    (<- (inst ?s bus-station) (inst ?v going-by-bus) (source-go ?v ?s))

    (<- (inst ?g giving) (inst ?b going-by-bus) (give-token-step ?b ?g))
    (<- (giver ?g ?a) (inst ?b going-by-bus) (give-token-step ?b ?g) (goer ?b ?a))
    (<- (recipient ?g ?a) (inst ?b going-by-bus) (give-token-step ?b ?g) (bus-driver ?b ?a))
    (<- (occupation ?a busdriver) (inst ?b going-by-bus) (bus-driver ?b ?a))
    (<- (thing-given ?g ?t) (inst ?b going-by-bus) (give-token-step ?b ?g) (token ?b ?t))
    (<- (inst ?t token) (inst ?b going-by-bus) (token ?b ?t))

    ; going-by-taxi

    (<- (inst ?p paying) (inst ?b going-by-taxi) (pay-step ?b ?p))
    (<- (payer ?p ?a) (inst ?b going-by-taxi) (pay-step ?b ?p) (goer ?b ?a))
    (<- (payee ?p ?a) (inst ?b going-by-taxi) (pay-step ?b ?p) (taxi-driver ?b ?a))
    (<- (occupation ?a taxidriver) (inst ?b going-by-taxi) (taxi-driver ?b ?a))

    ; going-by-plane

    (<- (inst ?s airport) (inst ?v going-by-plane) (source-go ?v ?s))

    (<- (inst ?s packing) (inst ?p going-by-plane) (pack-step ?p ?s))
    (<- (agent-pack ?s ?a) (inst ?p going-by-plane) (pack-step ?p ?s) (goer ?p ?a))
    (<- (patient-pack ?s ?l) (inst ?p going-by-plane) (pack-step ?p ?s) (plane-luggage ?p ?l))
    (<- (inst ?l bag) (inst ?p going-by-plane) (plane-luggage ?p ?l))

    (<- (inst ?b buying) (inst ?s going-by-plane) (buy-ticket-step ?s ?b))
    (<- (buyer ?b ?a) (inst ?s going-by-plane) (buy-ticket-step ?s ?b) (goer ?s ?a))
    (<- (thing-bought ?b ?t) (inst ?s going-by-plane) (buy-ticket-step ?s ?b)
	                     (plane-ticket ?s ?t))
    (<- (inst ?t ticket) (inst ?s going-by-plane) (plane-ticket ?s ?t))

    ; jogging

    (<- (inst ?d drinking) (inst ?j jogging) (drink-step ?j ?d))
    (<- (drinker ?d ?a) (inst ?j jogging) (drink-step ?j ?d) (jogger ?j ?a))
    (<- (patient-drink ?d ?a) (inst ?j jogging) (drink-step ?j ?d) (jog-thing-drunk ?j ?a))
    (<- (instr-drink ?d ?a) (inst ?j jogging) (drink-step ?j ?d) (jog-drink-straw ?j ?a))

    ; partying

    (<- (inst ?d drinking) (inst ?p partying) (drink-step ?p ?d))
    (<- (drinker ?d ?a) (inst ?p partying) (drink-step ?p ?d) (agent-party ?p ?a))
    (<- (patient-drink ?d ?a) (inst ?p partying) (drink-step ?p ?d) (party-thing-drunk ?p ?a))
    (<- (instr-drink ?d ?a) (inst ?p partying) (drink-step ?p ?d) (party-drink-straw ?p ?a))
    ))

(setf *facts* nil)

(setf *nogoods* nil)

(setf *assumption-nogoods*
  '(((go-step ?s ?g) (goer ?g ?p))
    ((go-step ?s ?g) (dest-go ?g ?str))
    ((find-step ?s ?f) (finder ?f ?a))
    ((find-step ?s ?f) (thing-found ?f ?tf))
    ((buy-step ?s ?b) (buyer ?b ?p))
    ((buy-step ?s ?b) (thing-bought ?b ?tb))
    ((pay-step ?b ?p) (payer ?p ?a))
    ((pay-step ?b ?p) (payee ?p ?a))
    ((pay-step ?b ?p) (thing-paid ?p ?tp))
    ((get-weapon-step ?r ?g) (agent-get ?g ?a))
    ((get-weapon-step ?r ?g) (patient-get ?g ?w))
    ((point-weapon-step ?r ?p) (agent-point ?p ?a))
    ((point-weapon-step ?r ?p) (patient-point ?p ?a))
    ((point-weapon-step ?r ?p) (instr-point ?p ?i))
    ((get-valuable-step ?r ?g) (agent-get ?g ?a))
    ((get-valuable-step ?r ?g) (patient-get ?g ?t))
    ((get-valuable-step ?r ?g) (from-get ?g ?a))
    ((order-step ?d ?o) (agent-order ?o ?a))
    ((order-step ?d ?o) (patient-order ?o ?p))
    ((drink-step ?d ?o) (drinker ?o ?a))
    ((drink-step ?d ?o) (patient-drink ?o ?p))
    ((drink-step ?d ?o) (instr-drink ?o ?p))
    ((get-straw-step ?d ?g) (agent-get ?g ?a))
    ((get-straw-step ?d ?g) (patient-get ?g ?p))
    ((put-straw-step ?d ?p) (agent-put ?p ?a))
    ((put-straw-step ?d ?p) (patient-put ?p ?a))
    ((put-straw-step ?d ?p) (place-put ?p ?a))
    ((ingest-step ?d ?i) (agent-ingest ?i ?a))
    ((ingest-step ?d ?i) (patient-ingest ?i ?p))
    ((ingest-step ?d ?i) (instr-ingest ?i ?p))
    ((get-on-step ?v ?o) (agent-get-on ?o ?a))
    ((get-on-step ?v ?o) (patient-get-on ?o ?w))
    ((get-on-step ?v ?o) (place-get-on ?o ?p))
    ((sit-step ?v ?s) (agent-sit ?s ?a))
    ((sit-step ?v ?s) (patient-sit ?s ?p))
    ((get-off-step ?v ?o) (agent-get-off ?o ?a))
    ((get-off-step ?v ?o) (patient-get-off ?o ?w))
    ((get-off-step ?v ?o) (place-get-off ?o ?p))
    ((give-token-step ?b ?g) (giver ?g ?a))
    ((give-token-step ?b ?g) (recipient ?g ?a))
    ((give-token-step ?b ?g) (thing-given ?g ?t))
    ((pack-step ?p ?s) (agent-pack ?s ?a))
    ((pack-step ?p ?s) (patient-pack ?s ?l))
    ((buy-ticket-step ?s ?b) (buyer ?b ?a))
    ((buy-ticket-step ?s ?b) (thing-bought ?b ?t))
    ))

(setf *sort-hierarchy*
      '((any . (physical action))
	(physical . (apparel bag food gift liquor place
		     seat shelf straw ticket token valuable vehicle weapon))
	(action . (buying courting drinking finding getting getting-off getting-on
		   giving going ingesting jogging ordering packing partying paying
		   pointing putting rest-dining robbing shopping sitting working))
	(apparel . (shirt skirt trousers uniform))
	(bag . (suitcase))
	(food . (bread milk milkshake))
	(gift . (flower jewelry))
	(liquor . (bourbon))
	(place . (airport bus-station park prison
		  restaurant school shopping-place))
	(valuable . (money))
	(vehicle . (bus plane taxi))
	(weapon . (gun knife))
	(going . (going-by-vehicle))
	(shopping . (liqst-shopping smarket-shopping))
	(shopping-place . (liquor-store smarket))
	(going-by-vehicle . (going-by-bus going-by-plane going-by-taxi))
	))


(setf *inter-batch-beam-width* 10)
(setf *intra-batch-beam-width* 30)
(setf *bchain-depth* 3)
(setf *caching* t)
(setf *factoring* t)
(setf *remove-superset?* t)
(setf *remove-superset-fn* #'alphabetic-variant-subset?)
(setf *explanation-eval-metric* #'coherence-then-simplicity)
(setf *compute-estimate-fn* #'pr-compute-estimate-coherence)
(setf *combine-estimates-fn* #'pr-combine-estimates-coherence)

(setf *predicate-specific-abduction* nil)
(setf *free-assumption-predicates* nil)

(setf *unique-slot-value-predicates*
      '(go-step goer dest-go source-go vehicle
	shopper store thing-shopped-for
	find-step finder thing-found
	buy-step buyer thing-bought 
	pay-step payer thing-paid
	get-straw-step get-weapon-step get-valuable-step agent-get patient-get from-get
	robber weapon-rob place-rob victim-rob thing-robbed
	point-weapon-step agent-point patient-point instr-point 
	diner restaurant rest-thing-ordered rest-thing-drunk rest-drink-straw
	order-step agent-order patient-order 
	drink-step drinker patient-drink instr-drink
	jogger jog-thing-drunk jog-drink-straw
	agent-party party-thing-drunk party-drink-straw 
	put-straw-step agent-put patient-put place-put 
	ingest-step agent-ingest patient-ingest instr-ingest 
	get-on-step agent-get-on patient-get-on place-get-on 
	sit-step agent-sit patient-sit vehicle-seat  
	get-off-step agent-get-off patient-get-off place-get-off
	give-token-step giver recipient occupation thing-given token
	taxi-driver bus-driver
	pack-step agent-pack patient-pack plane-luggage 
	buy-ticket-step plane-ticket))

(setf *plan-steps*
      '((shopping . (go-step find-step buy-step))
	(smarket-shopping . (go-step find-step buy-step))
	(liqst-shopping . (go-step find-step buy-step))
	(buying . (pay-step))
	(robbing . (get-weapon-step go-step point-weapon-step get-valuable-step))
	(rest-dining . (go-step order-step drink-step pay-step))
	(drinking . (get-straw-step put-straw-step ingest-step))
	(going-by-vehicle . (go-step get-on-step sit-step get-off-step))
	(going-by-bus . (go-step give-token-step get-on-step sit-step get-off-step))
	(going-by-taxi . (go-step get-on-step sit-step pay-step get-off-step))
	(going-by-plane . (pack-step go-step buy-ticket-step get-on-step
				     sit-step get-off-step))
	(jogging . (drink-step))
	(partying . (drink-step))))
