;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

(in-package 'user)

(export '(*brules* *facts*))

(setf *domain* 'circ-diagnosis)

(setf *brules*
      '((<- (out ?x ?w ?t) (andg ?x) (in1 ?x ?u ?t) (in2 ?x ?v ?t) (norm ?x) (and ?u ?v ?w))
	(<- (out ?x ?w ?t) (org ?x) (in1 ?x ?u ?t) (in2 ?x ?v ?t) (norm ?x) (or ?u ?v ?w))
	(<- (out ?x ?w ?t) (xorg ?x) (in1 ?x ?u ?t) (in2 ?x ?v ?t) (norm ?x) (xor ?u ?v ?w))

	(<- (out ?x ?w ?t) (in1 ?x ?u ?t) (in2 ?x ?v ?t) (ab ?x ?u ?v ?w ?t))
	(<- (out ?x 0 ?t) (in1 ?x ?u ?t) (in2 ?x ?v ?t) (stuck-at-0 ?x))
	(<- (out ?x 1 ?t) (in1 ?x ?u ?t) (in2 ?x ?v ?t) (stuck-at-1 ?x))

	; brules specifically for full adder
	
	(<- (in1 a1 ?y ?t) (in1 x1 ?y ?t))
	(<- (in2 a1 ?y ?t) (in2 x1 ?y ?t))
	(<- (in1 x2 ?y ?t) (out x1 ?y ?t))
	(<- (in2 x2 ?y ?t) (in1 a2 ?y ?t))
	(<- (in2 a2 ?y ?t) (out x1 ?y ?t))
	(<- (in1 o1 ?y ?t) (out a2 ?y ?t))
	(<- (in2 o1 ?y ?t) (out a1 ?y ?t))
	(<- (in1 x1 ?u ?t) (given-in1 x1 ?u ?t))
	(<- (in2 x1 ?u ?t) (given-in2 x1 ?u ?t))
	(<- (in1 a2 ?u ?t) (given-in1 a2 ?u ?t))
	))

(setf *facts*
      '((and 0 0 0)
	(and 0 1 0)
	(and 1 0 0)
	(and 1 1 1)
	(or 0 0 0)
	(or 0 1 1)
	(or 1 0 1)
	(or 1 1 1)
	(xor 0 0 0)
	(xor 0 1 1)
	(xor 1 0 1)
	(xor 1 1 0)

	; facts specifically for full adder
	
	(xorg x1)
	(xorg x2)
	(andg a1)
	(andg a2)
	(org o1)
	))


(setf *adder-obs*
      '((in1 x1 1 t0)
	(in2 x1 0 t0)
	(in1 a2 1 t0)
	(out o1 0 t0)
	(out x2 1 t0)
	(out x1 1 t0)
	(out a1 0 t0)
	(out a2 0 t0)))

(setf *nogoods* nil)
(setf *assumption-nogoods* nil)

(setf *inter-batch-beam-width* 45)
(setf *intra-batch-beam-width* 45)
(setf *bchain-depth* 7)
(setf *caching* t)
(setf *factoring* nil)
(setf *remove-superset?* nil)
(setf *explanation-eval-metric* #'diag-simplicity)
(setf *compute-estimate-fn* #'diag-compute-estimate)
(setf *combine-estimates-fn* #'diag-combine-estimates)

(setf *predicate-specific-abduction* t)
(setf *assumable-predicates*
      '(norm ab stuck-at-0 stuck-at-1 given-in1 given-in2))
(setf *free-assumption-predicates*
      '(norm given-in1 given-in2))
(setf *fault-mode-predicates*
      '(stuck-at-0 stuck-at-1))
(setf *components* '(x1 x2 a1 a2 o1))
(setf *mode-probs*
      '((x1 (norm 0.65) (stuck-at-0 0.15) (stuck-at-1 0.15) (ab 0.05))
	(x2 (norm 0.65) (stuck-at-0 0.15) (stuck-at-1 0.15) (ab 0.05))
	(a1 (norm 0.65) (stuck-at-0 0.15) (stuck-at-1 0.15) (ab 0.05))
	(a2 (norm 0.65) (stuck-at-0 0.15) (stuck-at-1 0.15) (ab 0.05))
	(o1 (norm 0.65) (stuck-at-0 0.15) (stuck-at-1 0.15) (ab 0.05))))
