;;; -*- Mode:Common-Lisp; Package:aaa; Base:10 -*-

;;;; Copyright (c) 1992 by Hwee Tou Ng. This program may be freely
;;;; copied, used, or modified provided that this copyright notice 
;;;; is included in each copy of this code and parts thereof.

(in-package :aaa)

(proclaim '(optimize (speed 3) (compilation-speed 0)))

(use-package 'user)

(defstruct (node (:print-function print-node))
  datum
  (label nil)
  (label-size 0))

(defstruct (environment (:print-function print-env))
  (assumptions nil)
  (rules nil)
  (subst *empty-bindings*)
  (eval-metric nil)
  (renamed-assumptions :not-renamed)  ; needed for alphabetic variant subset test
  estimate)

(defun print-node (n stream depth)
  (declare (ignore depth))
  (format stream "~s" (node-datum n))
  (values))

(defun print-env (e &optional (stream t) depth)
  (declare (ignore depth))
  (row-print-list (environment-assumptions e) nil nil nil stream 3)
  (values))
