/*=============================================================================

 F U Z Z Y   A R T M A P  (1 9 9 1)                  CAS/CNS Boston University 

  ** written by Ah-Hwee Tan  **

  ** Documented Oct 18, 1991 **
  ** revised    Dec 26, 1991 **

=============================================================================*/

#include <malloc.h>
#include "ARTMAP.h"

void display_pattern (str, v, n)
char  str[5];
float  v[];
int     n;
{
  int  i;

  printf ("%s = {", str);
  for (i=0; i<n-1; i++)
    printf ("%1.2lf,", v[i]);
  printf ("%1.2lf}\n",v[n-1]);
}

void open_files ()
{
  char fname[30];

  printf ("Name of Readily Processed Binary File > ");
  scanf ("%s", fname);
  dat = fopen (fname, "rb");
  score = fopen ("score.out", "w");
  temp = fopen ("temp.out", "w");
}

void close_files ()
{
  fclose (dat);
  fclose(score);
  fclose(temp);
  if (trace_weight)
    fclose (gfp);
}

/*
void draw_templates()
{
  int node_counter;
  
  if (boxes)
    for (node_counter = 0; node_counter <= num_category[ARTa]; node_counter++)
      plotBox(a_length,dn[0][node_counter],0);
  else
    for (node_counter = 0; node_counter <= num_category[ARTa]; node_counter++)
      plotPrev(a_length,dn[0][node_counter]);
}
*/

void  alloc_memory ()
{
  int  i, j;

  num_att[ARTa] = a_length*(1+complement);
  num_att[ARTb] = b_length*(1+complement);

  pattern = (float **) malloc (sizeof(float *)*2);
  for (i=0; i<2; i++)
    pattern[i] = (float *) malloc(sizeof(float)*num_att[i]);

  IAMI = (int **) malloc (sizeof(int *)*(num_category[ARTa]+1));
  for (i=0; i<num_category[ARTa]+1; i++)
    IAMI[i] = (int *) malloc (sizeof(int)*(num_category[ARTb]+1));

  F2 = (float **) malloc (sizeof(float *)*2);
  for (i=0; i<2; i++)
    F2[i] = (float *) malloc(sizeof(float)*(num_category[i]+1));

  dn = (float ***) malloc(sizeof(float **)*2);
  for (i=0; i<2; i++)
    {
      dn[i] = (float **) malloc(sizeof(float *)*(num_category[i]+1));
      for (j=0; j<num_category[i]+1; j++)
	dn[i][j] = (float *) malloc(sizeof(float)*num_att[i]);
    }

  confidence = (float *) malloc(sizeof(float)*(num_category[ARTa]+1));

  committed = (int **) malloc(sizeof(int *)*2);
  for (i=0; i<2; i++)
    committed[i] = (int *) malloc(sizeof(int)*(num_category[i]+1));

  makes_prediction = (int *) malloc(sizeof(int)*(num_category[ARTa]+1));

}

realloc_memory (whichART)
int  whichART;
{
  int  i;

  F2[whichART] = (float *) realloc(F2[whichART],sizeof(float)*(num_category[whichART]+1));
  committed[whichART] = (int *) realloc(committed[whichART],sizeof(int)*(num_category[whichART]+1));

  F2[whichART][num_category[whichART]] = 0.0;
  committed[whichART][num_category[whichART]] = FALSE;

  dn[whichART] = (float **) realloc(dn[whichART],sizeof(float *)*(num_category[whichART]+1));
  dn[whichART][num_category[whichART]] = (float *) malloc(sizeof(float)*num_att[whichART]);

  for (i=0; i<num_att[whichART]; i++)
    dn[whichART][num_category[whichART]][i] = dnInit;

  if (whichART==ARTa)
    {
      IAMI = (int **) realloc(IAMI,sizeof(int *)*(num_category[ARTa]+1));
      IAMI[num_category[ARTa]] = (int *) malloc (sizeof(int)*(num_category[ARTb]+1));

      confidence = (float *) realloc (confidence,sizeof(float)*(num_category[ARTa]+1));
      makes_prediction = (int *) realloc (makes_prediction,sizeof(int)*(num_category[ARTa]+1));

      for (i=0; i<num_category[ARTb]+1; i++)
	IAMI[num_category[ARTa]][i] = 0;

      confidence[num_category[ARTa]] = 1.0;
      makes_prediction[num_category[ARTa]] = 0;
    }
  else
    {
      for (i=0; i<num_category[ARTa]+1; i++)
	IAMI[i] = (int *) realloc(IAMI[i],sizeof(int)*(num_category[ARTb]+1));
      
      for (i=0; i<num_category[ARTa]+1; i++)
	IAMI[i][num_category[ARTb]] = 0;
    }
}

free_memory ()
{
  int i, j;

  for (i=0; i<2; i++)
    {
      for (j=0; j<num_category[i]+1; j++)
	free (dn[i][j]);
      free (dn[i]);
    }
  free (dn);

  for (i=0; i<2; i++)
    free (pattern[i]);
  free (pattern);

  for (i=0; i<num_category[ARTa]+1; i++)
    free (IAMI[i]);
  free (IAMI);

  for (i=0; i<2; i++)
    free (F2[i]);
  free (F2);

  free (confidence);

  for (i=0; i<2; i++)
    free (committed[i]);
  free (committed);

  free (makes_prediction);
}

void read_pattern (id)
int id;
{
  int m;
  int position;
  
  fseek (dat,(a_length+b_length)*sizeof(float)*Index[id],0);
  fread (pattern[ARTa],sizeof(float),a_length,dat);
  fread (pattern[ARTb],sizeof(float),b_length,dat);

  if (!complement)
    {
      for (position = 0; position < a_length; position++)
	/* Treatment of missing values */
	if (pattern[ARTa][position] == -1.0)
	  pattern[ARTa][position] = 1.0;
	else
	  if (pattern[ARTa][position] > 1.0 || pattern[ARTa][position] < 0.0)
	    {
	      printf ("Error in Input Pattern: Normalization required\n");
	      exit (0);
	    }
    }
  else
    {
      for (position = 0; position < a_length; position++)
	{
	  /* Treatment of missing values */
	  if (pattern[ARTa][position] == -1.0)
	    {
	      pattern[ARTa][position] = 1.0;
	      pattern[ARTa][position+a_length] = 1.0;
	    }
	  else if (pattern[ARTa][position] > 1.0 || pattern[ARTa][position] < 0.0)
	    {
	      printf ("Error in Input Pattern: Normalization required\n");
	      exit (0);
	    }
	  else
	    pattern[ARTa][position+a_length] = 1.0 - pattern[ARTa][position];
	}
      for (position = 0; position < b_length; position++)
	pattern[ARTb][position+b_length] = 1.0 - pattern[1][position];
    }

  if (trace >= 3)
    {
      printf ("Pattern %d :\n", Index[id]+1);
      for (m=0; m<2; m++)
	{
	  for (position = 0; position < num_att[m]; position++)
	    printf ("%1.3f ", pattern[m][position]);
	  printf ("\n");
	}
    }
}

report_train_performance ()
{
  printf ("Total of %d training patterns.\n", train_pats);
  printf ("Number of correct prediction : %d\n", num_right);
  printf ("Number of wrong prediction   : %d\n", num_wrong);
  printf ("Number of no prediction      : %d\n", num_no_prediction);
  printf ("Discrimination rate of %1.1f%% on training set achieved.\n\n", 100*num_right/(float)train_pats);
}

report_test_performance ()
{
  printf ("Total of %d test patterns.\n", test_pats);
  printf ("Number of correct prediction : %d\n", num_right);
  printf ("Number of wrong prediction   : %d\n", num_wrong);
  printf ("Number of no prediction      : %d\n", num_no_prediction);
  printf ("Prediction rate of %1.1f%% on test set achieved.\n\n", 100*num_right/(float)test_pats);
}

display_weight ()
{
  int  j, k;

  for (j=0; j<num_category[ARTa]; j++)
    {
      printf ("Category %d ARTa Weight: \n", j+1);
      for (k=0; k<num_att[ARTa]/2; k++)
	printf ("%1.1f ", dn[ARTa][j][k]);
      printf ("\n");
      for (k=num_att[ARTa]/2; k<num_att[ARTa]; k++)
	printf ("%1.1f ", dn[ARTa][j][k]);
      printf ("\n");
      printf ("Category %d Map Field  : ", j+1);
      for (k=0; k<num_category[ARTb]; k++)
	printf ("%d ", IAMI[j][k]);
      printf ("\n\n");

      fprintf (gfp, "Category %d ARTa Weight: \n", j+1);
      for (k=0; k<num_att[ARTa]/2; k++)
	fprintf (gfp, "%1.1f ", dn[ARTa][j][k]);
      fprintf (gfp, "\n");
      for (k=num_att[ARTa]/2; k<num_att[ARTa]; k++)
	fprintf (gfp, "%1.1f ", dn[ARTa][j][k]);
      fprintf (gfp, "\n");
      fprintf (gfp, "Category %d Map Field  : ", j+1);
      for (k=0; k<num_category[ARTb]; k++)
	fprintf (gfp, "%d ", IAMI[j][k]);
      fprintf (gfp, "\n\n");
    }
}

void   alloc_series_memory ()
{
  int  i, j, v;

  right_wrong = (int ***) malloc (sizeof(int **)*num_voters);
  for (v=0; v<num_voters; v++)
    {
      right_wrong[v] = (int **) malloc (sizeof(int *)*2);
      for (i=0; i<2; i++)
	right_wrong[v][i] = (int *) malloc(sizeof(int)*num_data_category);
    }

  sum_rate = (float *) malloc (sizeof(float)*num_voters);
  sum_sq_rate = (float *) malloc (sizeof(float)*num_voters);

  if (display_confusion_matrix)
    {
      p_table = (int ***) malloc (sizeof(int **)*num_voters);
      for (v=0; v<num_voters; v++)
	{
	  p_table[v] = (int **) malloc (sizeof(int *)*(num_data_category+1));
	  for (i=0; i<num_data_category+1; i++)
	    p_table[v][i] = (int *) malloc(sizeof(int)*num_data_category);
	}
      C = (float **) malloc (sizeof(float *)*num_voters); 
      for (v=0; v<num_voters; v++)
	C[v] = (float *) malloc (sizeof(float)*num_data_category);
    }

  Index = (int *) malloc(sizeof(int)*tot_pats);
  frequency = (int *) malloc(sizeof(int)*(num_data_category+1));
  num_votes = (int **) malloc (sizeof(int *)*test_pats);
  for (i=0; i<test_pats; i++)
    num_votes[i] = (int *) malloc (sizeof(int)*(num_data_category+1));
  actual_category = (int *) malloc (sizeof(int)*test_pats);
}

void print_series_data ()
{
  int ps_x, ps_y, v, i, j;
  int tot_right, tot_wrong, tot_freq=0;
  
  printf ("-------------------------------------------------------------------------\n");
  printf("%d training patterns. %d test patterns.\n",train_pats,
	 test_pats);
  printf("On average %1.2lf committed nodes, Min of %d and Max of %d.\n",tot_committed_nodes/((float)num_runs*num_voters), min_committed_node, max_committed_node);
  
  printf("%d - %d training iterations with average of %1.2lf iterations.\n",
	 min_times_through_training, max_times_through_training,
         tot_times_through_training/((float)num_runs*num_voters));
  
  printf("(min arho is set to %1.1lf. Statistics collected from %d runs.)\n",
	 min_arho, num_runs);
  
  printf ("-------------------------------------------------------------------------\n\n");
  
  for (v=0; v<num_voters; v++)
    {
      tot_right = 0;
      tot_wrong = 0;
      printf ("With %d voters :\n", v+1);
      printf ("\n-------------------------------------------------------------\n");
      printf ("\t\t\tRight\tWrong\tTotal\tP(Right)\n");
      printf ("-------------------------------------------------------------\n");
      for (ps_x = 0; ps_x < num_category[ARTb]; ps_x++)
	{
	  printf("Prediction %d\t:\t%d\t%d\t%d\t%1.3lf\n",
		 ps_x+1,
		 right_wrong[v][0][ps_x],
		 right_wrong[v][1][ps_x],
		 right_wrong[v][0][ps_x]+right_wrong[v][1][ps_x],
		 right_wrong[v][0][ps_x]/(float)
		 (right_wrong[v][0][ps_x]+right_wrong[v][1][ps_x]));
	  tot_right += right_wrong[v][0][ps_x];
	  tot_wrong += right_wrong[v][1][ps_x];
	}
      printf("No Prediction\t:\t\t%d\t%d\n", tot_no_prediction, tot_no_prediction);
      tot_wrong += tot_no_prediction;
      
      printf ("-------------------------------------------------------------\n");
      printf("Total:\t\t\t%d\t%d\t%d\t%1.3lf\n",
	     tot_right, tot_wrong,
	     tot_right + tot_wrong,
	     tot_right/(float)(tot_right+tot_wrong));
      printf ("-------------------------------------------------------------\n\n");

      printf ("  with standard deviation of %1.1f.\n\n",
	  sqrt (fabs (sum_sq_rate[v]/num_runs -
                      (sum_rate[v]/num_runs)*(sum_rate[v]/num_runs))));

      if (display_confusion_matrix)
	{
	  printf ("--------------------");
	  for(ps_y = 0; ps_y < num_category[ARTb]; ps_y++)
	    printf ("---------");
	  printf ("\nActual Category\t");
	  for(ps_y = 0; ps_y < num_category[ARTb]; ps_y++)
	      printf ("\t%d", ps_y+1);
	  printf ("\n");
	  printf ("--------------------");
	  for(ps_y = 0; ps_y < num_category[ARTb]; ps_y++)
	    printf ("---------");
	  printf ("\n");
	  
	  for(ps_x = 0; ps_x < num_category[ARTb]; ps_x++)
	    {
	      printf ("Predict %d\t:", ps_x+1);
	      for(ps_y = 0; ps_y < num_category[ARTb]; ps_y++)
		printf ("\t%d", p_table[v][ps_x][ps_y]);
	      printf ("\n");
	    }
	  printf ("No Prediction\t:");
	  for(ps_y = 0; ps_y < num_category[ARTb]; ps_y++)
	    printf ("\t%d", p_table[v][num_category[ARTb]][ps_y]);
	  printf ("\n");
	  printf ("--------------------");
	  for(ps_y = 0; ps_y < num_category[ARTb]; ps_y++)
	    printf ("---------");
	  printf ("\n\n");

	  printf ("Correlation Coefficients are as follows :\n\n");
	  for (ps_x=0; ps_x<num_data_category; ps_x++)
	    printf ("\tC[%d] = %1.2f\n", ps_x, C[v][ps_x]);
	  printf ("\n");
	}
    }
  printf("Total of %d no-predictions.  Range of P(right) : (%1.1f,%1.1f)\n\n", tot_no_prediction, min_rate_on_test, max_rate_on_test);

  printf ("Overall Standard deviation of Success Rate is %1.1lf.\n",
	  sqrt ( fabs (sum_sq_rate_on_test/(num_voters*num_runs)-
                       (sum_rate_on_test/(num_voters*num_runs))*
                       (sum_rate_on_test/(num_voters*num_runs)))));

  if (trace > 0)
    {
      for (ps_x = 0; ps_x<=num_data_category; ps_x++)
	tot_freq += frequency[ps_x];
      printf("Frequency of occurrance : \n");
      for (ps_x = 0; ps_x < num_data_category; ps_x++)
	printf ("\tCategory %d : %1.2f%%\n", ps_x+1, frequency[ps_x]/(float)tot_freq);
      printf ("\n");
    }
}

free_series_data ()
{
  int  i, v;

  for (v=0; v<num_voters; v++)
    {
      for (i=0; i<2; i++)
	free (right_wrong[v][i]);
      free (right_wrong[v]);
    }
  free (right_wrong);

  free (sum_rate);
  free (sum_sq_rate);

  free (frequency);
  free (Index);
  for (i=0; i<test_pats; i++)
    free (num_votes[i]);
  free (num_votes);
  free (actual_category);

  if (display_confusion_matrix)
    {
      for (v=0; v<num_voters; v++)
	{
	  for (i=0; i<num_data_category+1; i++)
	    free (p_table[v][i]);
	  free (p_table[v]);
	}
      free (p_table);
      for (v=0; v<num_voters; v++)
	free (C[v]);
      free (C);
    }
}      

display_parameters ()
{
  printf ("\n");
  printf ("Random Number Seed\t\t : %d\n", randomInit);
  printf ("Ordered Set\t\t\t : %d\n", orderedSet);
  printf ("Complement Coding\t\t : %d\n", complement);
  printf ("Track on Choice\t\t\t : %d\n", track_on_choice);
  printf ("No learn if wrong\t\t : %d\n", no_learn_if_wrong);
  printf ("Two Binary Categories\t\t : %d\n", two_binary_categories);
  printf ("On line learning\t\t : %d\n", on_line);
  printf ("No. of Voters\t\t\t : %d\n", num_voters);
  printf ("No. of Runs\t\t\t : %d\n", num_runs);
  printf ("Max no. of training iterations\t : %d\n", max_iterations);
  printf ("Complement Coding\t\t : %d\n", complement);
  printf ("No. of attributes ARTa\t\t : %d\n", a_length);
  printf ("No. of attributes ARTb\t\t : %d\n", b_length);
  printf ("No. of Data Categories\t\t : %d\n", num_data_category);
  printf ("No. of Training Patterns\t : %d\n", train_pats);
  printf ("No. of Test Patterns\t\t : %d\n", test_pats);
  printf ("Total no. of Patterns\t\t : %d\n", tot_pats);
  printf ("Initial Weight\t\t\t : %1.3f\n", dnInit);
  printf ("Alpha\t\t\t\t : %1.3f\n", Alpha);
  printf ("Epsilon\t\t\t\t : %1.3f\n", epsilon);
  printf ("Learning Rate\t\t\t : %1.3f\n", rate);
  printf ("Z Bar\t\t\t\t : %1.3f\n", z_bar);
  printf ("Min ARTa Vigilance\t\t : %1.3f\n", min_arho);
  printf ("ARTb Vigilance\t\t\t : %1.3f\n", brho);
  printf ("Noise Rate\t\t\t : %1.3f\n", noise_rate);
  printf ("Noise Tolerance\t\t\t : %1.3f\n", noise_tolerance);
  printf ("Trace Level\t\t\t : %d\n", trace);
  printf ("Explain\t\t\t\t : %d\n", explain);
  printf ("Trace Weight\t\t\t : %d\n", trace_weight);
  printf ("Display Confusion Matrix\t : %d\n", display_confusion_matrix);
  printf ("\n");
}

read_parameters ()
{
  FILE   *pfp;
  char   p_file[30];
  char   dummy[200];

  printf ("Name of Parameter File > ");
  scanf ("%s", p_file);
  pfp = fopen (p_file, "r");
  
  fscanf (pfp, "%d", &randomInit);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &orderedSet);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &track_on_choice);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &no_learn_if_wrong);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &two_binary_categories);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &on_line);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &num_voters);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &num_runs);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &max_iterations);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &complement);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &a_length);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &b_length);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &num_data_category);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &train_pats);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &test_pats);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &tot_pats);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%f", &dnInit);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%f", &Alpha);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%f", &epsilon);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%f", &rate);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%f", &z_bar);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%f", &min_arho);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%f", &brho);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%f", &noise_rate);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%f", &noise_tolerance);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &trace);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &explain);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &trace_weight);
  fgets (dummy, 200, pfp);
  fscanf (pfp, "%d", &display_confusion_matrix);
  fgets (dummy, 200, pfp);
  fclose (pfp);

  if (trace_weight)
    gfp = fopen ("wt.out", "w");
}      
