signature TOP =
sig
    (* read a MinML source file *)
    val file_type  : string -> unit
    val file_eval  : int -> string -> unit
    val file_apply : int -> int -> string -> unit
end

structure Top :> TOP =
struct

(* Uncomment to run the "non-collector" *)
    structure Loop = Loop (structure G = NoGC)


(* Uncomment to run the "Semi-Space collector" 
    structure Loop = Loop (structure G = SemiSpaceGC)
*)

(* Uncomment to run the "Mark-and-Sweep collector" 
    structure Loop = Loop (structure G = MarkAndSweepGC)
*)

    val random = ref (Random.rand(0,1000))

    fun genList 0 = DBMinML.Nil(T.INT)
      | genList n = DBMinML.Cons(DBMinML.Int(Random.randRange (0,1000) (!random)), genList (n-1))

    fun file_type  f = 
        (Loop.loopFile f Loop.showType)
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n")
             | Lexer.LexError s => print ("Lexer Error: " ^ s ^ "\n");

    fun file_eval heapSize f =
        (Loop.loopFile f (Loop.eval heapSize Loop.showType)) 
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n")

    fun file_apply heapSize listSize f = 
        (random := Random.rand(~heapSize, listSize);
        Loop.loopFile f (fn e => (Loop.eval heapSize Loop.showType (DBMinML.Apply(e, genList listSize)))))
        handle Parse.Error s => print ("Parse Error: " ^ s ^ "\n")
       

end
