structure SemiSpaceGC : GC =
struct

  (* Raised to indicate that an allocation or dereference has failed (due to
  lack of resources (or breaking of another invariant) and a collection should
  be invoked. *) 
  exception OutOfMemory

  exception Error of string

  type location = int ref

  datatype sVal =
      Int of int
    | True 
    | False 
    | Nil 
    | Loc of location
    | Unit
  and lVal = 
      Closure of Env * DBMinML.exp
    | Cons of sVal * sVal
    | Pair of sVal * sVal
  and Bind =
      ValBind of sVal 
    | ExpBind of sVal
  
  withtype Env = Bind list
  
  datatype Frame =
      FPrimopN of P.primop * sVal list * DBMinML.exp list
    | If1 of DBMinML.exp * DBMinML.exp
    | App1 of DBMinML.exp 
    | App2 of sVal
    | Cons1 of DBMinML.exp 
    | Cons2 of sVal 
    | FPair1 of DBMinML.exp
    | FPair2 of sVal
    | FFst
    | FSnd
    | Case1 of DBMinML.exp * (DBMinML.bind * DBMinML.bind * DBMinML.exp)
    | Let1 of DBMinML.bind * DBMinML.exp
  
  datatype Cont =
      Frame of Frame
    | Env of Env
  
  type stack = Cont list
  
  (* Types shared between the GC and the abstract machine. *)
  datatype HeapElement = Unused | Fwd of int | Cell of lVal;

  val (heap, upper, lower, next) = (ref (Array.array (0,Unused)), ref 0, ref 0, ref 0)

  val allocs = ref 0
  val reads = ref 0
  val collects = ref 0
  val accesses = ref 0


  (* Initialize the GC heap. *)
  fun init i = 
    let in
      heap := Array.array (i,Unused);
      upper := i div 2;
      lower := 0;
      next := 0
    end

  fun copyStack _ = raise Error "Unimplemented"

  and copyEnv _ = raise Error "Unimplemented"

  and copyPtr r = raise Error "Unimplemented"
  
  and copysVal _ = raise Error "Unimplemented"

  and copylVal _ = raise Error "Unimplemented"

  fun alloc k w = raise Error "Unimplemented"
  
  fun read r = raise Error "Unimplemented"

  fun numAllocs () = !allocs

  fun numReads () = !reads

  fun numCollects () = !collects

  fun numAccesses () = !accesses


end;
