structure NoGC : GC =
struct

  (* Raised to indicate that an allocation or dereference has failed (due to
  lack of resources (or breaking of another invariant) and a collection should
  be invoked. *) 
  exception OutOfMemory

  type location = int

  datatype sVal =
      Int of int
    | True 
    | False 
    | Nil 
    | Loc of location
    | Unit
  and lVal = 
      Closure of Env * DBMinML.exp
    | Cons of sVal * sVal
    | Pair of sVal * sVal
  and Bind =
      ValBind of sVal 
    | ExpBind of sVal
  
  withtype Env = Bind list
  
  datatype Frame =
      FPrimopN of P.primop * sVal list * DBMinML.exp list
    | If1 of DBMinML.exp * DBMinML.exp
    | App1 of DBMinML.exp 
    | App2 of sVal
    | Cons1 of DBMinML.exp 
    | Cons2 of sVal 
    | FPair1 of DBMinML.exp
    | FPair2 of sVal
    | FFst
    | FSnd
    | Case1 of DBMinML.exp * (DBMinML.bind * DBMinML.bind * DBMinML.exp)
    | Let1 of DBMinML.bind * DBMinML.exp
  
  datatype Cont =
      Frame of Frame
    | Env of Env
  
  type stack = Cont list
  
  (* Types shared between the GC and the abstract machine. *)
  val heap = ref (Array.array (0,Closure(nil,DBMinML.Int(0))))
  val next = ref 0


  val allocs = ref 0
  val reads = ref 0
  val collects = ref 0
  val accesses = ref 0


  (* Initialize the GC heap. *)
  fun init heap_size = 
    let in
      heap := Array.array (heap_size,Closure(nil,DBMinML.Int(0)));
      next := 0
    end

  (* Allocate a memory cell from the GC heap and store the given (large)
  value. *)
  fun alloc k w =
    let
      val _ = allocs := !allocs + 1
      val l = !next
      val _ = if l >= (Array.length (!heap)) then raise OutOfMemory else ()
      val _ = next := l+1
      val _ = Array.update(!heap, l, w)
    in 
      l
    end

  (* Deference a location from the heap and return the corresponding large
  value. *)
  fun read l = 
    let in
      reads := !reads + 1;
      Array.sub(!heap, l)
    end

  fun numAllocs () = !allocs

  fun numReads () = !reads

  fun numCollects () = !collects

  fun numAccesses () = !accesses

end;


