signature GC =
sig

  (* Raised to indicate that an allocation or dereference has failed (due to
  lack of resources (or breaking of another invariant) and a collection should
  be invoked. *) 
  exception OutOfMemory

  type location

  datatype sVal =
      Int of int
    | True 
    | False 
    | Nil 
    | Loc of location
    | Unit
  and lVal = 
      Closure of Env * DBMinML.exp
    | Cons of sVal * sVal
    | Pair of sVal * sVal
  and Bind =
      ValBind of sVal 
    | ExpBind of sVal
  
  withtype Env = Bind list
  
  datatype Frame =
      FPrimopN of P.primop * sVal list * DBMinML.exp list
    | If1 of DBMinML.exp * DBMinML.exp
    | App1 of DBMinML.exp 
    | App2 of sVal
    | Cons1 of DBMinML.exp 
    | Cons2 of sVal 
    | FPair1 of DBMinML.exp
    | FPair2 of sVal
    | FFst
    | FSnd
    | Case1 of DBMinML.exp * (DBMinML.bind * DBMinML.bind * DBMinML.exp)
    | Let1 of DBMinML.bind * DBMinML.exp
  
  datatype Cont =
      Frame of Frame
    | Env of Env
  
  type stack = Cont list
  
  (* Initialize the GC heap. *)
  val init : int -> unit

  (* Allocate a memory cell from the GC heap and store the given (large)
  value. *)
  val alloc : stack -> lVal -> location

  (* Deference a location from the heap and return the corresponding large
  value. *)
  val read : location -> lVal

  val numAllocs : unit -> int

  val numReads : unit -> int

  val numCollects : unit -> int

  val numAccesses : unit -> int

end;

