;  SAVE-HISTORY
;  Functions for recording the history of an experiment

(defun keephist (msg writefn writearg)
  (when *keephistory*
	(write msg :stream *history*)
	(write-char #\Newline *history*)
	(apply writefn `(,writearg))
	(write-char #\Newline *history*)))

(defun write-seu (args)
  (write "Size:" :stream *history*)
  (write (car args) :stream *history*)
  (write-char #\Newline *history*)
  (write "Time:" :stream *history*)
  (write (cadr args) :stream *history*)
  (write-char #\Newline *history*)
  (write "Distance:" :stream *history*)
  (write (caddr args) :stream *history*)
  (write-char #\Newline *history*)
  (write "Tileavial:" :stream *history*)
  (write (cadddr args) :stream *history*)
  (write-char #\Newline *history*)
  (write "Score:" :stream *history*)
  (write (car (cddddr args)) :stream *history*)
  (write-char #\Newline *history*)
  (write "Seu:  " :stream *history*)
  (write (car (cdr (cddddr args))) :stream *history*)
  (write-char #\Newline *history*))

(defun write-mind (mind)
  (write "Options:"  :stream *history*)
  (write-char #\Newline *history*)
  (write-options (agent-options mind))
  (write-char #\Newline *history*)
  (write-char #\Newline *history*)
  (write "Intentions:" :stream *history*)
  (write-char #\Newline *history*)
  (write-intentions (agent-intentions mind))
  (write-char #\Newline *history*)
  (write-char #\Newline *history*))

(defun write-options (options)
  (when options
	(write "  Purpose:  " :stream *history*)
	(write (option-set-purpose (first options)) :stream *history*)
	(write-char #\Newline *history*)
	(write-each-act (option-set-alt-acts (first options)))
	(write-char #\Newline *history*)
	(write-options (rest options))))

(defun write-each-act (acts)
  (when acts
	(write "    Id:  " :stream *history*)
	(write (act-id (first acts)) :stream *history*)
	(write-char #\Newline *history*)
	(write "    Type:  " :stream *history*)
	(write (act-type (first acts)) :stream *history*)
	(write-char #\Newline *history*)
	(write "    Parms:  " :stream *history*)
	(write (act-parms (first acts)) :stream *history*)
	(write-char #\Newline *history*)
	(write "    Time:  " :stream *history*)
	(write (act-time (first acts)) :stream *history*)
	(write "    Subacts:  "  :stream *history*)
	(write (mapcar #'act-id (act-subacts (first acts))) :stream *history*)
	(write-char #\Newline *history*)
	(write-char #\Newline *history*)
	(write-each-act (rest acts))))
	       
(defun write-intentions (ints)
  (when ints
	(write-each-act ints)))

(defun write-holes (hole-list)
  (write (mapcar #'obj-name hole-list) :stream *history*))

(defun write-plain (arg)
  (write arg :stream *history*))
