
;  EXPER


; Note:  Need to allow game length to be set too.

(defun experiment (startseed endseed &optional world agent)
  (when world (setf w0 world))
  (when agent (setf a0 agent))
;  (setf a0 (make-default-agent))
;  (setf w0 (make-default-world))
   (setf *keephistory* nil)    ;don't swamp memory
;   (setf *display-on* nil)
   (with-open-file
       (*expr* *exprfile* :direction :output :if-exists :rename)
       (record-settings  startseed))
   (let ( (score 0) (total 0) (times (+ 1 (- endseed startseed))))
     (do (( i startseed (+ i 1)))
	 ((> i endseed))
	 (setf score (tw-exp i))
	 (with-open-file
	     (*expr* *exprfile* :direction :output :if-exists :append)
	     (record-score score))
	 (setf total (+ total score)))
     (with-open-file
	 (*expr* *exprfile* :direction :output :if-exists :append)
         (record-average (round (/ total times)))))
t)


(defun record-settings (seed)
  (write (agent-name a0) :stream *expr*)
  (write-char #\Newline *expr*)
  (write (tw-name w0) :stream *expr*)
  (write-char #\Newline *expr*)(write-char #\Newline *expr*)
  (write "Seed:"  :stream *expr*)
  (write seed :stream *expr*)
  (write-char #\Newline *expr*)
  (write "===========================" :stream *expr*)
  (write-char #\Newline *expr*)
  (write "Agent Settings:" :stream *expr*)
  (write-char #\Newline *expr*)
  (write "Eval Strategy:" :stream *expr*)
  (write (agent-eval-strat a0) :stream *expr*)
  (write-char #\Newline *expr*)
  (write "Act Time:" :stream *expr*)
  (write (agent-act-time a0) :stream *expr*)
  (write-char #\Newline *expr*)
  (write "Threshold:" :stream *expr*)
  (write (agent-threshhold a0) :stream *expr*)
  (write-char #\Newline *expr*)
  (write "===========================" :stream *expr*)
  (write-char #\Newline *expr*)
  (write "World Settings:"  :stream *expr*)
  (write-char #\Newline *expr*)
  (write "Hole Appearance Rate:" :stream *expr*)
  (write (knob-ms-appear (tw-hole-knobs w0)) :stream *expr*)
  (write-char #\Newline *expr*)
  (write "Hole Disappear Rate:" :stream *expr*)
  (write (knob-ms-disappear (tw-hole-knobs w0)) :stream *expr*)
  (write-char #\Newline *expr*)
  (write "Hole Size Range:" :stream *expr*)
  (write (subknob-min (knob-cells (tw-hole-knobs w0))) :stream *expr*)
  (write "to " :stream *expr*)
  (write (subknob-max (knob-num (tw-hole-knobs w0))) :stream *expr*)
  (write-char #\Newline *expr*)
  (write "Hole Score Range:" :stream *expr*)
  (write (subknob-min (knob-score (tw-hole-knobs w0))) :stream *expr*)
  (write "to " :stream *expr*)
  (write (subknob-max (knob-score (tw-hole-knobs w0))) :stream *expr*)
  (write-char #\Newline *expr*)
;  add the rest later
  (write "===========================" :stream *expr*)
  (write-char #\Newline *expr*)
)

(defun record-score (score)
   (write score :stream *expr*)
   (write-char #\Newline *expr*))

(defun record-average (ave)
  (write "===========================" :stream *expr*)
  (write-char #\Newline *expr*)
  (write "Average:" :stream *expr*)
  (write ave :stream *expr*)
  (write-char #\Newline *expr*)
)
	  

