/* twdisp.c - screen management for the tile world.  MNR, 7/31/89. 

   Compile with "cc -c twdisp.c", then load-foreign-files from lisp.
*/

#include <curses.h>
#include <signal.h>

twinitdisp()
{
    initscr();
    nonl();
    cbreak();
    noecho();
}

twdisplay(ymax,xmax,terrain)
    int ymax,xmax;
    char *terrain;
{
    int x,y;

    for (y=0;y<ymax;++y)
	for (x=0;x<xmax;++x)
	    mvaddch(y,2*x,*(terrain+y*xmax+x));
    refresh();
}

twprint(y,x,len,str)
    int y,x,len;
    char *str;
{
    int i;

    for (i=0;i<len;++i) mvaddch(y+(x+i)/80,(x+i)%80,*(str+i));
    refresh();
}

twclear()
{
    erase();
    refresh();
}


twclosedisp()
{
    endwin();
}

char twgetch()
{
    return (char)getch();
}

twisch()
{
    int onep[1];
    long zerop[2];

    onep[0]=1;
    zerop[0]=0;
    zerop[1]=0;

    return stdin->_cnt || select(32,onep,NULL,NULL,zerop);
}
