; Tile world interface.  MNR, 8/1/89.
; Requires twdisp.c, the curses interface.

; C function definitions
(def-foreign-function twinitdisp)
(def-foreign-function twclosedisp)
(def-foreign-function twdisplay
    (rows :signed-32bit) (cols :signed-32bit) (terrain :simple-string))
(def-foreign-function twprint
    (row :signed-32bit) (col :signed-32bit) 
    (len :signed-32bit) (str :simple-string))
(def-foreign-function twclear)
(def-foreign-function (twgetch (:return-type :character)))
(def-foreign-function twisch)

; Lisp interface & utility functions

(defvar *act-length* 1000)

(defun tw-print (row col str)
    (twprint row col (length str) str))

(defvar arr-string (with-static-area (make-string 4000)))

(defun tw-display-array (rows cols arr)
    (dotimes (i rows)
	(dotimes (j cols)
	    (setf (aref arr-string (+ (* i cols) j))
		  (aref arr i j))))
    (twdisplay rows cols arr-string))

(defun tw-show (world)
    (twinitdisp)
    (tw-display world)
    (twclosedisp))

(defun tw-rerun (world)
    (let ((oldseed (tw-rand-seed w0)))
	(setf (tw-rand-seed w0)
	      (tw-rand-seed-was w0))
	(tw-run world)
	(setf (tw-rand-seed w0) oldseed)))

(defun tw-run (world)
    (twinitdisp)
    (tw-init world)
    (tw-cont2 world)
    (twclosedisp)
    nil)

(defun tw-cont (world)
    (twinitdisp)
    (tw-display world)
    (tw-cont2 world)
    (twclosedisp)
    nil)

(defun tw-cont2 (world)
  (let (ch moves move (prev (get-internal-real-time)) now time-since)
    (loop
        (setf moves nil)
	(loop
	        (when (= (twisch) 0)
		      (return))
		(setf ch (twgetch))
    		(cond ((eq ch #\u) (setf move 'u))
		      ((eq ch #\d) (setf move 'd))
		      ((eq ch #\l) (setf move 'l))
		      ((eq ch #\r) (setf move 'r))
		      ((eq ch #\q) (return-from tw-cont2))
		      (t (setf move 'n)))
		(setf moves (append moves (list move))))
	(setf now (get-internal-real-time))
	(setf time-since (round (/ (- now prev) 1000)))
	(if (or moves
		(> time-since (tw-slice world)))
	    (progn
		  (setf prev now)
		  (if (null moves) (setf moves (list 'n)))
		  (tw-step world nil (first moves) time-since)
		  (dolist (m (cdr moves))
		       (tw-step world nil m 0)))))))
	    
    

(defun fix()
   (twclosedisp)
   nil)

