;
; path planning functions
;
(def-foreign-function (moveplan (:return-type :simple-string))
    (rows :signed-32bit) (cols :signed-32bit)
    (grid :simple-string) (occupied :simple-string)
    (row :signed-32bit) (col :signed-32bit))

(def-foreign-function (pushplan (:return-type :simple-string))
    (rows :signed-32bit) (cols :signed-32bit)
    (grid :simple-string) (occupied :simple-string)
    (row :signed-32bit) (col :signed-32bit) (orientation :signed-32bit))

(load-foreign-files '("~ringuett/tile/twmove.o" "~ringuett/tile/twpush.o" 
		      "~ringuett/tile/bfs.o" "~ringuett/tile/heap.o"))



(defvar c-grid (with-static-area (make-string 4000)))
(defvar occupied (with-static-area (make-string 256 
					:initial-element (int-char 0))))
(setf (aref occupied (char-int #\#)) #\#)
(setf (aref occupied (char-int #\T)) #\#)
(setf (aref occupied (char-int #\t)) #\#)
(setf (aref occupied (char-int #\O)) #\#)
(setf (aref occupied (char-int #\o)) #\#)

; plan move to a square
(defun tw-plan-move (rows cols grid row col)
    (dotimes (i rows)
	(dotimes (j cols)
	    (setf (aref c-grid (+ (* i cols) j))
		  (aref grid i j))))
    (setf (aref c-grid (+ (* row cols) col)) #\D)
    (moveplan rows cols c-grid occupied (obj-row (first (tw-agent-list w0)))
					(obj-col (first (tw-agent-list w0)))))

; plan move to any empty square adjacent to a tile
(defun tw-plan-move-to (rows cols grid row col)
    (dotimes (i rows)
	(dotimes (j cols)
	    (setf (aref c-grid (+ (* i cols) j))
		  (aref grid i j))))
    (mapc #'(lambda(i j) 
		(if (eq (aref grid (+ row i) (+ col j)) nothing-char)
		    (setf (aref c-grid (+ (* (+ row i) cols) col j)) #\D)))
	  '(-1  0  1 -1  1 -1  0  1)
	  '(-1 -1 -1  0  0  1  1  1))
    (moveplan rows cols c-grid occupied (obj-row (first (tw-agent-list w0)))
					(obj-col (first (tw-agent-list w0)))))

(defun move (i j)
    (let ((plan (tw-plan-move (tw-rows w0) (tw-cols w0) (tw-grid w0) i j)))
	(if (not (and (eq (length plan) 1)
		      (eql (aref plan 0) #\x)))
	    (run-plan plan)
	    'no-path-found)))

(defun moveto (i j)
    (let ((plan (tw-plan-move-to (tw-rows w0) (tw-cols w0) (tw-grid w0) i j)))
	(if (not (and (eq (length plan) 1)
		      (eql (aref plan 0) #\x)))
	    (run-plan plan)
	    'no-path-found)))

(defun run-plan (plan)
	(twinitdisp)
	(dotimes (i (length plan))
	    (tw-step w0 nil (cond ((eql (aref plan i) #\u) 'u)
				  ((eql (aref plan i) #\d) 'd)
				  ((eql (aref plan i) #\l) 'l)
				  ((eql (aref plan i) #\r) 'r)) 0))
	(twclosedisp))
	

(defun tw-plan-push (rows cols grid tilerow tilecol holerow holecol)
    (dotimes (i rows)
	(dotimes (j cols)
	    (setf (aref c-grid (+ (* i cols) j))
		  (aref grid i j))))
    (setf (aref c-grid (+ (* (obj-row (first (tw-agent-list w0))) cols) 
			     (obj-col (first (tw-agent-list w0)))))
	  nothing-char)
    (setf (aref c-grid (+ (* tilerow cols) tilecol)) nothing-char)
    (setf (aref c-grid (+ (* holerow cols) holecol)) #\D)
    (let* ((drow (- (obj-row (first (tw-agent-list w0))) tilerow))
	   (dcol (- (obj-col (first (tw-agent-list w0))) tilecol)))
	(if (= drow -1)
	    (if (= dcol -1)
		(setf dir 7)
		(if (= dcol 0)
		    (setf dir 0)
		    (if (= dcol 1)
			(setf dir 1)
			(setf dir -1))))
	    (if (= drow 0)
		(if (= dcol -1)
		    (setf dir 6)
		    (if (= dcol 1)
			(setf dir 2)
			(setf dir -1)))
		(if (= drow 1)
		    (if (= dcol -1)
			(setf dir 5)
			(if (= dcol 0)
			    (setf dir 4)
			    (if (= dcol 1)
				(setf dir 3)
				(setf dir -1))))
		    (setf dir -1))))
	(if (>= dir 0)
	    (pushplan rows cols c-grid occupied tilerow tilecol dir)
	    'agent-not-by-the-tile)))

(defun pushto (tilerow tilecol destrow destcol)
    (let ((plan (tw-plan-push (tw-rows w0) (tw-cols w0) (tw-grid w0) 
		    tilerow tilecol destrow destcol)))
	(if (eq plan 'agent-not-by-the-tile)
	    plan
	    (if (and (eql (length plan) 1)
		     (eql (aref plan 0) #\x))
		'no-path-found
		(run-plan plan)))))

