; Tile world interface.  MNR, 8/1/89.
; Requires twdisp.c, the curses interface.

; C function definitions
(def-foreign-function twinitdisp)
(def-foreign-function twclosedisp)
(def-foreign-function twdisplay
    (rows :signed-32bit) (cols :signed-32bit) (terrain :simple-string))
(def-foreign-function twprint
    (row :signed-32bit) (col :signed-32bit) 
    (len :signed-32bit) (str :simple-string))
(def-foreign-function twclear)
(def-foreign-function (twgetch (:return-type :character)))

; Lisp interface & utility functions

(defvar *act-length* 1000)

(defun tw-print (row col str)
    (twprint row col (length str) str))

(defvar arr-string (with-static-area (make-string 4000)))

(defun tw-display-array (rows cols arr)
    (dotimes (i rows)
	(dotimes (j cols)
	    (setf (aref arr-string (+ (* i cols) j))
		  (aref arr i j))))
    (twdisplay rows cols arr-string))

(defun tw-show (world)
    (twinitdisp)
    (tw-display world)
    (twclosedisp))

(defun tw-run (world)
    (twinitdisp)
    (tw-init world)
    (tw-cont2 world)
    (twclosedisp)
    nil)

(defun tw-cont (world)
    (twinitdisp)
    (tw-display world)
    (tw-cont2 world)
    (twclosedisp)
    nil)

(defun tw-cont2 (world)
  (let (ch move)
    (loop
	(setf ch (twgetch))
	(cond ((eq ch #\u) (setf move 'u))
	      ((eq ch #\d) (setf move 'd))
	      ((eq ch #\l) (setf move 'l))
	      ((eq ch #\r) (setf move 'r))
	      ((eq ch #\q) (return))
	      (t (setf move 'n)))
	(tw-step world nil move *act-length*))))
    

(defun fix()
   (twclosedisp)
   nil)
