/* twdisp.c - screen management for the tile world.  MNR, 7/31/89.
   From ppcurse.c, MNR, 7/4/88.
*/

#include <curses.h>
#include <signal.h>

/* from curses doc */
die() { signal(SIGINT,SIG_IGN);
	mvcur(0,COLS-1,LINES-1,0);
	endwin();
	exit(0);
}

tw-init-disp()
{
    initscr();
    signal(SIGINT,die);
    noecho();
    nonl();
    erase();
}

tw-display(ymax,xmax,terrain)
{
    int x,y;

    for (y=0;y<ymax;++y)
	for (x=0;x<xmax;++x)
	    mvaddch(y,x,*(terrain+y*xmax+x));
    mvaddch(ymax,0,' ');
    refresh();
}

tw-clear()
{
    clear();
    refresh();
}


tw-close-disp()
{
    
    endwin();
    
}
