/* twdisp.c - screen management for the tile world.  MNR, 7/31/89.
   From ppcurse.c, MNR, 7/4/88.
*/

#include <curses.h>
#include <signal.h>

/* from curses doc */
die() 
{	signal(SIGINT,SIG_IGN);
	mvcur(0,COLS-1,LINES-1,0);
	endwin();
	exit(0);
}

twinitdisp()
{
    initscr();
/*    signal(SIGINT,die);*/
    nonl();
    cbreak();
    noecho();
}

twdisplay(ymax,xmax,terrain)
    int ymax,xmax;
    char *terrain;
{
    int x,y;

    for (y=0;y<ymax;++y)
	for (x=0;x<xmax;++x)
	    mvaddch(y,2*x,*(terrain+y*xmax+x));
    mvaddch(ymax,0,']');
    refresh();
}

twclear()
{
    erase();
    refresh();
}


twclosedisp()
{
    endwin();
}

char twgetch()
{
    return (char)getch();
}
