(in-package 'twp)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require 'xcw)
(require :loop)
(use-package :loop)
(use-package 'cw)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar *tileworld-window* "Use MAKE-TILEWORLD-WINDOW to initialize")
(defvar *last-char* NIL)

(defun init-display ()
  (make-tileworld-window)
  (clear *tileworld-window*)
  (clear-input *tileworld-window*)
  (setf *last-char* NIL))

(defun display-array (rows cols arr)
    (dotimes (i rows)
	(dotimes (j cols)
          (multiple-value-bind (x y) (rowcol->xy i j)
            (draw-char *tileworld-window*
                       (aref arr  i j)         
					  x
					  y)))))
          
;(defun display-array (rowmax colmax terrain)
;  (loop for col from 1 to colmax
;		for row from 1 to rowmax
;		do
;		(multiple-value-bind (x y) (rowcol->xy row col)
;                  (draw-char *tileworld-window*
;                             (aref terrain (+ (* y rowmax) x))
;                             x
;                             y))))

(defun draw-char (win c x y) 
  (clear-rectangle-xy win x y (font-character-width *system-font*)
                      (font-character-height *system-font*))
  (draw-string-xy win x y (string c)))

(defun display-string (col row chars-to-print str)
  (cond 
    ((<= chars-to-print 0) (values))
    (T (let ((chars-this-line (min chars-to-print (- 81 col))))
         (print-this-line col row chars-this-line str)
         (display-string  1 
                          (+ row 1) 
                          (- chars-to-print chars-this-line) 
                          (subseq str chars-this-line))))))

(defun print-this-line (row col chars str)
  (multiple-value-bind (x y) 
      (rowcol->xy row col)
    (clear-rectangle-xy *tileworld-window* x y 
                        (* chars (font-character-width *system-font*))
                        (font-character-height *system-font*))
	(draw-string-xy *tileworld-window* 
					x
					y
					(subseq str 0 chars))))

(defun clear-display ()
  (clear *tileworld-window*))

(defun refresh-display ()
  (values))

(defun close-display ()
  (flush *tileworld-window*))

(defun get-char ()
  (cond
   ((not (null *last-char*))
	  (prog1 *last-char*
		     (setf *last-char* NIL)))
   (t (read-char *tileworld-window*))))

(defun char-in-buffer? ()
  (cond 
   ((not (null *last-char*)) 1)
   (t (setf *last-char* (read-char-no-hang *tileworld-window*))
	  (if (null *last-char*) 0 1))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun make-tileworld-window ()
  (setq *tileworld-window*
		(make-window-stream :left 532
				    :bottom (- 800 (* (font-character-height 
                                                       *system-font*) 34))
                                    :lines-high 34
                                    :chars-wide 80
                                    :activate-p t))
  (enable-window-stream-event-handling *tileworld-window*)
  (values))

(defun rowcol->xy (row col)
  (values
   (* (+ col 1) (font-character-width *system-font*))	        ;x in pixels
   (- (window-stream-inner-height *tileworld-window*)   ;y in pixels, from Up Left
      (* (+ row 1) (font-character-height *system-font*)))))

;; initializations go here
(eval-when (load eval)
           (cw:initialize-common-windows)
		   (setq *system-font* (cw:open-font :courier :normal 10))
		   )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun twinitdisp () (init-display))
(defun twclosedisp () (close-display))
(defun twdisplay (rows cols arr) (display-array rows cols arr))
(defun twprint   (row col chars str) (print-this-line row col chars str))
(defun twclear   () (clear-display))
(defun twrefresh () (refresh-display))
(defun twgetch   () (get-char))
(defun twisch    () (char-in-buffer?))
(defun twdrawch  (window char x y) (draw-char window char x y))

(export '(twinitdisp 
		  twclosedisp 
		  twdisplay
		  twprint
		  twclear
		  twrefresh
		  twgetch
		  twisch
          twdrawch))

